function loadJurusan(id) {
    $('#jurusan option').remove();
    $.getJSON(base_url+'jurusanmatkul/getJurusanId/' + id, function (data) {
        console.log(data);
        let opsi;
        $.each(data, function (key, val) {
            opsi = `
                    <option value="${val.id_jurusan}">${val.nama_jurusan}</option>
                `;
            $('#jurusan').append(opsi);
        });
    });
}

$(document).ready(function () {
    $('[name="matkul_id"]').on('change', function () {
        loadJurusan($(this).val());
    });

    $('form#jurusanmatkul select').on('change', function () {
        $(this).closest('.form-group').removeClass('has-error');
        $(this).nextAll('.help-block').eq(0).text('');
    });

    $('form#jurusanmatkul').on('submit', function (e) {
        e.preventDefault();
        e.stopImmediatePropagation();

        var btn = $('#submit');
        btn.attr('disabled', 'disabled').text('Wait...');

        $.ajax({
            url: $(this).attr('action'),
            data: $(this).serialize(),
            method: 'POST',
            success: function (data) {
                btn.removeAttr('disabled').text('Save');
                console.log(data);
                if (data.status) {
                    Swal({
                        "title": "Success",
                        "text": "Data Data Saved Successfully",
                        "type": "success"
                    }).then((result) => {
                        if (result.value) {
                            window.location.href = base_url+'jurusanmatkul';
                        }
                    });
                } else {
                    if (data.errors) {
                        let j;
                        $.each(data.errors, function (key, val) {
                            j = $('[name="' + key + '"]');
                            j.closest('.form-group').addClass('has-error');
                            j.nextAll('.help-block').eq(0).text(val);
                            if (val == '') {
                                j.parent().addClass('has-error');
                                j.nextAll('.help-block').eq(0).text('');
                            }
                        });
                    }
                }
            }
        });
    });
});