<?php namespace Tobuli\Entities;

use Eloquent;
use Illuminate\Support\Facades\DB;

class UserDriver extends Eloquent {
	protected $table = 'user_drivers';

    protected $fillable = array(
        'user_id',
        'device_id',
        'name',
        'rfid',
        'phone',
        'email',
        'description'
    );

    public function user() {
        return $this->belongsTo('Tobuli\Entities\User', 'user_id', 'id');
    }

    public function device() {
        return $this->hasOne('Tobuli\Entities\Device', 'id', 'device_id');
    }

    public function devices() {
        return $this->belongsToMany('Tobuli\Entities\Device', 'user_driver_devices', 'driver_id', 'device_id');
    }

    public function getNameWithRfidAttribute()
    {
        return $this->name . (empty($this->rfid) ? "" : " ({$this->rfid})");
    }

    public function setDeviceIdAttribute($value)
    {
        $this->attributes['device_id'] = empty($value) ? null : $value;
    }

    public function changeDevice($device, $time = null)
    {
        if (is_null($time))
            $time = date('Y-m-d H:i:s');

        if ($currentDevice = $this->device) {
            $currentDevice->current_driver_id = null;
            $currentDevice->save();

            DB::table('user_driver_position_pivot')->insert([
                'device_id' => $currentDevice->id,
                'driver_id' => null,
                'date'      => $time
            ]);
        }

        if ($device) {
            $device->changeDriver($this, $time);
        }

        $this->device_id = $device->id ?? null;
        $this->save();
    }
}
