<?php

namespace Tobuli\Exporters\Device;


class CsvExporter extends Exporter
{
    public function export($devices, $attributes)
    {
        $this->filename = uniqid('', TRUE) . '.csv';
        $this->file = storage_path($this->filename);

        $file = fopen($this->file, 'wb');

        // UTF-8 BOM
        fwrite($file,"\xEF\xBB\xBF");

        fputcsv($file, $attributes);

        foreach ($devices as $device) {
            $values = [];

            foreach ($attributes as $attribute) {
                $values[] = $device->$attribute;
            }

            fputcsv($file, $values);
        }

        fclose($file);

        return $this;
    }
}