<?php

namespace Tobuli\Exporters\Device;

use Maatwebsite\Excel\Facades\Excel;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Tobuli\Exporters\XlsCollectionExporter;

class XlsExporter extends Exporter
{
    private $data;
    private $attributes;

    public function export($devices, $attributes)
    {
        $this->attributes = $attributes;
        $this->filename = uniqid('', TRUE) . '.xls';

        $this->data = [];

        foreach ($devices as $device) {
            $deviceData = $device->only($attributes);

            $this->data[] = $deviceData;
        }

        return $this;
    }

    public function download()
    {
        $export = new XlsCollectionExporter($this->data, $this->attributes);
        $export->setColumnFormat([
            'imei' => NumberFormat::FORMAT_TEXT,
        ]);

        return Excel::download($export, $this->filename, \Maatwebsite\Excel\Excel::XLS);
    }
}
