<?php

namespace Tobuli\Helpers\Alerts;

use Carbon\Carbon;
use Tobuli\Entities\Event;

class DistanceAlertCheck extends AlertCheck
{
    public function checkEvents($position, $prevPosition)
    {
        $distance = $this->check();

        if ( ! $distance)
            return null;

        $event = $this->getEvent();

        $event->type = Event::TYPE_DISTANCE;
        $event->message = '';
        $event->setAdditional('distance', $distance);
        $event->setAdditional('limit', $this->alert->distance);

        return [$event];
    }

    public function check()
    {
        if ( $this->alert->distance < 1 )
            return false;

        $position = $this->getPosition();

        if ( ! $position)
            return false;

        if ( ! $this->checkAlertPosition($position))
            return false;

        $dateFrom = $this->calcDateFrom();

        if ( ! $this->checkOccurred($dateFrom))
            return false;

        $distance = $this->device->getDistanceBetween($dateFrom, date('Y-m-d H:i:s'));

        if ($distance < $this->alert->getDistance())
            return false;

        return $distance;
    }

    public function getPosition()
    {
        $position = $this->device->positionTraccar();

        if ( ! $position)
            return null;

        $position->time = date('Y-m-d H:i:s');

        return $position;
    }

    protected function calcDateFrom()
    {
        $period = $this->alert->period;

        if ($period < 1)
            return $this->alert->created_at;

        $iterations = intval(Carbon::now()->diff($this->alert->created_at)->days / $period);

        return $this->alert->created_at->addDays($iterations * $period);
    }
}