<?php

namespace App\Http\Controllers\Frontend;

use App\Exceptions\PermissionException;
use App\Http\Controllers\Controller;
use Tobuli\Entities\Device;
use Tobuli\Entities\DevicePlan;

class DevicePlansController extends Controller
{
    public function __construct()
    {
        if (! settings('main_settings.enable_device_plans') ?? false) {
            throw new PermissionException();
         }

         parent::__construct();
    }

    public function index($device_id = null)
    {
        return view('front::DevicePlans.index', [
            'plans' => DevicePlan::active()
                ->get(),
            'devices' => $this->user
                ->devices
                ->pluck('name', 'id'),
            'device_id' => $device_id
        ]);
    }
}
