<?php namespace App\Providers;

use Illuminate\Database\Query\Builder AS QueryBuilder;
use Illuminate\Database\Eloquent\Builder AS EloquentBuilder;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Route;

class AppServiceProvider extends ServiceProvider {

	/**
	 * Bootstrap any application services.
	 *
	 * @return void
	 */
	public function boot()
	{
        Route::singularResourceParameters(false);

        try {
            $this->app['config']->set('app.name', settings('main_settings.server_name'));
        } catch (\Exception $exception) {}
	}

	/**
	 * Register any application services.
	 *
	 * @return void
	 */
	public function register()
	{
        QueryBuilder::macro("clearOrdersBy", function () {
            $this->{$this->unions ? 'unionOrders' : 'orders'} = null;

            return $this;
        });

        EloquentBuilder::macro("clearOrdersBy", function () {
            $query = $this->getQuery();

            $query->{$query->unions ? 'unionOrders' : 'orders'} = null;

            return $this;
        });

        EloquentBuilder::macro("isJoined", function ($table) {
            $query = $this->getQuery();

            if($query->joins == null) {
                return false;
            }

            foreach ($query->joins as $join) {
                if ($join->table == $table) {
                    return true;
                }
            }

            return false;
        });

        View::addLocation(base_path().'/Tobuli/Views');
        View::addNamespace('admin', base_path().'/Tobuli/Views/Admin');
        View::addNamespace('front', base_path().'/Tobuli/Views/Frontend');
	}

}
