<?php

use Illuminate\Database\Seeder;
use Tobuli\Entities\EmailTemplate;

class EmailTemplatesTableSeeder extends Seeder {

	public function run()
	{
        EmailTemplate::updateOrCreate(['name' => 'event'], [
            'name' => 'event',
            'title' => 'New event',
            'note' => 'Hello,<br><br>Event: [event]<br>Geofence: [geofence]<br>Device: [device.name]<br>Address: [address]<br>Position: [position]<br>Altitude: [altitude]<br>Speed: [speed]<br>Time: [time]'
        ]);

        EmailTemplate::updateOrCreate(['name' => 'service_expiration'], [
            'name' => 'service_expiration',
            'title' => 'Service expiration',
            'note' => 'Hello, device service is about to expire.<br><br>Device: [device.name]<br>Service: [service.name]<br>Left: [service.left]'
        ]);

        EmailTemplate::updateOrCreate(['name' => 'report'], [
            'name' => 'report',
            'title' => 'Report "[name]"',
            'note' => 'Hello,<br><br>Name: [name]<br>Period: [period]'
        ]);

        EmailTemplate::updateOrCreate(['name' => 'service_expired'], [
            'name' => 'service_expired',
            'title' => 'Service expired',
            'note' => 'Hello, device service is expired.<br><br>Device: [device.name]<br>Service: [service.name]'
        ]);

        EmailTemplate::updateOrCreate(['name' => 'registration'], [
            'name' => 'registration',
            'title' => 'Registration confirmation',
            'note' => 'Hello,<br><br>Thank you for registering, here\'s your login information:<br>Email: [email]<br>Password: [password]'
        ]);

        EmailTemplate::updateOrCreate(['name' => 'expiring_device'], [
            'name'  => 'expiring_device',
            'title' => 'Device expiration',
            'note'  => 'Hello,<br><br>Device ([device.name]) is expiring in [days] days',
        ]);

        EmailTemplate::updateOrCreate(['name' => 'expired_device'], [
            'name'  => 'expired_device',
            'title' => 'Device expired',
            'note'  => 'Hello,<br><br>Device ([device.name]) expired before [days] days',
        ]);

        EmailTemplate::updateOrCreate(['name' => 'expiring_user'], [
            'name'  => 'expiring_user',
            'title' => 'User expiration',
            'note'  => 'Hello,<br><br>User ([email]) is expiring in [days] days',
        ]);

        EmailTemplate::updateOrCreate(['name' => 'expired_user'], [
            'name'  => 'expired_user',
            'title' => 'User expired',
            'note'  => 'Hello,<br><br>User ([email]) expired before [days] days',
        ]);

        EmailTemplate::updateOrCreate(['name' => 'sharing_link'], [
            'name'  => 'sharing_link',
            'title' => 'Share link',
            'note'  => 'Hello,<br><br>share link: [link]',
        ]);
	}

}