<?php
// Facebook Multi Page/Group Poster v4
// Created by Novartis (Safwan)
// Admin Panel
if (count(get_included_files()) == 1) die();
if ($adminloggedIn)
{
    global $config, $dbName, $adminOptions, $successImg, $failImg, $warnImg, $hardDemo, $availablePlugins;
    if (isset($_GET['doUpdate']) && $adminOptions['updateVersion'])
    {
        if (!function_exists("zip_open")) return "<h4>$failImg Update Error</h4><p>Your server is missing PHP ZIP support. <br>It is part of default PHP package.<br>Please ask your hosting to enable ZIP support for PHP.<br>Updating cannot be done until this issue is resolved.</p>";
        $output = "<p>Initiating update procedure</p>";
        $updateFileName = $dbName . "-" . $adminOptions['updateVersion'] . '.zip';
        if (!file_exists($updateFileName))
        {
            $output .= '<p>Downloading New Update</p>';
            $updateFile = readURL('https://sarirsoftwares.com/fbmpgp/update.php?doUpdate&purchaseCode=' . $adminOptions['purchaseCode'] . '&version=' . $adminOptions['version']);
            if (!$updateFile) return "$output <br>$failImg Error Downloading Update";
            $dlHandler = fopen($updateFileName, 'w');
            if (!fwrite($dlHandler, $updateFile)) return "$output<p>$failImg Could not save new update. Operation aborted.</p>";
            fclose($dlHandler);
            $output .= '<p>Update Downloaded And Saved</p>';
        }
        else  $output .= '<p>Update already downloaded.</p>';
        if (!is_dir('backups')) mkdir('backups');
        $zipHandle = zip_open($updateFileName);
        if (!is_resource($zipHandle)) return "$output<p>$failImg Invalid update file. Please try again later</p>";
        $output .= '<ul>';
        while ($aF = zip_read($zipHandle))
        {
            $thisFileName = zip_entry_name($aF);
            $thisFileDir = dirname($thisFileName);
            if (substr($thisFileName, -1, 1) == '/') continue;
            if (!is_dir($thisFileDir))
            {
                mkdir($thisFileDir, 0777, true);
                $output .= '<li>Created Directory ' . $thisFileDir . '</li>';
            }
            if (!is_dir($thisFileName))
            {
                $output .= '<li>' . $thisFileName . '...........';
                $contents = zip_entry_read($aF, zip_entry_filesize($aF));
                $updateThis = '';
                if ($thisFileName == 'upgrade.php')
                {
                    $upgradeExec = fopen('upgrade.php', 'w');
                    fwrite($upgradeExec, $contents);
                    fclose($upgradeExec);
                    include ('upgrade.php');
                    unlink('upgrade.php');
                    $output .= ' EXECUTED</li>';
                }
                else
                {
                    if (file_exists($thisFileName)) rename($thisFileName, 'backups/' . basename($thisFileName));
                    $updateThis = fopen($thisFileName, 'w');
                    fwrite($updateThis, $contents);
                    fclose($updateThis);
                    unset($contents);
                    $output .= ' UPDATED</li>';
                }
            }
        }
        $output .= '</ul><p>All existing files were backed up to <strong>backups</strong> folder before being updated</p><p class="success">' . $successImg . ' FBMPGP Updated to v' . $adminOptions['updateVersion'] . '</p>';
        $adminOptions['version'] = $adminOptions['updateVersion'];
        $adminOptions['updateVersion'] = '';
        saveAdminOptions();
        unlink($updateFileName);
        return $output;
    }
    if ((isset($_POST['adminOptions']) || isset($_POST['appID']) || isset($_POST['purchaseCode'])) && $hardDemo)
    {
        $warn = "This is online Demo, therefore, settings cannot be changed";
        if (isset($_POST['purchaseCode']) && (!isset($_POST['adminOptions']))) die("Disabled in Demo");
    }
    elseif (isset($_POST['adminOptions']))
    {
        foreach ($_POST as $key => $data)
        {
            if ($key != "adminOptions") $adminOptions[$key] = $data;
        }
        if (is_numeric($_POST['adminTimeZone']))
        {
            $timezone = 'Etc/GMT' . ($_POST['adminTimeZone'] > 0 ? '-' : '+');
            $timezone .= abs($_POST['adminTimeZone']);
        }
        else
        {
            $timezone = $_POST['adminTimeZone'];
        }
        $adminOptions['adminTimeZone'] = $timezone;
        execComponent('adminPanelSave');
        saveAdminOptions();
        setcookie("FBMPGPLang", $adminOptions['lang'], time() + 86400 * 365);
        header("Location: ./?notify=" . $lang['Settings Saved']);
        exit;
    }
    elseif (isset($_POST['purchaseCode']))
    {
        $adminOptions['purchaseCode'] = $_POST['purchaseCode'];
        $adminOptions['lastUpdateCheck'] = time();
        saveAdminOptions(); //Should prevent too-fast checks
        $updateCheckResult = readURL('https://sarirsoftwares.com/fbmpgp/update.php?purchaseCode=' . $adminOptions['purchaseCode'] . '&version=' . $adminOptions['version'] . '&path=' . $_SERVER['SCRIPT_NAME'] . '&url=' . ($_SERVER['HTTPS'] && $_SERVER['HTTPS'] !== 'off' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST']) or die("$failImg $updateCheckResult" . $lang['Error Checking Update']);
        if ($updateCheckResult != '.')
        {
            $updateCheckResult = json_decode($updateCheckResult);
            $adminOptions['updateVersion'] = $updateCheckResult->{'version'};
            saveAdminOptions();
            die($updateCheckResult->{'html'});
        }
        else  die($successImg . " " . $lang['Latest Version']);
    }
    elseif (isset($_POST['appID']) && isset($_POST['appSecret']))
    {
        if ($db = new PDO('sqlite:' . $dbName . '-settings.db'))
        {
            $statement = $db->prepare("UPDATE Settings SET appid = \"" . $_POST['appID'] . "\", secret = \"" . $_POST['appSecret'] . "\" WHERE admin <> 0");
            if ($statement)
            {
                $statement->execute();
            }
            else
            {
                showHTML("Application changing failed while executing database statement.");
            }
            if ($db = new PDO('sqlite:' . $dbName . '-users.db'))
            {
                $statement = $db->prepare("UPDATE FB SET usertoken = \"\" WHERE username <> 0");
                if ($statement)
                {
                    $statement->execute();
                }
            }
            $adminOptions["admintoken"] = "";
            saveAdminOptions();
            header("Location: ./");
            exit;
        }
    }
    if ($config['appId']) $app = json_decode(readURL('https://graph.facebook.com/' . $GLOBALS['__FBAPI__'] . '/' . $config['appId'] . '?access_token=' . $config['appId'] . '|' . $config['secret']));
    else  $app = "";
    $output = "<div class='d-flex-lg flex-justify-between'><div class='my-1 flex-self-start order-3' data-role='panel' data-title-caption='FBMPGP v" . $adminOptions['version'] . "' data-cls-content='text-center'> <p class='' id='checkUpdateResult'></p>
       <div class='button rounded mt-2 h-auto " . ((time() - $adminOptions['lastUpdateCheck']) > 86400 * 7 ? "warning ani-vertical" : "info") . "' id='checkUpdate' onclick='checkUpdateClick()'>" . $lang['check for updates'] . "</div><p class='text-small'>" . $lang['Last Checked'] . ": " . ($adminOptions['lastUpdateCheck'] ? date('d-M-Y G:i', $adminOptions['lastUpdateCheck']) : "-") . "</p>        
        </div>
          
        <div id='admindiv' class='my-1' data-role='panel' data-title-caption='" . $lang['Application'] . " " . $lang['Information'] . "'>";
    if (isset($app->id)) $output .= "$successImg <strong>" . $lang['Application'] . " " . $lang['ID'] . "</strong>: " . $app->id;
    else  $output .= "<span class='mif-cross tally error'></span> <strong>" . $lang['Application'] . " " . $lang['ID'] . "</strong></span>: <span title='App ID and/or App Secret is Invalid'>" . ($config['appId'] ? $config['appId'] : "<span class='mif-blocked tally error'></span>") . "</span>";
    $output .= "&nbsp;&nbsp;<button class='button info rounded small' id=changeAppText title='" . $lang['Change App ID'] . "'>" . $lang['Change'] . "</button></a><br />";
    if (isset($app->name))
    {
        $output .= "$successImg <strong>" . $lang['Application'] . " " . $lang['Name'] . "</strong>: " . $app->name . "<br />";
        if (isset($adminOptions["admintoken"]) && $adminOptions["admintoken"] != "")
        {
            try
            {
                $permissions = $fb->api("/" . $GLOBALS['__FBAPI__'] . "/me/permissions", array("access_token" => $adminOptions["admintoken"]));
                foreach ($permissions['data'] as $perm)
                {
                    if ($perm['status'] == 'granted')
                    {
                        $valid = true;
                        break;
                    }
                }
                if (isset($valid)) $output .= "$successImg <strong>" . $lang['Application'] . " " . $lang['Administrator Token'] . "</strong>: " . $lang['Installed'] . " " . $lang['and'] . " " . $lang['valid'];
                else  $output .= "<span class='mif-cross tally error'></span> <strong>" . $lang['Application'] . " " . $lang['Administrator Token'] . "</strong>: " . $lang['Installed'] . " " . $lang['and'] . " " . $lang['invalid'] . "<form name=refresh id=adminToken method=get>
                        <input type=hidden name=rg value=1>
                        <input type=submit class='button rounded info' value='" . $lang['Reinstall Token'] . "'></form>";
            }
            catch (exception $e)
            {
                $output .= "<span class='mif-cross tally error'></span> <strong>" . $lang['Application'] . " " . $lang['Administrator Token'] . "</strong>: <span title='" . $e->getMessage() . "'>" . $lang['Installed'] . " " . $lang['and'] . " " . $lang['invalid'] . "</span>
                    <form name=refresh id=adminToken method=get>
                    <input type=hidden name=rg value=1>
                    <input type=submit class='button rounded info' value='" . $lang['Reinstall Token'] . "'></form>";
            }
        }
        else
        {
            $output .= "<span class='mif-cross tally error'></span> <strong>" . $lang['Application'] . " " . $lang['Administrator Token'] . "</strong>:
            <span title='You may alternatively, logout and signup + authorize as a user who is an administrator of the configured facebook application to install this token'>" . $lang['Not Installed'] . "</span>&nbsp;&nbsp;
            <form name=refresh id=adminToken method=get>
            <input type=hidden name=rg value=1>
            <input type=submit class='button rounded info' value='" . $lang['Install Token'] . "'></form>";
        }
    }
    else
    {
        $output .= "<span class='mif-cross tally error'></span> <strong>" . $lang['Application'] . " " . $lang['Name'] . "</strong>: <br />";
    }
    $output .= "</div>";
    //Admin Options
    $output .= "
        <div class='my-1' data-role='panel' data-title-caption='" . $lang['Change'] . " " . $lang['password'] . "'>
        <form name=adminCP method=post>
        <table class='table compact'>
        <tr><td>" . $lang['Enter'] . " " . $lang['current'] . " " . $lang['password'] . ":<td> <input type=password name=oldP>
        <tr><td>" . $lang['Enter'] . " " . $lang['new'] . " " . $lang['password'] . ":<td> <input type=password name=newP>
        <tr><td>" . $lang['Repeat'] . " " . $lang['new'] . " " . $lang['password'] . ":<td> <input type=password name=renewP>
        <tr><td colspan=2 class='text-center'><input class='button rounded' type=submit value='" . $lang['Submit'] . "'></center></table>";
    if (isset($_POST['oldP']) && isset($_POST['newP']) && isset($_POST['renewP']))
    {
        $output .= "<p class='text-center'>";
        if ($_POST['oldP'] != $adminPassword)
        {
            $output .= "<span class='tally error'>" . $lang['Incorrect'] . " " . $lang['password'] . "</span>";
        }
        elseif ($_POST['newP'] != $_POST['renewP'])
        {
            $output .= "<span class='tally warning'>" . $lang['Passwords'] . " " . $lang['do not match'] . "</span>";
        }
        elseif (strlen($_POST['newP']) < 5)
        {
            $output .= "<span class='tally warning'>" . $lang['Password'] . " " . $lang['length'] . "</span>";
        }
        elseif ($hardDemo)
        {
            $output .= "<span class='tally info'>Password cannot be changed in Demo!</span>";
        }
        else
        {
            $newP = encrypt($_POST['newP']);
            if ($db = new PDO('sqlite:' . $dbName . '-settings.db'))
            {
                $statement = $db->prepare("UPDATE Settings SET adminpass = \"$newP\" WHERE appid <> 0");
                if ($statement)
                {
                    $statement->execute();
                    $output .= "<span class='tally success'>" . $lang['Password'] . " " . $lang['Changed'] . " " . $lang['Successfully'] . "</span>";
                }
                else
                {
                    $output .= "<span class='tally error'>" . $lang['Critical Error'] . " " . $lang['while changeing'] . " " . $lang['Password'] . "</span>";
                }
            }
            else
            {
                $output .= "<span class='tally error'>Error opening database!</span>";
            }
        }
        $output .= "</p>";
    }
    $output .= "</form></div></div>        
        <form method=POST id=adminForm name=adminForm><input type=hidden name=adminOptions value=1>
        <div class='mt-5 w-100' data-role='panel' data-title-caption='" . $lang['Admin'] . " " . $lang['Options'] . "'>
        <table class='table striped'>
        <tr><td>" . $lang['Purchase Code'] . ":&nbsp;<sup><a href='http://i.imgur.com/wFF7VMD.gif' target='_new' title='How to find Purchase Code'>?</a></sup><td><input type=text name='purchaseCode' id='purchaseCodeAdminOptions' class='textbox' placeholder='' value='" . ($hardDemo ? "***" : $adminOptions['purchaseCode']) . "'>
        <tr><td>" . $lang['Enable'] . " " . $lang['New User Registration'] . ":<td><input type=radio data-role=radio name=enableNUR value=1 " . ($adminOptions['enableNUR'] == 1 ? "checked" : "") . " data-caption='" . $lang['Yes'] . "'>
            <br /><input type=radio data-role=radio name=enableNUR value=2 " . ($adminOptions['enableNUR'] == 2 ? "checked" : "") . " data-caption='" . $lang['Require Approval'] . "'>
            <br /><input type=radio data-role=radio name=enableNUR value=0 " . ($adminOptions['enableNUR'] == 0 ? "checked" : "") . " data-caption='" . $lang['No'] . "'>
        <tr><td>" . $lang['Email Verification'] . ":<td><input type=checkbox data-role=checkbox name=emailVerify " . ($adminOptions['emailVerify'] == 0 ? "" : "checked") . ">
        <tr><td>" . $lang['Automatic Role Assignments'] . ":<td><input type=checkbox data-role=checkbox name=enableARA " . ($adminOptions['enableARA'] == 0 ? "" : "checked") . ">
        <tr><td>";
    $output .= $lang['Enable'] . " " . $lang['CRON Scheduling'] . ":<td><input type=checkbox data-role=checkbox name=useCron " . ($adminOptions['useCron'] == 0 ? "" : "checked") . "><br>";
    if ($adminOptions['useCron'])
    {
        if ((time() - $adminOptions['lastCronExecution']) > ($adminOptions['cronDelay'] * 60 * 2)) $output .= "$warnImg";
        else  $output .= "$successImg";
        $output .= " <small>( " . $lang['Last'] . " " . $lang['CRON Run'] . ": " . date('d-M-Y G:i', $adminOptions['lastCronExecution']) . ")</small>";
    }
    $output .= "<tr><td>" . $lang['Demo Mode'] . ":<td><input type=checkbox data-role=checkbox name=enableDemo " . ($adminOptions['enableDemo'] == 0 ? "" : "checked") . ">";
    $output .= "<tr><td>" . $lang['Interface Language'] . ":<td><select name='lang'>";
    $langs = glob("lang/*.php");
    foreach ($langs as $file)
    {
        $filename = substr($file, 5, -9);
        $output .= "<option value='$filename'" . ($filename == $adminOptions['lang'] ? " selected" : "") . ">" . strtoupper($filename);
    }
    $output .= "</select>
    <tr><td>" . $lang['Admin'] . " " . $lang['Time Zone'] . ":<td><select name='adminTimeZone' id='adminTimeZone'>
                " . file_get_contents('includes/timezones.html') . "
          </select><input type=hidden name=adminTimeZoneId></tr></table></div><p class='text-center'><input class='button rounded primary' type=submit value='" . $lang['Save Settings'] . "'></p>
        
        <div class='d-flex-lg mt-5'><div class='w-100' data-role='panel' data-title-caption='" . $lang['Email'] . " " . $lang['Options'] . "'>
    	<table class='table striped'>
    	<tr><td>" . $lang['Admin'] . " " . $lang['Email'] . ":<td><input type=text name='adminEmail' class='textbox' placeholder='' value='" . ($hardDemo ? "" : $adminOptions['adminEmail']) . "'>
        <tr><td>" . $lang['Notifications'] . ": " . $lang['New User Registration'] . "<td><input type=checkbox data-role=checkbox name=notifySignUp " . ($adminOptions['notifySignUp'] == 0 ? "" : "checked") . ">
        <tr><td>" . $lang['Email'] . " " . $lang['Server'] . ":<td><input type=radio data-role=radio name=emailServer value='Sarir' " . ($adminOptions['emailServer'] == 'Sarir' ? "checked" : "") . " data-caption='Sarir'>
            <br /><input type=radio data-role=radio name=emailServer value='php' " . ($adminOptions['emailServer'] == 'php' ? "checked" : "") . " data-caption='PHP'>";
    //Posting Options
    $output .= "</table></div>
        <div class='w-100' data-role='panel' data-title-caption='" . $lang['Posting'] . " " . $lang['Options'] . "'>
        <table class='table striped'>";
    $output .= "<tr><td>" . $lang['Minimum'] . " " . $lang['Delay'] . ":<td><select name=minimumDelay>";
    for ($i = 1; $i <= 1800; $i += 5)
    {
        $i = $i - ($i % 5);
        if ($i == 0) $i = 1;
        if ($i == $adminOptions['minimumDelay']) $output .= "<option value=$i selected>$i " . $lang['sec'] . "</option>";
        else  $output .= "<option value=$i>$i " . $lang['sec'] . "</option>";
    }
    $output .= "</select>
        <tr><td>" . $lang['Default'] . " " . $lang['Delay'] . ":<td><select name=defaultDelay>";
    for ($i = 1; $i <= 1800; $i += 5)
    {
        $i = $i - ($i % 5);
        if ($i == 0) $i = 1;
        if ($i == $adminOptions['defaultDelay']) $output .= "<option value=$i selected>$i " . $lang['sec'] . "</option>";
        else  $output .= "<option value=$i>$i " . $lang['sec'] . "</option>";
    }
    $output .= "</select>";
    $output .= "<tr><td>" . $lang['CRON Run'] . " " . $lang['Delay'] . ":<td><select name=cronDelay>";
    for ($i = 1; $i <= 30; ++$i)
    {
        if ($i == $adminOptions['cronDelay']) $output .= "<option value=$i selected>$i " . $lang['min'] . "</option>";
        else  $output .= "<option value=$i>$i " . $lang['min'] . "</option>";
    }
    $output .= "</select>";
    $output .= "<tr><td>" . $lang['Maximum Cron Posts'] . ":<td><select name=maxCronPosts>";
    for ($i = 1; $i <= 10; ++$i)
    {
        if ($i == $adminOptions['maxCronPosts']) $output .= "<option value=$i selected>$i " . $lang['posts'] . "</option>";
        else  $output .= "<option value=$i>$i " . $lang['posts'] . "</option>";
    }
    $output .= "</select>
        <tr><td>imgur.com " . $lang['Client'] . " " . $lang['ID'] . ":<br><small><a href='https://api.imgur.com/oauth2/addclient' target='_new'>(" . $lang['Click to Create'] . ")</a></small><td><input type=" . ($hardDemo ? "password" : "text") . " name='imgurCID' class='textbox' placeholder='For Image Uploading' value='" . $adminOptions['imgurCID'] . "'>
        </table></div></div><p class='text-center'><input class='button rounded primary' type=submit value='" . $lang['Save Settings'] . "'></p>";
    //Customization Options
    $output .= "<div class='d-flex-lg mt-5'><div class='w-75-lg' data-role='panel' data-title-caption='" . $lang['Customization'] . " " . $lang['Options'] . "'>
    <table class='table striped'>
        <tr><th colspan=2><small>" . $lang['Leave blank default'] . "</small>
        <tr><td>" . $lang['Theme'] . ":<td><select name='theme' class='textbox'>";
    $themes = glob("themesv4/*.php");
    foreach ($themes as $file)
    {
        $filename = substr($file, 9, -4);
        $output .= "<option value='$filename'" . ($filename == $adminOptions['theme'] ? " selected" : "") . ">" . ucwords($filename);
    }
    $output .= "</select>
        <tr><td>" . $lang['Logo'] . " " . $lang['URL'] . ":<td><input type=text name='scriptLogo' class='textbox' placeholder='' value='" . $adminOptions['scriptLogo'] . "'>
        <tr><td>" . $lang['Webpage'] . " " . $lang['Title'] . ":<td><input type=text name='scriptTitle' class='textbox' placeholder='Facebook Multi Page Group Poster' value='" . $adminOptions['scriptTitle'] . "'>
        <tr><td>" . $lang['Main Heading'] . ":<td><input type=text name='scriptHeading' class='textbox' placeholder='Facebook Poster' value='" . $adminOptions['scriptHeading'] . "'>
        <tr><td>" . $lang['Extra Footer'] . ":<td><textarea name='scriptFooter' class='textbox' placeholder='HTML allowed. You may also place scripts (like Google Analytics etc.) here'>" . $adminOptions['scriptFooter'] . "</textarea>";
    $output .= "</table></div>";
    if ($adminOptions['theme'] != 'fbmpgp')
    {
        $output .= "<div class='w-50-lg' data-role='panel' data-title-caption='" . $lang['Theme'] . " " . $lang['Options'] . "'>
        <table class='table striped'>
            <tr><th colspan=2><small>" . $lang['Leave blank default'] . "</small>
            <tr><td>" . $lang['Theme'] . " " . $lang["Style"] . ":<td><select name='style'><option value='default'>Default";
        $themes = glob("themesv4/" . $adminOptions['theme'] . "/*.css");
        foreach ($themes as $file)
        {
            $filename = pathinfo($file, PATHINFO_FILENAME);
            $output .= "<option value='$filename'" . ($filename == $adminOptions['style'] ? " selected" : "") . ">" . ucwords($filename);
        }
        $output .= "</select>
            <tr><td>" . $lang['Main BG Color'] . ":<td><input type=text data-role=input name='modernMBGC' class='color {hash:true, required:false} textbox' value='" . $adminOptions['modernMBGC'] . "'>
                    <tr><td>" . $lang['Content BG Color'] . ":<td><input type=text data-role=input name='modernCBGC' class='color {hash:true, required:false} textbox' value='" . $adminOptions['modernCBGC'] . "'>
                    <tr><td>" . $lang['Header BG Color'] . ":<td><input type=text data-role=input name='modernHBGC' class='color {hash:true, required:false} textbox' value='" . $adminOptions['modernHBGC'] . "'>
                    </table></div></div>";
    }
    if (count($availablePlugins))
    {
        $output .= "<div class='mt-5' data-role='panel' data-title-caption='" . $lang['Enable'] . " " . $lang['Plugins'] . "'>
        <table class='table striped'>";
        foreach ($availablePlugins as $pluginName)
        {
            $output .= "<tr><td>" . ucwords($pluginName) . "<td><input type=checkbox data-role=checkbox name='plug_" . $pluginName . "' " . ($adminOptions['plug_' . $pluginName] ? "checked" : "") . ">";
        }
        $output .= "</table></div>";
    }
    $output = doPlug('adminPanel', $output);
    $output .= "<p class='text-center'><input class='button rounded primary' type=submit value='" . $lang['Save Settings'] . "'></p>
        </form></div>";
    $output .= "</div>
            <script> 
            function showCaution(){
        	   event.preventDefault();
        	   Metro.dialog.create({
                    title: '" . $lang['Important Note'] . "',
                    content: '" . $lang['App Change Note'] . "',
                    actions: [
                        {
                            caption: '" . $lang['Cancel'] . "',
                            cls: 'js-dialog-close'
                        },
                        {
                            caption: '" . $lang['Proceed'] . "',
                            cls: 'alert',
                            onclick: function(){
                                $('#changeAppForm').submit();
                            }
                        }
                    ]
                });
            }         
            $('#adminForm').submit(function(event){ 
                Metro.activity.open({
                    type: 'cycle',
                    style: 'color',
                    overlayAlpha: 0.85,
                    overlayColor: '#fff',                                                            
                    text: '<div class=\'mt-2 text-small\'>Saving, please wait...</div>',
                });
                $('input[type=checkbox]').each(function() {
                    if (this.checked) {
                        this.value=1;
                    } else {
                        this.checked=true;
                        this.value=0;
                    }
                });
                document.forms['adminForm'].adminTimeZoneId.value = document.forms['adminForm'].adminTimeZone.selectedIndex;
            });
            $('#adminToken').submit(function(event){
                /**
                 * Metro.dialog.create({
                 *                     title: '" . $lang['Important Note'] . "',
                 *                     content: '" . $lang['Admin Token Note'] . "',
                 *                     actions: [
                 *                         {
                 *                             caption: '" . $lang['Cancel'] . "',
                 *                             cls: 'js-dialog-close'
                 *                         },
                 *                         {
                 *                             caption: '" . $lang['Proceed'] . "',
                 *                             cls: 'js-dialog-close alert'
                 *                         }
                 *                     ]
                 *                 });
                 */
            });            
                        
            $(document).ready(function() {             	
                $('#purchaseCodeForm').submit(function(event){
                    event.preventDefault();
                    Metro.dialog.close('#purchaseCode');
                    $('#purchaseCodeAdminOptions').val($('#purchaseCodeUpdateForm').val());
                    $('#checkUpdateResult').html('<div class=\'mx-auto\' data-role=\'activity\' data-type=\'ring\' data-style=\'color\'></div>');
                    $.post( './', $('#purchaseCodeForm').serialize(), function( data ) {
                      $('#checkUpdateResult').html(''); 
                      $( '#checkUpdateResult' ).html( data );
                    }); 
                });                
                tz = parseFloat(" . $adminOptions['adminTimeZoneId'] . ");
                document.getElementById(\"adminTimeZone\").selectedIndex = tz; 
                $('#changeAppText').click(function(e) {
                    Metro.dialog.open('#changeApp');
                    //e.preventDefault();
                });                
                " . ($adminOptions['purchaseCode'] != '' ? "$('#purchaseCodeForm').submit();" : "") . "
            });
            function checkUpdateClick() {
                Metro.dialog.open('#purchaseCode');
                //e.preventDefault();
            }
            function createWindow() {
                Metro.window.create({
                    title: '" . $lang['Whats new'] . "',
                    content: document.getElementById('whatsNewResult').innerHTML,
                    btnMin: false,
                    btnMax: false,
                    place: 'center',
                    height: 300,
                    clsWindow: 'pos-fixed pos-center',
                    clsContent: 'p-2'
                });
            }
           </script>";
    //Dialogs
    $output .= "<div id=changeApp class='dialog' data-role='dialog'>
                    <form name=changeAppForm id='changeAppForm' class='lightbox' onsubmit='showCaution()' method=post>    
                  <div class='dialog-title'>" . $lang['Enter New Application'] . "</div>          
                  <div class='dialog-content'>          
                  <table class='table compact'>
                  <tr><td>" . $lang['Application'] . " " . $lang['ID'] . "
                    <td><input type=text size=10 name=appID class='textbox'>
                  <tr><td>" . $lang['Application'] . " " . $lang['Secret'] . "
                    <td><input type=text size=10 name=appSecret class='textbox'>
                  </table>          
                  </div><div class='dialog-actions'><button type=button class='button js-dialog-close'>" . $lang['Cancel'] . "</button><input class='button rounded primary' type=submit id='changeAppSubmit' value='" . $lang['Save Settings'] . "'></div></form></div>";
    $output .= " <div id=purchaseCode class='dialog' data-role='dialog'>  
                    <form name=purchaseCodeForm id='purchaseCodeForm' class='lightbox' method=post>      
          <div class='dialog-title'>" . $lang['Enter'] . " " . $lang['Purchase Code'] . "</div>          
          <div class='dialog-content'> 
          <input type=text size=10 id=purchaseCodeUpdateForm name=purchaseCode class='textbox' value='" . $adminOptions['purchaseCode'] . "'>
          </div><div class='dialog-actions'><button type=button class='button js-dialog-close'>" . $lang['Cancel'] . "</button><input class='button rounded primary' type=submit id='updateCheckSubmit' value='" . $lang['Proceed'] . "'></div></form></div>
            <div id=whatsNewResult class='d-none'>.</div>
            </div>";
    return $output;
}
?>