<div class="panel panel-default">

    <div class="panel-heading">
        <div class="panel-title"><i class="icon setup"></i> <?php echo e(trans('front.main_server_settings')); ?></div>
    </div>

    <div class="panel-body">
        <?php echo Form::open(array('route' => 'admin.main_server_settings.save', 'method' => 'POST', 'class' => 'form form-horizontal', 'id' => 'main-settings-form')); ?>


        <div class="form-group">
            <?php echo Form::label('server_name', trans('validation.attributes.server_name'), ['class' => 'col-xs-12 control-label"']); ?>

            <div class="col-xs-12">
                <?php echo Form::text('server_name', $settings['server_name'], ['class' => 'form-control']); ?>

            </div>
        </div>

        <div class="form-group">
            <?php echo Form::label('server_description', trans('validation.attributes.server_description'), ['class' => 'col-xs-12 control-label"']); ?>

            <div class="col-xs-12">
                <?php echo Form::text('server_description', $settings['server_description'], ['class' => 'form-control']); ?>

            </div>
        </div>

        <div class="form-group">
            <div class="col-xs-12">
                <?php echo Form::label(null, trans('validation.attributes.default_maps').':'); ?>

                <div class="checkboxes">
                    <?php echo Form::hidden('available_maps'); ?>


                    <?php $__currentLoopData = $maps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $title): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="checkbox">
                            <?php echo Form::checkbox('available_maps[]', $id, in_array($id, $settings['available_maps'])); ?>

                            <?php echo Form::label(null, $title); ?>

                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>

        <div class="map-setting map-setting-1 map-setting-3 map-setting-4 map-setting-5">
            <div class="form-group">
                <?php echo Form::label('google_maps_key', trans('validation.attributes.google_maps_key'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

                <div class="col-xs-12 col-sm-8">
                    <?php echo Form::text('google_maps_key', settings('main_settings.google_maps_key'), ['class' => 'form-control']); ?>

                </div>
            </div>
        </div>

        <div class="map-setting map-setting-10">
            <div class="form-group">
                <?php echo Form::label('here_api_key', trans('validation.attributes.here_api_key'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

                <div class="col-xs-12 col-sm-8">
                    <?php echo Form::text('here_api_key', settings('main_settings.here_api_key'), ['class' => 'form-control']); ?>

                </div>
            </div>
        </div>

        <div class="map-setting map-setting-14 map-setting-15 map-setting-16">
            <div class="form-group">
                <?php echo Form::label('mapbox_access_token', trans('validation.attributes.mapbox_access_token'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

                <div class="col-xs-12 col-sm-8">
                    <?php echo Form::text('mapbox_access_token', settings('main_settings.mapbox_access_token'), ['class' => 'form-control']); ?>

                </div>
            </div>
        </div>

        <div class="map-setting map-setting-7 map-setting-8 map-setting-9">
            <div class="form-group">
                <?php echo Form::label('bing_maps_key', trans('validation.attributes.bing_maps_key'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

                <div class="col-xs-12 col-sm-8">
                    <?php echo Form::text('bing_maps_key', settings('main_settings.bing_maps_key'), ['class' => 'form-control']); ?>

                </div>
            </div>
        </div>

        <div class="map-setting map-setting-17 map-setting-18 map-setting-19">
            <div class="form-group">
                <?php echo Form::label('maptiler_key', trans('validation.attributes.maptiler_key'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

                <div class="col-xs-12 col-sm-8">
                    <?php echo Form::text('maptiler_key', settings('main_settings.maptiler_key'), ['class' => 'form-control']); ?>

                </div>
            </div>
        </div>

        <div class="map-setting map-setting-21">
            <div class="form-group">
                <?php echo Form::label('openmaptiles_url', trans('validation.attributes.openmaptiles_url'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

                <div class="col-xs-12 col-sm-8">
                    <?php echo Form::text('openmaptiles_url', settings('main_settings.openmaptiles_url'), ['class' => 'form-control']); ?>

                </div>
            </div>
        </div>

        <hr>

        <div class="form-group">
            <?php echo Form::label('default_language', trans('validation.attributes.default_language'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

            <div class="col-xs-12 col-sm-8">
                <select name="default_language" class="form-control" data-icon="icon globe">
                <?php $__currentLoopData = $langs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($lang['key']); ?>" <?php echo e($lang['key'] == $settings['default_language'] ? 'selected="selected"' : ''); ?> <?php echo e(empty($lang['active']) ? 'disabled="disabled"' : ''); ?>>
                    <?php echo e($lang['title']); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>

        <div class="form-group">
            <?php echo Form::label('default_date_format', trans('validation.attributes.default_date_format'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

            <div class="col-xs-12 col-sm-8">
                <?php echo Form::select('default_date_format', $date_formats, $settings['default_date_format'], ['class' => 'form-control', 'data-icon' => 'icon calendar']); ?>

            </div>
        </div>

        <div class="form-group">
            <?php echo Form::label('default_time_format', trans('validation.attributes.default_time_format'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

            <div class="col-xs-12 col-sm-8">
                <?php echo Form::select('default_time_format', $time_formats, $settings['default_time_format'], ['class' => 'form-control', 'data-icon' => 'icon calendar']); ?>

            </div>
        </div>

        <div class="form-group">
            <?php echo Form::label('default_unit_of_distance', trans('validation.attributes.default_unit_of_distance'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

            <div class="col-xs-12 col-sm-8">
                <?php echo Form::select('default_unit_of_distance', $units_of_distance, $settings['default_unit_of_distance'], ['class' => 'form-control', 'data-icon' => 'icon unit-distance']); ?>

            </div>
        </div>

        <div class="form-group">
            <?php echo Form::label('default_unit_of_capacity', trans('validation.attributes.default_unit_of_capacity'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

            <div class="col-xs-12 col-sm-8">
                <?php echo Form::select('default_unit_of_capacity', $units_of_capacity, $settings['default_unit_of_capacity'], ['class' => 'form-control', 'data-icon' => 'icon unit-capacity']); ?>

            </div>
        </div>

        <div class="form-group">
            <?php echo Form::label('default_unit_of_altitude', trans('validation.attributes.default_unit_of_altitude'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

            <div class="col-xs-12 col-sm-8">
                <?php echo Form::select('default_unit_of_altitude', $units_of_altitude, $settings['default_unit_of_altitude'], ['class' => 'form-control', 'data-icon' => 'icon unit-altitude']); ?>

            </div>
        </div>

        <div class="form-group">
            <?php echo Form::label('default_object_online_timeout', trans('validation.attributes.default_object_online_timeout'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

            <div class="col-xs-12 col-sm-8">
                <?php echo Form::select('default_object_online_timeout', $object_online_timeouts, $settings['default_object_online_timeout'], ['class' => 'form-control', 'data-icon' => 'icon time']); ?>

            </div>
        </div>

        <div class="form-group">
            <?php echo Form::label('default_map', trans('validation.attributes.default_map'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

            <div class="col-xs-12 col-sm-8">
                <?php echo Form::select('default_map', $maps, $settings['default_map'], ['class' => 'form-control', 'data-icon' => 'icon map']); ?>

            </div>
        </div>

        <div class="form-group">
            <?php echo Form::label('map_zoom_level', trans('validation.attributes.map_zoom_level'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

            <div class="col-xs-12 col-sm-8">
                <?php echo Form::select('map_zoom_level', $zoom_levels, settings('main_settings.map_zoom_level'), ['class' => 'form-control', 'data-icon' => 'icon search']); ?>

            </div>
        </div>

        <div class="form-group">
            <?php echo Form::label('map_center_latitude', trans('validation.attributes.map_center_latitude'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

            <div class="col-xs-12 col-sm-8">
                <?php echo Form::text('map_center_latitude', settings('main_settings.map_center_latitude'), ['class' => 'form-control']); ?>

            </div>
        </div>

        <div class="form-group">
            <?php echo Form::label('map_center_longitude', trans('validation.attributes.map_center_longitude'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

            <div class="col-xs-12 col-sm-8">
                <?php echo Form::text('map_center_longitude', settings('main_settings.map_center_longitude'), ['class' => 'form-control']); ?>

            </div>
        </div>

        <div class="form-group">
            <?php echo Form::label('geocoder_api', trans('validation.attributes.geocoder_api'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

            <div class="col-xs-12 col-sm-8">
                <?php echo Form::select('geocoder_api', $geocoder_apis, settings('main_settings.geocoder_api'), ['class' => 'form-control']); ?>

            </div>
        </div>

        <div class="form-group api_key">
            <?php echo Form::label('api_key', trans('validation.attributes.api_key'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

            <div class="col-xs-12 col-sm-8">
                <?php echo Form::text('api_key', settings('main_settings.api_key'), ['class' => 'form-control']); ?>

            </div>
        </div>
        <div class="form-group api_url">
            <?php echo Form::label('api_url', trans('validation.attributes.api_url'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

            <div class="col-xs-12 col-sm-8">
                <?php echo Form::text('api_url', settings('main_settings.api_url'), ['class' => 'form-control', 'placeholder' => 'http://yourdomain.com/nominatim/reverse.php']); ?>

            </div>
        </div>
        <div class="form-group api_app_id">
            <?php echo Form::label('api_app_id', trans('validation.attributes.api_app_id'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

            <div class="col-xs-12 col-sm-8">
                <?php echo Form::text('api_app_id', settings('main_settings.api_app_id'), ['class' => 'form-control']); ?>

            </div>
        </div>
        <div class="form-group api_app_secret">
            <?php echo Form::label('api_app_secret', trans('validation.attributes.api_app_secret'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

            <div class="col-xs-12 col-sm-8">
                <?php echo Form::text('api_app_secret', settings('main_settings.api_app_secret'), ['class' => 'form-control']); ?>

            </div>
        </div>

        <div class="form-group">
            <?php echo Form::label('geocoder_cache_enabled', trans('validation.attributes.geocoder_cache'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

            <div class="col-xs-12 col-sm-8">
                <?php echo Form::select('geocoder_cache_enabled', $geocoder_cache_status, settings('main_settings.geocoder_cache_enabled'), ['class' => 'form-control']); ?>

            </div>
        </div>

        <?php if(settings('main_settings.geocoder_cache_enabled')): ?>
            <div class="form-group">
                <?php echo Form::label('geocoder_cache_days', trans('validation.attributes.geocoder_cache_days'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

                <div class="col-xs-12 col-sm-8">
                    <div class="input-group">
                        <?php echo Form::select('geocoder_cache_days', $geocoder_cache_days, settings('main_settings.geocoder_cache_days'), ['class' => 'form-control']); ?>

                        <span class="input-group-btn">
                            <button class="btn btn-danger" type="button" onClick="$('#delete-geocoder-cache-form').submit();">
                                <i class="icon trash"></i>
                            </button>
                        </span>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <div class="form-group">
            <?php echo Form::label('streetview_api', trans('validation.attributes.streetview_api'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

            <div class="col-xs-12 col-sm-8">
                <div class="input-group">
                    <?php echo Form::select('streetview_api', $streetview_apis, $streetview_api, ['class' => 'form-control']); ?>

                </div>
            </div>
        </div>
        <div class="form-group">
            <?php echo Form::label('streetview_key', trans('validation.attributes.streetview_key'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

            <div class="col-xs-12 col-sm-8">
                <div class="input-group">
                    <?php echo Form::text('streetview_key', $streetview_key, ['class' => 'form-control']); ?>

                </div>
            </div>
        </div>

        <div class="form-group">
            <?php echo Form::label('expire_notification[days_before]', trans('admin.expire_notification_before_days'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

            <div class="col-xs-12 col-sm-8">
                <div class="input-group">
                    <div class="checkbox input-group-btn">
                        <?php echo Form::hidden('expire_notification[active_before]', 0); ?>

                        <?php echo Form::checkbox('expire_notification[active_before]', 1, settings('main_settings.expire_notification.active_before')); ?>

                        <?php echo Form::label(null, null); ?>

                    </div>
                    <?php echo Form::text('expire_notification[days_before]', settings('main_settings.expire_notification.days_before'), ['class' => 'form-control']); ?>

                </div>
            </div>
        </div>

        <div class="form-group">
            <?php echo Form::label('expire_notification[days_after]', trans('admin.expire_notification_after_days'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

            <div class="col-xs-12 col-sm-8">
                <div class="input-group">
                    <div class="checkbox input-group-btn">
                        <?php echo Form::hidden('expire_notification[active_after]', 0); ?>

                        <?php echo Form::checkbox('expire_notification[active_after]', 1, settings('main_settings.expire_notification.active_after')); ?>

                        <?php echo Form::label(null, null); ?>

                    </div>
                    <?php echo Form::text('expire_notification[days_after]', settings('main_settings.expire_notification.days_after'), ['class' => 'form-control']); ?>

                </div>
            </div>
        </div>

        <div class="form-group">
            <?php echo Form::label('device_cameras_days', trans('validation.attributes.device_cameras_days').' ('.$images_size.')', ['class' => 'col-xs-12 col-sm-4 control-label']); ?>

            <div class="col-xs-12 col-sm-8">
                <?php echo Form::input('number', 'device_cameras_days', settings('main_settings.device_cameras_days'), ['class' => 'form-control', 'min' => '1', 'max' => '180', 'step' => '1']); ?>

            </div>
        </div>

        <div class="form-group">
            <?php echo Form::label('captcha_provider', trans('validation.attributes.captcha_provider'), ['class' => 'col-xs-12 col-sm-4 control-label']); ?>

            <div class="col-xs-12 col-sm-8">
                <?php echo Form::select('captcha_provider', $captcha_providers, settings('main_settings.captcha_provider'), ['class' => 'form-control']); ?>

            </div>
        </div>

        <div class="form-group" data-disablable="#captcha_provider;hide-disable;recaptcha">
            <?php echo Form::label('recaptcha_site_key', trans('validation.attributes.recaptcha_site_key'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

            <div class="col-xs-12 col-sm-8">
                <?php echo Form::text('recaptcha_site_key', settings('main_settings.recaptcha_site_key'), ['class' => 'form-control']); ?>

            </div>
        </div>

        <div class="form-group" data-disablable="#captcha_provider;hide-disable;recaptcha">
            <?php echo Form::label('recaptcha_secret_key', trans('validation.attributes.recaptcha_secret_key'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

            <div class="col-xs-12 col-sm-8">
                <?php echo Form::text('recaptcha_secret_key', settings('main_settings.recaptcha_secret_key'), ['class' => 'form-control']); ?>

            </div>
        </div>
        <?php echo Form::close(); ?>

        <?php echo Form::open(array('route' => 'admin.main_server_settings.delete_geocoder_cache', 'method' => 'POST', 'id' => 'delete-geocoder-cache-form')); ?>

        <?php echo Form::close(); ?>

    </div>

    <div class="panel-footer">
        <button type="submit" class="btn btn-action" onClick="$('#main-settings-form').submit();"><?php echo e(trans('global.save')); ?></button>
    </div>
</div>
<?php $__env->startPush('javascript'); ?>
<script>
    $(document).ready(function() {
        $(document).on('change', 'select[name="geocoder_api"]', function () {
            var val = $(this).val();

            $('.api_key').hide();
            $('.api_url').hide();
            $('.api_app_id').hide();
            $('.api_app_secret').hide();

            if (['google', 'geocodio', 'locationiq', 'longdo', 'here', 'pickpoint'].includes(val)) {
                $('.api_key').show();
            }

            if (val == 'nominatim') {
                $('.api_url').show();
            }

            if(val == "mapmyindia") {
                $('.api_app_id').show();
                $('.api_app_secret').show();
                $('.api_key').show();
            }
        });
        $('select[name="geocoder_api"]').trigger('change');

        $(document).on('change', 'input[name^="available_maps"]', function () {
            $('.map-setting').hide();

            $('input[name^="available_maps"]:checked').each(function() {
                $('.map-setting-'+$(this).val()).show();
            });
        });

        $('input[name^="available_maps"]:first').trigger('change');
    });
</script>
<?php $__env->stopPush(); ?>