<div class="table-responsive">
    <table class="table table-list">
        <thead>
        <tr>
            <th><?php echo e(trans('front.alert_active')); ?></th>
            <th><?php echo e(trans('front.alert_name')); ?></th>
            <th><?php echo e(trans('front.alert_devices_count')); ?></th>
            <th><?php echo e(trans('front.time_period')); ?></th>
            <th></th>
        </tr>
        </thead>
        <tbody>
        <?php if($alerts->isEmpty()): ?>
            <tr>
                <td colspan="5"><?php echo trans('front.nothing_found_request'); ?></td>
            </tr>
        <?php else: ?>
            <?php $__currentLoopData = $alerts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $alert): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td>
                        <span class="label label-sm label-<?php echo $alert->isActive() ? 'success' : 'danger'; ?>">
                            <?php echo trans('validation.attributes.active'); ?>

                        </span>
                    </td>
                    <td><?php echo e($alert->name); ?></td>
                    <td><?php echo e($alert->devices_count); ?></td>
                    <td>
                        <?php if(!empty($alert->pivot->active_from) || !empty($alert->pivot->active_to)): ?>
                            <?php echo e($alert->pivot->active_from ? Formatter::time()->human($alert->pivot->active_from) : '-'); ?>

                             /
                            <?php echo e($alert->pivot->active_to ? Formatter::time()->human($alert->pivot->active_to) : '-'); ?>

                        <?php endif; ?>
                    </td>
                    <td class="actions">
                        <div class="btn-group dropdown droparrow" data-position="fixed">
                            <i class="btn icon edit" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true"></i>
                            <ul class="dropdown-menu">
                                <li>
                                    <a href="javascript:"
                                       data-url="<?php echo route('alerts.edit', ['id' => $alert->id]); ?>"
                                       data-modal="alerts_edit">
                                        <span class="icon alerts"></span>
                                        <?php echo e(trans('global.alert')); ?>

                                    </a>
                                </li>
                                <li>
                                    <a href="javascript:"
                                       data-url="<?php echo route('device.alerts.time_period.edit', ['device_id' => $device->id, 'alert_id' => $alert->id]); ?>"
                                       data-modal="device_alerts_time_period_edit">
                                        <span class="icon time"></span>
                                        <?php echo e(trans('front.time_period')); ?>

                                    </a>
                                </li>
                            </ul>
                        </div>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <?php endif; ?>
        </tbody>
    </table>
</div>

<?php if(!$alerts->isEmpty()): ?>
    <div class="nav-pagination">
        <?php echo $alerts->setPath(route('device.alerts.table', ['device_id' => $device->id]))->render(); ?>

    </div>
<?php endif; ?>
