<div class="tab-pane" id="pois_tab">
    <div class="tab-pane-header">
        <div class="form">
            <div class="input-group">
                <div class="form-group search">
                    <?php echo Form::text('search', null, ['class' => 'form-control', 'placeholder' => trans('front.search'), 'autocomplete' => 'off']); ?>

                </div>
                <?php if(Auth::User()->perm('poi', 'edit')): ?>
                <span class="input-group-btn">
                    <button class="btn btn-default" title="<?php echo e(trans('front.import')); ?>" data-url="<?php echo e(route('pois.import')); ?>" data-modal="pois_import">
                        <i class="icon upload"></i>
                    </button>

                    <a href="javascript:" class="btn btn-primary" type="button" onClick="app.pois.create();">
                        <i class="icon add"></i>
                    </a>
                </span>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="tab-pane-body">
        <div id="ajax-map-icons"></div>
    </div>
</div>

<div class="tab-pane" id="pois_create">
    <?php echo Form::open(['route' => 'pois.store', 'method' => 'POST', 'id' => 'poi_create']); ?>

    <div class="tab-pane-header">
        <div class="alert alert-info">
            <?php echo trans('front.please_click_on_map'); ?>

        </div>
        <?php echo Form::hidden('id'); ?>

        <?php echo Form::hidden('coordinates'); ?>

        <div class="form-group">
            <?php echo Form::label('name', trans('validation.attributes.name').':'); ?>

            <?php echo Form::text('name', null, ['class' => 'form-control']); ?>

        </div>
        <div class="form-group">
            <?php echo Form::label('description', trans('validation.attributes.description').':'); ?>

            <?php echo Form::textarea('description', null, ['class' => 'form-control', 'rows' => 3]); ?>

        </div>
        <div class="form-group">
            <?php echo Form::label('group_id', trans('validation.attributes.group_id').':'); ?>

            <?php echo Form::select('group_id', $poi_groups, null, ['class' => 'form-control']); ?>

        </div>

        <?php echo Form::label('map_icon_idd', trans('validation.attributes.map_icon_id').':'); ?>

        <?php echo Form::hidden('map_icon_id'); ?>

    </div>
    <div class="tab-pane-body">
        <div class="icon-list">
        <?php $__currentLoopData = $mapIcons->toArray(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="checkbox-inline">
                <?php echo Form::radio('map_icon_id', $value['id'], null, ['data-width' => $value['width'], 'data-height' => $value['height']]); ?>

                <label><img src="<?php echo asset($value['path']); ?>" alt="ICON"></label>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
    <div class="tab-pane-footer">
        <div class="buttons text-center">
            <a type="button" class="btn btn-action" href="javascript:" onClick="app.pois.store();"><?php echo trans('global.save'); ?></a>
            <a type="button" class="btn btn-default" href="javascript:" onClick="app.openTab('pois_tab');"><?php echo trans('global.cancel'); ?></a>
        </div>
    </div>
    <?php echo Form::close(); ?>

</div>

<div class="tab-pane" id="pois_edit">
    <?php echo Form::open(['route' => 'pois.update', 'method' => 'PUT', 'id' => 'poi_update']); ?>

    <div class="tab-pane-header">
        <?php echo Form::hidden('id'); ?>

        <?php echo Form::hidden('coordinates'); ?>

        <div class="form-group">
            <?php echo Form::label('name', trans('validation.attributes.name').':'); ?>

            <?php echo Form::text('name', null, ['class' => 'form-control']); ?>

        </div>
        <div class="form-group">
            <?php echo Form::label('description', trans('validation.attributes.description').':'); ?>

            <?php echo Form::textarea('description', null, ['class' => 'form-control', 'rows' => 3]); ?>

        </div>
        <div class="form-group">
            <?php echo Form::label('group_id', trans('validation.attributes.group_id').':'); ?>

            <?php echo Form::select('group_id', $poi_groups, null, ['class' => 'form-control']); ?>

        </div>
        <div class="form-group">
            <?php echo Form::label('map_icon_idd', trans('validation.attributes.map_icon_id').':'); ?>

            <?php echo Form::hidden('map_icon_id'); ?>

        </div>
    </div>

    <div class="tab-pane-body">
        <div class="icon-list">
            <?php $__currentLoopData = $mapIcons->toArray(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="checkbox-inline">
                    <?php echo Form::radio('map_icon_id', $value['id'], null, ['data-width' => $value['width'], 'data-height' => $value['height']]); ?>

                    <label><img src="<?php echo asset($value['path']); ?>" alt="ICON"></label>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
    <div class="tab-pane-footer">
        <div class="buttons text-center">
            <a type="button" class="btn btn-action" href="javascript:" onClick="app.pois.update();"><?php echo trans('global.save'); ?></a>
            <a type="button" class="btn btn-default" href="javascript:" onClick="app.openTab('pois_tab');"><?php echo trans('global.cancel'); ?></a>
        </div>
    </div>
    <?php echo Form::close(); ?>

</div>