<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-lg-12 col-sm-12">
            <?php if(Session::has('billing_success')): ?>
                <div class="alert alert-success">
                    <?php echo Session::get('billing_success'); ?>

                </div>
            <?php endif; ?>
            <?php if(Session::has('billing_errors')): ?>
                <div class="alert alert-danger">
                    <ul>
                        <?php $errors = is_array(Session::get('billing_errors')) ?
                            Session::get('billing_errors') : Session::get('billing_errors')->all(); ?>

                        <?php $__currentLoopData = $errors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo $error; ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <?php $__currentLoopData = array_chunk($gateways, 2, true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chunk): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="row">
            <?php $__currentLoopData = $chunk; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gateway => $active): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php echo $__env->make('Admin.Billing.Gateways.' . $gateway, [
                    'gateway'   => $gateway,
                    'active'    => $active
                 ], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <script>
        var endpoint = '<?php echo e(route('payments.config_check', 'gateway')); ?>';

        $('.config-test').click(function (e) {
            var gateway = e.target.id.replace('_test', '');
            $.ajax({
                method: 'GET',
                data: $('#' + gateway).serialize(),
                url: endpoint.replace('gateway', gateway),
                beforeSend: function () {
                    loader.add('div.content');
                },
                success: function (response) {
                    if (response.status === 1) {
                        toastr.success('Config is valid.');
                    } else {
                        toastr.error('Config is invalid. ' + response.error);
                    }
                },
                complete: function () {
                    loader.remove('div.content');
                },
                error: function (jqXHR, textStatus, errorThrown) {
                }
            });
        });

        $('#plan_group_add').click(function () {
            var plan_group = $('.plan_group'),
                clone = plan_group.last().clone(),
                count = plan_group.length;

            clone.find('input').attr('name', 'plan_ids[' + count + ']');
            clone.find('select').attr('name', 'billing_plans[' + count + ']');
            clone.find('select').selectpicker();
            clone.insertBefore('#plan_group_add');

            $('.plan_group_remove').unbind('click').click(removeAction);
        });

        $('.plan_group_remove').click(removeAction);

        function removeAction() {
            if ($('.plan_group_remove').length === 1)
                return;

            $(this).closest('.form-group').remove();
        }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('Admin.Layouts.default', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>