<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="col-sm-6">

            <?php if(Session::has('user_defaults_errors')): ?>
                <div class="alert alert-danger">
                    <ul>
                        <?php $__currentLoopData = Session::get('user_defaults_errors')->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo $error; ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <div class="panel panel-default">

                <div class="panel-heading">
                    <div class="panel-title"><?php echo e(trans('front.registration')); ?></div>
                </div>

                <div class="panel-body">
                    <?php echo Form::open(array('route' => 'admin.main_server_settings.new_user_defaults_save', 'method' => 'POST', 'class' => 'form form-horizontal', 'id' => 'new-user-defaults-form')); ?>


                    <div class="form-group">
                        <?php echo Form::label('allow_users_registration', trans('validation.attributes.allow_users_registration'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

                        <div class="col-xs-12 col-sm-8">
                            <?php echo Form::select('allow_users_registration', ['0' => trans('global.no'), '1' => trans('global.yes')], $settings['allow_users_registration'], ['class' => 'form-control']); ?>

                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-xs-12 col-sm-4"></div>
                        <div class="col-xs-12 col-sm-8">
                            <div class="checkbox">
                                <?php echo Form::checkbox('enable_plans', 1, settings('main_settings.enable_plans')); ?>

                                <?php echo Form::label('enable_plans', trans('validation.attributes.enable_plans') ); ?>

                            </div>
                        </div>
                    </div>
                    <div class="form-group" id="default_billing_plan">
                        <?php echo Form::label('default_billing_plan', trans('validation.attributes.default_billing_plan'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

                        <div class="col-xs-12 col-sm-8">
                            <?php echo Form::select('default_billing_plan', $items->pluck('title','id')->all(), settings('main_settings.default_billing_plan'), ['class' => 'form-control']); ?>

                        </div>
                    </div>
                    <div class="form-group">
                        <?php echo Form::label('default_timezone', trans('validation.attributes.default_timezone'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

                        <div class="col-xs-12 col-sm-8">
                            <?php echo Form::select('default_timezone', $timezones, $settings['default_timezone'], ['class' => 'form-control']); ?>

                        </div>
                    </div>

                    <div class="form-group">
                        <?php echo Form::label(null, trans('validation.attributes.daylight_saving_time'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

                        <div class="col-xs-12 col-sm-8">
                            <?php echo Form::label('default_dst_type', trans('validation.attributes.dst_type').':'); ?>

                            <?php echo Form::select('default_dst_type', $dst_types, $settings['default_dst_type'] ?? null, ['class' => 'form-control']); ?>


                            <div class="row" data-disablable="#default_dst_type;hide-disable;exact">
                                <div class="col-xs-6">
                                    <?php echo Form::label('default_dst_date_from', trans('validation.attributes.date_from').':'); ?>

                                    <?php echo Form::text('default_dst_date_from', $settings['default_dst_date_from'] ?? null, ['class' => 'form-control']); ?>

                                </div>
                                <div class="col-xs-6">
                                    <?php echo Form::label('default_dst_date_to', trans('validation.attributes.date_to').':'); ?>

                                    <?php echo Form::text('default_dst_date_to', $settings['default_dst_date_to'] ?? null, ['class' => 'form-control']); ?>

                                </div>
                            </div>
                            <div data-disablable="#default_dst_type;hide-disable;other">
                                <?php echo Form::label('date_from', trans('front.from').':'); ?>

                                <div class="row">
                                    <div class="col-xs-4">
                                        <?php echo Form::select('default_dst_month_from', $months, $settings['default_dst_month_from'] ?? null, ['class' => 'form-control']); ?>

                                    </div>
                                    <div class="col-xs-2">
                                        <?php echo Form::select('default_dst_week_pos_from', $week_pos, $settings['default_dst_week_pos_from'] ?? null, ['class' => 'form-control']); ?>

                                    </div>
                                    <div class="col-xs-4">
                                        <?php echo Form::select('default_dst_week_day_from', $weekdays, $settings['default_dst_week_day_from'] ?? null, ['class' => 'form-control']); ?>

                                    </div>
                                    <div class="col-xs-2">
                                        <?php echo Form::text('default_dst_time_from', $settings['default_dst_time_from'] ?? null, ['class' => 'form-control', 'placeholder' => trans('front.time')]); ?>

                                    </div>
                                </div>

                                <?php echo Form::label('date_to', trans('front.to').':'); ?>

                                <div class="row">
                                    <div class="col-xs-4">
                                        <?php echo Form::select('default_dst_month_to', $months, $settings['default_dst_month_to'] ?? null, ['class' => 'form-control']); ?>

                                    </div>
                                    <div class="col-xs-2">
                                        <?php echo Form::select('default_dst_week_pos_to', $week_pos, $settings['default_dst_week_pos_to'] ?? null, ['class' => 'form-control']); ?>

                                    </div>
                                    <div class="col-xs-4">
                                        <?php echo Form::select('default_dst_week_day_to', $weekdays, $settings['default_dst_week_day_to'] ?? null, ['class' => 'form-control']); ?>

                                    </div>
                                    <div class="col-xs-2">
                                        <?php echo Form::text('default_dst_time_to', $settings['default_dst_time_to'] ?? null, ['class' => 'form-control', 'placeholder' => trans('front.time')]); ?>

                                    </div>
                                </div>
                            </div>
                            <div data-disablable="#default_dst_type;hide-disable;automatic">
                                <?php echo Form::label('default_dst_country_id', trans('front.country').':'); ?>

                                <?php echo Form::select('default_dst_country_id', $dst_countries, $settings['default_dst_country_id'] ?? null, ['class' => 'form-control', 'data-live-search' => 'true']); ?>

                            </div>
                        </div>
                    </div>

                    <div id="default_user_fields">
                        <div class="form-group">
                            <?php echo Form::label(null, trans('validation.attributes.devices_limit'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

                            <div class="col-xs-12 col-sm-8">
                                <div class="input-group">
                                    <div class="checkbox input-group-btn">
                                        <?php echo Form::checkbox('enable_devices_limit', 1, !is_null(settings('main_settings.devices_limit'))); ?>

                                        <?php echo Form::label(null); ?>

                                    </div>
                                    <?php echo Form::text('devices_limit', settings('main_settings.devices_limit'), ['class' => 'form-control']); ?>

                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <?php echo Form::label(null, trans('validation.attributes.subscription_expiration_after_days'), ['class' => 'col-xs-12 col-sm-4 control-label"']); ?>

                            <div class="col-xs-12 col-sm-8">
                                <div class="input-group">
                                    <div class="checkbox input-group-btn">
                                        <?php echo Form::checkbox('enable_subscription_expiration_after_days', 1, !is_null(settings('main_settings.subscription_expiration_after_days'))); ?>

                                        <?php echo Form::label(null); ?>

                                    </div>
                                    <?php echo Form::text('subscription_expiration_after_days', settings('main_settings.subscription_expiration_after_days'), ['class' => 'form-control']); ?>

                                </div>
                            </div>
                        </div>

                        <div>
                            <h3><?php echo e(trans('validation.attributes.permissions')); ?></h3>
                            <table class="table">
                                <thead>
                                <th style="text-align: left"><?php echo e(trans('front.permission')); ?></th>
                                <th style="text-align: center"><?php echo e(trans('front.view')); ?></th>
                                <th style="text-align: center"><?php echo e(trans('global.edit')); ?></th>
                                <th style="text-align: center"><?php echo e(trans('global.delete')); ?></th>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $grouped_permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group => $permissions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($group !== 'main'): ?>
                                        <tr class="table">
                                            <th colspan="4">
                                                <a href="javascript:" data-toggle="collapse" data-target="<?php echo e(".group-$group"); ?>">
                                                    <?php echo e(ucfirst($group)); ?>

                                                    <i class="fa fa-angle-down"></i>
                                                </a>
                                            </th>
                                        </tr>
                                    <?php endif; ?>
                                    <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission => $modes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr class="<?php echo e("group-$group"); ?> <?php echo e(($group !== 'main') ? 'collapse' : ''); ?>">
                                            <td>
                                                <?php if($group !== 'main'): ?>
                                                    <?php echo e(trans('validation.attributes.' . explode('.', $permission)[1])); ?>

                                                <?php else: ?>
                                                    <?php echo e(trans('front.' . $permission)); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td style="text-align: center">
                                                <div class="checkbox">
                                                    <?php if($modes['view']): ?>
                                                        <?php echo Form::checkbox("perms[$permission][view]", 1, getMainPermission($permission, 'view'), ['class' => 'perm_checkbox perm_view']); ?>

                                                    <?php else: ?>
                                                        <?php echo Form::checkbox('', 0, 0, ['disabled' => 'disabled']); ?>

                                                    <?php endif; ?>
                                                    <?php echo Form::label(null, null); ?>

                                                </div>
                                            </td>
                                            <td style="text-align: center">
                                                <div class="checkbox">
                                                    <?php if($modes['edit']): ?>
                                                        <?php echo Form::checkbox("perms[$permission][edit]", 1, getMainPermission($permission, 'edit'), ['class' => 'perm_checkbox perm_edit']); ?>

                                                    <?php else: ?>
                                                        <?php echo Form::checkbox('', 0, 0, ['disabled' => 'disabled']); ?>

                                                    <?php endif; ?>
                                                    <?php echo Form::label(null, null); ?>

                                                </div>
                                            </td>
                                            <td style="text-align: center">
                                                <div class="checkbox">
                                                    <?php if($modes['remove']): ?>
                                                        <?php echo Form::checkbox("perms[$permission][remove]", 1, getMainPermission($permission, 'remove'), ['class' => 'perm_checkbox perm_remove']); ?>

                                                    <?php else: ?>
                                                        <?php echo Form::checkbox('', 0, 0, ['disabled' => 'disabled']); ?>

                                                    <?php endif; ?>
                                                    <?php echo Form::label(null, null); ?>

                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>

                <div class="panel-footer">
                    <button type="submit" class="btn btn-action" onClick="$('#new-user-defaults-form').submit();"><?php echo e(trans('global.save')); ?></button>
                </div>
            </div>
        </div>

        <div class="col-sm-6">
            <div class="panel panel-default" id="table_billing_plans">
                <div class="panel-heading">
                    <ul class="nav nav-tabs nav-icons pull-right">
                        <li role="presentation" class="">
                            <a href="javascript:" type="button" data-modal="billing_plans_create" data-url="<?php echo e(route("admin.billing.create")); ?>">
                                <i class="icon add" title="<?php echo e(trans('admin.add_new_user')); ?>"></i>
                            </a>
                        </li>
                    </ul>

                    <div class="panel-title"><?php echo trans('front.plans'); ?></div>
                </div>

                <div class="panel-body" data-table>
                    <?php echo $__env->make('Admin.Billing.table', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
<script>
    tables.set_config('table_billing_plans', {
        url:'<?php echo e(route("admin.billing.plans")); ?>',
        delete_url:'<?php echo e(route("admin.billing.destroy")); ?>'
    });

    function billing_plans_edit_modal_callback() {
        tables.get('table_billing_plans');
        updateBillingPlans();
    }

    function billing_plans_create_modal_callback() {
        tables.get('table_billing_plans');
        updateBillingPlans();
    }

    function updateBillingPlans() {
        $.ajax({
            type: 'GET',
            dataType: "html",
            url: '<?php echo e(route('admin.billing.billing_plans_form')); ?>',
            success: function(res){
                $('#default_billing_plan div').html(res);
            }
        });
    }

    $(document).ready(function() {
        $(document).on('change', 'input[name="enable_plans"]', function() {
            if ($(this).prop('checked')) {
                $('#default_billing_plan').show();
                $('#default_user_fields').hide();
            }
            else {
                $('#default_user_fields').show();
                $('#default_billing_plan').hide();
            }
        });

        $(document).on('change', 'select[name="payment_type"]', function() {
            $("div[class*='payment-']").hide();
            $(".payment-" + $(this).val()).show();
        });
        $('select[name="payment_type"]').trigger('change');

        $(document).on('click', '.multi_delete', function() {
            setTimeout(function() {
                updateBillingPlans();
            }, 2000);
        });

        $('input[name="enable_plans"]').trigger('change');

        checkPerms();

        $(document).ready(function () {
            $('input[name="dst_date_from"]').datetimepicker({
                changeYear: false,
                format: 'mm-dd hh:ii',
                closeOnDateSelect: true
            });
            $('input[name="dst_date_to"]').datetimepicker({
                changeYear: false,
                format: 'mm-dd hh:ii',
                closeOnDateSelect: true
            });
        });
    });

    $(document).on('change', 'input.perm_checkbox', function () {
        checkPerm($(this));
    });

    $('input[name^="default_dst_date_"]').datetimepicker({
        changeYear: false,
        format: 'mm-dd hh:ii',
        closeOnDateSelect: true,
        weekStart: app.settings.weekStart
    }).on('monthUpdate', titleRemoveYear);
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('Admin.Layouts.default', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>