<title><?php echo e(Appearance::getSetting('server_name')); ?></title>

<base href="<?php echo e(url('/')); ?>">
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="app-version" content="<?php echo e(config('tobuli.version')); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta name="description" content="<?php echo e(Appearance::getSetting('server_description')); ?>">
<link rel="shortcut icon" href="<?php echo e(Appearance::getAssetFileUrl('favicon')); ?>" type="image/x-icon">
<link rel="stylesheet" href="<?php echo e(asset_resource('assets/css/'.Appearance::getSetting('template_color').'.css')); ?>">
<?php if(Language::dir() == 'rtl'): ?>
    <link rel="stylesheet" href="<?php echo e(asset_resource('assets/css/rtl.css')); ?>">
<?php endif; ?>
<?php if(Appearance::assetFileExists('css')): ?>
    <link rel="stylesheet" href="<?php echo e(Appearance::getAssetFileUrl('css')); ?>">
<?php endif; ?>
<?php if(Appearance::assetFileExists('js')): ?>
    <script src="<?php echo e(Appearance::getAssetFileUrl('js')); ?>" type="text/javascript" defer></script>
<?php endif; ?>
