<?php $__env->startSection('title'); ?>
    <?php echo e(trans('global.edit')); ?> (#<?php echo e($item->id); ?>)
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body'); ?>
    <?php echo Form::open(['route' => ['admin.device_icons.update', $item->id], 'method' => 'PUT']); ?>

    <?php echo Form::hidden('id'); ?>


    <div class="form-group">
        <div class="checkbox">
            <?php echo Form::checkbox('by_status', 1, $by_status); ?>

            <?php echo Form::label('by_status', trans('validation.attributes.by_status')); ?>

        </div>
    </div>

    <div class="form-group">
        <?php echo Form::label('type', trans('validation.attributes.type').'*:'); ?>

        <?php echo Form::select('type', $types, $item->type, ['class' => 'form-control']); ?>

    </div>

    <div class="form-group">
        <img src="<?php echo e(asset($item->path)); ?>">
    </div>

    <div class="form-group" id="icon" <?php echo e($by_status ? 'hidden' : ''); ?>>
        <?php echo Form::label('file', trans('validation.attributes.file').'*:'); ?>

        <?php echo Form::file('file', ['class' => 'form-control']); ?>

    </div>

    <?php
        $hidden = $by_status ? '' : 'hidden';
    ?>

    <div class="form-group by-status-file" <?php echo e($hidden); ?>>
        <?php echo Form::label('online', trans('validation.attributes.icon_status_online').'*:'); ?>

        <?php echo Form::file('online', ['class' => 'form-control']); ?>

    </div>

    <div class="form-group by-status-file" <?php echo e($hidden); ?>>
        <?php echo Form::label('ack', trans('validation.attributes.icon_status_ack').'*:'); ?>

        <?php echo Form::file('ack', ['class' => 'form-control']); ?>

    </div>

    <div class="form-group by-status-file" <?php echo e($hidden); ?>>
        <?php echo Form::label('engine', trans('validation.attributes.icon_status_engine').'*:'); ?>

        <?php echo Form::file('engine', ['class' => 'form-control']); ?>

    </div>

    <div class="form-group by-status-file" <?php echo e($hidden); ?>>
        <?php echo Form::label('offline', trans('validation.attributes.icon_status_offline').'*:'); ?>

        <?php echo Form::file('offline', ['class' => 'form-control']); ?>

    </div>

    <?php echo Form::close(); ?>


    <script>
        $(document).ready(function () {
            $('input[name="by_status"]').change(function (e) {
                if (e.target.checked) {
                    $('#icon').hide();
                    $('input[name="file"]').val('');

                    $('.by-status-file').each(function () {
                        $(this).show();
                    });
                } else {
                    $('.by-status-file').each(function () {
                        $(this).hide();
                        $(this).find('input').val('');
                    });

                    $('#icon').show();
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>
    <button type="button" class="btn btn-action update_with_files"><?php echo e(trans('global.save')); ?></button>
    <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo e(trans('global.cancel')); ?></button>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('Admin.Layouts.modal', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>