<?php if(!empty($groups)): ?>
    <?php $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="group" data-toggle="multiCheckbox">
            <div class="group-heading">

                <div class="checkbox">
                    <input type="checkbox" data-toggle="checkbox" value="<?php echo e($group['id']); ?>">
                    <label></label>
                </div>

                <div class="group-title <?php echo e($group['open'] ? '' : 'collapsed'); ?>" data-toggle="collapse" data-target="#device-group-<?php echo e($group['id']); ?>" data-parent="#objects_tab" aria-expanded="<?php echo e($group['open'] ? 'true' : 'false'); ?>" aria-controls="device-group-<?php echo e($group['id']); ?>">
                    <?php echo e($group['title']); ?> <span class="count"><?php echo e($group['devices']->total()); ?></span>
                </div>

                <div class="btn-group">
                    <?php if($group['id']): ?>
                        <i class="btn icon options" data-url="<?php echo e(route('devices_groups.edit', $group['id'])); ?>" data-modal="devices_groups_edit"></i>
                    <?php else: ?>
                        <i class="btn icon options" data-url="<?php echo e(route('devices_groups.create')); ?>" data-modal="devices_groups_create"></i>
                    <?php endif; ?>
                </div>
            </div>


            <div id="device-group-<?php echo e($group['id']); ?>" class="group-collapse collapse <?php echo e(! $group['open'] ? '' : 'in'); ?>" data-id="<?php echo e($group['id']); ?>" role="tabpanel" aria-expanded="<?php echo e($group['open'] ? 'true' : 'false'); ?>">
                <div class="group-body">

                        <?php echo $__env->make('Frontend.Objects.items', ['devices' => $group['devices']], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php else: ?>
    <p class="no-results"><?php echo trans('front.no_devices'); ?></p>
<?php endif; ?>
