<table class="table table-condensed">
    <tr class="">
        <?php echo tableHeader('validation.attributes.title'); ?>

        <?php echo tableHeader('validation.attributes.imei'); ?>

        <?php echo tableHeader('global.online', 'style="text-align:center"'); ?>

        <?php if(Auth::user()->can('view', new \Tobuli\Entities\Device(), 'expiration_date')): ?>
            <?php echo tableHeader('validation.attributes.expiration_date'); ?>

        <?php endif; ?>
        <?php echo tableHeader('admin.actions'); ?>

    </tr>
    <tbody>
<?php if(count($items)): ?>
    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $device): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($device->name); ?></td>
            <td><?php echo e($device->imei); ?></td>
            <td style="text-align: center">
                <span
                        class="device-status"
                        style="background-color: <?php echo e($device->getStatusColor()); ?>"
                        data-toggle="tooltip"
                        title="<?php echo e($device->getStatus()); ?>" >
                </span>
            </td>
            <?php if(Auth::user()->can('view', $device, 'expiration_date')): ?>
                <td>
                    <?php echo e($device->hasExpireDate() ? Formatter::time()->human($device->expiration_date) : trans('front.unlimited')); ?>

                </td>
            <?php endif; ?>
            <td>
                <div class="btn-group dropdown" data-position="fixed">
                    <i class="btn icon edit" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true"></i>
                    <ul class="dropdown-menu">
                        <li><a href="javascript:" data-modal="devices_edit" data-url="<?php echo e(route("devices.edit", [$device->id, 1])); ?>"><?php echo e(trans('global.edit')); ?></a></li>
                        <li><a href="<?php echo e(route('objects.destroy')); ?>" class="js-confirm-link" data-confirm="<?php echo trans('front.do_object_delete'); ?>" data-id="<?php echo e($device->id); ?>" data-method="DELETE"><?php echo e(trans('global.delete')); ?></a></li>
                    </ul>
                </div>
            </td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php else: ?>
    <tr>
        <td class="no-data" colspan="5">
            <?php echo e(trans('admin.no_data')); ?>

        </td>
    </tr>
<?php endif; ?>
    </tbody>
</table>