<div class="table-responsive">
    <table class="table table-list">
        <thead>
        <tr>
            <?php echo tableHeader('validation.attributes.title'); ?>

            <?php echo tableHeader('validation.attributes.price'); ?>

            <?php echo tableHeader('validation.attributes.duration_value'); ?>

            <?php echo tableHeader('validation.attributes.active'); ?>

            <?php echo tableHeader('admin.actions', 'style="text-align: right;"'); ?>

        </tr>
        </thead>

        <tbody>
        <?php if($items->count()): ?>
            <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo $item->title; ?></td>
                    <td><?php echo $item->price; ?></td>
                    <td><?php echo $item->duration_text; ?></td>
                    <td><?php echo trans('admin.'.($item->active ? 'yes' : 'no')); ?></td>
                    <td class="actions">
                        <div class="btn-group dropdown droparrow" data-position="fixed">
                            <i class="btn icon edit" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true"></i>
                            <ul class="dropdown-menu">
                                <li>
                                    <a href="javascript:"
                                       data-modal="device_plans_edit"
                                       data-url="<?php echo e(route("admin.device_plan.edit", $item->id)); ?>">
                                        <?php echo trans('global.edit'); ?>

                                    </a>
                                </li>
                                <li>
                                    <a href="<?php echo e(route('admin.device_plan.destroy')); ?>"
                                       class="js-confirm-link"
                                       data-confirm="<?php echo trans('front.do_delete'); ?>"
                                       data-id="<?php echo e($item->id); ?>"
                                       data-method="DELETE">
                                        <?php echo e(trans('global.delete')); ?>

                                    </a>
                                </li>
                            </ul>
                        </div>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
            <tr class="">
                <td class="no-data" colspan="5">
                    <?php echo trans('admin.no_data'); ?>

                </td>
            </tr>
        <?php endif; ?>
        </tbody>
    </table>
</div>