<li id="list-device-<?php echo e($item->id); ?>" data-device-id="<?php echo e($item->id); ?>">
    <div class="checkbox">
        <input type="checkbox" name="items[<?php echo e($item->id); ?>]" value="<?php echo e($item->id); ?>" <?php echo e(!empty($item->pivot->active) ? 'checked="checked"' : ''); ?> onChange="app.devices.active('<?php echo e($item->id); ?>', this.checked);"/>
        <label></label>
    </div>
    <div class="name" onClick="app.devices.select(<?php echo e($item->id); ?>);">
        <span data-device="name"><?php echo e($item->name); ?></span>
        <span data-device="time">
            <?php echo e($item->time); ?>

            <?php if($item->isExpired() && $item->isPlanAble()): ?>
                <a href="javascript:" data-url="<?php echo e(route('device_plans.index', ['device_id' => $item->id])); ?>" data-modal="device_plans_index">
                    <?php echo e(trans('front.upgrade')); ?>

                </a>
            <?php endif; ?>
        </span>
    </div>
    <div class="details">
        <span data-device="speed"><?php echo e(Formatter::speed()->human($item->getSpeed())); ?></span>
        <?php if( ! is_null($item->getEngineStatus())): ?>
        <span data-device="detect_engine" class="<?php echo e($item->getEngineStatus() ? 'on' : 'off'); ?>"><i class="icon detect_engine"></i></span>
        <?php endif; ?>
        <span data-device="status" style="background-color: <?php echo e($item->getStatusColor()); ?>" title="<?php echo e(trans("global.".$item->getStatus())); ?>"><?php echo e($item->getStatus()); ?></span>

        <div class="btn-group dropleft droparrow"  data-position="fixed">
            <i class="btn icon options" data-toggle="dropdown" data-position="fixed" aria-haspopup="true" aria-expanded="false"></i>
            <ul class="dropdown-menu" >
                <?php if( Auth::User()->perm('history', 'view') ): ?>
                    <li>
                        <a href="javascript:" class="object_show_history" onClick="app.history.device('<?php echo e($item->id); ?>', 'last_hour');">
                            <span class="icon last-hour"></span>
                            <span class="text"><?php echo e(trans('front.show_history')); ?> (<?php echo e(mb_strtolower(trans('front.last_hour'))); ?>)</span>
                        </a>
                    </li>
                    <li>
                        <a href="javascript:" class="object_show_history" onClick="app.history.device('<?php echo e($item->id); ?>', 'today');">
                            <span class="icon today"></span>
                            <span class="text"><?php echo e(trans('front.show_history')); ?> (<?php echo e(mb_strtolower(trans('front.today'))); ?>)</span>
                        </a>
                    </li>
                    <li>
                        <a href="javascript:" class="object_show_history" onClick="app.history.device('<?php echo e($item->id); ?>', 'yesterday');">
                            <span class="icon yesterday"></span>
                            <span class="text"><?php echo e(trans('front.show_history')); ?> (<?php echo e(mb_strtolower(trans('front.yesterday'))); ?>)</span>
                        </a>
                    </li>
                <?php endif; ?>

                <li>
                    <a href="javascript:" data-url="<?php echo e(route('devices.follow_map', [$item->id])); ?>" data-id="<?php echo e($item->id); ?>" onClick="app.devices.follow(<?php echo e($item->id); ?>);" data-name="<?php echo e(trans('front.follow').' ('.$item['name'].')'); ?>">
                        <span class="icon follow"></span>
                        <span class="text"><?php echo e(trans('front.follow')); ?></span>
                    </a>
                </li>

                <?php if( Auth::User()->perm('send_command', 'view') ): ?>
                    <li>
                        <a href="javascript:" data-url="<?php echo e(route('send_command.create')); ?>" data-modal="send_command" data-id="<?php echo e($item->id); ?>">
                            <span class="icon send-command"></span>
                            <span class="text"><?php echo e(trans('front.send_command')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                <?php if( Auth::User()->perm('devices', 'edit') ): ?>
                    <li>
                        <a href="javascript:" data-url="<?php echo e(route('devices.edit', [$item->id, 0])); ?>" data-modal="devices_edit">
                            <span class="icon edit"></span>
                            <span class="text"><?php echo e(trans('global.edit')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>
                <?php if(  Auth::User()->perm('chat', 'view') && $item->canChat()): ?>
                <li>
                    <a href="javascript:" class="chat_device" data-url="<?php echo e(route('chat.init', [$item->id, 'device', 1])); ?>">
                        <span class="icon icon-fa fa-comments-o"></span>
                        <span class="text"><?php echo e(trans('front.chat')); ?></span>
                    </a>
                </li>
                <?php endif; ?>

                <?php if(Auth::User()->perm('sharing', 'view')): ?>
                <li>
                    <a href="javascript:" data-url="<?php echo e(route('sharing.index', ['devices_id' => $item->id])); ?>" data-modal="device_sharing">
                        <span class="icon sharing"></span>
                        <span class="text"><?php echo e(trans('front.sharing')); ?></span>
                    </a>
                </li>
                <?php endif; ?>

                <?php if(Auth::User()->perm('checklist_qr_code', 'view')): ?>
                <li>
                    <a href="javascript:" data-url="<?php echo e(route('checklist.qr_code_preview', ['devices_id' => $item->id])); ?>" data-modal="device_qr_code">
                        <span class="icon qrcode"></span>
                        <span class="text"><?php echo e(trans('front.checklist_qr_code')); ?></span>
                    </a>
                </li>
                <?php endif; ?>

                <?php if(! empty($item->sim_number) && Auth::User()->able('configure_device')): ?>
                <li>
                    <a href="javascript:" data-url="<?php echo e(route('device_config.index', ['device_id' => $item->id])); ?>" data-modal="device_config">
                        <span class="icon devices"></span>
                        <span class="text"><?php echo e(trans('front.device_configuration')); ?></span>
                    </a>
                </li>
                <?php endif; ?>

                <?php if( Auth::User()->perm('call_actions', 'view') ): ?>
                <li>
                    <a href="javascript:" data-url="<?php echo e(route('call_actions.create', ['device_id' => $item->id])); ?>" data-modal="call_action_create">
                        <span class="icon call_action"></span>
                        <span class="text"><?php echo e(trans('front.call_action')); ?></span>
                    </a>
                </li>
                <?php endif; ?>

                <?php if($item->isPlanAble()): ?>
                    <li>
                        <a href="javascript:" data-url="<?php echo e(route('device_plans.index', ['device_id' => $item->id])); ?>" data-modal="device_plans_index">
                            <span class="icon icon-fa fa-money"></span>
                            <span class="text"><?php echo e(trans('admin.device_plans')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                <?php if( Auth::User()->perm('alerts', 'view') ): ?>
                    <li>
                        <a href="javascript:" data-url="<?php echo e(route('device.alerts.index', ['device_id' => $item->id])); ?>" data-modal="device_alerts_index">
                            <span class="icon alerts"></span>
                            <span class="text"><?php echo e(trans('front.device_alerts')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                <?php if(Auth::User()->perm('device_route_types', 'view') ): ?>
                    <li>
                        <a href="javascript:" data-url="<?php echo e(route('device_route_type.show', ['device_id' => $item->id])); ?>" data-modal="device_route_type_show">
                            <span class="icon route_type"></span>
                            <span class="text"><?php echo e(trans('front.route_types')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>
</li>
