<div id="header" class="folded">
    <nav class="navbar main-navbar">
        <div class="container-fluid">
            <div class="navbar-header">
                <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#bs-header-navbar-collapse" aria-expanded="false">
                    <span class="sr-only">Toggle navigation</span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </button>

                <?php if( Appearance::assetFileExists('logo') ): ?>
                <a class="navbar-brand" href="/" title="<?php echo e(Appearance::getSetting('server_name')); ?>"><img src="<?php echo e(Appearance::getAssetFileUrl('logo')); ?>"></a>
                <?php endif; ?>
            </div>

            <div class="collapse navbar-collapse" id="bs-header-navbar-collapse">
                <ul class="nav navbar-nav navbar-right">
                    <?php if(isAdmin()): ?>
                        <li>
                            <a href="<?php echo route('admin'); ?>" role="button" rel="tooltip" data-placement="bottom" title="<?php echo trans('global.admin'); ?>">
                                <span class="icon admin"></span>
                                <span class="text"><?php echo trans('global.admin'); ?></span>
                            </a>
                        </li>
                    <?php endif; ?>

                    <li class="dropdown">
                        <a href="javascript:" class="dropdown-toggle" role="button" data-toggle="dropdown" id="dropTools" rel="tooltip" data-placement="bottom" title="<?php echo trans('front.tools'); ?>">
                            <span class="icon tools"></span>
                            <span class="text"><?php echo trans('front.tools'); ?></span>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-left" role="menu" aria-labelledby="dropTools">
                            <?php if( Auth::User()->perm('alerts', 'view') ): ?>
                            <li>
                                <a href="javascript:" onclick="app.openTab('alerts_tab');">
                                    <span class="icon alerts"></span>
                                    <span class="text"><?php echo trans('front.alerts'); ?></span>
                                </a>
                            </li>
                            <?php endif; ?>
                            <?php if( Auth::User()->perm('geofences', 'view') ): ?>
                            <li>
                                <a href="javascript:" onclick="app.openTab('geofencing_tab');">
                                    <span class="icon geofences"></span>
                                    <span class="text"><?php echo trans('front.geofencing'); ?></span>
                                </a>
                            </li>
                            <?php endif; ?>
                            <?php if( Auth::User()->perm('routes', 'view') ): ?>
                            <li>
                                <a href="javascript:" onclick="app.openTab('routes_tab');">
                                    <span class="icon routes"></span>
                                    <span class="text"><?php echo trans('front.routes'); ?></span>
                                </a>
                            </li>
                            <?php endif; ?>
                            <?php if( Auth::User()->perm('reports', 'view') ): ?>
                            <li>
                                <a href="javascript:" data-url="<?php echo route('reports.create'); ?>" data-modal="reports_create" role="button">
                                    <span class="icon reports"></span>
                                    <span class="text"><?php echo trans('front.reports'); ?></span>
                                </a>
                            </li>
                            <?php endif; ?>
                            <li>
                                <a href="#objects_tab" data-toggle="tab" onclick="app.ruler();">
                                    <span class="icon ruler"></span>
                                    <span class="text"><?php echo trans('front.ruler'); ?></span>
                                </a>
                            </li>
                            <?php if( Auth::User()->perm('poi', 'view') ): ?>
                            <li>
                                <a href="javascript:" onClick="app.openTab('pois_tab');">
                                    <span class="icon poi"></span>
                                    <span class="text"><?php echo trans('front.poi'); ?></span>
                                </a>
                            </li>
                            <?php endif; ?>
                            <li>
                                <a href="javascript:" data-toggle="modal" data-target="#showPoint">
                                    <span class="icon point"></span>
                                    <span class="text"><?php echo trans('front.show_point'); ?></span>

                                </a>
                            </li>
                            <li>
                                <a href="javascript:" data-toggle="modal" data-target="#showAddress">
                                    <span class="icon address"></span>
                                    <span class="text"><?php echo trans('front.show_address'); ?></span>
                                </a>
                            </li>
                            <?php if( Auth::User()->perm('send_command', 'view') ): ?>
                            <li>
                                <a href="javascript:" data-url="<?php echo e(route('send_command.create')); ?>" data-modal="send_command">
                                    <span class="icon send-command"></span>
                                    <span class="text"><?php echo trans('front.send_command'); ?></span>
                                </a>
                            </li>
                            <?php endif; ?>
                            <?php if( Auth::User()->perm('camera', 'view') ): ?>
                                <li>
                                    <a href="javascript:" data-url="<?php echo e(route('device_media.create')); ?>" data-modal="camera_photos"  role="button">
                                        <span class="icon camera"></span>
                                        <span class="text"><?php echo trans('front.camera'); ?></span>
                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if( Auth::User()->perm('tasks', 'view') ): ?>
                            <li>
                                <a href="javascript:" data-url="<?php echo e(route('tasks.index')); ?>" data-modal="tasks"  role="button">
                                    <span class="icon task"></span>
                                    <span class="text"><?php echo trans('front.tasks'); ?></span>
                                </a>
                            </li>
                            <?php endif; ?>
                            <?php if( Auth::User()->perm('maintenance', 'view') ): ?>
                            <li>
                                <a href="<?php echo route('maintenance.index'); ?>" target="_blank" role="button">
                                    <span class="icon services"></span>
                                    <span class="text"><?php echo trans('front.maintenance'); ?></span>
                                </a>
                            </li>
                            <?php endif; ?>
                            <?php if(expensesTypesExist()): ?>
                            <li>
                                <a href="javascript:" data-url="<?php echo e(route('device_expenses.modal')); ?>" data-modal="devices_expenses">
                                    <span class="icon money"></span>
                                    <span class="text"><?php echo trans('front.expenses'); ?></span>
                                </a>
                            </li>
                            <?php endif; ?>
                            <li>
                                <a href="<?php echo e(route('dashboard')); ?>" onClick="event.preventDefault(); app.dashboard.init();">
                                    <span class="icon dashboard"></span>
                                    <span class="text"><?php echo trans('front.dashboard'); ?></span>
                                </a>
                            </li>
                            <?php if( Auth::User()->perm('sharing', 'view') ): ?>
                            <li>
                                <a href="javascript:" data-url="<?php echo e(route('sharing.index')); ?>" data-modal="sharing">
                                    <span class="icon sharing"></span>
                                    <span class="text"><?php echo trans('front.sharing'); ?></span>
                                </a>
                            </li>
                            <?php endif; ?>
                            <?php if(Auth::user()->able('configure_device')): ?>
                            <li>
                                <a href="javascript:" data-url="<?php echo e(route('device_config.index')); ?>" data-modal="device_config"  role="button">
                                    <span class="icon devices"></span>
                                    <span class="text"><?php echo trans('front.device_configuration'); ?></span>
                                </a>
                            </li>
                            <?php endif; ?>
                            <?php if( Auth::User()->perm('call_actions', 'view') ): ?>
                            <li>
                                <a href="javascript:" data-url="<?php echo e(route('call_actions.index')); ?>" data-modal="call_actions">
                                    <span class="icon call_action"></span>
                                    <span class="text"><?php echo trans('front.call_actions'); ?></span>
                                </a>
                            </li>
                            <?php endif; ?>
                        </ul>
                    </li>

                    <li>
                        <a href="javascript:" data-url="<?php echo route('my_account_settings.edit'); ?>" data-modal="my_account_settings_edit" role="button" rel="tooltip" data-placement="bottom" title="<?php echo trans('front.setup'); ?>">
                            <span class="icon setup"></span>
                            <span class="text"><?php echo trans('front.setup'); ?></span>
                        </a>
                    </li>

                    <?php if( Auth::User()->perm('chat', 'view') ): ?>
                    <li>
                        <a href="javascript:" data-url="<?php echo route('chat.index'); ?>" data-modal="chat" role="button" rel="tooltip" data-placement="bottom" title="<?php echo trans('front.chat'); ?>">
                            <span class="icon chat"></span>
                            <span class="text"><?php echo trans('front.chat'); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>

                    <li class="dropdown">
                        <a href="javascript:" class="dropdown-toggle" role="button" id="dropMyAccount" data-toggle="dropdown" rel="tooltip" data-placement="bottom" title="<?php echo trans('front.my_account'); ?>">
                            <span class="icon account"></span>
                            <span class="text"><?php echo trans('front.my_account'); ?></span>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-right" role="menu" aria-labelledby="dropMyAccount">
                            <li>
                                <a href="javascript:" data-url="<?php echo e(route('subscriptions.index')); ?>" data-modal="subscriptions_edit">
                                    <span class="icon membership"></span>
                                    <span class="text"><?php echo trans('front.subscriptions'); ?></span>
                                </a>
                            </li>
                            <?php if(Auth::User()->perm('custom_device_add', 'view')): ?>
                                <li>
                                    <a href="javascript:" data-url="<?php echo e(route('devices.subscriptions')); ?>" data-modal="device_subscriptions_index">
                                        <span class="icon device"></span>
                                        <span class="text"><?php echo trans('admin.device_plans'); ?></span>
                                    </a>
                                </li>
                            <?php elseif(settings('main_settings.enable_device_plans') ?? false): ?>
                            <li>
                                <a href="javascript:" data-url="<?php echo e(route('device_plans.index')); ?>" data-modal="device_plans_index">
                                    <span class="icon device"></span>
                                    <span class="text"><?php echo trans('admin.device_plans'); ?></span>
                                </a>
                            </li>
                            <?php endif; ?>
                            <li>
                                <?php if(isPublic()): ?>
                                <a href="<?php echo e(config('tobuli.frontend_change_password').auth()->user()->email); ?>">
                                    <span class="icon password"></span>
                                    <span class="text"><?php echo trans('front.change_password'); ?></span>
                                </a>
                                <?php else: ?>
                                <a href="javascript:" data-url="<?php echo e(route('my_account.edit')); ?>" data-modal="subscriptions_edit">
                                    <span class="icon password"></span>
                                    <span class="text"><?php echo trans('front.change_password'); ?></span>
                                </a>
                                <?php endif; ?>
                            </li>
                            <li>
                                <a href="<?php echo route('logout'); ?>">
                                    <span class="icon logout"></span>
                                    <span class="text"><?php echo trans('global.log_out'); ?></span>
                                </a>
                            </li>
                        </ul>
                    </li>
                    <li class="language-selection">
                        <a href="javascript:" data-url="<?php echo e(route('languages.index')); ?>" data-modal="language-selection">
                            <img src="<?php echo e(Language::flag()); ?>" alt="Language" class="img-thumbnail">
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
</div>
