<?php $__env->startSection('content'); ?>
    <div class="panel panel-default" id="table_device_plans">
        <div class="panel-heading">
            <ul class="nav nav-tabs nav-icons pull-right">
                <li role="presentation" class="">
                    <a href="javascript:" type="button" data-modal="device_plans_create" data-url="<?php echo e(route("admin.device_plan.create")); ?>">
                        <i class="icon add" title="<?php echo e(trans('admin.add_new')); ?>"></i>
                    </a>
                </li>
            </ul>

            <div class="panel-title"><?php echo trans('front.plans'); ?></div>
        </div>

        <div class="panel-body">
            <div class="checkbox">
                <?php echo Form::checkbox('enable_device_plans', 1, settings('main_settings.enable_device_plans') ?? false); ?>

                <?php echo Form::label('enable_device_plans', trans('validation.attributes.active') ); ?>

            </div>

            <div data-table>
                <?php echo $__env->make('Admin.DevicePlans.table', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/plugins/bootstrap-wysihtml5/bootstrap-wysihtml5.css')); ?>"/>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <script src="<?php echo e(asset('assets/plugins/bootstrap-wysihtml5/wysihtml5-0.3.0.js')); ?>" type="text/javascript"></script>
    <script src="<?php echo e(asset('assets/plugins/bootstrap-wysihtml5/bootstrap-wysihtml5.js')); ?>" type="text/javascript"></script>
    <script>
        tables.set_config('table_device_plans', {
            url:'<?php echo e(route("admin.device_plan.index")); ?>'
        });

        function device_plans_edit_modal_callback() {
            tables.get('table_device_plans');
        }

        function device_plans_create_modal_callback() {
            tables.get('table_device_plans');
        }

        $(document).on('change', 'input[name="enable_device_plans"]', function() {
            $.ajax({
                type: 'POST',
                url: '<?php echo e(route('admin.device_plan.toggle_active')); ?>',
                beforeSend: function() {
                    loader.add('.panel-body');
                },
                success: function(res) {

                },
                complete: function () {
                    loader.remove('.panel-body');
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('Admin.Layouts.default', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>