<?php $__env->startSection('modal_class', 'modal-lg'); ?>

<?php $__env->startSection('title'); ?>
    <i class="icon task"></i> <?php echo trans('front.tasks'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('body'); ?>
    <ul class="nav nav-tabs nav-default" role="tablist">
        <li class="active"><a href="#new_task" role="tab" data-toggle="tab"><?php echo trans('front.new_task'); ?></a></li>
        <li><a href="#setup-form-task-list" role="tab" data-toggle="tab"><?php echo trans('front.all_tasks'); ?></a></li>
    </ul>

    <div id="tasks-modal">
    <?php echo Form::open(['route' => 'tasks.store', 'method' => 'POST']); ?>

    <?php echo Form::hidden('id'); ?>


        <div class="alert alert-success" role="alert" style="display: none;"><?php echo trans('front.task_created'); ?></div>
        <div class="alert alert-danger main-alert" role="alert" style="display: none;"></div>


        <div class="tab-content">
            <div id="new_task" class="tab-pane active">
                <div class="row">
                    <div class="col-sm-9">
                        <div class="form-group">
                            <?php echo Form::label('device_id', trans('validation.attributes.device_id').':'); ?>

                            <?php echo Form::select('device_id', $devices, null, ['class' => 'form-control', 'data-live-search' => 'true']); ?>

                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <?php echo Form::label('invoice_number', trans('validation.attributes.invoice_number').':'); ?>

                            <?php echo Form::text('invoice_number', null, ['class' => 'form-control']); ?>

                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-9">
                        <div class="form-group">
                            <?php echo Form::label('title', trans('validation.attributes.title').':'); ?>

                            <?php echo Form::text('title',  null, ['class' => 'form-control']); ?>

                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <?php echo Form::label('priority', trans('validation.attributes.priority').':'); ?>

                            <?php echo Form::select('priority', $priorities, null, ['class' => 'form-control']); ?>

                        </div>
                    </div>
                </div>

                <hr>

                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <?php echo Form::label('pickup_address', trans('validation.attributes.pickup_address').':'); ?>

                            <?php echo Form::hidden('pickup_address_id'); ?>

                            <?php echo Form::hidden('pickup_address_lat'); ?>

                            <?php echo Form::hidden('pickup_address_lng'); ?>

                            <?php echo $__env->make('Frontend.Addresses.partials.map_button',
                                [
                                    'type' => 'pickup',
                                    'parent' => '#new_task',
                                    'address' => '',
                                    'lat' => '',
                                    'lng' => '',
                                ]
                            , array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                        </div>
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <?php echo Form::label('pickup_time_from', trans('global.from')); ?>

                                    <div class="input-group">
                                        <div class="has-feedback">
                                            <i class="icon calendar form-control-feedback"></i>
                                            <input class="datetimepicker form-control" name="pickup_time_from" type="text" value="<?php echo e(date('Y-m-d') . ' 08:00:00'); ?>">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <?php echo Form::label('pickup_time_to', trans('global.to')); ?>

                                    <div class="input-group">
                                        <div class="has-feedback">
                                            <i class="icon calendar form-control-feedback"></i>
                                            <input class="datetimepicker form-control" name="pickup_time_to" type="text" value="<?php echo e(date('Y-m-d') . ' 12:00:00'); ?>">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            <?php echo Form::label('delivery_address', trans('validation.attributes.delivery_address').':'); ?>

                            <?php echo Form::hidden('delivery_address_id'); ?>

                            <?php echo Form::hidden('delivery_address_lat'); ?>

                            <?php echo Form::hidden('delivery_address_lng'); ?>

                            <?php echo $__env->make('Frontend.Addresses.partials.map_button',
                                [
                                    'type' => 'delivery',
                                    'parent' => '#new_task',
                                    'address' => '',
                                    'lat' => '',
                                    'lng' => '',
                                ]
                            , array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                        </div>

                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="delivery_time_from" class="control-label"><?php echo e(trans('global.from')); ?></label>
                                    <div class="input-group">
                                        <div class="has-feedback">
                                            <i class="icon calendar form-control-feedback"></i>
                                            <input class="datetimepicker form-control" name="delivery_time_from" type="text" value="<?php echo e(date('Y-m-d') . ' 12:00:00'); ?>">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="delivery_time_to" class="control-label"><?php echo e(trans('global.to')); ?></label>
                                    <div class="input-group">
                                        <div class="has-feedback">
                                            <i class="icon calendar form-control-feedback"></i>
                                            <input class="datetimepicker form-control" name="delivery_time_to" type="text" value="<?php echo e(date('Y-m-d')  . ' 17:00:00'); ?>">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <hr>

                <div class="form-group">
                    <?php echo Form::label('comment', trans('front.comment').':'); ?>

                    <?php echo Form::textarea('comment',  null, ['class' => 'form-control']); ?>

                </div>


            </div>
            <div class="tab-pane"  id="setup-form-task-list">
                <div class="row">
                    <div class="col-xs-12" id="taskList">
                        <div class="row">
                            <div class="col-xs-6">
                                <div class="form-group">
                                    <?php echo Form::label('search_device_id', trans('validation.attributes.device_id').':'); ?>

                                    <?php echo Form::select('search_device_id', $devices, null, ['class' => 'form-control', 'data-live-search' => 'true',  'data-filter' => 'true']); ?>

                                </div>
                            </div>
                            <div class="col-xs-6">
                                <div class="form-group">
                                    <?php echo Form::label('search_task_status', trans('validation.attributes.status').':'); ?>

                                    <?php echo Form::select('search_task_status', $statuses, null, ['class' => 'form-control',  'data-filter' => 'true']); ?>

                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xs-6">
                                <div class="form-group">
                                    <?php echo Form::label('search_time_from', trans('global.from').':'); ?>

                                    <?php echo Form::text('search_time_from', null, ['class' => 'datetimepicker form-control', 'id' => 'search_time_from',  'data-filter' => 'true']); ?>

                                </div>
                            </div>
                            <div class="col-xs-6">
                                <div class="form-group">
                                    <?php echo Form::label('search_time_to', trans('global.to').':'); ?>

                                    <?php echo Form::text('search_time_to', null, ['class' => 'datetimepicker form-control', 'id' => 'search_time_to',  'data-filter' => 'true']); ?>

                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xs-6">
                                <div class="form-group">
                                    <?php echo Form::label('search_invoice_number', trans('validation.attributes.invoice_number').':'); ?>

                                    <?php echo Form::text('search_invoice_number', null, ['class' => 'form-control', 'id' => 'search_invoice_number',  'data-filter' => 'true']); ?>

                                </div>
                            </div>
                            <div class="col-xs-6">
                                <div class="form-group text-right">
                                    <label style="display: block;">&nbsp;</label>
                                    <button class="btn btn-default" type="button" id="searchTasks">
                                        <i class="icon find"></i> <?php echo e(trans('front.search')); ?>

                                    </button>
                                </div>
                            </div>
                            <input type="hidden" name="sorting[sort_by]" value="<?php echo e($tasks->sorting['sort_by']); ?>" data-filter="true">
                            <input type="hidden" name="sorting[sort]" value="<?php echo e($tasks->sorting['sort']); ?>" data-filter="true">
                        </div>
                        <div data-table>
                            <?php echo $__env->make('Frontend.Tasks.list', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php echo Form::close(); ?>

    </div>
    <script>
            tables.set_config('taskList', {
                url:'<?php echo e(route('tasks.list')); ?>',
                do_destroy: {
                    url: '<?php echo e(route("tasks.do_destroy")); ?>',
                    modal: 'tasks_destroy',
                    method: 'GET'
                },
                assign: {
                    url: '<?php echo e(route("tasks.assign_form")); ?>',
                    modal: 'tasks_assign',
                    method: 'GET'
                }
            });

            function tasks_edit_modal_callback(res) {
                if (res.status == 1) {
                    tables.get('taskList');
                }
            }

            function tasks_destroy_modal_callback(res) {
                if (res.status == 1)
                    tables.get('taskList');
            }

            function tasks_import_modal_callback() {
                tables.get('taskList');
            }

            function tasks_assign_modal_callback(res) {
                if (res.status == 1)
                    tables.get('taskList');
            }

            $('#searchTasks').on('click', function () {
                var $deviceId = $('#search_device_id').find("option:selected").val();
                var $status = $('#search_task_status').find("option:selected").val();
                var $time_from = $('#search_time_from').val();
                var $time_to = $('#search_time_to').val();
                var $invoice_number = $('#search_invoice_number').val();

                $.ajax({
                    type: "Get",
                    dataType: "html",
                    url: "<?php echo e(route('tasks.list')); ?>",
                    data: {
                        search_device_id: $deviceId,
                        search_task_status: $status,
                        search_time_from: $time_from,
                        search_time_to: $time_to,
                        search_invoice_number: $invoice_number
                    },
                    beforeSend: function() {
                        loader.add( $('body') );
                    },
                    success: function(res){
                        $table = $('[data-table]', $('#tasks'));
                        $table.html(res)


                    },
                    complete: function() {
                        loader.remove( $('body') );
                    }
                });
            });
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('buttons'); ?>
    <button type="button" class="btn btn-action update"><?php echo trans('global.save'); ?></button>
    <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo trans('global.cancel'); ?></button>
    <button type="button" class="btn btn-default" data-modal="tasks_import" data-url="<?php echo e(route('tasks.import')); ?>"><?php echo trans('front.import'); ?></button>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('Frontend.Layouts.modal', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>