<div class="tab-pane" id="geofencing_tab">
    <div class="tab-pane-header">
        <div class="form">
            <div class="input-group">
                <div class="form-group search">
                    <?php echo Form::text('search', null, ['class' => 'form-control', 'placeholder' => trans('front.search'), 'autocomplete' => 'off']); ?>

                </div>
                <?php if(Auth::User()->perm('geofences', 'edit')): ?>
                <span class="input-group-btn">
                    <div class="btn-group dropdown">
                        <button class="btn btn-default" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="icon edit"></i>
                        </button>
                        <ul class="dropdown-menu">
                            <li><a href="javascript:" data-url="<?php echo e(route('geofences.export')); ?>" data-modal="geofences_export"><?php echo e(trans('front.export')); ?></a></li>
                            <li>
                                <a href="javascript:"
                                   data-url="<?php echo e(route('geofences.import_modal')); ?>"
                                   data-modal="geofences_import">
                                    <?php echo e(trans('front.import')); ?>

                                </a>
                            </li>
                        </ul>
                    </div>

                    <a href="javascript:" class="btn btn-primary" type="button" onClick="app.geofences.create();">
                        <i class="icon add"></i>
                    </a>
                </span>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="tab-pane-body">
        <div id="ajax-geofences"></div>
    </div>
</div>

<div class="tab-pane" id="geofencing_create">
    <div class="tab-pane-header">
        <div class="alert alert-info">
            <?php echo trans('front.please_draw_polygon'); ?>

        </div>
    </div>

    <?php echo Form::hidden('polygon'); ?>

    <?php echo Form::open(['route' => 'geofences.store', 'method' => 'POST', 'class' => 'form', 'id' => 'geofence_create']); ?>

    <div class="tab-pane-body">
        <div class="form-group">
            <?php echo Form::label('name', trans('validation.attributes.name').':'); ?>

            <?php echo Form::text('name', null, ['class' => 'form-control']); ?>

        </div>
        <div class="form-group">
            <?php echo Form::label('type', trans('validation.attributes.type').':'); ?>

            <?php echo Form::select('type', $geofence_types, null, ['class' => 'form-control', 'onChange' => "app.geofences.changeType(this);"]); ?>

        </div>
        <?php if(settings('plugins.moving_geofence.status')): ?>
        <div class="form-group">
            <?php echo Form::label('device_id', trans('validation.attributes.geofence_device').':'); ?>

            <?php echo Form::select('device_id', ['' => trans('front.none')] + $devices, null, ['class' => 'form-control devices_list', 'data-live-search' => 'true']); ?>

        </div>
        <?php endif; ?>
        <div class="form-group">
            <?php echo Form::label('group_id', trans('validation.attributes.group_id').':'); ?>

            <div class="input-group">
                <div class="geofence_groups_select_ajax">
                    <?php echo Form::select('group_id', $geofence_groups, null, ['class' => 'form-control geofence_groups_select']); ?>

                </div>

                <span class="input-group-btn">
                    <a href="javascript:" class="btn btn-primary" data-url="<?php echo e(route('geofences_groups.index')); ?>" data-modal="geofence_groups" title="<?php echo e(trans('front.add_group')); ?>">
                        <i class="icon add"></i>
                    </a>
                </span>
            </div>
        </div>

        <div class="form-group">
            <?php echo Form::label('polygon_color', trans('validation.attributes.polygon_color').':'); ?>

            <?php echo Form::text('polygon_color', '#D000DF', ['class' => 'form-control colorpicker']); ?>

        </div>

        <div class="buttons text-center">
            <a type="button" class="btn btn-action" href="javascript:" onClick="app.geofences.store();"><?php echo trans('global.save'); ?></a>
            <a type="button" class="btn btn-default" href="javascript:" onClick="app.openTab('geofencing_tab');"><?php echo trans('global.cancel'); ?></a>
        </div>
    </div>
    <?php echo Form::close(); ?>

</div>

<div class="tab-pane" id="geofencing_edit">
    <?php echo Form::hidden('polygon'); ?>

    <?php echo Form::open(['route' => 'geofences.update', 'method' => 'PUT', 'id' => 'geofence_update']); ?>

    <div class="tab-pane-body">

        <div class="form-group">
            <?php echo Form::label('name', trans('validation.attributes.name').':'); ?>

            <?php echo Form::text('name', null, ['class' => 'form-control']); ?>

        </div>
        <div class="form-group">
            <?php echo Form::label('type', trans('validation.attributes.type').':'); ?>

            <?php echo Form::select('type', $geofence_types, null, ['class' => 'form-control', 'onChange' => "app.geofences.changeType(this);"]); ?>

        </div>
        <?php if(settings('plugins.moving_geofence.status')): ?>
            <div class="form-group">
                <?php echo Form::label('device_id', trans('validation.attributes.geofence_device').':'); ?>

                <?php echo Form::select('device_id', ['' => trans('front.none')] + $devices, null, ['class' => 'form-control devices_list', 'data-live-search' => 'true']); ?>

            </div>
        <?php endif; ?>
        <div class="form-group">
            <?php echo Form::label('group_id', trans('validation.attributes.group_id').':'); ?>

            <div class="input-group">
                <div class="geofence_groups_select_ajax">

                </div>
                <?php echo Form::select('group_id', $geofence_groups, null, ['class' => 'form-control geofence_groups_select']); ?>

                <span class="input-group-btn">
                    <a href="javascript:" class="btn btn-primary" data-url="<?php echo e(route('geofences_groups.index')); ?>" data-modal="geofence_groups" title="<?php echo e(trans('front.add_group')); ?>">
                        <i class="icon add"></i>
                    </a>
                </span>
            </div>
        </div>

        <div class="form-group">
            <?php echo Form::label('polygon_color', trans('validation.attributes.polygon_color').':'); ?>

            <?php echo Form::text('polygon_color', '#D000DF', ['class' => 'form-control colorpicker']); ?>

        </div>

        <div class="buttons text-center">
            <a type="button" class="btn btn-action" href="javascript:" onClick="app.geofences.update();"><?php echo trans('global.save'); ?></a>
            <a type="button" class="btn btn-default" href="javascript:" onClick="app.openTab('geofencing_tab');"><?php echo trans('global.cancel'); ?></a>
        </div>
    </div>
    <?php echo Form::close(); ?>

</div>