<?php if(!empty($items)): ?>
    <div class="history">
        <table class="table">
            <tbody>
            <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr data-history-id="<?php echo $key; ?>" class="<?php echo e($classes[$item['status']]['tr']); ?>" onClick="app.history.select( <?php echo $key; ?> );">
                    <td>
                        <span class="<?php echo e($classes[$item['status']]['class']); ?>"><?php echo $classes[$item['status']]['sym']; ?></span>
                    </td>
                    <td>
                        <div class="row">
                            <div class="col-xs-12 col-sm-6 datetime">
                                <span class="time"><?php echo e($item['start']['time']); ?></span>
                                <span class="date"><?php echo e($item['start']['date']); ?></span>
                            </div>
                            <?php if(!empty($item['metas'])): ?>
                            <div class="col-xs-12 col-sm-6 duration">

                                <?php $__currentLoopData = $item['metas']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $meta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(in_array($key, ['duration', 'message'])): ?>
                                    <span><?php echo e($meta['value']); ?></span>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            <?php endif; ?>
                        </div>

                        <?php if(settings('plugins.history_section_address.status')): ?>
                        <div class="row">
                            <div class="col-sm-12">
                                <br>
                                <span data-device="address" data-lat="<?php echo e($item['start']['lat']); ?>" data-lng="<?php echo e($item['start']['lng']); ?>"></span>
                            </div>
                        </div>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>

    <script>
        window.history_items = <?php echo json_encode($items); ?>;
        window.history_sensors = <?php echo json_encode($sensors); ?>;
        initComponents($('.history'));
    </script>
<?php else: ?>
    <p class="no-results"><?php echo trans('front.no_history'); ?></p>

    <script>
        window.history_items = null;
        window.history_sensors = null;
    </script>
<?php endif; ?>