<div class="table_error"></div>
<div class="table-responsive">
    <table class="table table-list" data-toggle="multiCheckbox">
        <thead>
        <tr>
            <?php if( Auth::User()->perm('devices', 'remove') ): ?>
                <?php echo tableHeaderCheckall(['do_destroy' => trans('admin.delete_selected'), 'assign' => trans('admin.assign_selected')]); ?>

            <?php endif; ?>
            <?php echo tableHeader('validation.attributes.active'); ?>

            <?php echo tableHeaderSort($items->sorting, 'devices.name', 'validation.attributes.name'); ?>

            <?php echo tableHeaderSort($items->sorting, 'devices.imei', 'validation.attributes.imei'); ?>

            <?php echo tableHeader('global.online', 'style="text-align:center;"'); ?>

            <?php echo tableHeaderSort($items->sorting, 'traccar.server_time', 'admin.last_connection'); ?>

            <?php if(Auth::user()->can('view', new \Tobuli\Entities\Device(), 'expiration_date')): ?>
                    <?php echo tableHeaderSort($items->sorting, 'expiration_date', 'validation.attributes.expiration_date'); ?>

            <?php endif; ?>
            <?php echo tableHeader('validation.attributes.user'); ?>

            <?php echo tableHeader('admin.actions', 'style="text-align: right;"'); ?>

        </tr>
        </thead>

        <tbody>
        <?php if(count($collection = $items->getCollection())): ?>
            <?php $__currentLoopData = $collection; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <?php if( Auth::User()->perm('devices', 'remove') ): ?>
                        <td>
                            <div class="checkbox">
                                <input type="checkbox" value="<?php echo $item->id; ?>">
                                <label></label>
                            </div>
                        </td>
                    <?php endif; ?>
                    <td>
                        <span class="label label-sm label-<?php echo $item->active ? 'success' : 'danger'; ?>">
                            <?php echo trans('validation.attributes.active'); ?>

                        </span>
                    </td>
                    <td>
                        <?php echo e($item->name); ?>

                    </td>
                    <td>
                        <?php echo e($item->imei); ?>

                    </td>
                    <td style="text-align: center">
                        <span
                                class="device-status"
                                style="background-color: <?php echo e($item->getStatusColor()); ?>"
                                data-toggle="tooltip"
                                title="<?php echo e(trans("global.{$item->getStatus()}")); ?>">
                        </span>
                    </td>
                    <td>
                        <?php echo e($item->server_time ? Formatter::time()->human($item->server_time) : trans('front.not_connected')); ?>

                    </td>
                    <?php if(Auth::user()->can('view', $item, 'expiration_date')): ?>
                        <td>
                            <?php echo e($item->hasExpireDate() ? Formatter::time()->human($item->expiration_date) : trans('front.unlimited')); ?>

                        </td>
                    <?php endif; ?>
                    <td class="user-list">
                        <?php echo e($item->users->filter(function($value){ return auth()->user()->can('show', $value); })->implode('email', ', ')); ?>

                    </td>
                    <td class="actions">
                        <?php if(Auth::User()->perm('devices', 'edit') || Auth::User()->perm('devices', 'remove')): ?>
                            <div class="btn-group dropdown droparrow" data-position="fixed">
                                <i class="btn icon edit" data-toggle="dropdown" aria-haspopup="true"
                                   aria-expanded="true"></i>
                                <ul class="dropdown-menu">
                                    <?php if( Auth::User()->perm('devices', 'edit') ): ?>
                                        <li>
                                            <a href="javascript:" data-modal="devices_edit"
                                               data-url="<?php echo e(route("devices.edit", [$item->id, 1])); ?>">
                                                <?php echo e(trans('global.edit')); ?>

                                            </a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if( Auth::User()->perm('devices', 'remove') ): ?>
                                        <li>
                                            <a href="javascript:" data-modal="devices_delete"
                                               data-url="<?php echo e(route("devices.do_destroy", ['id' => $item->id])); ?>">
                                                <?php echo e(trans('global.delete')); ?>

                                            </a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
            <tr class="">
                <td class="no-data" colspan="7">
                    <?php echo trans('admin.no_data'); ?>

                </td>
            </tr>
        <?php endif; ?>
        </tbody>
    </table>
</div>

<?php echo $__env->make("Admin.Layouts.partials.pagination", array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>