<!DOCTYPE html>
<html lang="<?php echo e(Language::iso()); ?>">
<head>
    <?php echo $__env->make('Frontend.Layouts.partials.head', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php echo $__env->yieldContent('styles'); ?>
</head>
<body>

<div id="header">
    <nav class="navbar navbar-main">
        <div class="container-fluid">
            <div class="navbar-header">
                <?php if( Appearance::assetFileExists('logo') ): ?>
                    <a class="navbar-brand" href="/" title="<?php echo e(Appearance::getSetting('server_name')); ?>"><img src="<?php echo e(Appearance::getAssetFileUrl('logo')); ?>"></a>
                <?php endif; ?>
            </div>

            <ul class="nav navbar-nav navbar-right">

                <?php echo $__env->yieldContent('header-menu-items'); ?>

                <li class="dropdown">
                    <a href="javascript:" class="dropdown-toggle" role="button" id="dropMyAccount" data-toggle="dropdown" rel="tooltip" data-placement="bottom" title="<?php echo trans('front.my_account'); ?>">
                        <span class="icon account"></span>
                        <span class="text"><?php echo trans('front.my_account'); ?></span>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-right" role="menu" aria-labelledby="dropMyAccount">
                        <li>
                            <a href="javascript:" data-url="<?php echo e(route('subscriptions.index')); ?>" data-modal="subscriptions_edit">
                                <span class="icon membership"></span>
                                <span class="text"><?php echo trans('front.subscriptions'); ?></span>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo route('logout'); ?>">
                                <span class="icon logout"></span>
                                <span class="text"><?php echo trans('global.log_out'); ?></span>
                            </a>
                        </li>
                    </ul>
                </li>
                <li class="language-selection">
                    <a href="javascript:" data-url="<?php echo e(route('languages.index')); ?>" data-modal="language-selection">
                        <img src="<?php echo e(Language::flag()); ?>" alt="Language" class="img-thumbnail">
                    </a>
                </li>
            </ul>

        </div>
    </nav>
</div>

<div class="content">
    <div class="container-fluid">
        <?php echo $__env->yieldContent('content'); ?>
    </div>
</div>

<?php echo $__env->make('Frontend.Layouts.partials.trans', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

<?php echo $__env->yieldContent('self-scripts'); ?>

<script src="<?php echo e(asset_resource('assets/js/core.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(asset_resource('assets/js/app.js')); ?>" type="text/javascript"></script>
<?php if(file_exists(storage_path('custom/js.js'))): ?>
    <script src="<?php echo e(asset_resource('assets/js/custom.js', storage_path('custom/js.js'))); ?>" type="text/javascript"></script>
<?php endif; ?>

<?php echo $__env->yieldContent('scripts'); ?>

</body>
</html>