<div class="table-responsive">
    <table class="table table-list">
        <thead>
            <tr>
                <th><?php echo trans('validation.attributes.title'); ?></th>
                <th><?php echo trans('validation.attributes.type'); ?></th>
                <th><?php echo trans('validation.attributes.format'); ?></th>
                <th><?php echo trans('front.devices'); ?></th>
                <th><?php echo trans('front.geofences'); ?></th>
                <th><?php echo trans('front.schedule'); ?></th>
                <th></th>
            </tr>
        </thead>
        <tbody>
        <?php if(count($reports)): ?>
            <?php $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td>
                        <?php echo e($report->title); ?>

                    </td>
                    <td>
                        <?php echo e(\Tobuli\Reports\ReportManager::getTitle($report->type) ?? ''); ?>

                    </td>
                    <td>
                        <?php echo e(trans('front.'.$report->format)); ?>

                    </td>
                    <td>
                        <?php echo e(count($report->devices)); ?>

                    </td>
                    <td>
                        <?php echo e(count($report->geofences)); ?>

                    </td>
                    <td>
                        <?php echo e($report->isSchedule() ? trans('global.yes') : trans('global.no')); ?>

                    </td>
                    <td class="actions">
                        <a href="javascript:" class="report_item_edit"><i class="icon edit"></i></a>
                        <?php
                        $report = $report->toArray();
                        $report['geofences'] = array_map(function($value) {
                            return array_only($value, ['id']);
                        },$report['geofences']);

                        $report['devices'] = array_map(function($value) {
                            return array_only($value, ['id']);
                        },$report['devices']);
                        ?>
                        <span class="report_item_json hidden"><?php echo json_encode($report); ?></span>

                        <a href="javascript:" data-url="<?php echo route('reports.do_destroy', $report['id']); ?>" data-modal="reports_destroy"><i class="icon delete"></i></a>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
            <tr>
                <td colspan="7"><?php echo trans('front.no_reports'); ?></td>
            </tr>
        <?php endif; ?>
        </tbody>
    </table>
</div>

<div class="nav-pagination">
    <?php echo $reports->render(); ?>

</div>