<?php $__env->startSection('content'); ?>
    <?php if( Appearance::getSetting('welcome_text') ): ?>
    <h1 class="sign-in-text text-center">
        <?php echo Appearance::getSetting('welcome_text'); ?>

    </h1>
    <?php endif; ?>

    <div class="panel">
        <div class="panel-background"></div>
        <div class="panel-body">

            <?php if( Appearance::assetFileExists('logo-main') ): ?>
            <a href="<?php echo e(route('home')); ?>">
                <img class="img-responsive center-block" src="<?php echo e(Appearance::getAssetFileUrl('logo-main')); ?>" alt="Logo">
            </a>
            <?php endif; ?>

            <hr>

            <?php if(Session::has('success')): ?>
                <div class="alert alert-success alert-dismissible">
                    <?php echo Session::get('success'); ?>

                </div>
            <?php endif; ?>

            <?php if(Session::has('message')): ?>
                <div class="alert alert-danger alert-dismissible">
                    <?php echo Session::get('message'); ?>

                </div>
            <?php endif; ?>

            <?php echo Form::open(array('route' => 'authentication.store', 'class' => 'form')); ?>

                <div class="form-group">
                    <?php echo Form::email('email', null, ['class' => 'form-control', 'placeholder' => trans('validation.attributes.email'), 'id' => 'sign-in-form-email']); ?>

                </div>
                <div class="form-group">
                    <?php echo Form::password('password', ['class' => 'form-control', 'placeholder' => trans('validation.attributes.password'), 'id' => 'sign-in-form-password']); ?>

                </div>

                <?php if(config('session.remember_me')): ?>
                <div class="form-group">
                    <div class="checkbox">
                        <?php echo Form::checkbox('remember_me', 1, ['id' => 'sign-in-form-remember']); ?>

                        <label><?php echo trans('validation.attributes.remember_me'); ?></label>
                    </div>
                </div>
                <?php endif; ?>

                <button class="btn btn-lg btn-primary btn-block"  name="Submit" value="Login" type="Submit"><?php echo trans('front.sign_in'); ?></button>

                <hr>

                <div class="form-group">
                    <div class="row">
                        <div class="col-sm-12">
                            <a href="<?php echo route('password_reminder.create'); ?>" class="btn btn-block btn-lg btn-default"><?php echo trans('front.cant_sign_in'); ?></a>
                        </div>
                        <div class="col-sm-12">
                            <?php if(settings('main_settings.allow_users_registration')): ?>
                                <a href="<?php echo route('registration.create'); ?>" class="btn btn-block btn-lg btn-default"><?php echo trans('front.not_a_member'); ?></a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php echo Form::close(); ?>

        </div>
    </div>

    <?php if( Appearance::getSetting('google_play_link') || Appearance::getSetting('apple_store_link') ): ?>
        <div class="app-links">
            <?php if( Appearance::getSetting('google_play_link') ): ?>
                <div class="col-xs-6">
                    <a href="<?php echo e(Appearance::getSetting('google_play_link')); ?>" target="_blank"><img src="<?php echo e(asset('assets/images/google-play.png')); ?>" class="img-responsive" /></a>
                </div>
            <?php endif; ?>

            <?php if( Appearance::getSetting('apple_store_link') ): ?>
                <div class="col-xs-6">
                    <a href="<?php echo e(Appearance::getSetting('apple_store_link')); ?>" target="_blank"><img src="<?php echo e(asset('assets/images/apple-store.png')); ?>" class="img-responsive" /></a>
                </div>
            <?php endif; ?>
            <div class="clearfix"></div>
        </div>

    <?php endif; ?>

    <?php if( Appearance::getSetting('bottom_text') ): ?>
        <p class="sign-in-text"><?php echo Appearance::getSetting('bottom_text'); ?></p>
    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('Frontend.Layouts.frontend', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>