/// <reference types="node" />
import type { Contact } from "./Contact";
import type { proto } from "../../WAProto";
export declare type KeyPair = {
    public: Uint8Array;
    private: Uint8Array;
};
export declare type SignedKeyPair = {
    keyPair: KeyPair;
    signature: Uint8Array;
    keyId: number;
};
export declare type ProtocolAddress = {
    name: string;
    deviceId: number;
};
export declare type SignalIdentity = {
    identifier: ProtocolAddress;
    identifierKey: Uint8Array;
};
export declare type LTHashState = {
    version: number;
    hash: Buffer;
    indexValueMap: {
        [indexMacBase64: string]: {
            valueMac: Uint8Array | Buffer;
        };
    };
};
export declare type SignalCreds = {
    readonly signedIdentityKey: KeyPair;
    readonly signedPreKey: SignedKeyPair;
    readonly registrationId: number;
};
export declare type AuthenticationCreds = SignalCreds & {
    readonly noiseKey: KeyPair;
    readonly advSecretKey: string;
    me?: Contact;
    account?: proto.IADVSignedDeviceIdentity;
    signalIdentities?: SignalIdentity[];
    myAppStateKeyId?: string;
    firstUnuploadedPreKeyId: number;
    serverHasPreKeys: boolean;
    nextPreKeyId: number;
    lastAccountSyncTimestamp?: number;
};
export declare type SignalDataTypeMap = {
    'pre-key': KeyPair;
    'session': any;
    'sender-key': any;
    'sender-key-memory': {
        [jid: string]: boolean;
    };
    'app-state-sync-key': proto.IAppStateSyncKeyData;
    'app-state-sync-version': LTHashState;
};
export declare type SignalDataSet = {
    [T in keyof SignalDataTypeMap]?: {
        [id: string]: SignalDataTypeMap[T] | null;
    };
};
declare type Awaitable<T> = T | Promise<T>;
export declare type SignalKeyStore = {
    get<T extends keyof SignalDataTypeMap>(type: T, ids: string[]): Awaitable<{
        [id: string]: SignalDataTypeMap[T];
    }>;
    set(data: SignalDataSet): Awaitable<void>;
};
export declare type SignalKeyStoreWithTransaction = SignalKeyStore & {
    isInTransaction: () => boolean;
    transaction(exec: () => Promise<void>): Promise<void>;
    prefetch<T extends keyof SignalDataTypeMap>(type: T, ids: string[]): Promise<void>;
};
export declare type SignalAuthState = {
    creds: SignalCreds;
    keys: SignalKeyStore;
};
export declare type AuthenticationState = {
    creds: AuthenticationCreds;
    keys: SignalKeyStore;
};
export {};
