import type { proto } from "../../WAProto";
/** set of statuses visible to other people; see updatePresence() in WhatsAppWeb.Send */
export declare type WAPresence = 'unavailable' | 'available' | 'composing' | 'recording' | 'paused';
export declare type WAPatchName = 'critical_block' | 'critical_unblock_low' | 'regular_low' | 'regular_high' | 'regular';
export interface PresenceData {
    lastKnownPresence: WAPresence;
    lastSeen?: number;
}
export declare type ChatMutation = {
    syncAction: proto.ISyncActionData;
    index: string[];
    indexMac: Uint8Array;
    valueMac: Uint8Array;
    operation: number;
};
export declare type WAPatchCreate = {
    syncAction: proto.ISyncActionValue;
    index: string[];
    type: WAPatchName;
    apiVersion: number;
    operation: proto.SyncdMutation.SyncdMutationSyncdOperation;
};
export declare type Chat = Omit<proto.IConversation, 'messages'> & {
    /** unix timestamp of date when mute ends, if applicable */
    mute?: number | null;
    /** timestamp of when pinned */
    pin?: number | null;
    archive?: boolean;
};
export declare type ChatModification = {
    archive: boolean;
} | {
    pin: boolean;
} | {
    /** mute for duration, or provide timestamp of mute to remove*/
    mute: number | null;
} | {
    clear: 'all' | {
        messages: {
            id: string;
            fromMe?: boolean;
        }[];
    };
} | {
    star: {
        messages: {
            id: string;
            fromMe?: boolean;
        }[];
        star: boolean;
    };
} | {
    markRead: boolean;
} | {
    delete: true;
};
