/*eslint-disable block-scoped-var, id-length, no-control-regex, no-magic-numbers, no-prototype-builtins, no-redeclare, no-shadow, no-var, sort-vars*/
"use strict";

var $protobuf = require("protobufjs/minimal");

// Common aliases
var $Reader = $protobuf.Reader, $Writer = $protobuf.Writer, $util = $protobuf.util;

// Exported root namespace
var $root = $protobuf.roots["default"] || ($protobuf.roots["default"] = {});

$root.proto = (function() {

    /**
     * Namespace proto.
     * @exports proto
     * @namespace
     */
    var proto = {};

    proto.ADVDeviceIdentity = (function() {

        /**
         * Properties of a ADVDeviceIdentity.
         * @memberof proto
         * @interface IADVDeviceIdentity
         * @property {number|null} [rawId] ADVDeviceIdentity rawId
         * @property {number|Long|null} [timestamp] ADVDeviceIdentity timestamp
         * @property {number|null} [keyIndex] ADVDeviceIdentity keyIndex
         */

        /**
         * Constructs a new ADVDeviceIdentity.
         * @memberof proto
         * @classdesc Represents a ADVDeviceIdentity.
         * @implements IADVDeviceIdentity
         * @constructor
         * @param {proto.IADVDeviceIdentity=} [properties] Properties to set
         */
        function ADVDeviceIdentity(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ADVDeviceIdentity rawId.
         * @member {number} rawId
         * @memberof proto.ADVDeviceIdentity
         * @instance
         */
        ADVDeviceIdentity.prototype.rawId = 0;

        /**
         * ADVDeviceIdentity timestamp.
         * @member {number|Long} timestamp
         * @memberof proto.ADVDeviceIdentity
         * @instance
         */
        ADVDeviceIdentity.prototype.timestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * ADVDeviceIdentity keyIndex.
         * @member {number} keyIndex
         * @memberof proto.ADVDeviceIdentity
         * @instance
         */
        ADVDeviceIdentity.prototype.keyIndex = 0;

        /**
         * Creates a new ADVDeviceIdentity instance using the specified properties.
         * @function create
         * @memberof proto.ADVDeviceIdentity
         * @static
         * @param {proto.IADVDeviceIdentity=} [properties] Properties to set
         * @returns {proto.ADVDeviceIdentity} ADVDeviceIdentity instance
         */
        ADVDeviceIdentity.create = function create(properties) {
            return new ADVDeviceIdentity(properties);
        };

        /**
         * Encodes the specified ADVDeviceIdentity message. Does not implicitly {@link proto.ADVDeviceIdentity.verify|verify} messages.
         * @function encode
         * @memberof proto.ADVDeviceIdentity
         * @static
         * @param {proto.IADVDeviceIdentity} message ADVDeviceIdentity message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVDeviceIdentity.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.rawId != null && Object.hasOwnProperty.call(message, "rawId"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.rawId);
            if (message.timestamp != null && Object.hasOwnProperty.call(message, "timestamp"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint64(message.timestamp);
            if (message.keyIndex != null && Object.hasOwnProperty.call(message, "keyIndex"))
                writer.uint32(/* id 3, wireType 0 =*/24).uint32(message.keyIndex);
            return writer;
        };

        /**
         * Encodes the specified ADVDeviceIdentity message, length delimited. Does not implicitly {@link proto.ADVDeviceIdentity.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ADVDeviceIdentity
         * @static
         * @param {proto.IADVDeviceIdentity} message ADVDeviceIdentity message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVDeviceIdentity.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ADVDeviceIdentity message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ADVDeviceIdentity
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ADVDeviceIdentity} ADVDeviceIdentity
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVDeviceIdentity.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ADVDeviceIdentity();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.rawId = reader.uint32();
                    break;
                case 2:
                    message.timestamp = reader.uint64();
                    break;
                case 3:
                    message.keyIndex = reader.uint32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ADVDeviceIdentity message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ADVDeviceIdentity
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ADVDeviceIdentity} ADVDeviceIdentity
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVDeviceIdentity.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ADVDeviceIdentity message.
         * @function verify
         * @memberof proto.ADVDeviceIdentity
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ADVDeviceIdentity.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.rawId != null && message.hasOwnProperty("rawId"))
                if (!$util.isInteger(message.rawId))
                    return "rawId: integer expected";
            if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                if (!$util.isInteger(message.timestamp) && !(message.timestamp && $util.isInteger(message.timestamp.low) && $util.isInteger(message.timestamp.high)))
                    return "timestamp: integer|Long expected";
            if (message.keyIndex != null && message.hasOwnProperty("keyIndex"))
                if (!$util.isInteger(message.keyIndex))
                    return "keyIndex: integer expected";
            return null;
        };

        /**
         * Creates a ADVDeviceIdentity message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ADVDeviceIdentity
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ADVDeviceIdentity} ADVDeviceIdentity
         */
        ADVDeviceIdentity.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ADVDeviceIdentity)
                return object;
            var message = new $root.proto.ADVDeviceIdentity();
            if (object.rawId != null)
                message.rawId = object.rawId >>> 0;
            if (object.timestamp != null)
                if ($util.Long)
                    (message.timestamp = $util.Long.fromValue(object.timestamp)).unsigned = true;
                else if (typeof object.timestamp === "string")
                    message.timestamp = parseInt(object.timestamp, 10);
                else if (typeof object.timestamp === "number")
                    message.timestamp = object.timestamp;
                else if (typeof object.timestamp === "object")
                    message.timestamp = new $util.LongBits(object.timestamp.low >>> 0, object.timestamp.high >>> 0).toNumber(true);
            if (object.keyIndex != null)
                message.keyIndex = object.keyIndex >>> 0;
            return message;
        };

        /**
         * Creates a plain object from a ADVDeviceIdentity message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ADVDeviceIdentity
         * @static
         * @param {proto.ADVDeviceIdentity} message ADVDeviceIdentity
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ADVDeviceIdentity.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.rawId = 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.timestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.timestamp = options.longs === String ? "0" : 0;
                object.keyIndex = 0;
            }
            if (message.rawId != null && message.hasOwnProperty("rawId"))
                object.rawId = message.rawId;
            if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                if (typeof message.timestamp === "number")
                    object.timestamp = options.longs === String ? String(message.timestamp) : message.timestamp;
                else
                    object.timestamp = options.longs === String ? $util.Long.prototype.toString.call(message.timestamp) : options.longs === Number ? new $util.LongBits(message.timestamp.low >>> 0, message.timestamp.high >>> 0).toNumber(true) : message.timestamp;
            if (message.keyIndex != null && message.hasOwnProperty("keyIndex"))
                object.keyIndex = message.keyIndex;
            return object;
        };

        /**
         * Converts this ADVDeviceIdentity to JSON.
         * @function toJSON
         * @memberof proto.ADVDeviceIdentity
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ADVDeviceIdentity.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ADVDeviceIdentity;
    })();

    proto.ADVKeyIndexList = (function() {

        /**
         * Properties of a ADVKeyIndexList.
         * @memberof proto
         * @interface IADVKeyIndexList
         * @property {number|null} [rawId] ADVKeyIndexList rawId
         * @property {number|Long|null} [timestamp] ADVKeyIndexList timestamp
         * @property {number|null} [currentIndex] ADVKeyIndexList currentIndex
         * @property {Array.<number>|null} [validIndexes] ADVKeyIndexList validIndexes
         */

        /**
         * Constructs a new ADVKeyIndexList.
         * @memberof proto
         * @classdesc Represents a ADVKeyIndexList.
         * @implements IADVKeyIndexList
         * @constructor
         * @param {proto.IADVKeyIndexList=} [properties] Properties to set
         */
        function ADVKeyIndexList(properties) {
            this.validIndexes = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ADVKeyIndexList rawId.
         * @member {number} rawId
         * @memberof proto.ADVKeyIndexList
         * @instance
         */
        ADVKeyIndexList.prototype.rawId = 0;

        /**
         * ADVKeyIndexList timestamp.
         * @member {number|Long} timestamp
         * @memberof proto.ADVKeyIndexList
         * @instance
         */
        ADVKeyIndexList.prototype.timestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * ADVKeyIndexList currentIndex.
         * @member {number} currentIndex
         * @memberof proto.ADVKeyIndexList
         * @instance
         */
        ADVKeyIndexList.prototype.currentIndex = 0;

        /**
         * ADVKeyIndexList validIndexes.
         * @member {Array.<number>} validIndexes
         * @memberof proto.ADVKeyIndexList
         * @instance
         */
        ADVKeyIndexList.prototype.validIndexes = $util.emptyArray;

        /**
         * Creates a new ADVKeyIndexList instance using the specified properties.
         * @function create
         * @memberof proto.ADVKeyIndexList
         * @static
         * @param {proto.IADVKeyIndexList=} [properties] Properties to set
         * @returns {proto.ADVKeyIndexList} ADVKeyIndexList instance
         */
        ADVKeyIndexList.create = function create(properties) {
            return new ADVKeyIndexList(properties);
        };

        /**
         * Encodes the specified ADVKeyIndexList message. Does not implicitly {@link proto.ADVKeyIndexList.verify|verify} messages.
         * @function encode
         * @memberof proto.ADVKeyIndexList
         * @static
         * @param {proto.IADVKeyIndexList} message ADVKeyIndexList message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVKeyIndexList.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.rawId != null && Object.hasOwnProperty.call(message, "rawId"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.rawId);
            if (message.timestamp != null && Object.hasOwnProperty.call(message, "timestamp"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint64(message.timestamp);
            if (message.currentIndex != null && Object.hasOwnProperty.call(message, "currentIndex"))
                writer.uint32(/* id 3, wireType 0 =*/24).uint32(message.currentIndex);
            if (message.validIndexes != null && message.validIndexes.length) {
                writer.uint32(/* id 4, wireType 2 =*/34).fork();
                for (var i = 0; i < message.validIndexes.length; ++i)
                    writer.uint32(message.validIndexes[i]);
                writer.ldelim();
            }
            return writer;
        };

        /**
         * Encodes the specified ADVKeyIndexList message, length delimited. Does not implicitly {@link proto.ADVKeyIndexList.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ADVKeyIndexList
         * @static
         * @param {proto.IADVKeyIndexList} message ADVKeyIndexList message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVKeyIndexList.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ADVKeyIndexList message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ADVKeyIndexList
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ADVKeyIndexList} ADVKeyIndexList
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVKeyIndexList.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ADVKeyIndexList();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.rawId = reader.uint32();
                    break;
                case 2:
                    message.timestamp = reader.uint64();
                    break;
                case 3:
                    message.currentIndex = reader.uint32();
                    break;
                case 4:
                    if (!(message.validIndexes && message.validIndexes.length))
                        message.validIndexes = [];
                    if ((tag & 7) === 2) {
                        var end2 = reader.uint32() + reader.pos;
                        while (reader.pos < end2)
                            message.validIndexes.push(reader.uint32());
                    } else
                        message.validIndexes.push(reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ADVKeyIndexList message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ADVKeyIndexList
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ADVKeyIndexList} ADVKeyIndexList
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVKeyIndexList.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ADVKeyIndexList message.
         * @function verify
         * @memberof proto.ADVKeyIndexList
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ADVKeyIndexList.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.rawId != null && message.hasOwnProperty("rawId"))
                if (!$util.isInteger(message.rawId))
                    return "rawId: integer expected";
            if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                if (!$util.isInteger(message.timestamp) && !(message.timestamp && $util.isInteger(message.timestamp.low) && $util.isInteger(message.timestamp.high)))
                    return "timestamp: integer|Long expected";
            if (message.currentIndex != null && message.hasOwnProperty("currentIndex"))
                if (!$util.isInteger(message.currentIndex))
                    return "currentIndex: integer expected";
            if (message.validIndexes != null && message.hasOwnProperty("validIndexes")) {
                if (!Array.isArray(message.validIndexes))
                    return "validIndexes: array expected";
                for (var i = 0; i < message.validIndexes.length; ++i)
                    if (!$util.isInteger(message.validIndexes[i]))
                        return "validIndexes: integer[] expected";
            }
            return null;
        };

        /**
         * Creates a ADVKeyIndexList message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ADVKeyIndexList
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ADVKeyIndexList} ADVKeyIndexList
         */
        ADVKeyIndexList.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ADVKeyIndexList)
                return object;
            var message = new $root.proto.ADVKeyIndexList();
            if (object.rawId != null)
                message.rawId = object.rawId >>> 0;
            if (object.timestamp != null)
                if ($util.Long)
                    (message.timestamp = $util.Long.fromValue(object.timestamp)).unsigned = true;
                else if (typeof object.timestamp === "string")
                    message.timestamp = parseInt(object.timestamp, 10);
                else if (typeof object.timestamp === "number")
                    message.timestamp = object.timestamp;
                else if (typeof object.timestamp === "object")
                    message.timestamp = new $util.LongBits(object.timestamp.low >>> 0, object.timestamp.high >>> 0).toNumber(true);
            if (object.currentIndex != null)
                message.currentIndex = object.currentIndex >>> 0;
            if (object.validIndexes) {
                if (!Array.isArray(object.validIndexes))
                    throw TypeError(".proto.ADVKeyIndexList.validIndexes: array expected");
                message.validIndexes = [];
                for (var i = 0; i < object.validIndexes.length; ++i)
                    message.validIndexes[i] = object.validIndexes[i] >>> 0;
            }
            return message;
        };

        /**
         * Creates a plain object from a ADVKeyIndexList message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ADVKeyIndexList
         * @static
         * @param {proto.ADVKeyIndexList} message ADVKeyIndexList
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ADVKeyIndexList.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.validIndexes = [];
            if (options.defaults) {
                object.rawId = 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.timestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.timestamp = options.longs === String ? "0" : 0;
                object.currentIndex = 0;
            }
            if (message.rawId != null && message.hasOwnProperty("rawId"))
                object.rawId = message.rawId;
            if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                if (typeof message.timestamp === "number")
                    object.timestamp = options.longs === String ? String(message.timestamp) : message.timestamp;
                else
                    object.timestamp = options.longs === String ? $util.Long.prototype.toString.call(message.timestamp) : options.longs === Number ? new $util.LongBits(message.timestamp.low >>> 0, message.timestamp.high >>> 0).toNumber(true) : message.timestamp;
            if (message.currentIndex != null && message.hasOwnProperty("currentIndex"))
                object.currentIndex = message.currentIndex;
            if (message.validIndexes && message.validIndexes.length) {
                object.validIndexes = [];
                for (var j = 0; j < message.validIndexes.length; ++j)
                    object.validIndexes[j] = message.validIndexes[j];
            }
            return object;
        };

        /**
         * Converts this ADVKeyIndexList to JSON.
         * @function toJSON
         * @memberof proto.ADVKeyIndexList
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ADVKeyIndexList.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ADVKeyIndexList;
    })();

    proto.ADVSignedDeviceIdentity = (function() {

        /**
         * Properties of a ADVSignedDeviceIdentity.
         * @memberof proto
         * @interface IADVSignedDeviceIdentity
         * @property {Uint8Array|null} [details] ADVSignedDeviceIdentity details
         * @property {Uint8Array|null} [accountSignatureKey] ADVSignedDeviceIdentity accountSignatureKey
         * @property {Uint8Array|null} [accountSignature] ADVSignedDeviceIdentity accountSignature
         * @property {Uint8Array|null} [deviceSignature] ADVSignedDeviceIdentity deviceSignature
         */

        /**
         * Constructs a new ADVSignedDeviceIdentity.
         * @memberof proto
         * @classdesc Represents a ADVSignedDeviceIdentity.
         * @implements IADVSignedDeviceIdentity
         * @constructor
         * @param {proto.IADVSignedDeviceIdentity=} [properties] Properties to set
         */
        function ADVSignedDeviceIdentity(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ADVSignedDeviceIdentity details.
         * @member {Uint8Array} details
         * @memberof proto.ADVSignedDeviceIdentity
         * @instance
         */
        ADVSignedDeviceIdentity.prototype.details = $util.newBuffer([]);

        /**
         * ADVSignedDeviceIdentity accountSignatureKey.
         * @member {Uint8Array} accountSignatureKey
         * @memberof proto.ADVSignedDeviceIdentity
         * @instance
         */
        ADVSignedDeviceIdentity.prototype.accountSignatureKey = $util.newBuffer([]);

        /**
         * ADVSignedDeviceIdentity accountSignature.
         * @member {Uint8Array} accountSignature
         * @memberof proto.ADVSignedDeviceIdentity
         * @instance
         */
        ADVSignedDeviceIdentity.prototype.accountSignature = $util.newBuffer([]);

        /**
         * ADVSignedDeviceIdentity deviceSignature.
         * @member {Uint8Array} deviceSignature
         * @memberof proto.ADVSignedDeviceIdentity
         * @instance
         */
        ADVSignedDeviceIdentity.prototype.deviceSignature = $util.newBuffer([]);

        /**
         * Creates a new ADVSignedDeviceIdentity instance using the specified properties.
         * @function create
         * @memberof proto.ADVSignedDeviceIdentity
         * @static
         * @param {proto.IADVSignedDeviceIdentity=} [properties] Properties to set
         * @returns {proto.ADVSignedDeviceIdentity} ADVSignedDeviceIdentity instance
         */
        ADVSignedDeviceIdentity.create = function create(properties) {
            return new ADVSignedDeviceIdentity(properties);
        };

        /**
         * Encodes the specified ADVSignedDeviceIdentity message. Does not implicitly {@link proto.ADVSignedDeviceIdentity.verify|verify} messages.
         * @function encode
         * @memberof proto.ADVSignedDeviceIdentity
         * @static
         * @param {proto.IADVSignedDeviceIdentity} message ADVSignedDeviceIdentity message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVSignedDeviceIdentity.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.details != null && Object.hasOwnProperty.call(message, "details"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.details);
            if (message.accountSignatureKey != null && Object.hasOwnProperty.call(message, "accountSignatureKey"))
                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.accountSignatureKey);
            if (message.accountSignature != null && Object.hasOwnProperty.call(message, "accountSignature"))
                writer.uint32(/* id 3, wireType 2 =*/26).bytes(message.accountSignature);
            if (message.deviceSignature != null && Object.hasOwnProperty.call(message, "deviceSignature"))
                writer.uint32(/* id 4, wireType 2 =*/34).bytes(message.deviceSignature);
            return writer;
        };

        /**
         * Encodes the specified ADVSignedDeviceIdentity message, length delimited. Does not implicitly {@link proto.ADVSignedDeviceIdentity.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ADVSignedDeviceIdentity
         * @static
         * @param {proto.IADVSignedDeviceIdentity} message ADVSignedDeviceIdentity message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVSignedDeviceIdentity.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ADVSignedDeviceIdentity message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ADVSignedDeviceIdentity
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ADVSignedDeviceIdentity} ADVSignedDeviceIdentity
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVSignedDeviceIdentity.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ADVSignedDeviceIdentity();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.details = reader.bytes();
                    break;
                case 2:
                    message.accountSignatureKey = reader.bytes();
                    break;
                case 3:
                    message.accountSignature = reader.bytes();
                    break;
                case 4:
                    message.deviceSignature = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ADVSignedDeviceIdentity message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ADVSignedDeviceIdentity
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ADVSignedDeviceIdentity} ADVSignedDeviceIdentity
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVSignedDeviceIdentity.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ADVSignedDeviceIdentity message.
         * @function verify
         * @memberof proto.ADVSignedDeviceIdentity
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ADVSignedDeviceIdentity.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.details != null && message.hasOwnProperty("details"))
                if (!(message.details && typeof message.details.length === "number" || $util.isString(message.details)))
                    return "details: buffer expected";
            if (message.accountSignatureKey != null && message.hasOwnProperty("accountSignatureKey"))
                if (!(message.accountSignatureKey && typeof message.accountSignatureKey.length === "number" || $util.isString(message.accountSignatureKey)))
                    return "accountSignatureKey: buffer expected";
            if (message.accountSignature != null && message.hasOwnProperty("accountSignature"))
                if (!(message.accountSignature && typeof message.accountSignature.length === "number" || $util.isString(message.accountSignature)))
                    return "accountSignature: buffer expected";
            if (message.deviceSignature != null && message.hasOwnProperty("deviceSignature"))
                if (!(message.deviceSignature && typeof message.deviceSignature.length === "number" || $util.isString(message.deviceSignature)))
                    return "deviceSignature: buffer expected";
            return null;
        };

        /**
         * Creates a ADVSignedDeviceIdentity message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ADVSignedDeviceIdentity
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ADVSignedDeviceIdentity} ADVSignedDeviceIdentity
         */
        ADVSignedDeviceIdentity.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ADVSignedDeviceIdentity)
                return object;
            var message = new $root.proto.ADVSignedDeviceIdentity();
            if (object.details != null)
                if (typeof object.details === "string")
                    $util.base64.decode(object.details, message.details = $util.newBuffer($util.base64.length(object.details)), 0);
                else if (object.details.length)
                    message.details = object.details;
            if (object.accountSignatureKey != null)
                if (typeof object.accountSignatureKey === "string")
                    $util.base64.decode(object.accountSignatureKey, message.accountSignatureKey = $util.newBuffer($util.base64.length(object.accountSignatureKey)), 0);
                else if (object.accountSignatureKey.length)
                    message.accountSignatureKey = object.accountSignatureKey;
            if (object.accountSignature != null)
                if (typeof object.accountSignature === "string")
                    $util.base64.decode(object.accountSignature, message.accountSignature = $util.newBuffer($util.base64.length(object.accountSignature)), 0);
                else if (object.accountSignature.length)
                    message.accountSignature = object.accountSignature;
            if (object.deviceSignature != null)
                if (typeof object.deviceSignature === "string")
                    $util.base64.decode(object.deviceSignature, message.deviceSignature = $util.newBuffer($util.base64.length(object.deviceSignature)), 0);
                else if (object.deviceSignature.length)
                    message.deviceSignature = object.deviceSignature;
            return message;
        };

        /**
         * Creates a plain object from a ADVSignedDeviceIdentity message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ADVSignedDeviceIdentity
         * @static
         * @param {proto.ADVSignedDeviceIdentity} message ADVSignedDeviceIdentity
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ADVSignedDeviceIdentity.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if (options.bytes === String)
                    object.details = "";
                else {
                    object.details = [];
                    if (options.bytes !== Array)
                        object.details = $util.newBuffer(object.details);
                }
                if (options.bytes === String)
                    object.accountSignatureKey = "";
                else {
                    object.accountSignatureKey = [];
                    if (options.bytes !== Array)
                        object.accountSignatureKey = $util.newBuffer(object.accountSignatureKey);
                }
                if (options.bytes === String)
                    object.accountSignature = "";
                else {
                    object.accountSignature = [];
                    if (options.bytes !== Array)
                        object.accountSignature = $util.newBuffer(object.accountSignature);
                }
                if (options.bytes === String)
                    object.deviceSignature = "";
                else {
                    object.deviceSignature = [];
                    if (options.bytes !== Array)
                        object.deviceSignature = $util.newBuffer(object.deviceSignature);
                }
            }
            if (message.details != null && message.hasOwnProperty("details"))
                object.details = options.bytes === String ? $util.base64.encode(message.details, 0, message.details.length) : options.bytes === Array ? Array.prototype.slice.call(message.details) : message.details;
            if (message.accountSignatureKey != null && message.hasOwnProperty("accountSignatureKey"))
                object.accountSignatureKey = options.bytes === String ? $util.base64.encode(message.accountSignatureKey, 0, message.accountSignatureKey.length) : options.bytes === Array ? Array.prototype.slice.call(message.accountSignatureKey) : message.accountSignatureKey;
            if (message.accountSignature != null && message.hasOwnProperty("accountSignature"))
                object.accountSignature = options.bytes === String ? $util.base64.encode(message.accountSignature, 0, message.accountSignature.length) : options.bytes === Array ? Array.prototype.slice.call(message.accountSignature) : message.accountSignature;
            if (message.deviceSignature != null && message.hasOwnProperty("deviceSignature"))
                object.deviceSignature = options.bytes === String ? $util.base64.encode(message.deviceSignature, 0, message.deviceSignature.length) : options.bytes === Array ? Array.prototype.slice.call(message.deviceSignature) : message.deviceSignature;
            return object;
        };

        /**
         * Converts this ADVSignedDeviceIdentity to JSON.
         * @function toJSON
         * @memberof proto.ADVSignedDeviceIdentity
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ADVSignedDeviceIdentity.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ADVSignedDeviceIdentity;
    })();

    proto.ADVSignedDeviceIdentityHMAC = (function() {

        /**
         * Properties of a ADVSignedDeviceIdentityHMAC.
         * @memberof proto
         * @interface IADVSignedDeviceIdentityHMAC
         * @property {Uint8Array|null} [details] ADVSignedDeviceIdentityHMAC details
         * @property {Uint8Array|null} [hmac] ADVSignedDeviceIdentityHMAC hmac
         */

        /**
         * Constructs a new ADVSignedDeviceIdentityHMAC.
         * @memberof proto
         * @classdesc Represents a ADVSignedDeviceIdentityHMAC.
         * @implements IADVSignedDeviceIdentityHMAC
         * @constructor
         * @param {proto.IADVSignedDeviceIdentityHMAC=} [properties] Properties to set
         */
        function ADVSignedDeviceIdentityHMAC(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ADVSignedDeviceIdentityHMAC details.
         * @member {Uint8Array} details
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @instance
         */
        ADVSignedDeviceIdentityHMAC.prototype.details = $util.newBuffer([]);

        /**
         * ADVSignedDeviceIdentityHMAC hmac.
         * @member {Uint8Array} hmac
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @instance
         */
        ADVSignedDeviceIdentityHMAC.prototype.hmac = $util.newBuffer([]);

        /**
         * Creates a new ADVSignedDeviceIdentityHMAC instance using the specified properties.
         * @function create
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @static
         * @param {proto.IADVSignedDeviceIdentityHMAC=} [properties] Properties to set
         * @returns {proto.ADVSignedDeviceIdentityHMAC} ADVSignedDeviceIdentityHMAC instance
         */
        ADVSignedDeviceIdentityHMAC.create = function create(properties) {
            return new ADVSignedDeviceIdentityHMAC(properties);
        };

        /**
         * Encodes the specified ADVSignedDeviceIdentityHMAC message. Does not implicitly {@link proto.ADVSignedDeviceIdentityHMAC.verify|verify} messages.
         * @function encode
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @static
         * @param {proto.IADVSignedDeviceIdentityHMAC} message ADVSignedDeviceIdentityHMAC message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVSignedDeviceIdentityHMAC.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.details != null && Object.hasOwnProperty.call(message, "details"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.details);
            if (message.hmac != null && Object.hasOwnProperty.call(message, "hmac"))
                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.hmac);
            return writer;
        };

        /**
         * Encodes the specified ADVSignedDeviceIdentityHMAC message, length delimited. Does not implicitly {@link proto.ADVSignedDeviceIdentityHMAC.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @static
         * @param {proto.IADVSignedDeviceIdentityHMAC} message ADVSignedDeviceIdentityHMAC message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVSignedDeviceIdentityHMAC.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ADVSignedDeviceIdentityHMAC message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ADVSignedDeviceIdentityHMAC} ADVSignedDeviceIdentityHMAC
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVSignedDeviceIdentityHMAC.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ADVSignedDeviceIdentityHMAC();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.details = reader.bytes();
                    break;
                case 2:
                    message.hmac = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ADVSignedDeviceIdentityHMAC message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ADVSignedDeviceIdentityHMAC} ADVSignedDeviceIdentityHMAC
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVSignedDeviceIdentityHMAC.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ADVSignedDeviceIdentityHMAC message.
         * @function verify
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ADVSignedDeviceIdentityHMAC.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.details != null && message.hasOwnProperty("details"))
                if (!(message.details && typeof message.details.length === "number" || $util.isString(message.details)))
                    return "details: buffer expected";
            if (message.hmac != null && message.hasOwnProperty("hmac"))
                if (!(message.hmac && typeof message.hmac.length === "number" || $util.isString(message.hmac)))
                    return "hmac: buffer expected";
            return null;
        };

        /**
         * Creates a ADVSignedDeviceIdentityHMAC message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ADVSignedDeviceIdentityHMAC} ADVSignedDeviceIdentityHMAC
         */
        ADVSignedDeviceIdentityHMAC.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ADVSignedDeviceIdentityHMAC)
                return object;
            var message = new $root.proto.ADVSignedDeviceIdentityHMAC();
            if (object.details != null)
                if (typeof object.details === "string")
                    $util.base64.decode(object.details, message.details = $util.newBuffer($util.base64.length(object.details)), 0);
                else if (object.details.length)
                    message.details = object.details;
            if (object.hmac != null)
                if (typeof object.hmac === "string")
                    $util.base64.decode(object.hmac, message.hmac = $util.newBuffer($util.base64.length(object.hmac)), 0);
                else if (object.hmac.length)
                    message.hmac = object.hmac;
            return message;
        };

        /**
         * Creates a plain object from a ADVSignedDeviceIdentityHMAC message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @static
         * @param {proto.ADVSignedDeviceIdentityHMAC} message ADVSignedDeviceIdentityHMAC
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ADVSignedDeviceIdentityHMAC.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if (options.bytes === String)
                    object.details = "";
                else {
                    object.details = [];
                    if (options.bytes !== Array)
                        object.details = $util.newBuffer(object.details);
                }
                if (options.bytes === String)
                    object.hmac = "";
                else {
                    object.hmac = [];
                    if (options.bytes !== Array)
                        object.hmac = $util.newBuffer(object.hmac);
                }
            }
            if (message.details != null && message.hasOwnProperty("details"))
                object.details = options.bytes === String ? $util.base64.encode(message.details, 0, message.details.length) : options.bytes === Array ? Array.prototype.slice.call(message.details) : message.details;
            if (message.hmac != null && message.hasOwnProperty("hmac"))
                object.hmac = options.bytes === String ? $util.base64.encode(message.hmac, 0, message.hmac.length) : options.bytes === Array ? Array.prototype.slice.call(message.hmac) : message.hmac;
            return object;
        };

        /**
         * Converts this ADVSignedDeviceIdentityHMAC to JSON.
         * @function toJSON
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ADVSignedDeviceIdentityHMAC.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ADVSignedDeviceIdentityHMAC;
    })();

    proto.ADVSignedKeyIndexList = (function() {

        /**
         * Properties of a ADVSignedKeyIndexList.
         * @memberof proto
         * @interface IADVSignedKeyIndexList
         * @property {Uint8Array|null} [details] ADVSignedKeyIndexList details
         * @property {Uint8Array|null} [accountSignature] ADVSignedKeyIndexList accountSignature
         */

        /**
         * Constructs a new ADVSignedKeyIndexList.
         * @memberof proto
         * @classdesc Represents a ADVSignedKeyIndexList.
         * @implements IADVSignedKeyIndexList
         * @constructor
         * @param {proto.IADVSignedKeyIndexList=} [properties] Properties to set
         */
        function ADVSignedKeyIndexList(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ADVSignedKeyIndexList details.
         * @member {Uint8Array} details
         * @memberof proto.ADVSignedKeyIndexList
         * @instance
         */
        ADVSignedKeyIndexList.prototype.details = $util.newBuffer([]);

        /**
         * ADVSignedKeyIndexList accountSignature.
         * @member {Uint8Array} accountSignature
         * @memberof proto.ADVSignedKeyIndexList
         * @instance
         */
        ADVSignedKeyIndexList.prototype.accountSignature = $util.newBuffer([]);

        /**
         * Creates a new ADVSignedKeyIndexList instance using the specified properties.
         * @function create
         * @memberof proto.ADVSignedKeyIndexList
         * @static
         * @param {proto.IADVSignedKeyIndexList=} [properties] Properties to set
         * @returns {proto.ADVSignedKeyIndexList} ADVSignedKeyIndexList instance
         */
        ADVSignedKeyIndexList.create = function create(properties) {
            return new ADVSignedKeyIndexList(properties);
        };

        /**
         * Encodes the specified ADVSignedKeyIndexList message. Does not implicitly {@link proto.ADVSignedKeyIndexList.verify|verify} messages.
         * @function encode
         * @memberof proto.ADVSignedKeyIndexList
         * @static
         * @param {proto.IADVSignedKeyIndexList} message ADVSignedKeyIndexList message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVSignedKeyIndexList.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.details != null && Object.hasOwnProperty.call(message, "details"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.details);
            if (message.accountSignature != null && Object.hasOwnProperty.call(message, "accountSignature"))
                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.accountSignature);
            return writer;
        };

        /**
         * Encodes the specified ADVSignedKeyIndexList message, length delimited. Does not implicitly {@link proto.ADVSignedKeyIndexList.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ADVSignedKeyIndexList
         * @static
         * @param {proto.IADVSignedKeyIndexList} message ADVSignedKeyIndexList message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVSignedKeyIndexList.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ADVSignedKeyIndexList message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ADVSignedKeyIndexList
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ADVSignedKeyIndexList} ADVSignedKeyIndexList
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVSignedKeyIndexList.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ADVSignedKeyIndexList();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.details = reader.bytes();
                    break;
                case 2:
                    message.accountSignature = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ADVSignedKeyIndexList message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ADVSignedKeyIndexList
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ADVSignedKeyIndexList} ADVSignedKeyIndexList
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVSignedKeyIndexList.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ADVSignedKeyIndexList message.
         * @function verify
         * @memberof proto.ADVSignedKeyIndexList
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ADVSignedKeyIndexList.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.details != null && message.hasOwnProperty("details"))
                if (!(message.details && typeof message.details.length === "number" || $util.isString(message.details)))
                    return "details: buffer expected";
            if (message.accountSignature != null && message.hasOwnProperty("accountSignature"))
                if (!(message.accountSignature && typeof message.accountSignature.length === "number" || $util.isString(message.accountSignature)))
                    return "accountSignature: buffer expected";
            return null;
        };

        /**
         * Creates a ADVSignedKeyIndexList message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ADVSignedKeyIndexList
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ADVSignedKeyIndexList} ADVSignedKeyIndexList
         */
        ADVSignedKeyIndexList.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ADVSignedKeyIndexList)
                return object;
            var message = new $root.proto.ADVSignedKeyIndexList();
            if (object.details != null)
                if (typeof object.details === "string")
                    $util.base64.decode(object.details, message.details = $util.newBuffer($util.base64.length(object.details)), 0);
                else if (object.details.length)
                    message.details = object.details;
            if (object.accountSignature != null)
                if (typeof object.accountSignature === "string")
                    $util.base64.decode(object.accountSignature, message.accountSignature = $util.newBuffer($util.base64.length(object.accountSignature)), 0);
                else if (object.accountSignature.length)
                    message.accountSignature = object.accountSignature;
            return message;
        };

        /**
         * Creates a plain object from a ADVSignedKeyIndexList message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ADVSignedKeyIndexList
         * @static
         * @param {proto.ADVSignedKeyIndexList} message ADVSignedKeyIndexList
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ADVSignedKeyIndexList.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if (options.bytes === String)
                    object.details = "";
                else {
                    object.details = [];
                    if (options.bytes !== Array)
                        object.details = $util.newBuffer(object.details);
                }
                if (options.bytes === String)
                    object.accountSignature = "";
                else {
                    object.accountSignature = [];
                    if (options.bytes !== Array)
                        object.accountSignature = $util.newBuffer(object.accountSignature);
                }
            }
            if (message.details != null && message.hasOwnProperty("details"))
                object.details = options.bytes === String ? $util.base64.encode(message.details, 0, message.details.length) : options.bytes === Array ? Array.prototype.slice.call(message.details) : message.details;
            if (message.accountSignature != null && message.hasOwnProperty("accountSignature"))
                object.accountSignature = options.bytes === String ? $util.base64.encode(message.accountSignature, 0, message.accountSignature.length) : options.bytes === Array ? Array.prototype.slice.call(message.accountSignature) : message.accountSignature;
            return object;
        };

        /**
         * Converts this ADVSignedKeyIndexList to JSON.
         * @function toJSON
         * @memberof proto.ADVSignedKeyIndexList
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ADVSignedKeyIndexList.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ADVSignedKeyIndexList;
    })();

    proto.AppVersion = (function() {

        /**
         * Properties of an AppVersion.
         * @memberof proto
         * @interface IAppVersion
         * @property {number|null} [primary] AppVersion primary
         * @property {number|null} [secondary] AppVersion secondary
         * @property {number|null} [tertiary] AppVersion tertiary
         * @property {number|null} [quaternary] AppVersion quaternary
         * @property {number|null} [quinary] AppVersion quinary
         */

        /**
         * Constructs a new AppVersion.
         * @memberof proto
         * @classdesc Represents an AppVersion.
         * @implements IAppVersion
         * @constructor
         * @param {proto.IAppVersion=} [properties] Properties to set
         */
        function AppVersion(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * AppVersion primary.
         * @member {number} primary
         * @memberof proto.AppVersion
         * @instance
         */
        AppVersion.prototype.primary = 0;

        /**
         * AppVersion secondary.
         * @member {number} secondary
         * @memberof proto.AppVersion
         * @instance
         */
        AppVersion.prototype.secondary = 0;

        /**
         * AppVersion tertiary.
         * @member {number} tertiary
         * @memberof proto.AppVersion
         * @instance
         */
        AppVersion.prototype.tertiary = 0;

        /**
         * AppVersion quaternary.
         * @member {number} quaternary
         * @memberof proto.AppVersion
         * @instance
         */
        AppVersion.prototype.quaternary = 0;

        /**
         * AppVersion quinary.
         * @member {number} quinary
         * @memberof proto.AppVersion
         * @instance
         */
        AppVersion.prototype.quinary = 0;

        /**
         * Creates a new AppVersion instance using the specified properties.
         * @function create
         * @memberof proto.AppVersion
         * @static
         * @param {proto.IAppVersion=} [properties] Properties to set
         * @returns {proto.AppVersion} AppVersion instance
         */
        AppVersion.create = function create(properties) {
            return new AppVersion(properties);
        };

        /**
         * Encodes the specified AppVersion message. Does not implicitly {@link proto.AppVersion.verify|verify} messages.
         * @function encode
         * @memberof proto.AppVersion
         * @static
         * @param {proto.IAppVersion} message AppVersion message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AppVersion.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.primary != null && Object.hasOwnProperty.call(message, "primary"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.primary);
            if (message.secondary != null && Object.hasOwnProperty.call(message, "secondary"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint32(message.secondary);
            if (message.tertiary != null && Object.hasOwnProperty.call(message, "tertiary"))
                writer.uint32(/* id 3, wireType 0 =*/24).uint32(message.tertiary);
            if (message.quaternary != null && Object.hasOwnProperty.call(message, "quaternary"))
                writer.uint32(/* id 4, wireType 0 =*/32).uint32(message.quaternary);
            if (message.quinary != null && Object.hasOwnProperty.call(message, "quinary"))
                writer.uint32(/* id 5, wireType 0 =*/40).uint32(message.quinary);
            return writer;
        };

        /**
         * Encodes the specified AppVersion message, length delimited. Does not implicitly {@link proto.AppVersion.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.AppVersion
         * @static
         * @param {proto.IAppVersion} message AppVersion message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AppVersion.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an AppVersion message from the specified reader or buffer.
         * @function decode
         * @memberof proto.AppVersion
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.AppVersion} AppVersion
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AppVersion.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AppVersion();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.primary = reader.uint32();
                    break;
                case 2:
                    message.secondary = reader.uint32();
                    break;
                case 3:
                    message.tertiary = reader.uint32();
                    break;
                case 4:
                    message.quaternary = reader.uint32();
                    break;
                case 5:
                    message.quinary = reader.uint32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an AppVersion message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.AppVersion
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.AppVersion} AppVersion
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AppVersion.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an AppVersion message.
         * @function verify
         * @memberof proto.AppVersion
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        AppVersion.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.primary != null && message.hasOwnProperty("primary"))
                if (!$util.isInteger(message.primary))
                    return "primary: integer expected";
            if (message.secondary != null && message.hasOwnProperty("secondary"))
                if (!$util.isInteger(message.secondary))
                    return "secondary: integer expected";
            if (message.tertiary != null && message.hasOwnProperty("tertiary"))
                if (!$util.isInteger(message.tertiary))
                    return "tertiary: integer expected";
            if (message.quaternary != null && message.hasOwnProperty("quaternary"))
                if (!$util.isInteger(message.quaternary))
                    return "quaternary: integer expected";
            if (message.quinary != null && message.hasOwnProperty("quinary"))
                if (!$util.isInteger(message.quinary))
                    return "quinary: integer expected";
            return null;
        };

        /**
         * Creates an AppVersion message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.AppVersion
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.AppVersion} AppVersion
         */
        AppVersion.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.AppVersion)
                return object;
            var message = new $root.proto.AppVersion();
            if (object.primary != null)
                message.primary = object.primary >>> 0;
            if (object.secondary != null)
                message.secondary = object.secondary >>> 0;
            if (object.tertiary != null)
                message.tertiary = object.tertiary >>> 0;
            if (object.quaternary != null)
                message.quaternary = object.quaternary >>> 0;
            if (object.quinary != null)
                message.quinary = object.quinary >>> 0;
            return message;
        };

        /**
         * Creates a plain object from an AppVersion message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.AppVersion
         * @static
         * @param {proto.AppVersion} message AppVersion
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        AppVersion.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.primary = 0;
                object.secondary = 0;
                object.tertiary = 0;
                object.quaternary = 0;
                object.quinary = 0;
            }
            if (message.primary != null && message.hasOwnProperty("primary"))
                object.primary = message.primary;
            if (message.secondary != null && message.hasOwnProperty("secondary"))
                object.secondary = message.secondary;
            if (message.tertiary != null && message.hasOwnProperty("tertiary"))
                object.tertiary = message.tertiary;
            if (message.quaternary != null && message.hasOwnProperty("quaternary"))
                object.quaternary = message.quaternary;
            if (message.quinary != null && message.hasOwnProperty("quinary"))
                object.quinary = message.quinary;
            return object;
        };

        /**
         * Converts this AppVersion to JSON.
         * @function toJSON
         * @memberof proto.AppVersion
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        AppVersion.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return AppVersion;
    })();

    proto.CompanionProps = (function() {

        /**
         * Properties of a CompanionProps.
         * @memberof proto
         * @interface ICompanionProps
         * @property {string|null} [os] CompanionProps os
         * @property {proto.IAppVersion|null} [version] CompanionProps version
         * @property {proto.CompanionProps.CompanionPropsPlatformType|null} [platformType] CompanionProps platformType
         * @property {boolean|null} [requireFullSync] CompanionProps requireFullSync
         */

        /**
         * Constructs a new CompanionProps.
         * @memberof proto
         * @classdesc Represents a CompanionProps.
         * @implements ICompanionProps
         * @constructor
         * @param {proto.ICompanionProps=} [properties] Properties to set
         */
        function CompanionProps(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * CompanionProps os.
         * @member {string} os
         * @memberof proto.CompanionProps
         * @instance
         */
        CompanionProps.prototype.os = "";

        /**
         * CompanionProps version.
         * @member {proto.IAppVersion|null|undefined} version
         * @memberof proto.CompanionProps
         * @instance
         */
        CompanionProps.prototype.version = null;

        /**
         * CompanionProps platformType.
         * @member {proto.CompanionProps.CompanionPropsPlatformType} platformType
         * @memberof proto.CompanionProps
         * @instance
         */
        CompanionProps.prototype.platformType = 0;

        /**
         * CompanionProps requireFullSync.
         * @member {boolean} requireFullSync
         * @memberof proto.CompanionProps
         * @instance
         */
        CompanionProps.prototype.requireFullSync = false;

        /**
         * Creates a new CompanionProps instance using the specified properties.
         * @function create
         * @memberof proto.CompanionProps
         * @static
         * @param {proto.ICompanionProps=} [properties] Properties to set
         * @returns {proto.CompanionProps} CompanionProps instance
         */
        CompanionProps.create = function create(properties) {
            return new CompanionProps(properties);
        };

        /**
         * Encodes the specified CompanionProps message. Does not implicitly {@link proto.CompanionProps.verify|verify} messages.
         * @function encode
         * @memberof proto.CompanionProps
         * @static
         * @param {proto.ICompanionProps} message CompanionProps message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CompanionProps.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.os != null && Object.hasOwnProperty.call(message, "os"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.os);
            if (message.version != null && Object.hasOwnProperty.call(message, "version"))
                $root.proto.AppVersion.encode(message.version, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.platformType != null && Object.hasOwnProperty.call(message, "platformType"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.platformType);
            if (message.requireFullSync != null && Object.hasOwnProperty.call(message, "requireFullSync"))
                writer.uint32(/* id 4, wireType 0 =*/32).bool(message.requireFullSync);
            return writer;
        };

        /**
         * Encodes the specified CompanionProps message, length delimited. Does not implicitly {@link proto.CompanionProps.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.CompanionProps
         * @static
         * @param {proto.ICompanionProps} message CompanionProps message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CompanionProps.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a CompanionProps message from the specified reader or buffer.
         * @function decode
         * @memberof proto.CompanionProps
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.CompanionProps} CompanionProps
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CompanionProps.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.CompanionProps();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.os = reader.string();
                    break;
                case 2:
                    message.version = $root.proto.AppVersion.decode(reader, reader.uint32());
                    break;
                case 3:
                    message.platformType = reader.int32();
                    break;
                case 4:
                    message.requireFullSync = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a CompanionProps message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.CompanionProps
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.CompanionProps} CompanionProps
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CompanionProps.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a CompanionProps message.
         * @function verify
         * @memberof proto.CompanionProps
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        CompanionProps.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.os != null && message.hasOwnProperty("os"))
                if (!$util.isString(message.os))
                    return "os: string expected";
            if (message.version != null && message.hasOwnProperty("version")) {
                var error = $root.proto.AppVersion.verify(message.version);
                if (error)
                    return "version." + error;
            }
            if (message.platformType != null && message.hasOwnProperty("platformType"))
                switch (message.platformType) {
                default:
                    return "platformType: enum value expected";
                case 0:
                case 1:
                case 2:
                case 3:
                case 4:
                case 5:
                case 6:
                case 7:
                case 8:
                case 9:
                case 10:
                case 11:
                case 12:
                case 13:
                    break;
                }
            if (message.requireFullSync != null && message.hasOwnProperty("requireFullSync"))
                if (typeof message.requireFullSync !== "boolean")
                    return "requireFullSync: boolean expected";
            return null;
        };

        /**
         * Creates a CompanionProps message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.CompanionProps
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.CompanionProps} CompanionProps
         */
        CompanionProps.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.CompanionProps)
                return object;
            var message = new $root.proto.CompanionProps();
            if (object.os != null)
                message.os = String(object.os);
            if (object.version != null) {
                if (typeof object.version !== "object")
                    throw TypeError(".proto.CompanionProps.version: object expected");
                message.version = $root.proto.AppVersion.fromObject(object.version);
            }
            switch (object.platformType) {
            case "UNKNOWN":
            case 0:
                message.platformType = 0;
                break;
            case "CHROME":
            case 1:
                message.platformType = 1;
                break;
            case "FIREFOX":
            case 2:
                message.platformType = 2;
                break;
            case "IE":
            case 3:
                message.platformType = 3;
                break;
            case "OPERA":
            case 4:
                message.platformType = 4;
                break;
            case "SAFARI":
            case 5:
                message.platformType = 5;
                break;
            case "EDGE":
            case 6:
                message.platformType = 6;
                break;
            case "DESKTOP":
            case 7:
                message.platformType = 7;
                break;
            case "IPAD":
            case 8:
                message.platformType = 8;
                break;
            case "ANDROID_TABLET":
            case 9:
                message.platformType = 9;
                break;
            case "OHANA":
            case 10:
                message.platformType = 10;
                break;
            case "ALOHA":
            case 11:
                message.platformType = 11;
                break;
            case "CATALINA":
            case 12:
                message.platformType = 12;
                break;
            case "TCL_TV":
            case 13:
                message.platformType = 13;
                break;
            }
            if (object.requireFullSync != null)
                message.requireFullSync = Boolean(object.requireFullSync);
            return message;
        };

        /**
         * Creates a plain object from a CompanionProps message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.CompanionProps
         * @static
         * @param {proto.CompanionProps} message CompanionProps
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        CompanionProps.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.os = "";
                object.version = null;
                object.platformType = options.enums === String ? "UNKNOWN" : 0;
                object.requireFullSync = false;
            }
            if (message.os != null && message.hasOwnProperty("os"))
                object.os = message.os;
            if (message.version != null && message.hasOwnProperty("version"))
                object.version = $root.proto.AppVersion.toObject(message.version, options);
            if (message.platformType != null && message.hasOwnProperty("platformType"))
                object.platformType = options.enums === String ? $root.proto.CompanionProps.CompanionPropsPlatformType[message.platformType] : message.platformType;
            if (message.requireFullSync != null && message.hasOwnProperty("requireFullSync"))
                object.requireFullSync = message.requireFullSync;
            return object;
        };

        /**
         * Converts this CompanionProps to JSON.
         * @function toJSON
         * @memberof proto.CompanionProps
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        CompanionProps.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * CompanionPropsPlatformType enum.
         * @name proto.CompanionProps.CompanionPropsPlatformType
         * @enum {number}
         * @property {number} UNKNOWN=0 UNKNOWN value
         * @property {number} CHROME=1 CHROME value
         * @property {number} FIREFOX=2 FIREFOX value
         * @property {number} IE=3 IE value
         * @property {number} OPERA=4 OPERA value
         * @property {number} SAFARI=5 SAFARI value
         * @property {number} EDGE=6 EDGE value
         * @property {number} DESKTOP=7 DESKTOP value
         * @property {number} IPAD=8 IPAD value
         * @property {number} ANDROID_TABLET=9 ANDROID_TABLET value
         * @property {number} OHANA=10 OHANA value
         * @property {number} ALOHA=11 ALOHA value
         * @property {number} CATALINA=12 CATALINA value
         * @property {number} TCL_TV=13 TCL_TV value
         */
        CompanionProps.CompanionPropsPlatformType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "CHROME"] = 1;
            values[valuesById[2] = "FIREFOX"] = 2;
            values[valuesById[3] = "IE"] = 3;
            values[valuesById[4] = "OPERA"] = 4;
            values[valuesById[5] = "SAFARI"] = 5;
            values[valuesById[6] = "EDGE"] = 6;
            values[valuesById[7] = "DESKTOP"] = 7;
            values[valuesById[8] = "IPAD"] = 8;
            values[valuesById[9] = "ANDROID_TABLET"] = 9;
            values[valuesById[10] = "OHANA"] = 10;
            values[valuesById[11] = "ALOHA"] = 11;
            values[valuesById[12] = "CATALINA"] = 12;
            values[valuesById[13] = "TCL_TV"] = 13;
            return values;
        })();

        return CompanionProps;
    })();

    proto.ActionLink = (function() {

        /**
         * Properties of an ActionLink.
         * @memberof proto
         * @interface IActionLink
         * @property {string|null} [url] ActionLink url
         * @property {string|null} [buttonTitle] ActionLink buttonTitle
         */

        /**
         * Constructs a new ActionLink.
         * @memberof proto
         * @classdesc Represents an ActionLink.
         * @implements IActionLink
         * @constructor
         * @param {proto.IActionLink=} [properties] Properties to set
         */
        function ActionLink(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ActionLink url.
         * @member {string} url
         * @memberof proto.ActionLink
         * @instance
         */
        ActionLink.prototype.url = "";

        /**
         * ActionLink buttonTitle.
         * @member {string} buttonTitle
         * @memberof proto.ActionLink
         * @instance
         */
        ActionLink.prototype.buttonTitle = "";

        /**
         * Creates a new ActionLink instance using the specified properties.
         * @function create
         * @memberof proto.ActionLink
         * @static
         * @param {proto.IActionLink=} [properties] Properties to set
         * @returns {proto.ActionLink} ActionLink instance
         */
        ActionLink.create = function create(properties) {
            return new ActionLink(properties);
        };

        /**
         * Encodes the specified ActionLink message. Does not implicitly {@link proto.ActionLink.verify|verify} messages.
         * @function encode
         * @memberof proto.ActionLink
         * @static
         * @param {proto.IActionLink} message ActionLink message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ActionLink.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.url != null && Object.hasOwnProperty.call(message, "url"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.url);
            if (message.buttonTitle != null && Object.hasOwnProperty.call(message, "buttonTitle"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.buttonTitle);
            return writer;
        };

        /**
         * Encodes the specified ActionLink message, length delimited. Does not implicitly {@link proto.ActionLink.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ActionLink
         * @static
         * @param {proto.IActionLink} message ActionLink message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ActionLink.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an ActionLink message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ActionLink
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ActionLink} ActionLink
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ActionLink.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ActionLink();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.url = reader.string();
                    break;
                case 2:
                    message.buttonTitle = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an ActionLink message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ActionLink
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ActionLink} ActionLink
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ActionLink.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an ActionLink message.
         * @function verify
         * @memberof proto.ActionLink
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ActionLink.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.url != null && message.hasOwnProperty("url"))
                if (!$util.isString(message.url))
                    return "url: string expected";
            if (message.buttonTitle != null && message.hasOwnProperty("buttonTitle"))
                if (!$util.isString(message.buttonTitle))
                    return "buttonTitle: string expected";
            return null;
        };

        /**
         * Creates an ActionLink message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ActionLink
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ActionLink} ActionLink
         */
        ActionLink.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ActionLink)
                return object;
            var message = new $root.proto.ActionLink();
            if (object.url != null)
                message.url = String(object.url);
            if (object.buttonTitle != null)
                message.buttonTitle = String(object.buttonTitle);
            return message;
        };

        /**
         * Creates a plain object from an ActionLink message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ActionLink
         * @static
         * @param {proto.ActionLink} message ActionLink
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ActionLink.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.url = "";
                object.buttonTitle = "";
            }
            if (message.url != null && message.hasOwnProperty("url"))
                object.url = message.url;
            if (message.buttonTitle != null && message.hasOwnProperty("buttonTitle"))
                object.buttonTitle = message.buttonTitle;
            return object;
        };

        /**
         * Converts this ActionLink to JSON.
         * @function toJSON
         * @memberof proto.ActionLink
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ActionLink.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ActionLink;
    })();

    proto.AdReplyInfo = (function() {

        /**
         * Properties of an AdReplyInfo.
         * @memberof proto
         * @interface IAdReplyInfo
         * @property {string|null} [advertiserName] AdReplyInfo advertiserName
         * @property {proto.AdReplyInfo.AdReplyInfoMediaType|null} [mediaType] AdReplyInfo mediaType
         * @property {Uint8Array|null} [jpegThumbnail] AdReplyInfo jpegThumbnail
         * @property {string|null} [caption] AdReplyInfo caption
         */

        /**
         * Constructs a new AdReplyInfo.
         * @memberof proto
         * @classdesc Represents an AdReplyInfo.
         * @implements IAdReplyInfo
         * @constructor
         * @param {proto.IAdReplyInfo=} [properties] Properties to set
         */
        function AdReplyInfo(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * AdReplyInfo advertiserName.
         * @member {string} advertiserName
         * @memberof proto.AdReplyInfo
         * @instance
         */
        AdReplyInfo.prototype.advertiserName = "";

        /**
         * AdReplyInfo mediaType.
         * @member {proto.AdReplyInfo.AdReplyInfoMediaType} mediaType
         * @memberof proto.AdReplyInfo
         * @instance
         */
        AdReplyInfo.prototype.mediaType = 0;

        /**
         * AdReplyInfo jpegThumbnail.
         * @member {Uint8Array} jpegThumbnail
         * @memberof proto.AdReplyInfo
         * @instance
         */
        AdReplyInfo.prototype.jpegThumbnail = $util.newBuffer([]);

        /**
         * AdReplyInfo caption.
         * @member {string} caption
         * @memberof proto.AdReplyInfo
         * @instance
         */
        AdReplyInfo.prototype.caption = "";

        /**
         * Creates a new AdReplyInfo instance using the specified properties.
         * @function create
         * @memberof proto.AdReplyInfo
         * @static
         * @param {proto.IAdReplyInfo=} [properties] Properties to set
         * @returns {proto.AdReplyInfo} AdReplyInfo instance
         */
        AdReplyInfo.create = function create(properties) {
            return new AdReplyInfo(properties);
        };

        /**
         * Encodes the specified AdReplyInfo message. Does not implicitly {@link proto.AdReplyInfo.verify|verify} messages.
         * @function encode
         * @memberof proto.AdReplyInfo
         * @static
         * @param {proto.IAdReplyInfo} message AdReplyInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AdReplyInfo.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.advertiserName != null && Object.hasOwnProperty.call(message, "advertiserName"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.advertiserName);
            if (message.mediaType != null && Object.hasOwnProperty.call(message, "mediaType"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.mediaType);
            if (message.jpegThumbnail != null && Object.hasOwnProperty.call(message, "jpegThumbnail"))
                writer.uint32(/* id 16, wireType 2 =*/130).bytes(message.jpegThumbnail);
            if (message.caption != null && Object.hasOwnProperty.call(message, "caption"))
                writer.uint32(/* id 17, wireType 2 =*/138).string(message.caption);
            return writer;
        };

        /**
         * Encodes the specified AdReplyInfo message, length delimited. Does not implicitly {@link proto.AdReplyInfo.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.AdReplyInfo
         * @static
         * @param {proto.IAdReplyInfo} message AdReplyInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AdReplyInfo.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an AdReplyInfo message from the specified reader or buffer.
         * @function decode
         * @memberof proto.AdReplyInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.AdReplyInfo} AdReplyInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AdReplyInfo.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AdReplyInfo();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.advertiserName = reader.string();
                    break;
                case 2:
                    message.mediaType = reader.int32();
                    break;
                case 16:
                    message.jpegThumbnail = reader.bytes();
                    break;
                case 17:
                    message.caption = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an AdReplyInfo message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.AdReplyInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.AdReplyInfo} AdReplyInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AdReplyInfo.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an AdReplyInfo message.
         * @function verify
         * @memberof proto.AdReplyInfo
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        AdReplyInfo.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.advertiserName != null && message.hasOwnProperty("advertiserName"))
                if (!$util.isString(message.advertiserName))
                    return "advertiserName: string expected";
            if (message.mediaType != null && message.hasOwnProperty("mediaType"))
                switch (message.mediaType) {
                default:
                    return "mediaType: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            if (message.jpegThumbnail != null && message.hasOwnProperty("jpegThumbnail"))
                if (!(message.jpegThumbnail && typeof message.jpegThumbnail.length === "number" || $util.isString(message.jpegThumbnail)))
                    return "jpegThumbnail: buffer expected";
            if (message.caption != null && message.hasOwnProperty("caption"))
                if (!$util.isString(message.caption))
                    return "caption: string expected";
            return null;
        };

        /**
         * Creates an AdReplyInfo message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.AdReplyInfo
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.AdReplyInfo} AdReplyInfo
         */
        AdReplyInfo.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.AdReplyInfo)
                return object;
            var message = new $root.proto.AdReplyInfo();
            if (object.advertiserName != null)
                message.advertiserName = String(object.advertiserName);
            switch (object.mediaType) {
            case "NONE":
            case 0:
                message.mediaType = 0;
                break;
            case "IMAGE":
            case 1:
                message.mediaType = 1;
                break;
            case "VIDEO":
            case 2:
                message.mediaType = 2;
                break;
            }
            if (object.jpegThumbnail != null)
                if (typeof object.jpegThumbnail === "string")
                    $util.base64.decode(object.jpegThumbnail, message.jpegThumbnail = $util.newBuffer($util.base64.length(object.jpegThumbnail)), 0);
                else if (object.jpegThumbnail.length)
                    message.jpegThumbnail = object.jpegThumbnail;
            if (object.caption != null)
                message.caption = String(object.caption);
            return message;
        };

        /**
         * Creates a plain object from an AdReplyInfo message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.AdReplyInfo
         * @static
         * @param {proto.AdReplyInfo} message AdReplyInfo
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        AdReplyInfo.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.advertiserName = "";
                object.mediaType = options.enums === String ? "NONE" : 0;
                if (options.bytes === String)
                    object.jpegThumbnail = "";
                else {
                    object.jpegThumbnail = [];
                    if (options.bytes !== Array)
                        object.jpegThumbnail = $util.newBuffer(object.jpegThumbnail);
                }
                object.caption = "";
            }
            if (message.advertiserName != null && message.hasOwnProperty("advertiserName"))
                object.advertiserName = message.advertiserName;
            if (message.mediaType != null && message.hasOwnProperty("mediaType"))
                object.mediaType = options.enums === String ? $root.proto.AdReplyInfo.AdReplyInfoMediaType[message.mediaType] : message.mediaType;
            if (message.jpegThumbnail != null && message.hasOwnProperty("jpegThumbnail"))
                object.jpegThumbnail = options.bytes === String ? $util.base64.encode(message.jpegThumbnail, 0, message.jpegThumbnail.length) : options.bytes === Array ? Array.prototype.slice.call(message.jpegThumbnail) : message.jpegThumbnail;
            if (message.caption != null && message.hasOwnProperty("caption"))
                object.caption = message.caption;
            return object;
        };

        /**
         * Converts this AdReplyInfo to JSON.
         * @function toJSON
         * @memberof proto.AdReplyInfo
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        AdReplyInfo.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * AdReplyInfoMediaType enum.
         * @name proto.AdReplyInfo.AdReplyInfoMediaType
         * @enum {number}
         * @property {number} NONE=0 NONE value
         * @property {number} IMAGE=1 IMAGE value
         * @property {number} VIDEO=2 VIDEO value
         */
        AdReplyInfo.AdReplyInfoMediaType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "NONE"] = 0;
            values[valuesById[1] = "IMAGE"] = 1;
            values[valuesById[2] = "VIDEO"] = 2;
            return values;
        })();

        return AdReplyInfo;
    })();

    proto.AppStateFatalExceptionNotification = (function() {

        /**
         * Properties of an AppStateFatalExceptionNotification.
         * @memberof proto
         * @interface IAppStateFatalExceptionNotification
         * @property {Array.<string>|null} [collectionNames] AppStateFatalExceptionNotification collectionNames
         * @property {number|Long|null} [timestamp] AppStateFatalExceptionNotification timestamp
         */

        /**
         * Constructs a new AppStateFatalExceptionNotification.
         * @memberof proto
         * @classdesc Represents an AppStateFatalExceptionNotification.
         * @implements IAppStateFatalExceptionNotification
         * @constructor
         * @param {proto.IAppStateFatalExceptionNotification=} [properties] Properties to set
         */
        function AppStateFatalExceptionNotification(properties) {
            this.collectionNames = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * AppStateFatalExceptionNotification collectionNames.
         * @member {Array.<string>} collectionNames
         * @memberof proto.AppStateFatalExceptionNotification
         * @instance
         */
        AppStateFatalExceptionNotification.prototype.collectionNames = $util.emptyArray;

        /**
         * AppStateFatalExceptionNotification timestamp.
         * @member {number|Long} timestamp
         * @memberof proto.AppStateFatalExceptionNotification
         * @instance
         */
        AppStateFatalExceptionNotification.prototype.timestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * Creates a new AppStateFatalExceptionNotification instance using the specified properties.
         * @function create
         * @memberof proto.AppStateFatalExceptionNotification
         * @static
         * @param {proto.IAppStateFatalExceptionNotification=} [properties] Properties to set
         * @returns {proto.AppStateFatalExceptionNotification} AppStateFatalExceptionNotification instance
         */
        AppStateFatalExceptionNotification.create = function create(properties) {
            return new AppStateFatalExceptionNotification(properties);
        };

        /**
         * Encodes the specified AppStateFatalExceptionNotification message. Does not implicitly {@link proto.AppStateFatalExceptionNotification.verify|verify} messages.
         * @function encode
         * @memberof proto.AppStateFatalExceptionNotification
         * @static
         * @param {proto.IAppStateFatalExceptionNotification} message AppStateFatalExceptionNotification message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AppStateFatalExceptionNotification.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.collectionNames != null && message.collectionNames.length)
                for (var i = 0; i < message.collectionNames.length; ++i)
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.collectionNames[i]);
            if (message.timestamp != null && Object.hasOwnProperty.call(message, "timestamp"))
                writer.uint32(/* id 2, wireType 0 =*/16).int64(message.timestamp);
            return writer;
        };

        /**
         * Encodes the specified AppStateFatalExceptionNotification message, length delimited. Does not implicitly {@link proto.AppStateFatalExceptionNotification.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.AppStateFatalExceptionNotification
         * @static
         * @param {proto.IAppStateFatalExceptionNotification} message AppStateFatalExceptionNotification message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AppStateFatalExceptionNotification.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an AppStateFatalExceptionNotification message from the specified reader or buffer.
         * @function decode
         * @memberof proto.AppStateFatalExceptionNotification
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.AppStateFatalExceptionNotification} AppStateFatalExceptionNotification
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AppStateFatalExceptionNotification.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AppStateFatalExceptionNotification();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    if (!(message.collectionNames && message.collectionNames.length))
                        message.collectionNames = [];
                    message.collectionNames.push(reader.string());
                    break;
                case 2:
                    message.timestamp = reader.int64();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an AppStateFatalExceptionNotification message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.AppStateFatalExceptionNotification
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.AppStateFatalExceptionNotification} AppStateFatalExceptionNotification
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AppStateFatalExceptionNotification.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an AppStateFatalExceptionNotification message.
         * @function verify
         * @memberof proto.AppStateFatalExceptionNotification
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        AppStateFatalExceptionNotification.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.collectionNames != null && message.hasOwnProperty("collectionNames")) {
                if (!Array.isArray(message.collectionNames))
                    return "collectionNames: array expected";
                for (var i = 0; i < message.collectionNames.length; ++i)
                    if (!$util.isString(message.collectionNames[i]))
                        return "collectionNames: string[] expected";
            }
            if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                if (!$util.isInteger(message.timestamp) && !(message.timestamp && $util.isInteger(message.timestamp.low) && $util.isInteger(message.timestamp.high)))
                    return "timestamp: integer|Long expected";
            return null;
        };

        /**
         * Creates an AppStateFatalExceptionNotification message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.AppStateFatalExceptionNotification
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.AppStateFatalExceptionNotification} AppStateFatalExceptionNotification
         */
        AppStateFatalExceptionNotification.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.AppStateFatalExceptionNotification)
                return object;
            var message = new $root.proto.AppStateFatalExceptionNotification();
            if (object.collectionNames) {
                if (!Array.isArray(object.collectionNames))
                    throw TypeError(".proto.AppStateFatalExceptionNotification.collectionNames: array expected");
                message.collectionNames = [];
                for (var i = 0; i < object.collectionNames.length; ++i)
                    message.collectionNames[i] = String(object.collectionNames[i]);
            }
            if (object.timestamp != null)
                if ($util.Long)
                    (message.timestamp = $util.Long.fromValue(object.timestamp)).unsigned = false;
                else if (typeof object.timestamp === "string")
                    message.timestamp = parseInt(object.timestamp, 10);
                else if (typeof object.timestamp === "number")
                    message.timestamp = object.timestamp;
                else if (typeof object.timestamp === "object")
                    message.timestamp = new $util.LongBits(object.timestamp.low >>> 0, object.timestamp.high >>> 0).toNumber();
            return message;
        };

        /**
         * Creates a plain object from an AppStateFatalExceptionNotification message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.AppStateFatalExceptionNotification
         * @static
         * @param {proto.AppStateFatalExceptionNotification} message AppStateFatalExceptionNotification
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        AppStateFatalExceptionNotification.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.collectionNames = [];
            if (options.defaults)
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.timestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.timestamp = options.longs === String ? "0" : 0;
            if (message.collectionNames && message.collectionNames.length) {
                object.collectionNames = [];
                for (var j = 0; j < message.collectionNames.length; ++j)
                    object.collectionNames[j] = message.collectionNames[j];
            }
            if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                if (typeof message.timestamp === "number")
                    object.timestamp = options.longs === String ? String(message.timestamp) : message.timestamp;
                else
                    object.timestamp = options.longs === String ? $util.Long.prototype.toString.call(message.timestamp) : options.longs === Number ? new $util.LongBits(message.timestamp.low >>> 0, message.timestamp.high >>> 0).toNumber() : message.timestamp;
            return object;
        };

        /**
         * Converts this AppStateFatalExceptionNotification to JSON.
         * @function toJSON
         * @memberof proto.AppStateFatalExceptionNotification
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        AppStateFatalExceptionNotification.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return AppStateFatalExceptionNotification;
    })();

    proto.AppStateSyncKey = (function() {

        /**
         * Properties of an AppStateSyncKey.
         * @memberof proto
         * @interface IAppStateSyncKey
         * @property {proto.IAppStateSyncKeyId|null} [keyId] AppStateSyncKey keyId
         * @property {proto.IAppStateSyncKeyData|null} [keyData] AppStateSyncKey keyData
         */

        /**
         * Constructs a new AppStateSyncKey.
         * @memberof proto
         * @classdesc Represents an AppStateSyncKey.
         * @implements IAppStateSyncKey
         * @constructor
         * @param {proto.IAppStateSyncKey=} [properties] Properties to set
         */
        function AppStateSyncKey(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * AppStateSyncKey keyId.
         * @member {proto.IAppStateSyncKeyId|null|undefined} keyId
         * @memberof proto.AppStateSyncKey
         * @instance
         */
        AppStateSyncKey.prototype.keyId = null;

        /**
         * AppStateSyncKey keyData.
         * @member {proto.IAppStateSyncKeyData|null|undefined} keyData
         * @memberof proto.AppStateSyncKey
         * @instance
         */
        AppStateSyncKey.prototype.keyData = null;

        /**
         * Creates a new AppStateSyncKey instance using the specified properties.
         * @function create
         * @memberof proto.AppStateSyncKey
         * @static
         * @param {proto.IAppStateSyncKey=} [properties] Properties to set
         * @returns {proto.AppStateSyncKey} AppStateSyncKey instance
         */
        AppStateSyncKey.create = function create(properties) {
            return new AppStateSyncKey(properties);
        };

        /**
         * Encodes the specified AppStateSyncKey message. Does not implicitly {@link proto.AppStateSyncKey.verify|verify} messages.
         * @function encode
         * @memberof proto.AppStateSyncKey
         * @static
         * @param {proto.IAppStateSyncKey} message AppStateSyncKey message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AppStateSyncKey.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.keyId != null && Object.hasOwnProperty.call(message, "keyId"))
                $root.proto.AppStateSyncKeyId.encode(message.keyId, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.keyData != null && Object.hasOwnProperty.call(message, "keyData"))
                $root.proto.AppStateSyncKeyData.encode(message.keyData, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified AppStateSyncKey message, length delimited. Does not implicitly {@link proto.AppStateSyncKey.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.AppStateSyncKey
         * @static
         * @param {proto.IAppStateSyncKey} message AppStateSyncKey message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AppStateSyncKey.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an AppStateSyncKey message from the specified reader or buffer.
         * @function decode
         * @memberof proto.AppStateSyncKey
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.AppStateSyncKey} AppStateSyncKey
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AppStateSyncKey.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AppStateSyncKey();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.keyId = $root.proto.AppStateSyncKeyId.decode(reader, reader.uint32());
                    break;
                case 2:
                    message.keyData = $root.proto.AppStateSyncKeyData.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an AppStateSyncKey message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.AppStateSyncKey
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.AppStateSyncKey} AppStateSyncKey
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AppStateSyncKey.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an AppStateSyncKey message.
         * @function verify
         * @memberof proto.AppStateSyncKey
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        AppStateSyncKey.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.keyId != null && message.hasOwnProperty("keyId")) {
                var error = $root.proto.AppStateSyncKeyId.verify(message.keyId);
                if (error)
                    return "keyId." + error;
            }
            if (message.keyData != null && message.hasOwnProperty("keyData")) {
                var error = $root.proto.AppStateSyncKeyData.verify(message.keyData);
                if (error)
                    return "keyData." + error;
            }
            return null;
        };

        /**
         * Creates an AppStateSyncKey message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.AppStateSyncKey
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.AppStateSyncKey} AppStateSyncKey
         */
        AppStateSyncKey.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.AppStateSyncKey)
                return object;
            var message = new $root.proto.AppStateSyncKey();
            if (object.keyId != null) {
                if (typeof object.keyId !== "object")
                    throw TypeError(".proto.AppStateSyncKey.keyId: object expected");
                message.keyId = $root.proto.AppStateSyncKeyId.fromObject(object.keyId);
            }
            if (object.keyData != null) {
                if (typeof object.keyData !== "object")
                    throw TypeError(".proto.AppStateSyncKey.keyData: object expected");
                message.keyData = $root.proto.AppStateSyncKeyData.fromObject(object.keyData);
            }
            return message;
        };

        /**
         * Creates a plain object from an AppStateSyncKey message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.AppStateSyncKey
         * @static
         * @param {proto.AppStateSyncKey} message AppStateSyncKey
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        AppStateSyncKey.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.keyId = null;
                object.keyData = null;
            }
            if (message.keyId != null && message.hasOwnProperty("keyId"))
                object.keyId = $root.proto.AppStateSyncKeyId.toObject(message.keyId, options);
            if (message.keyData != null && message.hasOwnProperty("keyData"))
                object.keyData = $root.proto.AppStateSyncKeyData.toObject(message.keyData, options);
            return object;
        };

        /**
         * Converts this AppStateSyncKey to JSON.
         * @function toJSON
         * @memberof proto.AppStateSyncKey
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        AppStateSyncKey.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return AppStateSyncKey;
    })();

    proto.AppStateSyncKeyData = (function() {

        /**
         * Properties of an AppStateSyncKeyData.
         * @memberof proto
         * @interface IAppStateSyncKeyData
         * @property {Uint8Array|null} [keyData] AppStateSyncKeyData keyData
         * @property {proto.IAppStateSyncKeyFingerprint|null} [fingerprint] AppStateSyncKeyData fingerprint
         * @property {number|Long|null} [timestamp] AppStateSyncKeyData timestamp
         */

        /**
         * Constructs a new AppStateSyncKeyData.
         * @memberof proto
         * @classdesc Represents an AppStateSyncKeyData.
         * @implements IAppStateSyncKeyData
         * @constructor
         * @param {proto.IAppStateSyncKeyData=} [properties] Properties to set
         */
        function AppStateSyncKeyData(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * AppStateSyncKeyData keyData.
         * @member {Uint8Array} keyData
         * @memberof proto.AppStateSyncKeyData
         * @instance
         */
        AppStateSyncKeyData.prototype.keyData = $util.newBuffer([]);

        /**
         * AppStateSyncKeyData fingerprint.
         * @member {proto.IAppStateSyncKeyFingerprint|null|undefined} fingerprint
         * @memberof proto.AppStateSyncKeyData
         * @instance
         */
        AppStateSyncKeyData.prototype.fingerprint = null;

        /**
         * AppStateSyncKeyData timestamp.
         * @member {number|Long} timestamp
         * @memberof proto.AppStateSyncKeyData
         * @instance
         */
        AppStateSyncKeyData.prototype.timestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * Creates a new AppStateSyncKeyData instance using the specified properties.
         * @function create
         * @memberof proto.AppStateSyncKeyData
         * @static
         * @param {proto.IAppStateSyncKeyData=} [properties] Properties to set
         * @returns {proto.AppStateSyncKeyData} AppStateSyncKeyData instance
         */
        AppStateSyncKeyData.create = function create(properties) {
            return new AppStateSyncKeyData(properties);
        };

        /**
         * Encodes the specified AppStateSyncKeyData message. Does not implicitly {@link proto.AppStateSyncKeyData.verify|verify} messages.
         * @function encode
         * @memberof proto.AppStateSyncKeyData
         * @static
         * @param {proto.IAppStateSyncKeyData} message AppStateSyncKeyData message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AppStateSyncKeyData.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.keyData != null && Object.hasOwnProperty.call(message, "keyData"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.keyData);
            if (message.fingerprint != null && Object.hasOwnProperty.call(message, "fingerprint"))
                $root.proto.AppStateSyncKeyFingerprint.encode(message.fingerprint, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.timestamp != null && Object.hasOwnProperty.call(message, "timestamp"))
                writer.uint32(/* id 3, wireType 0 =*/24).int64(message.timestamp);
            return writer;
        };

        /**
         * Encodes the specified AppStateSyncKeyData message, length delimited. Does not implicitly {@link proto.AppStateSyncKeyData.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.AppStateSyncKeyData
         * @static
         * @param {proto.IAppStateSyncKeyData} message AppStateSyncKeyData message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AppStateSyncKeyData.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an AppStateSyncKeyData message from the specified reader or buffer.
         * @function decode
         * @memberof proto.AppStateSyncKeyData
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.AppStateSyncKeyData} AppStateSyncKeyData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AppStateSyncKeyData.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AppStateSyncKeyData();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.keyData = reader.bytes();
                    break;
                case 2:
                    message.fingerprint = $root.proto.AppStateSyncKeyFingerprint.decode(reader, reader.uint32());
                    break;
                case 3:
                    message.timestamp = reader.int64();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an AppStateSyncKeyData message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.AppStateSyncKeyData
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.AppStateSyncKeyData} AppStateSyncKeyData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AppStateSyncKeyData.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an AppStateSyncKeyData message.
         * @function verify
         * @memberof proto.AppStateSyncKeyData
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        AppStateSyncKeyData.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.keyData != null && message.hasOwnProperty("keyData"))
                if (!(message.keyData && typeof message.keyData.length === "number" || $util.isString(message.keyData)))
                    return "keyData: buffer expected";
            if (message.fingerprint != null && message.hasOwnProperty("fingerprint")) {
                var error = $root.proto.AppStateSyncKeyFingerprint.verify(message.fingerprint);
                if (error)
                    return "fingerprint." + error;
            }
            if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                if (!$util.isInteger(message.timestamp) && !(message.timestamp && $util.isInteger(message.timestamp.low) && $util.isInteger(message.timestamp.high)))
                    return "timestamp: integer|Long expected";
            return null;
        };

        /**
         * Creates an AppStateSyncKeyData message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.AppStateSyncKeyData
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.AppStateSyncKeyData} AppStateSyncKeyData
         */
        AppStateSyncKeyData.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.AppStateSyncKeyData)
                return object;
            var message = new $root.proto.AppStateSyncKeyData();
            if (object.keyData != null)
                if (typeof object.keyData === "string")
                    $util.base64.decode(object.keyData, message.keyData = $util.newBuffer($util.base64.length(object.keyData)), 0);
                else if (object.keyData.length)
                    message.keyData = object.keyData;
            if (object.fingerprint != null) {
                if (typeof object.fingerprint !== "object")
                    throw TypeError(".proto.AppStateSyncKeyData.fingerprint: object expected");
                message.fingerprint = $root.proto.AppStateSyncKeyFingerprint.fromObject(object.fingerprint);
            }
            if (object.timestamp != null)
                if ($util.Long)
                    (message.timestamp = $util.Long.fromValue(object.timestamp)).unsigned = false;
                else if (typeof object.timestamp === "string")
                    message.timestamp = parseInt(object.timestamp, 10);
                else if (typeof object.timestamp === "number")
                    message.timestamp = object.timestamp;
                else if (typeof object.timestamp === "object")
                    message.timestamp = new $util.LongBits(object.timestamp.low >>> 0, object.timestamp.high >>> 0).toNumber();
            return message;
        };

        /**
         * Creates a plain object from an AppStateSyncKeyData message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.AppStateSyncKeyData
         * @static
         * @param {proto.AppStateSyncKeyData} message AppStateSyncKeyData
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        AppStateSyncKeyData.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if (options.bytes === String)
                    object.keyData = "";
                else {
                    object.keyData = [];
                    if (options.bytes !== Array)
                        object.keyData = $util.newBuffer(object.keyData);
                }
                object.fingerprint = null;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.timestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.timestamp = options.longs === String ? "0" : 0;
            }
            if (message.keyData != null && message.hasOwnProperty("keyData"))
                object.keyData = options.bytes === String ? $util.base64.encode(message.keyData, 0, message.keyData.length) : options.bytes === Array ? Array.prototype.slice.call(message.keyData) : message.keyData;
            if (message.fingerprint != null && message.hasOwnProperty("fingerprint"))
                object.fingerprint = $root.proto.AppStateSyncKeyFingerprint.toObject(message.fingerprint, options);
            if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                if (typeof message.timestamp === "number")
                    object.timestamp = options.longs === String ? String(message.timestamp) : message.timestamp;
                else
                    object.timestamp = options.longs === String ? $util.Long.prototype.toString.call(message.timestamp) : options.longs === Number ? new $util.LongBits(message.timestamp.low >>> 0, message.timestamp.high >>> 0).toNumber() : message.timestamp;
            return object;
        };

        /**
         * Converts this AppStateSyncKeyData to JSON.
         * @function toJSON
         * @memberof proto.AppStateSyncKeyData
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        AppStateSyncKeyData.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return AppStateSyncKeyData;
    })();

    proto.AppStateSyncKeyFingerprint = (function() {

        /**
         * Properties of an AppStateSyncKeyFingerprint.
         * @memberof proto
         * @interface IAppStateSyncKeyFingerprint
         * @property {number|null} [rawId] AppStateSyncKeyFingerprint rawId
         * @property {number|null} [currentIndex] AppStateSyncKeyFingerprint currentIndex
         * @property {Array.<number>|null} [deviceIndexes] AppStateSyncKeyFingerprint deviceIndexes
         */

        /**
         * Constructs a new AppStateSyncKeyFingerprint.
         * @memberof proto
         * @classdesc Represents an AppStateSyncKeyFingerprint.
         * @implements IAppStateSyncKeyFingerprint
         * @constructor
         * @param {proto.IAppStateSyncKeyFingerprint=} [properties] Properties to set
         */
        function AppStateSyncKeyFingerprint(properties) {
            this.deviceIndexes = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * AppStateSyncKeyFingerprint rawId.
         * @member {number} rawId
         * @memberof proto.AppStateSyncKeyFingerprint
         * @instance
         */
        AppStateSyncKeyFingerprint.prototype.rawId = 0;

        /**
         * AppStateSyncKeyFingerprint currentIndex.
         * @member {number} currentIndex
         * @memberof proto.AppStateSyncKeyFingerprint
         * @instance
         */
        AppStateSyncKeyFingerprint.prototype.currentIndex = 0;

        /**
         * AppStateSyncKeyFingerprint deviceIndexes.
         * @member {Array.<number>} deviceIndexes
         * @memberof proto.AppStateSyncKeyFingerprint
         * @instance
         */
        AppStateSyncKeyFingerprint.prototype.deviceIndexes = $util.emptyArray;

        /**
         * Creates a new AppStateSyncKeyFingerprint instance using the specified properties.
         * @function create
         * @memberof proto.AppStateSyncKeyFingerprint
         * @static
         * @param {proto.IAppStateSyncKeyFingerprint=} [properties] Properties to set
         * @returns {proto.AppStateSyncKeyFingerprint} AppStateSyncKeyFingerprint instance
         */
        AppStateSyncKeyFingerprint.create = function create(properties) {
            return new AppStateSyncKeyFingerprint(properties);
        };

        /**
         * Encodes the specified AppStateSyncKeyFingerprint message. Does not implicitly {@link proto.AppStateSyncKeyFingerprint.verify|verify} messages.
         * @function encode
         * @memberof proto.AppStateSyncKeyFingerprint
         * @static
         * @param {proto.IAppStateSyncKeyFingerprint} message AppStateSyncKeyFingerprint message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AppStateSyncKeyFingerprint.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.rawId != null && Object.hasOwnProperty.call(message, "rawId"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.rawId);
            if (message.currentIndex != null && Object.hasOwnProperty.call(message, "currentIndex"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint32(message.currentIndex);
            if (message.deviceIndexes != null && message.deviceIndexes.length) {
                writer.uint32(/* id 3, wireType 2 =*/26).fork();
                for (var i = 0; i < message.deviceIndexes.length; ++i)
                    writer.uint32(message.deviceIndexes[i]);
                writer.ldelim();
            }
            return writer;
        };

        /**
         * Encodes the specified AppStateSyncKeyFingerprint message, length delimited. Does not implicitly {@link proto.AppStateSyncKeyFingerprint.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.AppStateSyncKeyFingerprint
         * @static
         * @param {proto.IAppStateSyncKeyFingerprint} message AppStateSyncKeyFingerprint message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AppStateSyncKeyFingerprint.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an AppStateSyncKeyFingerprint message from the specified reader or buffer.
         * @function decode
         * @memberof proto.AppStateSyncKeyFingerprint
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.AppStateSyncKeyFingerprint} AppStateSyncKeyFingerprint
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AppStateSyncKeyFingerprint.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AppStateSyncKeyFingerprint();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.rawId = reader.uint32();
                    break;
                case 2:
                    message.currentIndex = reader.uint32();
                    break;
                case 3:
                    if (!(message.deviceIndexes && message.deviceIndexes.length))
                        message.deviceIndexes = [];
                    if ((tag & 7) === 2) {
                        var end2 = reader.uint32() + reader.pos;
                        while (reader.pos < end2)
                            message.deviceIndexes.push(reader.uint32());
                    } else
                        message.deviceIndexes.push(reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an AppStateSyncKeyFingerprint message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.AppStateSyncKeyFingerprint
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.AppStateSyncKeyFingerprint} AppStateSyncKeyFingerprint
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AppStateSyncKeyFingerprint.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an AppStateSyncKeyFingerprint message.
         * @function verify
         * @memberof proto.AppStateSyncKeyFingerprint
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        AppStateSyncKeyFingerprint.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.rawId != null && message.hasOwnProperty("rawId"))
                if (!$util.isInteger(message.rawId))
                    return "rawId: integer expected";
            if (message.currentIndex != null && message.hasOwnProperty("currentIndex"))
                if (!$util.isInteger(message.currentIndex))
                    return "currentIndex: integer expected";
            if (message.deviceIndexes != null && message.hasOwnProperty("deviceIndexes")) {
                if (!Array.isArray(message.deviceIndexes))
                    return "deviceIndexes: array expected";
                for (var i = 0; i < message.deviceIndexes.length; ++i)
                    if (!$util.isInteger(message.deviceIndexes[i]))
                        return "deviceIndexes: integer[] expected";
            }
            return null;
        };

        /**
         * Creates an AppStateSyncKeyFingerprint message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.AppStateSyncKeyFingerprint
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.AppStateSyncKeyFingerprint} AppStateSyncKeyFingerprint
         */
        AppStateSyncKeyFingerprint.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.AppStateSyncKeyFingerprint)
                return object;
            var message = new $root.proto.AppStateSyncKeyFingerprint();
            if (object.rawId != null)
                message.rawId = object.rawId >>> 0;
            if (object.currentIndex != null)
                message.currentIndex = object.currentIndex >>> 0;
            if (object.deviceIndexes) {
                if (!Array.isArray(object.deviceIndexes))
                    throw TypeError(".proto.AppStateSyncKeyFingerprint.deviceIndexes: array expected");
                message.deviceIndexes = [];
                for (var i = 0; i < object.deviceIndexes.length; ++i)
                    message.deviceIndexes[i] = object.deviceIndexes[i] >>> 0;
            }
            return message;
        };

        /**
         * Creates a plain object from an AppStateSyncKeyFingerprint message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.AppStateSyncKeyFingerprint
         * @static
         * @param {proto.AppStateSyncKeyFingerprint} message AppStateSyncKeyFingerprint
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        AppStateSyncKeyFingerprint.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.deviceIndexes = [];
            if (options.defaults) {
                object.rawId = 0;
                object.currentIndex = 0;
            }
            if (message.rawId != null && message.hasOwnProperty("rawId"))
                object.rawId = message.rawId;
            if (message.currentIndex != null && message.hasOwnProperty("currentIndex"))
                object.currentIndex = message.currentIndex;
            if (message.deviceIndexes && message.deviceIndexes.length) {
                object.deviceIndexes = [];
                for (var j = 0; j < message.deviceIndexes.length; ++j)
                    object.deviceIndexes[j] = message.deviceIndexes[j];
            }
            return object;
        };

        /**
         * Converts this AppStateSyncKeyFingerprint to JSON.
         * @function toJSON
         * @memberof proto.AppStateSyncKeyFingerprint
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        AppStateSyncKeyFingerprint.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return AppStateSyncKeyFingerprint;
    })();

    proto.AppStateSyncKeyId = (function() {

        /**
         * Properties of an AppStateSyncKeyId.
         * @memberof proto
         * @interface IAppStateSyncKeyId
         * @property {Uint8Array|null} [keyId] AppStateSyncKeyId keyId
         */

        /**
         * Constructs a new AppStateSyncKeyId.
         * @memberof proto
         * @classdesc Represents an AppStateSyncKeyId.
         * @implements IAppStateSyncKeyId
         * @constructor
         * @param {proto.IAppStateSyncKeyId=} [properties] Properties to set
         */
        function AppStateSyncKeyId(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * AppStateSyncKeyId keyId.
         * @member {Uint8Array} keyId
         * @memberof proto.AppStateSyncKeyId
         * @instance
         */
        AppStateSyncKeyId.prototype.keyId = $util.newBuffer([]);

        /**
         * Creates a new AppStateSyncKeyId instance using the specified properties.
         * @function create
         * @memberof proto.AppStateSyncKeyId
         * @static
         * @param {proto.IAppStateSyncKeyId=} [properties] Properties to set
         * @returns {proto.AppStateSyncKeyId} AppStateSyncKeyId instance
         */
        AppStateSyncKeyId.create = function create(properties) {
            return new AppStateSyncKeyId(properties);
        };

        /**
         * Encodes the specified AppStateSyncKeyId message. Does not implicitly {@link proto.AppStateSyncKeyId.verify|verify} messages.
         * @function encode
         * @memberof proto.AppStateSyncKeyId
         * @static
         * @param {proto.IAppStateSyncKeyId} message AppStateSyncKeyId message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AppStateSyncKeyId.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.keyId != null && Object.hasOwnProperty.call(message, "keyId"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.keyId);
            return writer;
        };

        /**
         * Encodes the specified AppStateSyncKeyId message, length delimited. Does not implicitly {@link proto.AppStateSyncKeyId.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.AppStateSyncKeyId
         * @static
         * @param {proto.IAppStateSyncKeyId} message AppStateSyncKeyId message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AppStateSyncKeyId.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an AppStateSyncKeyId message from the specified reader or buffer.
         * @function decode
         * @memberof proto.AppStateSyncKeyId
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.AppStateSyncKeyId} AppStateSyncKeyId
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AppStateSyncKeyId.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AppStateSyncKeyId();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.keyId = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an AppStateSyncKeyId message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.AppStateSyncKeyId
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.AppStateSyncKeyId} AppStateSyncKeyId
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AppStateSyncKeyId.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an AppStateSyncKeyId message.
         * @function verify
         * @memberof proto.AppStateSyncKeyId
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        AppStateSyncKeyId.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.keyId != null && message.hasOwnProperty("keyId"))
                if (!(message.keyId && typeof message.keyId.length === "number" || $util.isString(message.keyId)))
                    return "keyId: buffer expected";
            return null;
        };

        /**
         * Creates an AppStateSyncKeyId message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.AppStateSyncKeyId
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.AppStateSyncKeyId} AppStateSyncKeyId
         */
        AppStateSyncKeyId.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.AppStateSyncKeyId)
                return object;
            var message = new $root.proto.AppStateSyncKeyId();
            if (object.keyId != null)
                if (typeof object.keyId === "string")
                    $util.base64.decode(object.keyId, message.keyId = $util.newBuffer($util.base64.length(object.keyId)), 0);
                else if (object.keyId.length)
                    message.keyId = object.keyId;
            return message;
        };

        /**
         * Creates a plain object from an AppStateSyncKeyId message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.AppStateSyncKeyId
         * @static
         * @param {proto.AppStateSyncKeyId} message AppStateSyncKeyId
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        AppStateSyncKeyId.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                if (options.bytes === String)
                    object.keyId = "";
                else {
                    object.keyId = [];
                    if (options.bytes !== Array)
                        object.keyId = $util.newBuffer(object.keyId);
                }
            if (message.keyId != null && message.hasOwnProperty("keyId"))
                object.keyId = options.bytes === String ? $util.base64.encode(message.keyId, 0, message.keyId.length) : options.bytes === Array ? Array.prototype.slice.call(message.keyId) : message.keyId;
            return object;
        };

        /**
         * Converts this AppStateSyncKeyId to JSON.
         * @function toJSON
         * @memberof proto.AppStateSyncKeyId
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        AppStateSyncKeyId.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return AppStateSyncKeyId;
    })();

    proto.AppStateSyncKeyRequest = (function() {

        /**
         * Properties of an AppStateSyncKeyRequest.
         * @memberof proto
         * @interface IAppStateSyncKeyRequest
         * @property {Array.<proto.IAppStateSyncKeyId>|null} [keyIds] AppStateSyncKeyRequest keyIds
         */

        /**
         * Constructs a new AppStateSyncKeyRequest.
         * @memberof proto
         * @classdesc Represents an AppStateSyncKeyRequest.
         * @implements IAppStateSyncKeyRequest
         * @constructor
         * @param {proto.IAppStateSyncKeyRequest=} [properties] Properties to set
         */
        function AppStateSyncKeyRequest(properties) {
            this.keyIds = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * AppStateSyncKeyRequest keyIds.
         * @member {Array.<proto.IAppStateSyncKeyId>} keyIds
         * @memberof proto.AppStateSyncKeyRequest
         * @instance
         */
        AppStateSyncKeyRequest.prototype.keyIds = $util.emptyArray;

        /**
         * Creates a new AppStateSyncKeyRequest instance using the specified properties.
         * @function create
         * @memberof proto.AppStateSyncKeyRequest
         * @static
         * @param {proto.IAppStateSyncKeyRequest=} [properties] Properties to set
         * @returns {proto.AppStateSyncKeyRequest} AppStateSyncKeyRequest instance
         */
        AppStateSyncKeyRequest.create = function create(properties) {
            return new AppStateSyncKeyRequest(properties);
        };

        /**
         * Encodes the specified AppStateSyncKeyRequest message. Does not implicitly {@link proto.AppStateSyncKeyRequest.verify|verify} messages.
         * @function encode
         * @memberof proto.AppStateSyncKeyRequest
         * @static
         * @param {proto.IAppStateSyncKeyRequest} message AppStateSyncKeyRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AppStateSyncKeyRequest.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.keyIds != null && message.keyIds.length)
                for (var i = 0; i < message.keyIds.length; ++i)
                    $root.proto.AppStateSyncKeyId.encode(message.keyIds[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified AppStateSyncKeyRequest message, length delimited. Does not implicitly {@link proto.AppStateSyncKeyRequest.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.AppStateSyncKeyRequest
         * @static
         * @param {proto.IAppStateSyncKeyRequest} message AppStateSyncKeyRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AppStateSyncKeyRequest.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an AppStateSyncKeyRequest message from the specified reader or buffer.
         * @function decode
         * @memberof proto.AppStateSyncKeyRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.AppStateSyncKeyRequest} AppStateSyncKeyRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AppStateSyncKeyRequest.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AppStateSyncKeyRequest();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    if (!(message.keyIds && message.keyIds.length))
                        message.keyIds = [];
                    message.keyIds.push($root.proto.AppStateSyncKeyId.decode(reader, reader.uint32()));
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an AppStateSyncKeyRequest message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.AppStateSyncKeyRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.AppStateSyncKeyRequest} AppStateSyncKeyRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AppStateSyncKeyRequest.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an AppStateSyncKeyRequest message.
         * @function verify
         * @memberof proto.AppStateSyncKeyRequest
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        AppStateSyncKeyRequest.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.keyIds != null && message.hasOwnProperty("keyIds")) {
                if (!Array.isArray(message.keyIds))
                    return "keyIds: array expected";
                for (var i = 0; i < message.keyIds.length; ++i) {
                    var error = $root.proto.AppStateSyncKeyId.verify(message.keyIds[i]);
                    if (error)
                        return "keyIds." + error;
                }
            }
            return null;
        };

        /**
         * Creates an AppStateSyncKeyRequest message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.AppStateSyncKeyRequest
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.AppStateSyncKeyRequest} AppStateSyncKeyRequest
         */
        AppStateSyncKeyRequest.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.AppStateSyncKeyRequest)
                return object;
            var message = new $root.proto.AppStateSyncKeyRequest();
            if (object.keyIds) {
                if (!Array.isArray(object.keyIds))
                    throw TypeError(".proto.AppStateSyncKeyRequest.keyIds: array expected");
                message.keyIds = [];
                for (var i = 0; i < object.keyIds.length; ++i) {
                    if (typeof object.keyIds[i] !== "object")
                        throw TypeError(".proto.AppStateSyncKeyRequest.keyIds: object expected");
                    message.keyIds[i] = $root.proto.AppStateSyncKeyId.fromObject(object.keyIds[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from an AppStateSyncKeyRequest message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.AppStateSyncKeyRequest
         * @static
         * @param {proto.AppStateSyncKeyRequest} message AppStateSyncKeyRequest
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        AppStateSyncKeyRequest.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.keyIds = [];
            if (message.keyIds && message.keyIds.length) {
                object.keyIds = [];
                for (var j = 0; j < message.keyIds.length; ++j)
                    object.keyIds[j] = $root.proto.AppStateSyncKeyId.toObject(message.keyIds[j], options);
            }
            return object;
        };

        /**
         * Converts this AppStateSyncKeyRequest to JSON.
         * @function toJSON
         * @memberof proto.AppStateSyncKeyRequest
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        AppStateSyncKeyRequest.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return AppStateSyncKeyRequest;
    })();

    proto.AppStateSyncKeyShare = (function() {

        /**
         * Properties of an AppStateSyncKeyShare.
         * @memberof proto
         * @interface IAppStateSyncKeyShare
         * @property {Array.<proto.IAppStateSyncKey>|null} [keys] AppStateSyncKeyShare keys
         */

        /**
         * Constructs a new AppStateSyncKeyShare.
         * @memberof proto
         * @classdesc Represents an AppStateSyncKeyShare.
         * @implements IAppStateSyncKeyShare
         * @constructor
         * @param {proto.IAppStateSyncKeyShare=} [properties] Properties to set
         */
        function AppStateSyncKeyShare(properties) {
            this.keys = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * AppStateSyncKeyShare keys.
         * @member {Array.<proto.IAppStateSyncKey>} keys
         * @memberof proto.AppStateSyncKeyShare
         * @instance
         */
        AppStateSyncKeyShare.prototype.keys = $util.emptyArray;

        /**
         * Creates a new AppStateSyncKeyShare instance using the specified properties.
         * @function create
         * @memberof proto.AppStateSyncKeyShare
         * @static
         * @param {proto.IAppStateSyncKeyShare=} [properties] Properties to set
         * @returns {proto.AppStateSyncKeyShare} AppStateSyncKeyShare instance
         */
        AppStateSyncKeyShare.create = function create(properties) {
            return new AppStateSyncKeyShare(properties);
        };

        /**
         * Encodes the specified AppStateSyncKeyShare message. Does not implicitly {@link proto.AppStateSyncKeyShare.verify|verify} messages.
         * @function encode
         * @memberof proto.AppStateSyncKeyShare
         * @static
         * @param {proto.IAppStateSyncKeyShare} message AppStateSyncKeyShare message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AppStateSyncKeyShare.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.keys != null && message.keys.length)
                for (var i = 0; i < message.keys.length; ++i)
                    $root.proto.AppStateSyncKey.encode(message.keys[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified AppStateSyncKeyShare message, length delimited. Does not implicitly {@link proto.AppStateSyncKeyShare.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.AppStateSyncKeyShare
         * @static
         * @param {proto.IAppStateSyncKeyShare} message AppStateSyncKeyShare message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AppStateSyncKeyShare.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an AppStateSyncKeyShare message from the specified reader or buffer.
         * @function decode
         * @memberof proto.AppStateSyncKeyShare
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.AppStateSyncKeyShare} AppStateSyncKeyShare
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AppStateSyncKeyShare.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AppStateSyncKeyShare();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    if (!(message.keys && message.keys.length))
                        message.keys = [];
                    message.keys.push($root.proto.AppStateSyncKey.decode(reader, reader.uint32()));
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an AppStateSyncKeyShare message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.AppStateSyncKeyShare
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.AppStateSyncKeyShare} AppStateSyncKeyShare
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AppStateSyncKeyShare.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an AppStateSyncKeyShare message.
         * @function verify
         * @memberof proto.AppStateSyncKeyShare
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        AppStateSyncKeyShare.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.keys != null && message.hasOwnProperty("keys")) {
                if (!Array.isArray(message.keys))
                    return "keys: array expected";
                for (var i = 0; i < message.keys.length; ++i) {
                    var error = $root.proto.AppStateSyncKey.verify(message.keys[i]);
                    if (error)
                        return "keys." + error;
                }
            }
            return null;
        };

        /**
         * Creates an AppStateSyncKeyShare message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.AppStateSyncKeyShare
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.AppStateSyncKeyShare} AppStateSyncKeyShare
         */
        AppStateSyncKeyShare.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.AppStateSyncKeyShare)
                return object;
            var message = new $root.proto.AppStateSyncKeyShare();
            if (object.keys) {
                if (!Array.isArray(object.keys))
                    throw TypeError(".proto.AppStateSyncKeyShare.keys: array expected");
                message.keys = [];
                for (var i = 0; i < object.keys.length; ++i) {
                    if (typeof object.keys[i] !== "object")
                        throw TypeError(".proto.AppStateSyncKeyShare.keys: object expected");
                    message.keys[i] = $root.proto.AppStateSyncKey.fromObject(object.keys[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from an AppStateSyncKeyShare message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.AppStateSyncKeyShare
         * @static
         * @param {proto.AppStateSyncKeyShare} message AppStateSyncKeyShare
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        AppStateSyncKeyShare.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.keys = [];
            if (message.keys && message.keys.length) {
                object.keys = [];
                for (var j = 0; j < message.keys.length; ++j)
                    object.keys[j] = $root.proto.AppStateSyncKey.toObject(message.keys[j], options);
            }
            return object;
        };

        /**
         * Converts this AppStateSyncKeyShare to JSON.
         * @function toJSON
         * @memberof proto.AppStateSyncKeyShare
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        AppStateSyncKeyShare.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return AppStateSyncKeyShare;
    })();

    proto.AudioMessage = (function() {

        /**
         * Properties of an AudioMessage.
         * @memberof proto
         * @interface IAudioMessage
         * @property {string|null} [url] AudioMessage url
         * @property {string|null} [mimetype] AudioMessage mimetype
         * @property {Uint8Array|null} [fileSha256] AudioMessage fileSha256
         * @property {number|Long|null} [fileLength] AudioMessage fileLength
         * @property {number|null} [seconds] AudioMessage seconds
         * @property {boolean|null} [ptt] AudioMessage ptt
         * @property {Uint8Array|null} [mediaKey] AudioMessage mediaKey
         * @property {Uint8Array|null} [fileEncSha256] AudioMessage fileEncSha256
         * @property {string|null} [directPath] AudioMessage directPath
         * @property {number|Long|null} [mediaKeyTimestamp] AudioMessage mediaKeyTimestamp
         * @property {proto.IContextInfo|null} [contextInfo] AudioMessage contextInfo
         * @property {Uint8Array|null} [streamingSidecar] AudioMessage streamingSidecar
         * @property {Uint8Array|null} [waveform] AudioMessage waveform
         */

        /**
         * Constructs a new AudioMessage.
         * @memberof proto
         * @classdesc Represents an AudioMessage.
         * @implements IAudioMessage
         * @constructor
         * @param {proto.IAudioMessage=} [properties] Properties to set
         */
        function AudioMessage(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * AudioMessage url.
         * @member {string} url
         * @memberof proto.AudioMessage
         * @instance
         */
        AudioMessage.prototype.url = "";

        /**
         * AudioMessage mimetype.
         * @member {string} mimetype
         * @memberof proto.AudioMessage
         * @instance
         */
        AudioMessage.prototype.mimetype = "";

        /**
         * AudioMessage fileSha256.
         * @member {Uint8Array} fileSha256
         * @memberof proto.AudioMessage
         * @instance
         */
        AudioMessage.prototype.fileSha256 = $util.newBuffer([]);

        /**
         * AudioMessage fileLength.
         * @member {number|Long} fileLength
         * @memberof proto.AudioMessage
         * @instance
         */
        AudioMessage.prototype.fileLength = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * AudioMessage seconds.
         * @member {number} seconds
         * @memberof proto.AudioMessage
         * @instance
         */
        AudioMessage.prototype.seconds = 0;

        /**
         * AudioMessage ptt.
         * @member {boolean} ptt
         * @memberof proto.AudioMessage
         * @instance
         */
        AudioMessage.prototype.ptt = false;

        /**
         * AudioMessage mediaKey.
         * @member {Uint8Array} mediaKey
         * @memberof proto.AudioMessage
         * @instance
         */
        AudioMessage.prototype.mediaKey = $util.newBuffer([]);

        /**
         * AudioMessage fileEncSha256.
         * @member {Uint8Array} fileEncSha256
         * @memberof proto.AudioMessage
         * @instance
         */
        AudioMessage.prototype.fileEncSha256 = $util.newBuffer([]);

        /**
         * AudioMessage directPath.
         * @member {string} directPath
         * @memberof proto.AudioMessage
         * @instance
         */
        AudioMessage.prototype.directPath = "";

        /**
         * AudioMessage mediaKeyTimestamp.
         * @member {number|Long} mediaKeyTimestamp
         * @memberof proto.AudioMessage
         * @instance
         */
        AudioMessage.prototype.mediaKeyTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * AudioMessage contextInfo.
         * @member {proto.IContextInfo|null|undefined} contextInfo
         * @memberof proto.AudioMessage
         * @instance
         */
        AudioMessage.prototype.contextInfo = null;

        /**
         * AudioMessage streamingSidecar.
         * @member {Uint8Array} streamingSidecar
         * @memberof proto.AudioMessage
         * @instance
         */
        AudioMessage.prototype.streamingSidecar = $util.newBuffer([]);

        /**
         * AudioMessage waveform.
         * @member {Uint8Array} waveform
         * @memberof proto.AudioMessage
         * @instance
         */
        AudioMessage.prototype.waveform = $util.newBuffer([]);

        /**
         * Creates a new AudioMessage instance using the specified properties.
         * @function create
         * @memberof proto.AudioMessage
         * @static
         * @param {proto.IAudioMessage=} [properties] Properties to set
         * @returns {proto.AudioMessage} AudioMessage instance
         */
        AudioMessage.create = function create(properties) {
            return new AudioMessage(properties);
        };

        /**
         * Encodes the specified AudioMessage message. Does not implicitly {@link proto.AudioMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.AudioMessage
         * @static
         * @param {proto.IAudioMessage} message AudioMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AudioMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.url != null && Object.hasOwnProperty.call(message, "url"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.url);
            if (message.mimetype != null && Object.hasOwnProperty.call(message, "mimetype"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.mimetype);
            if (message.fileSha256 != null && Object.hasOwnProperty.call(message, "fileSha256"))
                writer.uint32(/* id 3, wireType 2 =*/26).bytes(message.fileSha256);
            if (message.fileLength != null && Object.hasOwnProperty.call(message, "fileLength"))
                writer.uint32(/* id 4, wireType 0 =*/32).uint64(message.fileLength);
            if (message.seconds != null && Object.hasOwnProperty.call(message, "seconds"))
                writer.uint32(/* id 5, wireType 0 =*/40).uint32(message.seconds);
            if (message.ptt != null && Object.hasOwnProperty.call(message, "ptt"))
                writer.uint32(/* id 6, wireType 0 =*/48).bool(message.ptt);
            if (message.mediaKey != null && Object.hasOwnProperty.call(message, "mediaKey"))
                writer.uint32(/* id 7, wireType 2 =*/58).bytes(message.mediaKey);
            if (message.fileEncSha256 != null && Object.hasOwnProperty.call(message, "fileEncSha256"))
                writer.uint32(/* id 8, wireType 2 =*/66).bytes(message.fileEncSha256);
            if (message.directPath != null && Object.hasOwnProperty.call(message, "directPath"))
                writer.uint32(/* id 9, wireType 2 =*/74).string(message.directPath);
            if (message.mediaKeyTimestamp != null && Object.hasOwnProperty.call(message, "mediaKeyTimestamp"))
                writer.uint32(/* id 10, wireType 0 =*/80).int64(message.mediaKeyTimestamp);
            if (message.contextInfo != null && Object.hasOwnProperty.call(message, "contextInfo"))
                $root.proto.ContextInfo.encode(message.contextInfo, writer.uint32(/* id 17, wireType 2 =*/138).fork()).ldelim();
            if (message.streamingSidecar != null && Object.hasOwnProperty.call(message, "streamingSidecar"))
                writer.uint32(/* id 18, wireType 2 =*/146).bytes(message.streamingSidecar);
            if (message.waveform != null && Object.hasOwnProperty.call(message, "waveform"))
                writer.uint32(/* id 19, wireType 2 =*/154).bytes(message.waveform);
            return writer;
        };

        /**
         * Encodes the specified AudioMessage message, length delimited. Does not implicitly {@link proto.AudioMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.AudioMessage
         * @static
         * @param {proto.IAudioMessage} message AudioMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AudioMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an AudioMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.AudioMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.AudioMessage} AudioMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AudioMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AudioMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.url = reader.string();
                    break;
                case 2:
                    message.mimetype = reader.string();
                    break;
                case 3:
                    message.fileSha256 = reader.bytes();
                    break;
                case 4:
                    message.fileLength = reader.uint64();
                    break;
                case 5:
                    message.seconds = reader.uint32();
                    break;
                case 6:
                    message.ptt = reader.bool();
                    break;
                case 7:
                    message.mediaKey = reader.bytes();
                    break;
                case 8:
                    message.fileEncSha256 = reader.bytes();
                    break;
                case 9:
                    message.directPath = reader.string();
                    break;
                case 10:
                    message.mediaKeyTimestamp = reader.int64();
                    break;
                case 17:
                    message.contextInfo = $root.proto.ContextInfo.decode(reader, reader.uint32());
                    break;
                case 18:
                    message.streamingSidecar = reader.bytes();
                    break;
                case 19:
                    message.waveform = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an AudioMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.AudioMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.AudioMessage} AudioMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AudioMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an AudioMessage message.
         * @function verify
         * @memberof proto.AudioMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        AudioMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.url != null && message.hasOwnProperty("url"))
                if (!$util.isString(message.url))
                    return "url: string expected";
            if (message.mimetype != null && message.hasOwnProperty("mimetype"))
                if (!$util.isString(message.mimetype))
                    return "mimetype: string expected";
            if (message.fileSha256 != null && message.hasOwnProperty("fileSha256"))
                if (!(message.fileSha256 && typeof message.fileSha256.length === "number" || $util.isString(message.fileSha256)))
                    return "fileSha256: buffer expected";
            if (message.fileLength != null && message.hasOwnProperty("fileLength"))
                if (!$util.isInteger(message.fileLength) && !(message.fileLength && $util.isInteger(message.fileLength.low) && $util.isInteger(message.fileLength.high)))
                    return "fileLength: integer|Long expected";
            if (message.seconds != null && message.hasOwnProperty("seconds"))
                if (!$util.isInteger(message.seconds))
                    return "seconds: integer expected";
            if (message.ptt != null && message.hasOwnProperty("ptt"))
                if (typeof message.ptt !== "boolean")
                    return "ptt: boolean expected";
            if (message.mediaKey != null && message.hasOwnProperty("mediaKey"))
                if (!(message.mediaKey && typeof message.mediaKey.length === "number" || $util.isString(message.mediaKey)))
                    return "mediaKey: buffer expected";
            if (message.fileEncSha256 != null && message.hasOwnProperty("fileEncSha256"))
                if (!(message.fileEncSha256 && typeof message.fileEncSha256.length === "number" || $util.isString(message.fileEncSha256)))
                    return "fileEncSha256: buffer expected";
            if (message.directPath != null && message.hasOwnProperty("directPath"))
                if (!$util.isString(message.directPath))
                    return "directPath: string expected";
            if (message.mediaKeyTimestamp != null && message.hasOwnProperty("mediaKeyTimestamp"))
                if (!$util.isInteger(message.mediaKeyTimestamp) && !(message.mediaKeyTimestamp && $util.isInteger(message.mediaKeyTimestamp.low) && $util.isInteger(message.mediaKeyTimestamp.high)))
                    return "mediaKeyTimestamp: integer|Long expected";
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo")) {
                var error = $root.proto.ContextInfo.verify(message.contextInfo);
                if (error)
                    return "contextInfo." + error;
            }
            if (message.streamingSidecar != null && message.hasOwnProperty("streamingSidecar"))
                if (!(message.streamingSidecar && typeof message.streamingSidecar.length === "number" || $util.isString(message.streamingSidecar)))
                    return "streamingSidecar: buffer expected";
            if (message.waveform != null && message.hasOwnProperty("waveform"))
                if (!(message.waveform && typeof message.waveform.length === "number" || $util.isString(message.waveform)))
                    return "waveform: buffer expected";
            return null;
        };

        /**
         * Creates an AudioMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.AudioMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.AudioMessage} AudioMessage
         */
        AudioMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.AudioMessage)
                return object;
            var message = new $root.proto.AudioMessage();
            if (object.url != null)
                message.url = String(object.url);
            if (object.mimetype != null)
                message.mimetype = String(object.mimetype);
            if (object.fileSha256 != null)
                if (typeof object.fileSha256 === "string")
                    $util.base64.decode(object.fileSha256, message.fileSha256 = $util.newBuffer($util.base64.length(object.fileSha256)), 0);
                else if (object.fileSha256.length)
                    message.fileSha256 = object.fileSha256;
            if (object.fileLength != null)
                if ($util.Long)
                    (message.fileLength = $util.Long.fromValue(object.fileLength)).unsigned = true;
                else if (typeof object.fileLength === "string")
                    message.fileLength = parseInt(object.fileLength, 10);
                else if (typeof object.fileLength === "number")
                    message.fileLength = object.fileLength;
                else if (typeof object.fileLength === "object")
                    message.fileLength = new $util.LongBits(object.fileLength.low >>> 0, object.fileLength.high >>> 0).toNumber(true);
            if (object.seconds != null)
                message.seconds = object.seconds >>> 0;
            if (object.ptt != null)
                message.ptt = Boolean(object.ptt);
            if (object.mediaKey != null)
                if (typeof object.mediaKey === "string")
                    $util.base64.decode(object.mediaKey, message.mediaKey = $util.newBuffer($util.base64.length(object.mediaKey)), 0);
                else if (object.mediaKey.length)
                    message.mediaKey = object.mediaKey;
            if (object.fileEncSha256 != null)
                if (typeof object.fileEncSha256 === "string")
                    $util.base64.decode(object.fileEncSha256, message.fileEncSha256 = $util.newBuffer($util.base64.length(object.fileEncSha256)), 0);
                else if (object.fileEncSha256.length)
                    message.fileEncSha256 = object.fileEncSha256;
            if (object.directPath != null)
                message.directPath = String(object.directPath);
            if (object.mediaKeyTimestamp != null)
                if ($util.Long)
                    (message.mediaKeyTimestamp = $util.Long.fromValue(object.mediaKeyTimestamp)).unsigned = false;
                else if (typeof object.mediaKeyTimestamp === "string")
                    message.mediaKeyTimestamp = parseInt(object.mediaKeyTimestamp, 10);
                else if (typeof object.mediaKeyTimestamp === "number")
                    message.mediaKeyTimestamp = object.mediaKeyTimestamp;
                else if (typeof object.mediaKeyTimestamp === "object")
                    message.mediaKeyTimestamp = new $util.LongBits(object.mediaKeyTimestamp.low >>> 0, object.mediaKeyTimestamp.high >>> 0).toNumber();
            if (object.contextInfo != null) {
                if (typeof object.contextInfo !== "object")
                    throw TypeError(".proto.AudioMessage.contextInfo: object expected");
                message.contextInfo = $root.proto.ContextInfo.fromObject(object.contextInfo);
            }
            if (object.streamingSidecar != null)
                if (typeof object.streamingSidecar === "string")
                    $util.base64.decode(object.streamingSidecar, message.streamingSidecar = $util.newBuffer($util.base64.length(object.streamingSidecar)), 0);
                else if (object.streamingSidecar.length)
                    message.streamingSidecar = object.streamingSidecar;
            if (object.waveform != null)
                if (typeof object.waveform === "string")
                    $util.base64.decode(object.waveform, message.waveform = $util.newBuffer($util.base64.length(object.waveform)), 0);
                else if (object.waveform.length)
                    message.waveform = object.waveform;
            return message;
        };

        /**
         * Creates a plain object from an AudioMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.AudioMessage
         * @static
         * @param {proto.AudioMessage} message AudioMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        AudioMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.url = "";
                object.mimetype = "";
                if (options.bytes === String)
                    object.fileSha256 = "";
                else {
                    object.fileSha256 = [];
                    if (options.bytes !== Array)
                        object.fileSha256 = $util.newBuffer(object.fileSha256);
                }
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.fileLength = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.fileLength = options.longs === String ? "0" : 0;
                object.seconds = 0;
                object.ptt = false;
                if (options.bytes === String)
                    object.mediaKey = "";
                else {
                    object.mediaKey = [];
                    if (options.bytes !== Array)
                        object.mediaKey = $util.newBuffer(object.mediaKey);
                }
                if (options.bytes === String)
                    object.fileEncSha256 = "";
                else {
                    object.fileEncSha256 = [];
                    if (options.bytes !== Array)
                        object.fileEncSha256 = $util.newBuffer(object.fileEncSha256);
                }
                object.directPath = "";
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.mediaKeyTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.mediaKeyTimestamp = options.longs === String ? "0" : 0;
                object.contextInfo = null;
                if (options.bytes === String)
                    object.streamingSidecar = "";
                else {
                    object.streamingSidecar = [];
                    if (options.bytes !== Array)
                        object.streamingSidecar = $util.newBuffer(object.streamingSidecar);
                }
                if (options.bytes === String)
                    object.waveform = "";
                else {
                    object.waveform = [];
                    if (options.bytes !== Array)
                        object.waveform = $util.newBuffer(object.waveform);
                }
            }
            if (message.url != null && message.hasOwnProperty("url"))
                object.url = message.url;
            if (message.mimetype != null && message.hasOwnProperty("mimetype"))
                object.mimetype = message.mimetype;
            if (message.fileSha256 != null && message.hasOwnProperty("fileSha256"))
                object.fileSha256 = options.bytes === String ? $util.base64.encode(message.fileSha256, 0, message.fileSha256.length) : options.bytes === Array ? Array.prototype.slice.call(message.fileSha256) : message.fileSha256;
            if (message.fileLength != null && message.hasOwnProperty("fileLength"))
                if (typeof message.fileLength === "number")
                    object.fileLength = options.longs === String ? String(message.fileLength) : message.fileLength;
                else
                    object.fileLength = options.longs === String ? $util.Long.prototype.toString.call(message.fileLength) : options.longs === Number ? new $util.LongBits(message.fileLength.low >>> 0, message.fileLength.high >>> 0).toNumber(true) : message.fileLength;
            if (message.seconds != null && message.hasOwnProperty("seconds"))
                object.seconds = message.seconds;
            if (message.ptt != null && message.hasOwnProperty("ptt"))
                object.ptt = message.ptt;
            if (message.mediaKey != null && message.hasOwnProperty("mediaKey"))
                object.mediaKey = options.bytes === String ? $util.base64.encode(message.mediaKey, 0, message.mediaKey.length) : options.bytes === Array ? Array.prototype.slice.call(message.mediaKey) : message.mediaKey;
            if (message.fileEncSha256 != null && message.hasOwnProperty("fileEncSha256"))
                object.fileEncSha256 = options.bytes === String ? $util.base64.encode(message.fileEncSha256, 0, message.fileEncSha256.length) : options.bytes === Array ? Array.prototype.slice.call(message.fileEncSha256) : message.fileEncSha256;
            if (message.directPath != null && message.hasOwnProperty("directPath"))
                object.directPath = message.directPath;
            if (message.mediaKeyTimestamp != null && message.hasOwnProperty("mediaKeyTimestamp"))
                if (typeof message.mediaKeyTimestamp === "number")
                    object.mediaKeyTimestamp = options.longs === String ? String(message.mediaKeyTimestamp) : message.mediaKeyTimestamp;
                else
                    object.mediaKeyTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.mediaKeyTimestamp) : options.longs === Number ? new $util.LongBits(message.mediaKeyTimestamp.low >>> 0, message.mediaKeyTimestamp.high >>> 0).toNumber() : message.mediaKeyTimestamp;
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo"))
                object.contextInfo = $root.proto.ContextInfo.toObject(message.contextInfo, options);
            if (message.streamingSidecar != null && message.hasOwnProperty("streamingSidecar"))
                object.streamingSidecar = options.bytes === String ? $util.base64.encode(message.streamingSidecar, 0, message.streamingSidecar.length) : options.bytes === Array ? Array.prototype.slice.call(message.streamingSidecar) : message.streamingSidecar;
            if (message.waveform != null && message.hasOwnProperty("waveform"))
                object.waveform = options.bytes === String ? $util.base64.encode(message.waveform, 0, message.waveform.length) : options.bytes === Array ? Array.prototype.slice.call(message.waveform) : message.waveform;
            return object;
        };

        /**
         * Converts this AudioMessage to JSON.
         * @function toJSON
         * @memberof proto.AudioMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        AudioMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return AudioMessage;
    })();

    proto.Button = (function() {

        /**
         * Properties of a Button.
         * @memberof proto
         * @interface IButton
         * @property {string|null} [buttonId] Button buttonId
         * @property {proto.IButtonText|null} [buttonText] Button buttonText
         * @property {proto.Button.ButtonType|null} [type] Button type
         * @property {proto.INativeFlowInfo|null} [nativeFlowInfo] Button nativeFlowInfo
         */

        /**
         * Constructs a new Button.
         * @memberof proto
         * @classdesc Represents a Button.
         * @implements IButton
         * @constructor
         * @param {proto.IButton=} [properties] Properties to set
         */
        function Button(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Button buttonId.
         * @member {string} buttonId
         * @memberof proto.Button
         * @instance
         */
        Button.prototype.buttonId = "";

        /**
         * Button buttonText.
         * @member {proto.IButtonText|null|undefined} buttonText
         * @memberof proto.Button
         * @instance
         */
        Button.prototype.buttonText = null;

        /**
         * Button type.
         * @member {proto.Button.ButtonType} type
         * @memberof proto.Button
         * @instance
         */
        Button.prototype.type = 0;

        /**
         * Button nativeFlowInfo.
         * @member {proto.INativeFlowInfo|null|undefined} nativeFlowInfo
         * @memberof proto.Button
         * @instance
         */
        Button.prototype.nativeFlowInfo = null;

        /**
         * Creates a new Button instance using the specified properties.
         * @function create
         * @memberof proto.Button
         * @static
         * @param {proto.IButton=} [properties] Properties to set
         * @returns {proto.Button} Button instance
         */
        Button.create = function create(properties) {
            return new Button(properties);
        };

        /**
         * Encodes the specified Button message. Does not implicitly {@link proto.Button.verify|verify} messages.
         * @function encode
         * @memberof proto.Button
         * @static
         * @param {proto.IButton} message Button message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Button.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.buttonId != null && Object.hasOwnProperty.call(message, "buttonId"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.buttonId);
            if (message.buttonText != null && Object.hasOwnProperty.call(message, "buttonText"))
                $root.proto.ButtonText.encode(message.buttonText, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.type != null && Object.hasOwnProperty.call(message, "type"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.type);
            if (message.nativeFlowInfo != null && Object.hasOwnProperty.call(message, "nativeFlowInfo"))
                $root.proto.NativeFlowInfo.encode(message.nativeFlowInfo, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified Button message, length delimited. Does not implicitly {@link proto.Button.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.Button
         * @static
         * @param {proto.IButton} message Button message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Button.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a Button message from the specified reader or buffer.
         * @function decode
         * @memberof proto.Button
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.Button} Button
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Button.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.Button();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.buttonId = reader.string();
                    break;
                case 2:
                    message.buttonText = $root.proto.ButtonText.decode(reader, reader.uint32());
                    break;
                case 3:
                    message.type = reader.int32();
                    break;
                case 4:
                    message.nativeFlowInfo = $root.proto.NativeFlowInfo.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a Button message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.Button
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.Button} Button
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Button.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a Button message.
         * @function verify
         * @memberof proto.Button
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Button.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.buttonId != null && message.hasOwnProperty("buttonId"))
                if (!$util.isString(message.buttonId))
                    return "buttonId: string expected";
            if (message.buttonText != null && message.hasOwnProperty("buttonText")) {
                var error = $root.proto.ButtonText.verify(message.buttonText);
                if (error)
                    return "buttonText." + error;
            }
            if (message.type != null && message.hasOwnProperty("type"))
                switch (message.type) {
                default:
                    return "type: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            if (message.nativeFlowInfo != null && message.hasOwnProperty("nativeFlowInfo")) {
                var error = $root.proto.NativeFlowInfo.verify(message.nativeFlowInfo);
                if (error)
                    return "nativeFlowInfo." + error;
            }
            return null;
        };

        /**
         * Creates a Button message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.Button
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.Button} Button
         */
        Button.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.Button)
                return object;
            var message = new $root.proto.Button();
            if (object.buttonId != null)
                message.buttonId = String(object.buttonId);
            if (object.buttonText != null) {
                if (typeof object.buttonText !== "object")
                    throw TypeError(".proto.Button.buttonText: object expected");
                message.buttonText = $root.proto.ButtonText.fromObject(object.buttonText);
            }
            switch (object.type) {
            case "UNKNOWN":
            case 0:
                message.type = 0;
                break;
            case "RESPONSE":
            case 1:
                message.type = 1;
                break;
            case "NATIVE_FLOW":
            case 2:
                message.type = 2;
                break;
            }
            if (object.nativeFlowInfo != null) {
                if (typeof object.nativeFlowInfo !== "object")
                    throw TypeError(".proto.Button.nativeFlowInfo: object expected");
                message.nativeFlowInfo = $root.proto.NativeFlowInfo.fromObject(object.nativeFlowInfo);
            }
            return message;
        };

        /**
         * Creates a plain object from a Button message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.Button
         * @static
         * @param {proto.Button} message Button
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Button.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.buttonId = "";
                object.buttonText = null;
                object.type = options.enums === String ? "UNKNOWN" : 0;
                object.nativeFlowInfo = null;
            }
            if (message.buttonId != null && message.hasOwnProperty("buttonId"))
                object.buttonId = message.buttonId;
            if (message.buttonText != null && message.hasOwnProperty("buttonText"))
                object.buttonText = $root.proto.ButtonText.toObject(message.buttonText, options);
            if (message.type != null && message.hasOwnProperty("type"))
                object.type = options.enums === String ? $root.proto.Button.ButtonType[message.type] : message.type;
            if (message.nativeFlowInfo != null && message.hasOwnProperty("nativeFlowInfo"))
                object.nativeFlowInfo = $root.proto.NativeFlowInfo.toObject(message.nativeFlowInfo, options);
            return object;
        };

        /**
         * Converts this Button to JSON.
         * @function toJSON
         * @memberof proto.Button
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Button.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * ButtonType enum.
         * @name proto.Button.ButtonType
         * @enum {number}
         * @property {number} UNKNOWN=0 UNKNOWN value
         * @property {number} RESPONSE=1 RESPONSE value
         * @property {number} NATIVE_FLOW=2 NATIVE_FLOW value
         */
        Button.ButtonType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "RESPONSE"] = 1;
            values[valuesById[2] = "NATIVE_FLOW"] = 2;
            return values;
        })();

        return Button;
    })();

    proto.ButtonsMessage = (function() {

        /**
         * Properties of a ButtonsMessage.
         * @memberof proto
         * @interface IButtonsMessage
         * @property {string|null} [contentText] ButtonsMessage contentText
         * @property {string|null} [footerText] ButtonsMessage footerText
         * @property {proto.IContextInfo|null} [contextInfo] ButtonsMessage contextInfo
         * @property {Array.<proto.IButton>|null} [buttons] ButtonsMessage buttons
         * @property {proto.ButtonsMessage.ButtonsMessageHeaderType|null} [headerType] ButtonsMessage headerType
         * @property {string|null} [text] ButtonsMessage text
         * @property {proto.IDocumentMessage|null} [documentMessage] ButtonsMessage documentMessage
         * @property {proto.IImageMessage|null} [imageMessage] ButtonsMessage imageMessage
         * @property {proto.IVideoMessage|null} [videoMessage] ButtonsMessage videoMessage
         * @property {proto.ILocationMessage|null} [locationMessage] ButtonsMessage locationMessage
         */

        /**
         * Constructs a new ButtonsMessage.
         * @memberof proto
         * @classdesc Represents a ButtonsMessage.
         * @implements IButtonsMessage
         * @constructor
         * @param {proto.IButtonsMessage=} [properties] Properties to set
         */
        function ButtonsMessage(properties) {
            this.buttons = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ButtonsMessage contentText.
         * @member {string} contentText
         * @memberof proto.ButtonsMessage
         * @instance
         */
        ButtonsMessage.prototype.contentText = "";

        /**
         * ButtonsMessage footerText.
         * @member {string} footerText
         * @memberof proto.ButtonsMessage
         * @instance
         */
        ButtonsMessage.prototype.footerText = "";

        /**
         * ButtonsMessage contextInfo.
         * @member {proto.IContextInfo|null|undefined} contextInfo
         * @memberof proto.ButtonsMessage
         * @instance
         */
        ButtonsMessage.prototype.contextInfo = null;

        /**
         * ButtonsMessage buttons.
         * @member {Array.<proto.IButton>} buttons
         * @memberof proto.ButtonsMessage
         * @instance
         */
        ButtonsMessage.prototype.buttons = $util.emptyArray;

        /**
         * ButtonsMessage headerType.
         * @member {proto.ButtonsMessage.ButtonsMessageHeaderType} headerType
         * @memberof proto.ButtonsMessage
         * @instance
         */
        ButtonsMessage.prototype.headerType = 0;

        /**
         * ButtonsMessage text.
         * @member {string|null|undefined} text
         * @memberof proto.ButtonsMessage
         * @instance
         */
        ButtonsMessage.prototype.text = null;

        /**
         * ButtonsMessage documentMessage.
         * @member {proto.IDocumentMessage|null|undefined} documentMessage
         * @memberof proto.ButtonsMessage
         * @instance
         */
        ButtonsMessage.prototype.documentMessage = null;

        /**
         * ButtonsMessage imageMessage.
         * @member {proto.IImageMessage|null|undefined} imageMessage
         * @memberof proto.ButtonsMessage
         * @instance
         */
        ButtonsMessage.prototype.imageMessage = null;

        /**
         * ButtonsMessage videoMessage.
         * @member {proto.IVideoMessage|null|undefined} videoMessage
         * @memberof proto.ButtonsMessage
         * @instance
         */
        ButtonsMessage.prototype.videoMessage = null;

        /**
         * ButtonsMessage locationMessage.
         * @member {proto.ILocationMessage|null|undefined} locationMessage
         * @memberof proto.ButtonsMessage
         * @instance
         */
        ButtonsMessage.prototype.locationMessage = null;

        // OneOf field names bound to virtual getters and setters
        var $oneOfFields;

        /**
         * ButtonsMessage header.
         * @member {"text"|"documentMessage"|"imageMessage"|"videoMessage"|"locationMessage"|undefined} header
         * @memberof proto.ButtonsMessage
         * @instance
         */
        Object.defineProperty(ButtonsMessage.prototype, "header", {
            get: $util.oneOfGetter($oneOfFields = ["text", "documentMessage", "imageMessage", "videoMessage", "locationMessage"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new ButtonsMessage instance using the specified properties.
         * @function create
         * @memberof proto.ButtonsMessage
         * @static
         * @param {proto.IButtonsMessage=} [properties] Properties to set
         * @returns {proto.ButtonsMessage} ButtonsMessage instance
         */
        ButtonsMessage.create = function create(properties) {
            return new ButtonsMessage(properties);
        };

        /**
         * Encodes the specified ButtonsMessage message. Does not implicitly {@link proto.ButtonsMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.ButtonsMessage
         * @static
         * @param {proto.IButtonsMessage} message ButtonsMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ButtonsMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.text != null && Object.hasOwnProperty.call(message, "text"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.text);
            if (message.documentMessage != null && Object.hasOwnProperty.call(message, "documentMessage"))
                $root.proto.DocumentMessage.encode(message.documentMessage, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.imageMessage != null && Object.hasOwnProperty.call(message, "imageMessage"))
                $root.proto.ImageMessage.encode(message.imageMessage, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            if (message.videoMessage != null && Object.hasOwnProperty.call(message, "videoMessage"))
                $root.proto.VideoMessage.encode(message.videoMessage, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
            if (message.locationMessage != null && Object.hasOwnProperty.call(message, "locationMessage"))
                $root.proto.LocationMessage.encode(message.locationMessage, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
            if (message.contentText != null && Object.hasOwnProperty.call(message, "contentText"))
                writer.uint32(/* id 6, wireType 2 =*/50).string(message.contentText);
            if (message.footerText != null && Object.hasOwnProperty.call(message, "footerText"))
                writer.uint32(/* id 7, wireType 2 =*/58).string(message.footerText);
            if (message.contextInfo != null && Object.hasOwnProperty.call(message, "contextInfo"))
                $root.proto.ContextInfo.encode(message.contextInfo, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
            if (message.buttons != null && message.buttons.length)
                for (var i = 0; i < message.buttons.length; ++i)
                    $root.proto.Button.encode(message.buttons[i], writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
            if (message.headerType != null && Object.hasOwnProperty.call(message, "headerType"))
                writer.uint32(/* id 10, wireType 0 =*/80).int32(message.headerType);
            return writer;
        };

        /**
         * Encodes the specified ButtonsMessage message, length delimited. Does not implicitly {@link proto.ButtonsMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ButtonsMessage
         * @static
         * @param {proto.IButtonsMessage} message ButtonsMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ButtonsMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ButtonsMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ButtonsMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ButtonsMessage} ButtonsMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ButtonsMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ButtonsMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 6:
                    message.contentText = reader.string();
                    break;
                case 7:
                    message.footerText = reader.string();
                    break;
                case 8:
                    message.contextInfo = $root.proto.ContextInfo.decode(reader, reader.uint32());
                    break;
                case 9:
                    if (!(message.buttons && message.buttons.length))
                        message.buttons = [];
                    message.buttons.push($root.proto.Button.decode(reader, reader.uint32()));
                    break;
                case 10:
                    message.headerType = reader.int32();
                    break;
                case 1:
                    message.text = reader.string();
                    break;
                case 2:
                    message.documentMessage = $root.proto.DocumentMessage.decode(reader, reader.uint32());
                    break;
                case 3:
                    message.imageMessage = $root.proto.ImageMessage.decode(reader, reader.uint32());
                    break;
                case 4:
                    message.videoMessage = $root.proto.VideoMessage.decode(reader, reader.uint32());
                    break;
                case 5:
                    message.locationMessage = $root.proto.LocationMessage.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ButtonsMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ButtonsMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ButtonsMessage} ButtonsMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ButtonsMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ButtonsMessage message.
         * @function verify
         * @memberof proto.ButtonsMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ButtonsMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            var properties = {};
            if (message.contentText != null && message.hasOwnProperty("contentText"))
                if (!$util.isString(message.contentText))
                    return "contentText: string expected";
            if (message.footerText != null && message.hasOwnProperty("footerText"))
                if (!$util.isString(message.footerText))
                    return "footerText: string expected";
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo")) {
                var error = $root.proto.ContextInfo.verify(message.contextInfo);
                if (error)
                    return "contextInfo." + error;
            }
            if (message.buttons != null && message.hasOwnProperty("buttons")) {
                if (!Array.isArray(message.buttons))
                    return "buttons: array expected";
                for (var i = 0; i < message.buttons.length; ++i) {
                    var error = $root.proto.Button.verify(message.buttons[i]);
                    if (error)
                        return "buttons." + error;
                }
            }
            if (message.headerType != null && message.hasOwnProperty("headerType"))
                switch (message.headerType) {
                default:
                    return "headerType: enum value expected";
                case 0:
                case 1:
                case 2:
                case 3:
                case 4:
                case 5:
                case 6:
                    break;
                }
            if (message.text != null && message.hasOwnProperty("text")) {
                properties.header = 1;
                if (!$util.isString(message.text))
                    return "text: string expected";
            }
            if (message.documentMessage != null && message.hasOwnProperty("documentMessage")) {
                if (properties.header === 1)
                    return "header: multiple values";
                properties.header = 1;
                {
                    var error = $root.proto.DocumentMessage.verify(message.documentMessage);
                    if (error)
                        return "documentMessage." + error;
                }
            }
            if (message.imageMessage != null && message.hasOwnProperty("imageMessage")) {
                if (properties.header === 1)
                    return "header: multiple values";
                properties.header = 1;
                {
                    var error = $root.proto.ImageMessage.verify(message.imageMessage);
                    if (error)
                        return "imageMessage." + error;
                }
            }
            if (message.videoMessage != null && message.hasOwnProperty("videoMessage")) {
                if (properties.header === 1)
                    return "header: multiple values";
                properties.header = 1;
                {
                    var error = $root.proto.VideoMessage.verify(message.videoMessage);
                    if (error)
                        return "videoMessage." + error;
                }
            }
            if (message.locationMessage != null && message.hasOwnProperty("locationMessage")) {
                if (properties.header === 1)
                    return "header: multiple values";
                properties.header = 1;
                {
                    var error = $root.proto.LocationMessage.verify(message.locationMessage);
                    if (error)
                        return "locationMessage." + error;
                }
            }
            return null;
        };

        /**
         * Creates a ButtonsMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ButtonsMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ButtonsMessage} ButtonsMessage
         */
        ButtonsMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ButtonsMessage)
                return object;
            var message = new $root.proto.ButtonsMessage();
            if (object.contentText != null)
                message.contentText = String(object.contentText);
            if (object.footerText != null)
                message.footerText = String(object.footerText);
            if (object.contextInfo != null) {
                if (typeof object.contextInfo !== "object")
                    throw TypeError(".proto.ButtonsMessage.contextInfo: object expected");
                message.contextInfo = $root.proto.ContextInfo.fromObject(object.contextInfo);
            }
            if (object.buttons) {
                if (!Array.isArray(object.buttons))
                    throw TypeError(".proto.ButtonsMessage.buttons: array expected");
                message.buttons = [];
                for (var i = 0; i < object.buttons.length; ++i) {
                    if (typeof object.buttons[i] !== "object")
                        throw TypeError(".proto.ButtonsMessage.buttons: object expected");
                    message.buttons[i] = $root.proto.Button.fromObject(object.buttons[i]);
                }
            }
            switch (object.headerType) {
            case "UNKNOWN":
            case 0:
                message.headerType = 0;
                break;
            case "EMPTY":
            case 1:
                message.headerType = 1;
                break;
            case "TEXT":
            case 2:
                message.headerType = 2;
                break;
            case "DOCUMENT":
            case 3:
                message.headerType = 3;
                break;
            case "IMAGE":
            case 4:
                message.headerType = 4;
                break;
            case "VIDEO":
            case 5:
                message.headerType = 5;
                break;
            case "LOCATION":
            case 6:
                message.headerType = 6;
                break;
            }
            if (object.text != null)
                message.text = String(object.text);
            if (object.documentMessage != null) {
                if (typeof object.documentMessage !== "object")
                    throw TypeError(".proto.ButtonsMessage.documentMessage: object expected");
                message.documentMessage = $root.proto.DocumentMessage.fromObject(object.documentMessage);
            }
            if (object.imageMessage != null) {
                if (typeof object.imageMessage !== "object")
                    throw TypeError(".proto.ButtonsMessage.imageMessage: object expected");
                message.imageMessage = $root.proto.ImageMessage.fromObject(object.imageMessage);
            }
            if (object.videoMessage != null) {
                if (typeof object.videoMessage !== "object")
                    throw TypeError(".proto.ButtonsMessage.videoMessage: object expected");
                message.videoMessage = $root.proto.VideoMessage.fromObject(object.videoMessage);
            }
            if (object.locationMessage != null) {
                if (typeof object.locationMessage !== "object")
                    throw TypeError(".proto.ButtonsMessage.locationMessage: object expected");
                message.locationMessage = $root.proto.LocationMessage.fromObject(object.locationMessage);
            }
            return message;
        };

        /**
         * Creates a plain object from a ButtonsMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ButtonsMessage
         * @static
         * @param {proto.ButtonsMessage} message ButtonsMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ButtonsMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.buttons = [];
            if (options.defaults) {
                object.contentText = "";
                object.footerText = "";
                object.contextInfo = null;
                object.headerType = options.enums === String ? "UNKNOWN" : 0;
            }
            if (message.text != null && message.hasOwnProperty("text")) {
                object.text = message.text;
                if (options.oneofs)
                    object.header = "text";
            }
            if (message.documentMessage != null && message.hasOwnProperty("documentMessage")) {
                object.documentMessage = $root.proto.DocumentMessage.toObject(message.documentMessage, options);
                if (options.oneofs)
                    object.header = "documentMessage";
            }
            if (message.imageMessage != null && message.hasOwnProperty("imageMessage")) {
                object.imageMessage = $root.proto.ImageMessage.toObject(message.imageMessage, options);
                if (options.oneofs)
                    object.header = "imageMessage";
            }
            if (message.videoMessage != null && message.hasOwnProperty("videoMessage")) {
                object.videoMessage = $root.proto.VideoMessage.toObject(message.videoMessage, options);
                if (options.oneofs)
                    object.header = "videoMessage";
            }
            if (message.locationMessage != null && message.hasOwnProperty("locationMessage")) {
                object.locationMessage = $root.proto.LocationMessage.toObject(message.locationMessage, options);
                if (options.oneofs)
                    object.header = "locationMessage";
            }
            if (message.contentText != null && message.hasOwnProperty("contentText"))
                object.contentText = message.contentText;
            if (message.footerText != null && message.hasOwnProperty("footerText"))
                object.footerText = message.footerText;
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo"))
                object.contextInfo = $root.proto.ContextInfo.toObject(message.contextInfo, options);
            if (message.buttons && message.buttons.length) {
                object.buttons = [];
                for (var j = 0; j < message.buttons.length; ++j)
                    object.buttons[j] = $root.proto.Button.toObject(message.buttons[j], options);
            }
            if (message.headerType != null && message.hasOwnProperty("headerType"))
                object.headerType = options.enums === String ? $root.proto.ButtonsMessage.ButtonsMessageHeaderType[message.headerType] : message.headerType;
            return object;
        };

        /**
         * Converts this ButtonsMessage to JSON.
         * @function toJSON
         * @memberof proto.ButtonsMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ButtonsMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * ButtonsMessageHeaderType enum.
         * @name proto.ButtonsMessage.ButtonsMessageHeaderType
         * @enum {number}
         * @property {number} UNKNOWN=0 UNKNOWN value
         * @property {number} EMPTY=1 EMPTY value
         * @property {number} TEXT=2 TEXT value
         * @property {number} DOCUMENT=3 DOCUMENT value
         * @property {number} IMAGE=4 IMAGE value
         * @property {number} VIDEO=5 VIDEO value
         * @property {number} LOCATION=6 LOCATION value
         */
        ButtonsMessage.ButtonsMessageHeaderType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "EMPTY"] = 1;
            values[valuesById[2] = "TEXT"] = 2;
            values[valuesById[3] = "DOCUMENT"] = 3;
            values[valuesById[4] = "IMAGE"] = 4;
            values[valuesById[5] = "VIDEO"] = 5;
            values[valuesById[6] = "LOCATION"] = 6;
            return values;
        })();

        return ButtonsMessage;
    })();

    proto.ButtonsResponseMessage = (function() {

        /**
         * Properties of a ButtonsResponseMessage.
         * @memberof proto
         * @interface IButtonsResponseMessage
         * @property {string|null} [selectedButtonId] ButtonsResponseMessage selectedButtonId
         * @property {proto.IContextInfo|null} [contextInfo] ButtonsResponseMessage contextInfo
         * @property {proto.ButtonsResponseMessage.ButtonsResponseMessageType|null} [type] ButtonsResponseMessage type
         * @property {string|null} [selectedDisplayText] ButtonsResponseMessage selectedDisplayText
         */

        /**
         * Constructs a new ButtonsResponseMessage.
         * @memberof proto
         * @classdesc Represents a ButtonsResponseMessage.
         * @implements IButtonsResponseMessage
         * @constructor
         * @param {proto.IButtonsResponseMessage=} [properties] Properties to set
         */
        function ButtonsResponseMessage(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ButtonsResponseMessage selectedButtonId.
         * @member {string} selectedButtonId
         * @memberof proto.ButtonsResponseMessage
         * @instance
         */
        ButtonsResponseMessage.prototype.selectedButtonId = "";

        /**
         * ButtonsResponseMessage contextInfo.
         * @member {proto.IContextInfo|null|undefined} contextInfo
         * @memberof proto.ButtonsResponseMessage
         * @instance
         */
        ButtonsResponseMessage.prototype.contextInfo = null;

        /**
         * ButtonsResponseMessage type.
         * @member {proto.ButtonsResponseMessage.ButtonsResponseMessageType} type
         * @memberof proto.ButtonsResponseMessage
         * @instance
         */
        ButtonsResponseMessage.prototype.type = 0;

        /**
         * ButtonsResponseMessage selectedDisplayText.
         * @member {string|null|undefined} selectedDisplayText
         * @memberof proto.ButtonsResponseMessage
         * @instance
         */
        ButtonsResponseMessage.prototype.selectedDisplayText = null;

        // OneOf field names bound to virtual getters and setters
        var $oneOfFields;

        /**
         * ButtonsResponseMessage response.
         * @member {"selectedDisplayText"|undefined} response
         * @memberof proto.ButtonsResponseMessage
         * @instance
         */
        Object.defineProperty(ButtonsResponseMessage.prototype, "response", {
            get: $util.oneOfGetter($oneOfFields = ["selectedDisplayText"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new ButtonsResponseMessage instance using the specified properties.
         * @function create
         * @memberof proto.ButtonsResponseMessage
         * @static
         * @param {proto.IButtonsResponseMessage=} [properties] Properties to set
         * @returns {proto.ButtonsResponseMessage} ButtonsResponseMessage instance
         */
        ButtonsResponseMessage.create = function create(properties) {
            return new ButtonsResponseMessage(properties);
        };

        /**
         * Encodes the specified ButtonsResponseMessage message. Does not implicitly {@link proto.ButtonsResponseMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.ButtonsResponseMessage
         * @static
         * @param {proto.IButtonsResponseMessage} message ButtonsResponseMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ButtonsResponseMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.selectedButtonId != null && Object.hasOwnProperty.call(message, "selectedButtonId"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.selectedButtonId);
            if (message.selectedDisplayText != null && Object.hasOwnProperty.call(message, "selectedDisplayText"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.selectedDisplayText);
            if (message.contextInfo != null && Object.hasOwnProperty.call(message, "contextInfo"))
                $root.proto.ContextInfo.encode(message.contextInfo, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            if (message.type != null && Object.hasOwnProperty.call(message, "type"))
                writer.uint32(/* id 4, wireType 0 =*/32).int32(message.type);
            return writer;
        };

        /**
         * Encodes the specified ButtonsResponseMessage message, length delimited. Does not implicitly {@link proto.ButtonsResponseMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ButtonsResponseMessage
         * @static
         * @param {proto.IButtonsResponseMessage} message ButtonsResponseMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ButtonsResponseMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ButtonsResponseMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ButtonsResponseMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ButtonsResponseMessage} ButtonsResponseMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ButtonsResponseMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ButtonsResponseMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.selectedButtonId = reader.string();
                    break;
                case 3:
                    message.contextInfo = $root.proto.ContextInfo.decode(reader, reader.uint32());
                    break;
                case 4:
                    message.type = reader.int32();
                    break;
                case 2:
                    message.selectedDisplayText = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ButtonsResponseMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ButtonsResponseMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ButtonsResponseMessage} ButtonsResponseMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ButtonsResponseMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ButtonsResponseMessage message.
         * @function verify
         * @memberof proto.ButtonsResponseMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ButtonsResponseMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            var properties = {};
            if (message.selectedButtonId != null && message.hasOwnProperty("selectedButtonId"))
                if (!$util.isString(message.selectedButtonId))
                    return "selectedButtonId: string expected";
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo")) {
                var error = $root.proto.ContextInfo.verify(message.contextInfo);
                if (error)
                    return "contextInfo." + error;
            }
            if (message.type != null && message.hasOwnProperty("type"))
                switch (message.type) {
                default:
                    return "type: enum value expected";
                case 0:
                case 1:
                    break;
                }
            if (message.selectedDisplayText != null && message.hasOwnProperty("selectedDisplayText")) {
                properties.response = 1;
                if (!$util.isString(message.selectedDisplayText))
                    return "selectedDisplayText: string expected";
            }
            return null;
        };

        /**
         * Creates a ButtonsResponseMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ButtonsResponseMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ButtonsResponseMessage} ButtonsResponseMessage
         */
        ButtonsResponseMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ButtonsResponseMessage)
                return object;
            var message = new $root.proto.ButtonsResponseMessage();
            if (object.selectedButtonId != null)
                message.selectedButtonId = String(object.selectedButtonId);
            if (object.contextInfo != null) {
                if (typeof object.contextInfo !== "object")
                    throw TypeError(".proto.ButtonsResponseMessage.contextInfo: object expected");
                message.contextInfo = $root.proto.ContextInfo.fromObject(object.contextInfo);
            }
            switch (object.type) {
            case "UNKNOWN":
            case 0:
                message.type = 0;
                break;
            case "DISPLAY_TEXT":
            case 1:
                message.type = 1;
                break;
            }
            if (object.selectedDisplayText != null)
                message.selectedDisplayText = String(object.selectedDisplayText);
            return message;
        };

        /**
         * Creates a plain object from a ButtonsResponseMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ButtonsResponseMessage
         * @static
         * @param {proto.ButtonsResponseMessage} message ButtonsResponseMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ButtonsResponseMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.selectedButtonId = "";
                object.contextInfo = null;
                object.type = options.enums === String ? "UNKNOWN" : 0;
            }
            if (message.selectedButtonId != null && message.hasOwnProperty("selectedButtonId"))
                object.selectedButtonId = message.selectedButtonId;
            if (message.selectedDisplayText != null && message.hasOwnProperty("selectedDisplayText")) {
                object.selectedDisplayText = message.selectedDisplayText;
                if (options.oneofs)
                    object.response = "selectedDisplayText";
            }
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo"))
                object.contextInfo = $root.proto.ContextInfo.toObject(message.contextInfo, options);
            if (message.type != null && message.hasOwnProperty("type"))
                object.type = options.enums === String ? $root.proto.ButtonsResponseMessage.ButtonsResponseMessageType[message.type] : message.type;
            return object;
        };

        /**
         * Converts this ButtonsResponseMessage to JSON.
         * @function toJSON
         * @memberof proto.ButtonsResponseMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ButtonsResponseMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * ButtonsResponseMessageType enum.
         * @name proto.ButtonsResponseMessage.ButtonsResponseMessageType
         * @enum {number}
         * @property {number} UNKNOWN=0 UNKNOWN value
         * @property {number} DISPLAY_TEXT=1 DISPLAY_TEXT value
         */
        ButtonsResponseMessage.ButtonsResponseMessageType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "DISPLAY_TEXT"] = 1;
            return values;
        })();

        return ButtonsResponseMessage;
    })();

    proto.ButtonText = (function() {

        /**
         * Properties of a ButtonText.
         * @memberof proto
         * @interface IButtonText
         * @property {string|null} [displayText] ButtonText displayText
         */

        /**
         * Constructs a new ButtonText.
         * @memberof proto
         * @classdesc Represents a ButtonText.
         * @implements IButtonText
         * @constructor
         * @param {proto.IButtonText=} [properties] Properties to set
         */
        function ButtonText(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ButtonText displayText.
         * @member {string} displayText
         * @memberof proto.ButtonText
         * @instance
         */
        ButtonText.prototype.displayText = "";

        /**
         * Creates a new ButtonText instance using the specified properties.
         * @function create
         * @memberof proto.ButtonText
         * @static
         * @param {proto.IButtonText=} [properties] Properties to set
         * @returns {proto.ButtonText} ButtonText instance
         */
        ButtonText.create = function create(properties) {
            return new ButtonText(properties);
        };

        /**
         * Encodes the specified ButtonText message. Does not implicitly {@link proto.ButtonText.verify|verify} messages.
         * @function encode
         * @memberof proto.ButtonText
         * @static
         * @param {proto.IButtonText} message ButtonText message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ButtonText.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.displayText != null && Object.hasOwnProperty.call(message, "displayText"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.displayText);
            return writer;
        };

        /**
         * Encodes the specified ButtonText message, length delimited. Does not implicitly {@link proto.ButtonText.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ButtonText
         * @static
         * @param {proto.IButtonText} message ButtonText message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ButtonText.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ButtonText message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ButtonText
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ButtonText} ButtonText
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ButtonText.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ButtonText();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.displayText = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ButtonText message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ButtonText
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ButtonText} ButtonText
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ButtonText.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ButtonText message.
         * @function verify
         * @memberof proto.ButtonText
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ButtonText.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.displayText != null && message.hasOwnProperty("displayText"))
                if (!$util.isString(message.displayText))
                    return "displayText: string expected";
            return null;
        };

        /**
         * Creates a ButtonText message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ButtonText
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ButtonText} ButtonText
         */
        ButtonText.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ButtonText)
                return object;
            var message = new $root.proto.ButtonText();
            if (object.displayText != null)
                message.displayText = String(object.displayText);
            return message;
        };

        /**
         * Creates a plain object from a ButtonText message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ButtonText
         * @static
         * @param {proto.ButtonText} message ButtonText
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ButtonText.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.displayText = "";
            if (message.displayText != null && message.hasOwnProperty("displayText"))
                object.displayText = message.displayText;
            return object;
        };

        /**
         * Converts this ButtonText to JSON.
         * @function toJSON
         * @memberof proto.ButtonText
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ButtonText.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ButtonText;
    })();

    proto.Call = (function() {

        /**
         * Properties of a Call.
         * @memberof proto
         * @interface ICall
         * @property {Uint8Array|null} [callKey] Call callKey
         * @property {string|null} [conversionSource] Call conversionSource
         * @property {Uint8Array|null} [conversionData] Call conversionData
         * @property {number|null} [conversionDelaySeconds] Call conversionDelaySeconds
         */

        /**
         * Constructs a new Call.
         * @memberof proto
         * @classdesc Represents a Call.
         * @implements ICall
         * @constructor
         * @param {proto.ICall=} [properties] Properties to set
         */
        function Call(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Call callKey.
         * @member {Uint8Array} callKey
         * @memberof proto.Call
         * @instance
         */
        Call.prototype.callKey = $util.newBuffer([]);

        /**
         * Call conversionSource.
         * @member {string} conversionSource
         * @memberof proto.Call
         * @instance
         */
        Call.prototype.conversionSource = "";

        /**
         * Call conversionData.
         * @member {Uint8Array} conversionData
         * @memberof proto.Call
         * @instance
         */
        Call.prototype.conversionData = $util.newBuffer([]);

        /**
         * Call conversionDelaySeconds.
         * @member {number} conversionDelaySeconds
         * @memberof proto.Call
         * @instance
         */
        Call.prototype.conversionDelaySeconds = 0;

        /**
         * Creates a new Call instance using the specified properties.
         * @function create
         * @memberof proto.Call
         * @static
         * @param {proto.ICall=} [properties] Properties to set
         * @returns {proto.Call} Call instance
         */
        Call.create = function create(properties) {
            return new Call(properties);
        };

        /**
         * Encodes the specified Call message. Does not implicitly {@link proto.Call.verify|verify} messages.
         * @function encode
         * @memberof proto.Call
         * @static
         * @param {proto.ICall} message Call message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Call.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.callKey != null && Object.hasOwnProperty.call(message, "callKey"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.callKey);
            if (message.conversionSource != null && Object.hasOwnProperty.call(message, "conversionSource"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.conversionSource);
            if (message.conversionData != null && Object.hasOwnProperty.call(message, "conversionData"))
                writer.uint32(/* id 3, wireType 2 =*/26).bytes(message.conversionData);
            if (message.conversionDelaySeconds != null && Object.hasOwnProperty.call(message, "conversionDelaySeconds"))
                writer.uint32(/* id 4, wireType 0 =*/32).uint32(message.conversionDelaySeconds);
            return writer;
        };

        /**
         * Encodes the specified Call message, length delimited. Does not implicitly {@link proto.Call.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.Call
         * @static
         * @param {proto.ICall} message Call message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Call.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a Call message from the specified reader or buffer.
         * @function decode
         * @memberof proto.Call
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.Call} Call
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Call.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.Call();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.callKey = reader.bytes();
                    break;
                case 2:
                    message.conversionSource = reader.string();
                    break;
                case 3:
                    message.conversionData = reader.bytes();
                    break;
                case 4:
                    message.conversionDelaySeconds = reader.uint32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a Call message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.Call
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.Call} Call
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Call.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a Call message.
         * @function verify
         * @memberof proto.Call
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Call.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.callKey != null && message.hasOwnProperty("callKey"))
                if (!(message.callKey && typeof message.callKey.length === "number" || $util.isString(message.callKey)))
                    return "callKey: buffer expected";
            if (message.conversionSource != null && message.hasOwnProperty("conversionSource"))
                if (!$util.isString(message.conversionSource))
                    return "conversionSource: string expected";
            if (message.conversionData != null && message.hasOwnProperty("conversionData"))
                if (!(message.conversionData && typeof message.conversionData.length === "number" || $util.isString(message.conversionData)))
                    return "conversionData: buffer expected";
            if (message.conversionDelaySeconds != null && message.hasOwnProperty("conversionDelaySeconds"))
                if (!$util.isInteger(message.conversionDelaySeconds))
                    return "conversionDelaySeconds: integer expected";
            return null;
        };

        /**
         * Creates a Call message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.Call
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.Call} Call
         */
        Call.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.Call)
                return object;
            var message = new $root.proto.Call();
            if (object.callKey != null)
                if (typeof object.callKey === "string")
                    $util.base64.decode(object.callKey, message.callKey = $util.newBuffer($util.base64.length(object.callKey)), 0);
                else if (object.callKey.length)
                    message.callKey = object.callKey;
            if (object.conversionSource != null)
                message.conversionSource = String(object.conversionSource);
            if (object.conversionData != null)
                if (typeof object.conversionData === "string")
                    $util.base64.decode(object.conversionData, message.conversionData = $util.newBuffer($util.base64.length(object.conversionData)), 0);
                else if (object.conversionData.length)
                    message.conversionData = object.conversionData;
            if (object.conversionDelaySeconds != null)
                message.conversionDelaySeconds = object.conversionDelaySeconds >>> 0;
            return message;
        };

        /**
         * Creates a plain object from a Call message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.Call
         * @static
         * @param {proto.Call} message Call
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Call.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if (options.bytes === String)
                    object.callKey = "";
                else {
                    object.callKey = [];
                    if (options.bytes !== Array)
                        object.callKey = $util.newBuffer(object.callKey);
                }
                object.conversionSource = "";
                if (options.bytes === String)
                    object.conversionData = "";
                else {
                    object.conversionData = [];
                    if (options.bytes !== Array)
                        object.conversionData = $util.newBuffer(object.conversionData);
                }
                object.conversionDelaySeconds = 0;
            }
            if (message.callKey != null && message.hasOwnProperty("callKey"))
                object.callKey = options.bytes === String ? $util.base64.encode(message.callKey, 0, message.callKey.length) : options.bytes === Array ? Array.prototype.slice.call(message.callKey) : message.callKey;
            if (message.conversionSource != null && message.hasOwnProperty("conversionSource"))
                object.conversionSource = message.conversionSource;
            if (message.conversionData != null && message.hasOwnProperty("conversionData"))
                object.conversionData = options.bytes === String ? $util.base64.encode(message.conversionData, 0, message.conversionData.length) : options.bytes === Array ? Array.prototype.slice.call(message.conversionData) : message.conversionData;
            if (message.conversionDelaySeconds != null && message.hasOwnProperty("conversionDelaySeconds"))
                object.conversionDelaySeconds = message.conversionDelaySeconds;
            return object;
        };

        /**
         * Converts this Call to JSON.
         * @function toJSON
         * @memberof proto.Call
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Call.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return Call;
    })();

    proto.CallButton = (function() {

        /**
         * Properties of a CallButton.
         * @memberof proto
         * @interface ICallButton
         * @property {proto.IHighlyStructuredMessage|null} [displayText] CallButton displayText
         * @property {proto.IHighlyStructuredMessage|null} [phoneNumber] CallButton phoneNumber
         */

        /**
         * Constructs a new CallButton.
         * @memberof proto
         * @classdesc Represents a CallButton.
         * @implements ICallButton
         * @constructor
         * @param {proto.ICallButton=} [properties] Properties to set
         */
        function CallButton(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * CallButton displayText.
         * @member {proto.IHighlyStructuredMessage|null|undefined} displayText
         * @memberof proto.CallButton
         * @instance
         */
        CallButton.prototype.displayText = null;

        /**
         * CallButton phoneNumber.
         * @member {proto.IHighlyStructuredMessage|null|undefined} phoneNumber
         * @memberof proto.CallButton
         * @instance
         */
        CallButton.prototype.phoneNumber = null;

        /**
         * Creates a new CallButton instance using the specified properties.
         * @function create
         * @memberof proto.CallButton
         * @static
         * @param {proto.ICallButton=} [properties] Properties to set
         * @returns {proto.CallButton} CallButton instance
         */
        CallButton.create = function create(properties) {
            return new CallButton(properties);
        };

        /**
         * Encodes the specified CallButton message. Does not implicitly {@link proto.CallButton.verify|verify} messages.
         * @function encode
         * @memberof proto.CallButton
         * @static
         * @param {proto.ICallButton} message CallButton message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CallButton.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.displayText != null && Object.hasOwnProperty.call(message, "displayText"))
                $root.proto.HighlyStructuredMessage.encode(message.displayText, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.phoneNumber != null && Object.hasOwnProperty.call(message, "phoneNumber"))
                $root.proto.HighlyStructuredMessage.encode(message.phoneNumber, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified CallButton message, length delimited. Does not implicitly {@link proto.CallButton.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.CallButton
         * @static
         * @param {proto.ICallButton} message CallButton message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CallButton.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a CallButton message from the specified reader or buffer.
         * @function decode
         * @memberof proto.CallButton
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.CallButton} CallButton
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CallButton.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.CallButton();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.displayText = $root.proto.HighlyStructuredMessage.decode(reader, reader.uint32());
                    break;
                case 2:
                    message.phoneNumber = $root.proto.HighlyStructuredMessage.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a CallButton message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.CallButton
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.CallButton} CallButton
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CallButton.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a CallButton message.
         * @function verify
         * @memberof proto.CallButton
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        CallButton.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.displayText != null && message.hasOwnProperty("displayText")) {
                var error = $root.proto.HighlyStructuredMessage.verify(message.displayText);
                if (error)
                    return "displayText." + error;
            }
            if (message.phoneNumber != null && message.hasOwnProperty("phoneNumber")) {
                var error = $root.proto.HighlyStructuredMessage.verify(message.phoneNumber);
                if (error)
                    return "phoneNumber." + error;
            }
            return null;
        };

        /**
         * Creates a CallButton message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.CallButton
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.CallButton} CallButton
         */
        CallButton.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.CallButton)
                return object;
            var message = new $root.proto.CallButton();
            if (object.displayText != null) {
                if (typeof object.displayText !== "object")
                    throw TypeError(".proto.CallButton.displayText: object expected");
                message.displayText = $root.proto.HighlyStructuredMessage.fromObject(object.displayText);
            }
            if (object.phoneNumber != null) {
                if (typeof object.phoneNumber !== "object")
                    throw TypeError(".proto.CallButton.phoneNumber: object expected");
                message.phoneNumber = $root.proto.HighlyStructuredMessage.fromObject(object.phoneNumber);
            }
            return message;
        };

        /**
         * Creates a plain object from a CallButton message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.CallButton
         * @static
         * @param {proto.CallButton} message CallButton
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        CallButton.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.displayText = null;
                object.phoneNumber = null;
            }
            if (message.displayText != null && message.hasOwnProperty("displayText"))
                object.displayText = $root.proto.HighlyStructuredMessage.toObject(message.displayText, options);
            if (message.phoneNumber != null && message.hasOwnProperty("phoneNumber"))
                object.phoneNumber = $root.proto.HighlyStructuredMessage.toObject(message.phoneNumber, options);
            return object;
        };

        /**
         * Converts this CallButton to JSON.
         * @function toJSON
         * @memberof proto.CallButton
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        CallButton.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return CallButton;
    })();

    proto.CancelPaymentRequestMessage = (function() {

        /**
         * Properties of a CancelPaymentRequestMessage.
         * @memberof proto
         * @interface ICancelPaymentRequestMessage
         * @property {proto.IMessageKey|null} [key] CancelPaymentRequestMessage key
         */

        /**
         * Constructs a new CancelPaymentRequestMessage.
         * @memberof proto
         * @classdesc Represents a CancelPaymentRequestMessage.
         * @implements ICancelPaymentRequestMessage
         * @constructor
         * @param {proto.ICancelPaymentRequestMessage=} [properties] Properties to set
         */
        function CancelPaymentRequestMessage(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * CancelPaymentRequestMessage key.
         * @member {proto.IMessageKey|null|undefined} key
         * @memberof proto.CancelPaymentRequestMessage
         * @instance
         */
        CancelPaymentRequestMessage.prototype.key = null;

        /**
         * Creates a new CancelPaymentRequestMessage instance using the specified properties.
         * @function create
         * @memberof proto.CancelPaymentRequestMessage
         * @static
         * @param {proto.ICancelPaymentRequestMessage=} [properties] Properties to set
         * @returns {proto.CancelPaymentRequestMessage} CancelPaymentRequestMessage instance
         */
        CancelPaymentRequestMessage.create = function create(properties) {
            return new CancelPaymentRequestMessage(properties);
        };

        /**
         * Encodes the specified CancelPaymentRequestMessage message. Does not implicitly {@link proto.CancelPaymentRequestMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.CancelPaymentRequestMessage
         * @static
         * @param {proto.ICancelPaymentRequestMessage} message CancelPaymentRequestMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CancelPaymentRequestMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.key != null && Object.hasOwnProperty.call(message, "key"))
                $root.proto.MessageKey.encode(message.key, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified CancelPaymentRequestMessage message, length delimited. Does not implicitly {@link proto.CancelPaymentRequestMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.CancelPaymentRequestMessage
         * @static
         * @param {proto.ICancelPaymentRequestMessage} message CancelPaymentRequestMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CancelPaymentRequestMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a CancelPaymentRequestMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.CancelPaymentRequestMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.CancelPaymentRequestMessage} CancelPaymentRequestMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CancelPaymentRequestMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.CancelPaymentRequestMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.key = $root.proto.MessageKey.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a CancelPaymentRequestMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.CancelPaymentRequestMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.CancelPaymentRequestMessage} CancelPaymentRequestMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CancelPaymentRequestMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a CancelPaymentRequestMessage message.
         * @function verify
         * @memberof proto.CancelPaymentRequestMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        CancelPaymentRequestMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.key != null && message.hasOwnProperty("key")) {
                var error = $root.proto.MessageKey.verify(message.key);
                if (error)
                    return "key." + error;
            }
            return null;
        };

        /**
         * Creates a CancelPaymentRequestMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.CancelPaymentRequestMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.CancelPaymentRequestMessage} CancelPaymentRequestMessage
         */
        CancelPaymentRequestMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.CancelPaymentRequestMessage)
                return object;
            var message = new $root.proto.CancelPaymentRequestMessage();
            if (object.key != null) {
                if (typeof object.key !== "object")
                    throw TypeError(".proto.CancelPaymentRequestMessage.key: object expected");
                message.key = $root.proto.MessageKey.fromObject(object.key);
            }
            return message;
        };

        /**
         * Creates a plain object from a CancelPaymentRequestMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.CancelPaymentRequestMessage
         * @static
         * @param {proto.CancelPaymentRequestMessage} message CancelPaymentRequestMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        CancelPaymentRequestMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.key = null;
            if (message.key != null && message.hasOwnProperty("key"))
                object.key = $root.proto.MessageKey.toObject(message.key, options);
            return object;
        };

        /**
         * Converts this CancelPaymentRequestMessage to JSON.
         * @function toJSON
         * @memberof proto.CancelPaymentRequestMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        CancelPaymentRequestMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return CancelPaymentRequestMessage;
    })();

    proto.CatalogSnapshot = (function() {

        /**
         * Properties of a CatalogSnapshot.
         * @memberof proto
         * @interface ICatalogSnapshot
         * @property {proto.IImageMessage|null} [catalogImage] CatalogSnapshot catalogImage
         * @property {string|null} [title] CatalogSnapshot title
         * @property {string|null} [description] CatalogSnapshot description
         */

        /**
         * Constructs a new CatalogSnapshot.
         * @memberof proto
         * @classdesc Represents a CatalogSnapshot.
         * @implements ICatalogSnapshot
         * @constructor
         * @param {proto.ICatalogSnapshot=} [properties] Properties to set
         */
        function CatalogSnapshot(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * CatalogSnapshot catalogImage.
         * @member {proto.IImageMessage|null|undefined} catalogImage
         * @memberof proto.CatalogSnapshot
         * @instance
         */
        CatalogSnapshot.prototype.catalogImage = null;

        /**
         * CatalogSnapshot title.
         * @member {string} title
         * @memberof proto.CatalogSnapshot
         * @instance
         */
        CatalogSnapshot.prototype.title = "";

        /**
         * CatalogSnapshot description.
         * @member {string} description
         * @memberof proto.CatalogSnapshot
         * @instance
         */
        CatalogSnapshot.prototype.description = "";

        /**
         * Creates a new CatalogSnapshot instance using the specified properties.
         * @function create
         * @memberof proto.CatalogSnapshot
         * @static
         * @param {proto.ICatalogSnapshot=} [properties] Properties to set
         * @returns {proto.CatalogSnapshot} CatalogSnapshot instance
         */
        CatalogSnapshot.create = function create(properties) {
            return new CatalogSnapshot(properties);
        };

        /**
         * Encodes the specified CatalogSnapshot message. Does not implicitly {@link proto.CatalogSnapshot.verify|verify} messages.
         * @function encode
         * @memberof proto.CatalogSnapshot
         * @static
         * @param {proto.ICatalogSnapshot} message CatalogSnapshot message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CatalogSnapshot.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.catalogImage != null && Object.hasOwnProperty.call(message, "catalogImage"))
                $root.proto.ImageMessage.encode(message.catalogImage, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.title != null && Object.hasOwnProperty.call(message, "title"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.title);
            if (message.description != null && Object.hasOwnProperty.call(message, "description"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.description);
            return writer;
        };

        /**
         * Encodes the specified CatalogSnapshot message, length delimited. Does not implicitly {@link proto.CatalogSnapshot.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.CatalogSnapshot
         * @static
         * @param {proto.ICatalogSnapshot} message CatalogSnapshot message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CatalogSnapshot.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a CatalogSnapshot message from the specified reader or buffer.
         * @function decode
         * @memberof proto.CatalogSnapshot
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.CatalogSnapshot} CatalogSnapshot
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CatalogSnapshot.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.CatalogSnapshot();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.catalogImage = $root.proto.ImageMessage.decode(reader, reader.uint32());
                    break;
                case 2:
                    message.title = reader.string();
                    break;
                case 3:
                    message.description = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a CatalogSnapshot message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.CatalogSnapshot
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.CatalogSnapshot} CatalogSnapshot
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CatalogSnapshot.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a CatalogSnapshot message.
         * @function verify
         * @memberof proto.CatalogSnapshot
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        CatalogSnapshot.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.catalogImage != null && message.hasOwnProperty("catalogImage")) {
                var error = $root.proto.ImageMessage.verify(message.catalogImage);
                if (error)
                    return "catalogImage." + error;
            }
            if (message.title != null && message.hasOwnProperty("title"))
                if (!$util.isString(message.title))
                    return "title: string expected";
            if (message.description != null && message.hasOwnProperty("description"))
                if (!$util.isString(message.description))
                    return "description: string expected";
            return null;
        };

        /**
         * Creates a CatalogSnapshot message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.CatalogSnapshot
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.CatalogSnapshot} CatalogSnapshot
         */
        CatalogSnapshot.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.CatalogSnapshot)
                return object;
            var message = new $root.proto.CatalogSnapshot();
            if (object.catalogImage != null) {
                if (typeof object.catalogImage !== "object")
                    throw TypeError(".proto.CatalogSnapshot.catalogImage: object expected");
                message.catalogImage = $root.proto.ImageMessage.fromObject(object.catalogImage);
            }
            if (object.title != null)
                message.title = String(object.title);
            if (object.description != null)
                message.description = String(object.description);
            return message;
        };

        /**
         * Creates a plain object from a CatalogSnapshot message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.CatalogSnapshot
         * @static
         * @param {proto.CatalogSnapshot} message CatalogSnapshot
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        CatalogSnapshot.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.catalogImage = null;
                object.title = "";
                object.description = "";
            }
            if (message.catalogImage != null && message.hasOwnProperty("catalogImage"))
                object.catalogImage = $root.proto.ImageMessage.toObject(message.catalogImage, options);
            if (message.title != null && message.hasOwnProperty("title"))
                object.title = message.title;
            if (message.description != null && message.hasOwnProperty("description"))
                object.description = message.description;
            return object;
        };

        /**
         * Converts this CatalogSnapshot to JSON.
         * @function toJSON
         * @memberof proto.CatalogSnapshot
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        CatalogSnapshot.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return CatalogSnapshot;
    })();

    proto.Chat = (function() {

        /**
         * Properties of a Chat.
         * @memberof proto
         * @interface IChat
         * @property {string|null} [displayName] Chat displayName
         * @property {string|null} [id] Chat id
         */

        /**
         * Constructs a new Chat.
         * @memberof proto
         * @classdesc Represents a Chat.
         * @implements IChat
         * @constructor
         * @param {proto.IChat=} [properties] Properties to set
         */
        function Chat(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Chat displayName.
         * @member {string} displayName
         * @memberof proto.Chat
         * @instance
         */
        Chat.prototype.displayName = "";

        /**
         * Chat id.
         * @member {string} id
         * @memberof proto.Chat
         * @instance
         */
        Chat.prototype.id = "";

        /**
         * Creates a new Chat instance using the specified properties.
         * @function create
         * @memberof proto.Chat
         * @static
         * @param {proto.IChat=} [properties] Properties to set
         * @returns {proto.Chat} Chat instance
         */
        Chat.create = function create(properties) {
            return new Chat(properties);
        };

        /**
         * Encodes the specified Chat message. Does not implicitly {@link proto.Chat.verify|verify} messages.
         * @function encode
         * @memberof proto.Chat
         * @static
         * @param {proto.IChat} message Chat message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Chat.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.displayName != null && Object.hasOwnProperty.call(message, "displayName"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.displayName);
            if (message.id != null && Object.hasOwnProperty.call(message, "id"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.id);
            return writer;
        };

        /**
         * Encodes the specified Chat message, length delimited. Does not implicitly {@link proto.Chat.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.Chat
         * @static
         * @param {proto.IChat} message Chat message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Chat.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a Chat message from the specified reader or buffer.
         * @function decode
         * @memberof proto.Chat
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.Chat} Chat
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Chat.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.Chat();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.displayName = reader.string();
                    break;
                case 2:
                    message.id = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a Chat message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.Chat
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.Chat} Chat
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Chat.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a Chat message.
         * @function verify
         * @memberof proto.Chat
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Chat.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.displayName != null && message.hasOwnProperty("displayName"))
                if (!$util.isString(message.displayName))
                    return "displayName: string expected";
            if (message.id != null && message.hasOwnProperty("id"))
                if (!$util.isString(message.id))
                    return "id: string expected";
            return null;
        };

        /**
         * Creates a Chat message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.Chat
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.Chat} Chat
         */
        Chat.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.Chat)
                return object;
            var message = new $root.proto.Chat();
            if (object.displayName != null)
                message.displayName = String(object.displayName);
            if (object.id != null)
                message.id = String(object.id);
            return message;
        };

        /**
         * Creates a plain object from a Chat message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.Chat
         * @static
         * @param {proto.Chat} message Chat
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Chat.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.displayName = "";
                object.id = "";
            }
            if (message.displayName != null && message.hasOwnProperty("displayName"))
                object.displayName = message.displayName;
            if (message.id != null && message.hasOwnProperty("id"))
                object.id = message.id;
            return object;
        };

        /**
         * Converts this Chat to JSON.
         * @function toJSON
         * @memberof proto.Chat
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Chat.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return Chat;
    })();

    proto.CollectionMessage = (function() {

        /**
         * Properties of a CollectionMessage.
         * @memberof proto
         * @interface ICollectionMessage
         * @property {string|null} [bizJid] CollectionMessage bizJid
         * @property {string|null} [id] CollectionMessage id
         * @property {number|null} [messageVersion] CollectionMessage messageVersion
         */

        /**
         * Constructs a new CollectionMessage.
         * @memberof proto
         * @classdesc Represents a CollectionMessage.
         * @implements ICollectionMessage
         * @constructor
         * @param {proto.ICollectionMessage=} [properties] Properties to set
         */
        function CollectionMessage(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * CollectionMessage bizJid.
         * @member {string} bizJid
         * @memberof proto.CollectionMessage
         * @instance
         */
        CollectionMessage.prototype.bizJid = "";

        /**
         * CollectionMessage id.
         * @member {string} id
         * @memberof proto.CollectionMessage
         * @instance
         */
        CollectionMessage.prototype.id = "";

        /**
         * CollectionMessage messageVersion.
         * @member {number} messageVersion
         * @memberof proto.CollectionMessage
         * @instance
         */
        CollectionMessage.prototype.messageVersion = 0;

        /**
         * Creates a new CollectionMessage instance using the specified properties.
         * @function create
         * @memberof proto.CollectionMessage
         * @static
         * @param {proto.ICollectionMessage=} [properties] Properties to set
         * @returns {proto.CollectionMessage} CollectionMessage instance
         */
        CollectionMessage.create = function create(properties) {
            return new CollectionMessage(properties);
        };

        /**
         * Encodes the specified CollectionMessage message. Does not implicitly {@link proto.CollectionMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.CollectionMessage
         * @static
         * @param {proto.ICollectionMessage} message CollectionMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CollectionMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.bizJid != null && Object.hasOwnProperty.call(message, "bizJid"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.bizJid);
            if (message.id != null && Object.hasOwnProperty.call(message, "id"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.id);
            if (message.messageVersion != null && Object.hasOwnProperty.call(message, "messageVersion"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.messageVersion);
            return writer;
        };

        /**
         * Encodes the specified CollectionMessage message, length delimited. Does not implicitly {@link proto.CollectionMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.CollectionMessage
         * @static
         * @param {proto.ICollectionMessage} message CollectionMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CollectionMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a CollectionMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.CollectionMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.CollectionMessage} CollectionMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CollectionMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.CollectionMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.bizJid = reader.string();
                    break;
                case 2:
                    message.id = reader.string();
                    break;
                case 3:
                    message.messageVersion = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a CollectionMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.CollectionMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.CollectionMessage} CollectionMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CollectionMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a CollectionMessage message.
         * @function verify
         * @memberof proto.CollectionMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        CollectionMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.bizJid != null && message.hasOwnProperty("bizJid"))
                if (!$util.isString(message.bizJid))
                    return "bizJid: string expected";
            if (message.id != null && message.hasOwnProperty("id"))
                if (!$util.isString(message.id))
                    return "id: string expected";
            if (message.messageVersion != null && message.hasOwnProperty("messageVersion"))
                if (!$util.isInteger(message.messageVersion))
                    return "messageVersion: integer expected";
            return null;
        };

        /**
         * Creates a CollectionMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.CollectionMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.CollectionMessage} CollectionMessage
         */
        CollectionMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.CollectionMessage)
                return object;
            var message = new $root.proto.CollectionMessage();
            if (object.bizJid != null)
                message.bizJid = String(object.bizJid);
            if (object.id != null)
                message.id = String(object.id);
            if (object.messageVersion != null)
                message.messageVersion = object.messageVersion | 0;
            return message;
        };

        /**
         * Creates a plain object from a CollectionMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.CollectionMessage
         * @static
         * @param {proto.CollectionMessage} message CollectionMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        CollectionMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.bizJid = "";
                object.id = "";
                object.messageVersion = 0;
            }
            if (message.bizJid != null && message.hasOwnProperty("bizJid"))
                object.bizJid = message.bizJid;
            if (message.id != null && message.hasOwnProperty("id"))
                object.id = message.id;
            if (message.messageVersion != null && message.hasOwnProperty("messageVersion"))
                object.messageVersion = message.messageVersion;
            return object;
        };

        /**
         * Converts this CollectionMessage to JSON.
         * @function toJSON
         * @memberof proto.CollectionMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        CollectionMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return CollectionMessage;
    })();

    proto.ContactMessage = (function() {

        /**
         * Properties of a ContactMessage.
         * @memberof proto
         * @interface IContactMessage
         * @property {string|null} [displayName] ContactMessage displayName
         * @property {string|null} [vcard] ContactMessage vcard
         * @property {proto.IContextInfo|null} [contextInfo] ContactMessage contextInfo
         */

        /**
         * Constructs a new ContactMessage.
         * @memberof proto
         * @classdesc Represents a ContactMessage.
         * @implements IContactMessage
         * @constructor
         * @param {proto.IContactMessage=} [properties] Properties to set
         */
        function ContactMessage(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ContactMessage displayName.
         * @member {string} displayName
         * @memberof proto.ContactMessage
         * @instance
         */
        ContactMessage.prototype.displayName = "";

        /**
         * ContactMessage vcard.
         * @member {string} vcard
         * @memberof proto.ContactMessage
         * @instance
         */
        ContactMessage.prototype.vcard = "";

        /**
         * ContactMessage contextInfo.
         * @member {proto.IContextInfo|null|undefined} contextInfo
         * @memberof proto.ContactMessage
         * @instance
         */
        ContactMessage.prototype.contextInfo = null;

        /**
         * Creates a new ContactMessage instance using the specified properties.
         * @function create
         * @memberof proto.ContactMessage
         * @static
         * @param {proto.IContactMessage=} [properties] Properties to set
         * @returns {proto.ContactMessage} ContactMessage instance
         */
        ContactMessage.create = function create(properties) {
            return new ContactMessage(properties);
        };

        /**
         * Encodes the specified ContactMessage message. Does not implicitly {@link proto.ContactMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.ContactMessage
         * @static
         * @param {proto.IContactMessage} message ContactMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ContactMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.displayName != null && Object.hasOwnProperty.call(message, "displayName"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.displayName);
            if (message.vcard != null && Object.hasOwnProperty.call(message, "vcard"))
                writer.uint32(/* id 16, wireType 2 =*/130).string(message.vcard);
            if (message.contextInfo != null && Object.hasOwnProperty.call(message, "contextInfo"))
                $root.proto.ContextInfo.encode(message.contextInfo, writer.uint32(/* id 17, wireType 2 =*/138).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified ContactMessage message, length delimited. Does not implicitly {@link proto.ContactMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ContactMessage
         * @static
         * @param {proto.IContactMessage} message ContactMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ContactMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ContactMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ContactMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ContactMessage} ContactMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ContactMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ContactMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.displayName = reader.string();
                    break;
                case 16:
                    message.vcard = reader.string();
                    break;
                case 17:
                    message.contextInfo = $root.proto.ContextInfo.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ContactMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ContactMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ContactMessage} ContactMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ContactMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ContactMessage message.
         * @function verify
         * @memberof proto.ContactMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ContactMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.displayName != null && message.hasOwnProperty("displayName"))
                if (!$util.isString(message.displayName))
                    return "displayName: string expected";
            if (message.vcard != null && message.hasOwnProperty("vcard"))
                if (!$util.isString(message.vcard))
                    return "vcard: string expected";
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo")) {
                var error = $root.proto.ContextInfo.verify(message.contextInfo);
                if (error)
                    return "contextInfo." + error;
            }
            return null;
        };

        /**
         * Creates a ContactMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ContactMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ContactMessage} ContactMessage
         */
        ContactMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ContactMessage)
                return object;
            var message = new $root.proto.ContactMessage();
            if (object.displayName != null)
                message.displayName = String(object.displayName);
            if (object.vcard != null)
                message.vcard = String(object.vcard);
            if (object.contextInfo != null) {
                if (typeof object.contextInfo !== "object")
                    throw TypeError(".proto.ContactMessage.contextInfo: object expected");
                message.contextInfo = $root.proto.ContextInfo.fromObject(object.contextInfo);
            }
            return message;
        };

        /**
         * Creates a plain object from a ContactMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ContactMessage
         * @static
         * @param {proto.ContactMessage} message ContactMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ContactMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.displayName = "";
                object.vcard = "";
                object.contextInfo = null;
            }
            if (message.displayName != null && message.hasOwnProperty("displayName"))
                object.displayName = message.displayName;
            if (message.vcard != null && message.hasOwnProperty("vcard"))
                object.vcard = message.vcard;
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo"))
                object.contextInfo = $root.proto.ContextInfo.toObject(message.contextInfo, options);
            return object;
        };

        /**
         * Converts this ContactMessage to JSON.
         * @function toJSON
         * @memberof proto.ContactMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ContactMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ContactMessage;
    })();

    proto.ContactsArrayMessage = (function() {

        /**
         * Properties of a ContactsArrayMessage.
         * @memberof proto
         * @interface IContactsArrayMessage
         * @property {string|null} [displayName] ContactsArrayMessage displayName
         * @property {Array.<proto.IContactMessage>|null} [contacts] ContactsArrayMessage contacts
         * @property {proto.IContextInfo|null} [contextInfo] ContactsArrayMessage contextInfo
         */

        /**
         * Constructs a new ContactsArrayMessage.
         * @memberof proto
         * @classdesc Represents a ContactsArrayMessage.
         * @implements IContactsArrayMessage
         * @constructor
         * @param {proto.IContactsArrayMessage=} [properties] Properties to set
         */
        function ContactsArrayMessage(properties) {
            this.contacts = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ContactsArrayMessage displayName.
         * @member {string} displayName
         * @memberof proto.ContactsArrayMessage
         * @instance
         */
        ContactsArrayMessage.prototype.displayName = "";

        /**
         * ContactsArrayMessage contacts.
         * @member {Array.<proto.IContactMessage>} contacts
         * @memberof proto.ContactsArrayMessage
         * @instance
         */
        ContactsArrayMessage.prototype.contacts = $util.emptyArray;

        /**
         * ContactsArrayMessage contextInfo.
         * @member {proto.IContextInfo|null|undefined} contextInfo
         * @memberof proto.ContactsArrayMessage
         * @instance
         */
        ContactsArrayMessage.prototype.contextInfo = null;

        /**
         * Creates a new ContactsArrayMessage instance using the specified properties.
         * @function create
         * @memberof proto.ContactsArrayMessage
         * @static
         * @param {proto.IContactsArrayMessage=} [properties] Properties to set
         * @returns {proto.ContactsArrayMessage} ContactsArrayMessage instance
         */
        ContactsArrayMessage.create = function create(properties) {
            return new ContactsArrayMessage(properties);
        };

        /**
         * Encodes the specified ContactsArrayMessage message. Does not implicitly {@link proto.ContactsArrayMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.ContactsArrayMessage
         * @static
         * @param {proto.IContactsArrayMessage} message ContactsArrayMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ContactsArrayMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.displayName != null && Object.hasOwnProperty.call(message, "displayName"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.displayName);
            if (message.contacts != null && message.contacts.length)
                for (var i = 0; i < message.contacts.length; ++i)
                    $root.proto.ContactMessage.encode(message.contacts[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.contextInfo != null && Object.hasOwnProperty.call(message, "contextInfo"))
                $root.proto.ContextInfo.encode(message.contextInfo, writer.uint32(/* id 17, wireType 2 =*/138).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified ContactsArrayMessage message, length delimited. Does not implicitly {@link proto.ContactsArrayMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ContactsArrayMessage
         * @static
         * @param {proto.IContactsArrayMessage} message ContactsArrayMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ContactsArrayMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ContactsArrayMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ContactsArrayMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ContactsArrayMessage} ContactsArrayMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ContactsArrayMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ContactsArrayMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.displayName = reader.string();
                    break;
                case 2:
                    if (!(message.contacts && message.contacts.length))
                        message.contacts = [];
                    message.contacts.push($root.proto.ContactMessage.decode(reader, reader.uint32()));
                    break;
                case 17:
                    message.contextInfo = $root.proto.ContextInfo.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ContactsArrayMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ContactsArrayMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ContactsArrayMessage} ContactsArrayMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ContactsArrayMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ContactsArrayMessage message.
         * @function verify
         * @memberof proto.ContactsArrayMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ContactsArrayMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.displayName != null && message.hasOwnProperty("displayName"))
                if (!$util.isString(message.displayName))
                    return "displayName: string expected";
            if (message.contacts != null && message.hasOwnProperty("contacts")) {
                if (!Array.isArray(message.contacts))
                    return "contacts: array expected";
                for (var i = 0; i < message.contacts.length; ++i) {
                    var error = $root.proto.ContactMessage.verify(message.contacts[i]);
                    if (error)
                        return "contacts." + error;
                }
            }
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo")) {
                var error = $root.proto.ContextInfo.verify(message.contextInfo);
                if (error)
                    return "contextInfo." + error;
            }
            return null;
        };

        /**
         * Creates a ContactsArrayMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ContactsArrayMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ContactsArrayMessage} ContactsArrayMessage
         */
        ContactsArrayMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ContactsArrayMessage)
                return object;
            var message = new $root.proto.ContactsArrayMessage();
            if (object.displayName != null)
                message.displayName = String(object.displayName);
            if (object.contacts) {
                if (!Array.isArray(object.contacts))
                    throw TypeError(".proto.ContactsArrayMessage.contacts: array expected");
                message.contacts = [];
                for (var i = 0; i < object.contacts.length; ++i) {
                    if (typeof object.contacts[i] !== "object")
                        throw TypeError(".proto.ContactsArrayMessage.contacts: object expected");
                    message.contacts[i] = $root.proto.ContactMessage.fromObject(object.contacts[i]);
                }
            }
            if (object.contextInfo != null) {
                if (typeof object.contextInfo !== "object")
                    throw TypeError(".proto.ContactsArrayMessage.contextInfo: object expected");
                message.contextInfo = $root.proto.ContextInfo.fromObject(object.contextInfo);
            }
            return message;
        };

        /**
         * Creates a plain object from a ContactsArrayMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ContactsArrayMessage
         * @static
         * @param {proto.ContactsArrayMessage} message ContactsArrayMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ContactsArrayMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.contacts = [];
            if (options.defaults) {
                object.displayName = "";
                object.contextInfo = null;
            }
            if (message.displayName != null && message.hasOwnProperty("displayName"))
                object.displayName = message.displayName;
            if (message.contacts && message.contacts.length) {
                object.contacts = [];
                for (var j = 0; j < message.contacts.length; ++j)
                    object.contacts[j] = $root.proto.ContactMessage.toObject(message.contacts[j], options);
            }
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo"))
                object.contextInfo = $root.proto.ContextInfo.toObject(message.contextInfo, options);
            return object;
        };

        /**
         * Converts this ContactsArrayMessage to JSON.
         * @function toJSON
         * @memberof proto.ContactsArrayMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ContactsArrayMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ContactsArrayMessage;
    })();

    proto.ContextInfo = (function() {

        /**
         * Properties of a ContextInfo.
         * @memberof proto
         * @interface IContextInfo
         * @property {string|null} [stanzaId] ContextInfo stanzaId
         * @property {string|null} [participant] ContextInfo participant
         * @property {proto.IMessage|null} [quotedMessage] ContextInfo quotedMessage
         * @property {string|null} [remoteJid] ContextInfo remoteJid
         * @property {Array.<string>|null} [mentionedJid] ContextInfo mentionedJid
         * @property {string|null} [conversionSource] ContextInfo conversionSource
         * @property {Uint8Array|null} [conversionData] ContextInfo conversionData
         * @property {number|null} [conversionDelaySeconds] ContextInfo conversionDelaySeconds
         * @property {number|null} [forwardingScore] ContextInfo forwardingScore
         * @property {boolean|null} [isForwarded] ContextInfo isForwarded
         * @property {proto.IAdReplyInfo|null} [quotedAd] ContextInfo quotedAd
         * @property {proto.IMessageKey|null} [placeholderKey] ContextInfo placeholderKey
         * @property {number|null} [expiration] ContextInfo expiration
         * @property {number|Long|null} [ephemeralSettingTimestamp] ContextInfo ephemeralSettingTimestamp
         * @property {Uint8Array|null} [ephemeralSharedSecret] ContextInfo ephemeralSharedSecret
         * @property {proto.IExternalAdReplyInfo|null} [externalAdReply] ContextInfo externalAdReply
         * @property {string|null} [entryPointConversionSource] ContextInfo entryPointConversionSource
         * @property {string|null} [entryPointConversionApp] ContextInfo entryPointConversionApp
         * @property {number|null} [entryPointConversionDelaySeconds] ContextInfo entryPointConversionDelaySeconds
         * @property {proto.IDisappearingMode|null} [disappearingMode] ContextInfo disappearingMode
         * @property {proto.IActionLink|null} [actionLink] ContextInfo actionLink
         * @property {string|null} [groupSubject] ContextInfo groupSubject
         * @property {string|null} [parentGroupJid] ContextInfo parentGroupJid
         * @property {Uint8Array|null} [messageSecret] ContextInfo messageSecret
         */

        /**
         * Constructs a new ContextInfo.
         * @memberof proto
         * @classdesc Represents a ContextInfo.
         * @implements IContextInfo
         * @constructor
         * @param {proto.IContextInfo=} [properties] Properties to set
         */
        function ContextInfo(properties) {
            this.mentionedJid = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ContextInfo stanzaId.
         * @member {string} stanzaId
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.stanzaId = "";

        /**
         * ContextInfo participant.
         * @member {string} participant
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.participant = "";

        /**
         * ContextInfo quotedMessage.
         * @member {proto.IMessage|null|undefined} quotedMessage
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.quotedMessage = null;

        /**
         * ContextInfo remoteJid.
         * @member {string} remoteJid
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.remoteJid = "";

        /**
         * ContextInfo mentionedJid.
         * @member {Array.<string>} mentionedJid
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.mentionedJid = $util.emptyArray;

        /**
         * ContextInfo conversionSource.
         * @member {string} conversionSource
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.conversionSource = "";

        /**
         * ContextInfo conversionData.
         * @member {Uint8Array} conversionData
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.conversionData = $util.newBuffer([]);

        /**
         * ContextInfo conversionDelaySeconds.
         * @member {number} conversionDelaySeconds
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.conversionDelaySeconds = 0;

        /**
         * ContextInfo forwardingScore.
         * @member {number} forwardingScore
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.forwardingScore = 0;

        /**
         * ContextInfo isForwarded.
         * @member {boolean} isForwarded
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.isForwarded = false;

        /**
         * ContextInfo quotedAd.
         * @member {proto.IAdReplyInfo|null|undefined} quotedAd
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.quotedAd = null;

        /**
         * ContextInfo placeholderKey.
         * @member {proto.IMessageKey|null|undefined} placeholderKey
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.placeholderKey = null;

        /**
         * ContextInfo expiration.
         * @member {number} expiration
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.expiration = 0;

        /**
         * ContextInfo ephemeralSettingTimestamp.
         * @member {number|Long} ephemeralSettingTimestamp
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.ephemeralSettingTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * ContextInfo ephemeralSharedSecret.
         * @member {Uint8Array} ephemeralSharedSecret
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.ephemeralSharedSecret = $util.newBuffer([]);

        /**
         * ContextInfo externalAdReply.
         * @member {proto.IExternalAdReplyInfo|null|undefined} externalAdReply
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.externalAdReply = null;

        /**
         * ContextInfo entryPointConversionSource.
         * @member {string} entryPointConversionSource
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.entryPointConversionSource = "";

        /**
         * ContextInfo entryPointConversionApp.
         * @member {string} entryPointConversionApp
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.entryPointConversionApp = "";

        /**
         * ContextInfo entryPointConversionDelaySeconds.
         * @member {number} entryPointConversionDelaySeconds
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.entryPointConversionDelaySeconds = 0;

        /**
         * ContextInfo disappearingMode.
         * @member {proto.IDisappearingMode|null|undefined} disappearingMode
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.disappearingMode = null;

        /**
         * ContextInfo actionLink.
         * @member {proto.IActionLink|null|undefined} actionLink
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.actionLink = null;

        /**
         * ContextInfo groupSubject.
         * @member {string} groupSubject
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.groupSubject = "";

        /**
         * ContextInfo parentGroupJid.
         * @member {string} parentGroupJid
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.parentGroupJid = "";

        /**
         * ContextInfo messageSecret.
         * @member {Uint8Array} messageSecret
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.messageSecret = $util.newBuffer([]);

        /**
         * Creates a new ContextInfo instance using the specified properties.
         * @function create
         * @memberof proto.ContextInfo
         * @static
         * @param {proto.IContextInfo=} [properties] Properties to set
         * @returns {proto.ContextInfo} ContextInfo instance
         */
        ContextInfo.create = function create(properties) {
            return new ContextInfo(properties);
        };

        /**
         * Encodes the specified ContextInfo message. Does not implicitly {@link proto.ContextInfo.verify|verify} messages.
         * @function encode
         * @memberof proto.ContextInfo
         * @static
         * @param {proto.IContextInfo} message ContextInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ContextInfo.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.stanzaId != null && Object.hasOwnProperty.call(message, "stanzaId"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.stanzaId);
            if (message.participant != null && Object.hasOwnProperty.call(message, "participant"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.participant);
            if (message.quotedMessage != null && Object.hasOwnProperty.call(message, "quotedMessage"))
                $root.proto.Message.encode(message.quotedMessage, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            if (message.remoteJid != null && Object.hasOwnProperty.call(message, "remoteJid"))
                writer.uint32(/* id 4, wireType 2 =*/34).string(message.remoteJid);
            if (message.mentionedJid != null && message.mentionedJid.length)
                for (var i = 0; i < message.mentionedJid.length; ++i)
                    writer.uint32(/* id 15, wireType 2 =*/122).string(message.mentionedJid[i]);
            if (message.conversionSource != null && Object.hasOwnProperty.call(message, "conversionSource"))
                writer.uint32(/* id 18, wireType 2 =*/146).string(message.conversionSource);
            if (message.conversionData != null && Object.hasOwnProperty.call(message, "conversionData"))
                writer.uint32(/* id 19, wireType 2 =*/154).bytes(message.conversionData);
            if (message.conversionDelaySeconds != null && Object.hasOwnProperty.call(message, "conversionDelaySeconds"))
                writer.uint32(/* id 20, wireType 0 =*/160).uint32(message.conversionDelaySeconds);
            if (message.forwardingScore != null && Object.hasOwnProperty.call(message, "forwardingScore"))
                writer.uint32(/* id 21, wireType 0 =*/168).uint32(message.forwardingScore);
            if (message.isForwarded != null && Object.hasOwnProperty.call(message, "isForwarded"))
                writer.uint32(/* id 22, wireType 0 =*/176).bool(message.isForwarded);
            if (message.quotedAd != null && Object.hasOwnProperty.call(message, "quotedAd"))
                $root.proto.AdReplyInfo.encode(message.quotedAd, writer.uint32(/* id 23, wireType 2 =*/186).fork()).ldelim();
            if (message.placeholderKey != null && Object.hasOwnProperty.call(message, "placeholderKey"))
                $root.proto.MessageKey.encode(message.placeholderKey, writer.uint32(/* id 24, wireType 2 =*/194).fork()).ldelim();
            if (message.expiration != null && Object.hasOwnProperty.call(message, "expiration"))
                writer.uint32(/* id 25, wireType 0 =*/200).uint32(message.expiration);
            if (message.ephemeralSettingTimestamp != null && Object.hasOwnProperty.call(message, "ephemeralSettingTimestamp"))
                writer.uint32(/* id 26, wireType 0 =*/208).int64(message.ephemeralSettingTimestamp);
            if (message.ephemeralSharedSecret != null && Object.hasOwnProperty.call(message, "ephemeralSharedSecret"))
                writer.uint32(/* id 27, wireType 2 =*/218).bytes(message.ephemeralSharedSecret);
            if (message.externalAdReply != null && Object.hasOwnProperty.call(message, "externalAdReply"))
                $root.proto.ExternalAdReplyInfo.encode(message.externalAdReply, writer.uint32(/* id 28, wireType 2 =*/226).fork()).ldelim();
            if (message.entryPointConversionSource != null && Object.hasOwnProperty.call(message, "entryPointConversionSource"))
                writer.uint32(/* id 29, wireType 2 =*/234).string(message.entryPointConversionSource);
            if (message.entryPointConversionApp != null && Object.hasOwnProperty.call(message, "entryPointConversionApp"))
                writer.uint32(/* id 30, wireType 2 =*/242).string(message.entryPointConversionApp);
            if (message.entryPointConversionDelaySeconds != null && Object.hasOwnProperty.call(message, "entryPointConversionDelaySeconds"))
                writer.uint32(/* id 31, wireType 0 =*/248).uint32(message.entryPointConversionDelaySeconds);
            if (message.disappearingMode != null && Object.hasOwnProperty.call(message, "disappearingMode"))
                $root.proto.DisappearingMode.encode(message.disappearingMode, writer.uint32(/* id 32, wireType 2 =*/258).fork()).ldelim();
            if (message.actionLink != null && Object.hasOwnProperty.call(message, "actionLink"))
                $root.proto.ActionLink.encode(message.actionLink, writer.uint32(/* id 33, wireType 2 =*/266).fork()).ldelim();
            if (message.groupSubject != null && Object.hasOwnProperty.call(message, "groupSubject"))
                writer.uint32(/* id 34, wireType 2 =*/274).string(message.groupSubject);
            if (message.parentGroupJid != null && Object.hasOwnProperty.call(message, "parentGroupJid"))
                writer.uint32(/* id 35, wireType 2 =*/282).string(message.parentGroupJid);
            if (message.messageSecret != null && Object.hasOwnProperty.call(message, "messageSecret"))
                writer.uint32(/* id 36, wireType 2 =*/290).bytes(message.messageSecret);
            return writer;
        };

        /**
         * Encodes the specified ContextInfo message, length delimited. Does not implicitly {@link proto.ContextInfo.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ContextInfo
         * @static
         * @param {proto.IContextInfo} message ContextInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ContextInfo.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ContextInfo message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ContextInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ContextInfo} ContextInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ContextInfo.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ContextInfo();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.stanzaId = reader.string();
                    break;
                case 2:
                    message.participant = reader.string();
                    break;
                case 3:
                    message.quotedMessage = $root.proto.Message.decode(reader, reader.uint32());
                    break;
                case 4:
                    message.remoteJid = reader.string();
                    break;
                case 15:
                    if (!(message.mentionedJid && message.mentionedJid.length))
                        message.mentionedJid = [];
                    message.mentionedJid.push(reader.string());
                    break;
                case 18:
                    message.conversionSource = reader.string();
                    break;
                case 19:
                    message.conversionData = reader.bytes();
                    break;
                case 20:
                    message.conversionDelaySeconds = reader.uint32();
                    break;
                case 21:
                    message.forwardingScore = reader.uint32();
                    break;
                case 22:
                    message.isForwarded = reader.bool();
                    break;
                case 23:
                    message.quotedAd = $root.proto.AdReplyInfo.decode(reader, reader.uint32());
                    break;
                case 24:
                    message.placeholderKey = $root.proto.MessageKey.decode(reader, reader.uint32());
                    break;
                case 25:
                    message.expiration = reader.uint32();
                    break;
                case 26:
                    message.ephemeralSettingTimestamp = reader.int64();
                    break;
                case 27:
                    message.ephemeralSharedSecret = reader.bytes();
                    break;
                case 28:
                    message.externalAdReply = $root.proto.ExternalAdReplyInfo.decode(reader, reader.uint32());
                    break;
                case 29:
                    message.entryPointConversionSource = reader.string();
                    break;
                case 30:
                    message.entryPointConversionApp = reader.string();
                    break;
                case 31:
                    message.entryPointConversionDelaySeconds = reader.uint32();
                    break;
                case 32:
                    message.disappearingMode = $root.proto.DisappearingMode.decode(reader, reader.uint32());
                    break;
                case 33:
                    message.actionLink = $root.proto.ActionLink.decode(reader, reader.uint32());
                    break;
                case 34:
                    message.groupSubject = reader.string();
                    break;
                case 35:
                    message.parentGroupJid = reader.string();
                    break;
                case 36:
                    message.messageSecret = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ContextInfo message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ContextInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ContextInfo} ContextInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ContextInfo.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ContextInfo message.
         * @function verify
         * @memberof proto.ContextInfo
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ContextInfo.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.stanzaId != null && message.hasOwnProperty("stanzaId"))
                if (!$util.isString(message.stanzaId))
                    return "stanzaId: string expected";
            if (message.participant != null && message.hasOwnProperty("participant"))
                if (!$util.isString(message.participant))
                    return "participant: string expected";
            if (message.quotedMessage != null && message.hasOwnProperty("quotedMessage")) {
                var error = $root.proto.Message.verify(message.quotedMessage);
                if (error)
                    return "quotedMessage." + error;
            }
            if (message.remoteJid != null && message.hasOwnProperty("remoteJid"))
                if (!$util.isString(message.remoteJid))
                    return "remoteJid: string expected";
            if (message.mentionedJid != null && message.hasOwnProperty("mentionedJid")) {
                if (!Array.isArray(message.mentionedJid))
                    return "mentionedJid: array expected";
                for (var i = 0; i < message.mentionedJid.length; ++i)
                    if (!$util.isString(message.mentionedJid[i]))
                        return "mentionedJid: string[] expected";
            }
            if (message.conversionSource != null && message.hasOwnProperty("conversionSource"))
                if (!$util.isString(message.conversionSource))
                    return "conversionSource: string expected";
            if (message.conversionData != null && message.hasOwnProperty("conversionData"))
                if (!(message.conversionData && typeof message.conversionData.length === "number" || $util.isString(message.conversionData)))
                    return "conversionData: buffer expected";
            if (message.conversionDelaySeconds != null && message.hasOwnProperty("conversionDelaySeconds"))
                if (!$util.isInteger(message.conversionDelaySeconds))
                    return "conversionDelaySeconds: integer expected";
            if (message.forwardingScore != null && message.hasOwnProperty("forwardingScore"))
                if (!$util.isInteger(message.forwardingScore))
                    return "forwardingScore: integer expected";
            if (message.isForwarded != null && message.hasOwnProperty("isForwarded"))
                if (typeof message.isForwarded !== "boolean")
                    return "isForwarded: boolean expected";
            if (message.quotedAd != null && message.hasOwnProperty("quotedAd")) {
                var error = $root.proto.AdReplyInfo.verify(message.quotedAd);
                if (error)
                    return "quotedAd." + error;
            }
            if (message.placeholderKey != null && message.hasOwnProperty("placeholderKey")) {
                var error = $root.proto.MessageKey.verify(message.placeholderKey);
                if (error)
                    return "placeholderKey." + error;
            }
            if (message.expiration != null && message.hasOwnProperty("expiration"))
                if (!$util.isInteger(message.expiration))
                    return "expiration: integer expected";
            if (message.ephemeralSettingTimestamp != null && message.hasOwnProperty("ephemeralSettingTimestamp"))
                if (!$util.isInteger(message.ephemeralSettingTimestamp) && !(message.ephemeralSettingTimestamp && $util.isInteger(message.ephemeralSettingTimestamp.low) && $util.isInteger(message.ephemeralSettingTimestamp.high)))
                    return "ephemeralSettingTimestamp: integer|Long expected";
            if (message.ephemeralSharedSecret != null && message.hasOwnProperty("ephemeralSharedSecret"))
                if (!(message.ephemeralSharedSecret && typeof message.ephemeralSharedSecret.length === "number" || $util.isString(message.ephemeralSharedSecret)))
                    return "ephemeralSharedSecret: buffer expected";
            if (message.externalAdReply != null && message.hasOwnProperty("externalAdReply")) {
                var error = $root.proto.ExternalAdReplyInfo.verify(message.externalAdReply);
                if (error)
                    return "externalAdReply." + error;
            }
            if (message.entryPointConversionSource != null && message.hasOwnProperty("entryPointConversionSource"))
                if (!$util.isString(message.entryPointConversionSource))
                    return "entryPointConversionSource: string expected";
            if (message.entryPointConversionApp != null && message.hasOwnProperty("entryPointConversionApp"))
                if (!$util.isString(message.entryPointConversionApp))
                    return "entryPointConversionApp: string expected";
            if (message.entryPointConversionDelaySeconds != null && message.hasOwnProperty("entryPointConversionDelaySeconds"))
                if (!$util.isInteger(message.entryPointConversionDelaySeconds))
                    return "entryPointConversionDelaySeconds: integer expected";
            if (message.disappearingMode != null && message.hasOwnProperty("disappearingMode")) {
                var error = $root.proto.DisappearingMode.verify(message.disappearingMode);
                if (error)
                    return "disappearingMode." + error;
            }
            if (message.actionLink != null && message.hasOwnProperty("actionLink")) {
                var error = $root.proto.ActionLink.verify(message.actionLink);
                if (error)
                    return "actionLink." + error;
            }
            if (message.groupSubject != null && message.hasOwnProperty("groupSubject"))
                if (!$util.isString(message.groupSubject))
                    return "groupSubject: string expected";
            if (message.parentGroupJid != null && message.hasOwnProperty("parentGroupJid"))
                if (!$util.isString(message.parentGroupJid))
                    return "parentGroupJid: string expected";
            if (message.messageSecret != null && message.hasOwnProperty("messageSecret"))
                if (!(message.messageSecret && typeof message.messageSecret.length === "number" || $util.isString(message.messageSecret)))
                    return "messageSecret: buffer expected";
            return null;
        };

        /**
         * Creates a ContextInfo message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ContextInfo
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ContextInfo} ContextInfo
         */
        ContextInfo.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ContextInfo)
                return object;
            var message = new $root.proto.ContextInfo();
            if (object.stanzaId != null)
                message.stanzaId = String(object.stanzaId);
            if (object.participant != null)
                message.participant = String(object.participant);
            if (object.quotedMessage != null) {
                if (typeof object.quotedMessage !== "object")
                    throw TypeError(".proto.ContextInfo.quotedMessage: object expected");
                message.quotedMessage = $root.proto.Message.fromObject(object.quotedMessage);
            }
            if (object.remoteJid != null)
                message.remoteJid = String(object.remoteJid);
            if (object.mentionedJid) {
                if (!Array.isArray(object.mentionedJid))
                    throw TypeError(".proto.ContextInfo.mentionedJid: array expected");
                message.mentionedJid = [];
                for (var i = 0; i < object.mentionedJid.length; ++i)
                    message.mentionedJid[i] = String(object.mentionedJid[i]);
            }
            if (object.conversionSource != null)
                message.conversionSource = String(object.conversionSource);
            if (object.conversionData != null)
                if (typeof object.conversionData === "string")
                    $util.base64.decode(object.conversionData, message.conversionData = $util.newBuffer($util.base64.length(object.conversionData)), 0);
                else if (object.conversionData.length)
                    message.conversionData = object.conversionData;
            if (object.conversionDelaySeconds != null)
                message.conversionDelaySeconds = object.conversionDelaySeconds >>> 0;
            if (object.forwardingScore != null)
                message.forwardingScore = object.forwardingScore >>> 0;
            if (object.isForwarded != null)
                message.isForwarded = Boolean(object.isForwarded);
            if (object.quotedAd != null) {
                if (typeof object.quotedAd !== "object")
                    throw TypeError(".proto.ContextInfo.quotedAd: object expected");
                message.quotedAd = $root.proto.AdReplyInfo.fromObject(object.quotedAd);
            }
            if (object.placeholderKey != null) {
                if (typeof object.placeholderKey !== "object")
                    throw TypeError(".proto.ContextInfo.placeholderKey: object expected");
                message.placeholderKey = $root.proto.MessageKey.fromObject(object.placeholderKey);
            }
            if (object.expiration != null)
                message.expiration = object.expiration >>> 0;
            if (object.ephemeralSettingTimestamp != null)
                if ($util.Long)
                    (message.ephemeralSettingTimestamp = $util.Long.fromValue(object.ephemeralSettingTimestamp)).unsigned = false;
                else if (typeof object.ephemeralSettingTimestamp === "string")
                    message.ephemeralSettingTimestamp = parseInt(object.ephemeralSettingTimestamp, 10);
                else if (typeof object.ephemeralSettingTimestamp === "number")
                    message.ephemeralSettingTimestamp = object.ephemeralSettingTimestamp;
                else if (typeof object.ephemeralSettingTimestamp === "object")
                    message.ephemeralSettingTimestamp = new $util.LongBits(object.ephemeralSettingTimestamp.low >>> 0, object.ephemeralSettingTimestamp.high >>> 0).toNumber();
            if (object.ephemeralSharedSecret != null)
                if (typeof object.ephemeralSharedSecret === "string")
                    $util.base64.decode(object.ephemeralSharedSecret, message.ephemeralSharedSecret = $util.newBuffer($util.base64.length(object.ephemeralSharedSecret)), 0);
                else if (object.ephemeralSharedSecret.length)
                    message.ephemeralSharedSecret = object.ephemeralSharedSecret;
            if (object.externalAdReply != null) {
                if (typeof object.externalAdReply !== "object")
                    throw TypeError(".proto.ContextInfo.externalAdReply: object expected");
                message.externalAdReply = $root.proto.ExternalAdReplyInfo.fromObject(object.externalAdReply);
            }
            if (object.entryPointConversionSource != null)
                message.entryPointConversionSource = String(object.entryPointConversionSource);
            if (object.entryPointConversionApp != null)
                message.entryPointConversionApp = String(object.entryPointConversionApp);
            if (object.entryPointConversionDelaySeconds != null)
                message.entryPointConversionDelaySeconds = object.entryPointConversionDelaySeconds >>> 0;
            if (object.disappearingMode != null) {
                if (typeof object.disappearingMode !== "object")
                    throw TypeError(".proto.ContextInfo.disappearingMode: object expected");
                message.disappearingMode = $root.proto.DisappearingMode.fromObject(object.disappearingMode);
            }
            if (object.actionLink != null) {
                if (typeof object.actionLink !== "object")
                    throw TypeError(".proto.ContextInfo.actionLink: object expected");
                message.actionLink = $root.proto.ActionLink.fromObject(object.actionLink);
            }
            if (object.groupSubject != null)
                message.groupSubject = String(object.groupSubject);
            if (object.parentGroupJid != null)
                message.parentGroupJid = String(object.parentGroupJid);
            if (object.messageSecret != null)
                if (typeof object.messageSecret === "string")
                    $util.base64.decode(object.messageSecret, message.messageSecret = $util.newBuffer($util.base64.length(object.messageSecret)), 0);
                else if (object.messageSecret.length)
                    message.messageSecret = object.messageSecret;
            return message;
        };

        /**
         * Creates a plain object from a ContextInfo message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ContextInfo
         * @static
         * @param {proto.ContextInfo} message ContextInfo
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ContextInfo.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.mentionedJid = [];
            if (options.defaults) {
                object.stanzaId = "";
                object.participant = "";
                object.quotedMessage = null;
                object.remoteJid = "";
                object.conversionSource = "";
                if (options.bytes === String)
                    object.conversionData = "";
                else {
                    object.conversionData = [];
                    if (options.bytes !== Array)
                        object.conversionData = $util.newBuffer(object.conversionData);
                }
                object.conversionDelaySeconds = 0;
                object.forwardingScore = 0;
                object.isForwarded = false;
                object.quotedAd = null;
                object.placeholderKey = null;
                object.expiration = 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.ephemeralSettingTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.ephemeralSettingTimestamp = options.longs === String ? "0" : 0;
                if (options.bytes === String)
                    object.ephemeralSharedSecret = "";
                else {
                    object.ephemeralSharedSecret = [];
                    if (options.bytes !== Array)
                        object.ephemeralSharedSecret = $util.newBuffer(object.ephemeralSharedSecret);
                }
                object.externalAdReply = null;
                object.entryPointConversionSource = "";
                object.entryPointConversionApp = "";
                object.entryPointConversionDelaySeconds = 0;
                object.disappearingMode = null;
                object.actionLink = null;
                object.groupSubject = "";
                object.parentGroupJid = "";
                if (options.bytes === String)
                    object.messageSecret = "";
                else {
                    object.messageSecret = [];
                    if (options.bytes !== Array)
                        object.messageSecret = $util.newBuffer(object.messageSecret);
                }
            }
            if (message.stanzaId != null && message.hasOwnProperty("stanzaId"))
                object.stanzaId = message.stanzaId;
            if (message.participant != null && message.hasOwnProperty("participant"))
                object.participant = message.participant;
            if (message.quotedMessage != null && message.hasOwnProperty("quotedMessage"))
                object.quotedMessage = $root.proto.Message.toObject(message.quotedMessage, options);
            if (message.remoteJid != null && message.hasOwnProperty("remoteJid"))
                object.remoteJid = message.remoteJid;
            if (message.mentionedJid && message.mentionedJid.length) {
                object.mentionedJid = [];
                for (var j = 0; j < message.mentionedJid.length; ++j)
                    object.mentionedJid[j] = message.mentionedJid[j];
            }
            if (message.conversionSource != null && message.hasOwnProperty("conversionSource"))
                object.conversionSource = message.conversionSource;
            if (message.conversionData != null && message.hasOwnProperty("conversionData"))
                object.conversionData = options.bytes === String ? $util.base64.encode(message.conversionData, 0, message.conversionData.length) : options.bytes === Array ? Array.prototype.slice.call(message.conversionData) : message.conversionData;
            if (message.conversionDelaySeconds != null && message.hasOwnProperty("conversionDelaySeconds"))
                object.conversionDelaySeconds = message.conversionDelaySeconds;
            if (message.forwardingScore != null && message.hasOwnProperty("forwardingScore"))
                object.forwardingScore = message.forwardingScore;
            if (message.isForwarded != null && message.hasOwnProperty("isForwarded"))
                object.isForwarded = message.isForwarded;
            if (message.quotedAd != null && message.hasOwnProperty("quotedAd"))
                object.quotedAd = $root.proto.AdReplyInfo.toObject(message.quotedAd, options);
            if (message.placeholderKey != null && message.hasOwnProperty("placeholderKey"))
                object.placeholderKey = $root.proto.MessageKey.toObject(message.placeholderKey, options);
            if (message.expiration != null && message.hasOwnProperty("expiration"))
                object.expiration = message.expiration;
            if (message.ephemeralSettingTimestamp != null && message.hasOwnProperty("ephemeralSettingTimestamp"))
                if (typeof message.ephemeralSettingTimestamp === "number")
                    object.ephemeralSettingTimestamp = options.longs === String ? String(message.ephemeralSettingTimestamp) : message.ephemeralSettingTimestamp;
                else
                    object.ephemeralSettingTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.ephemeralSettingTimestamp) : options.longs === Number ? new $util.LongBits(message.ephemeralSettingTimestamp.low >>> 0, message.ephemeralSettingTimestamp.high >>> 0).toNumber() : message.ephemeralSettingTimestamp;
            if (message.ephemeralSharedSecret != null && message.hasOwnProperty("ephemeralSharedSecret"))
                object.ephemeralSharedSecret = options.bytes === String ? $util.base64.encode(message.ephemeralSharedSecret, 0, message.ephemeralSharedSecret.length) : options.bytes === Array ? Array.prototype.slice.call(message.ephemeralSharedSecret) : message.ephemeralSharedSecret;
            if (message.externalAdReply != null && message.hasOwnProperty("externalAdReply"))
                object.externalAdReply = $root.proto.ExternalAdReplyInfo.toObject(message.externalAdReply, options);
            if (message.entryPointConversionSource != null && message.hasOwnProperty("entryPointConversionSource"))
                object.entryPointConversionSource = message.entryPointConversionSource;
            if (message.entryPointConversionApp != null && message.hasOwnProperty("entryPointConversionApp"))
                object.entryPointConversionApp = message.entryPointConversionApp;
            if (message.entryPointConversionDelaySeconds != null && message.hasOwnProperty("entryPointConversionDelaySeconds"))
                object.entryPointConversionDelaySeconds = message.entryPointConversionDelaySeconds;
            if (message.disappearingMode != null && message.hasOwnProperty("disappearingMode"))
                object.disappearingMode = $root.proto.DisappearingMode.toObject(message.disappearingMode, options);
            if (message.actionLink != null && message.hasOwnProperty("actionLink"))
                object.actionLink = $root.proto.ActionLink.toObject(message.actionLink, options);
            if (message.groupSubject != null && message.hasOwnProperty("groupSubject"))
                object.groupSubject = message.groupSubject;
            if (message.parentGroupJid != null && message.hasOwnProperty("parentGroupJid"))
                object.parentGroupJid = message.parentGroupJid;
            if (message.messageSecret != null && message.hasOwnProperty("messageSecret"))
                object.messageSecret = options.bytes === String ? $util.base64.encode(message.messageSecret, 0, message.messageSecret.length) : options.bytes === Array ? Array.prototype.slice.call(message.messageSecret) : message.messageSecret;
            return object;
        };

        /**
         * Converts this ContextInfo to JSON.
         * @function toJSON
         * @memberof proto.ContextInfo
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ContextInfo.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ContextInfo;
    })();

    proto.DeclinePaymentRequestMessage = (function() {

        /**
         * Properties of a DeclinePaymentRequestMessage.
         * @memberof proto
         * @interface IDeclinePaymentRequestMessage
         * @property {proto.IMessageKey|null} [key] DeclinePaymentRequestMessage key
         */

        /**
         * Constructs a new DeclinePaymentRequestMessage.
         * @memberof proto
         * @classdesc Represents a DeclinePaymentRequestMessage.
         * @implements IDeclinePaymentRequestMessage
         * @constructor
         * @param {proto.IDeclinePaymentRequestMessage=} [properties] Properties to set
         */
        function DeclinePaymentRequestMessage(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DeclinePaymentRequestMessage key.
         * @member {proto.IMessageKey|null|undefined} key
         * @memberof proto.DeclinePaymentRequestMessage
         * @instance
         */
        DeclinePaymentRequestMessage.prototype.key = null;

        /**
         * Creates a new DeclinePaymentRequestMessage instance using the specified properties.
         * @function create
         * @memberof proto.DeclinePaymentRequestMessage
         * @static
         * @param {proto.IDeclinePaymentRequestMessage=} [properties] Properties to set
         * @returns {proto.DeclinePaymentRequestMessage} DeclinePaymentRequestMessage instance
         */
        DeclinePaymentRequestMessage.create = function create(properties) {
            return new DeclinePaymentRequestMessage(properties);
        };

        /**
         * Encodes the specified DeclinePaymentRequestMessage message. Does not implicitly {@link proto.DeclinePaymentRequestMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.DeclinePaymentRequestMessage
         * @static
         * @param {proto.IDeclinePaymentRequestMessage} message DeclinePaymentRequestMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DeclinePaymentRequestMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.key != null && Object.hasOwnProperty.call(message, "key"))
                $root.proto.MessageKey.encode(message.key, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified DeclinePaymentRequestMessage message, length delimited. Does not implicitly {@link proto.DeclinePaymentRequestMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.DeclinePaymentRequestMessage
         * @static
         * @param {proto.IDeclinePaymentRequestMessage} message DeclinePaymentRequestMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DeclinePaymentRequestMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DeclinePaymentRequestMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.DeclinePaymentRequestMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.DeclinePaymentRequestMessage} DeclinePaymentRequestMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DeclinePaymentRequestMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.DeclinePaymentRequestMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.key = $root.proto.MessageKey.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DeclinePaymentRequestMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.DeclinePaymentRequestMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.DeclinePaymentRequestMessage} DeclinePaymentRequestMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DeclinePaymentRequestMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DeclinePaymentRequestMessage message.
         * @function verify
         * @memberof proto.DeclinePaymentRequestMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DeclinePaymentRequestMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.key != null && message.hasOwnProperty("key")) {
                var error = $root.proto.MessageKey.verify(message.key);
                if (error)
                    return "key." + error;
            }
            return null;
        };

        /**
         * Creates a DeclinePaymentRequestMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.DeclinePaymentRequestMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.DeclinePaymentRequestMessage} DeclinePaymentRequestMessage
         */
        DeclinePaymentRequestMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.DeclinePaymentRequestMessage)
                return object;
            var message = new $root.proto.DeclinePaymentRequestMessage();
            if (object.key != null) {
                if (typeof object.key !== "object")
                    throw TypeError(".proto.DeclinePaymentRequestMessage.key: object expected");
                message.key = $root.proto.MessageKey.fromObject(object.key);
            }
            return message;
        };

        /**
         * Creates a plain object from a DeclinePaymentRequestMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.DeclinePaymentRequestMessage
         * @static
         * @param {proto.DeclinePaymentRequestMessage} message DeclinePaymentRequestMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DeclinePaymentRequestMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.key = null;
            if (message.key != null && message.hasOwnProperty("key"))
                object.key = $root.proto.MessageKey.toObject(message.key, options);
            return object;
        };

        /**
         * Converts this DeclinePaymentRequestMessage to JSON.
         * @function toJSON
         * @memberof proto.DeclinePaymentRequestMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DeclinePaymentRequestMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DeclinePaymentRequestMessage;
    })();

    proto.DeviceListMetadata = (function() {

        /**
         * Properties of a DeviceListMetadata.
         * @memberof proto
         * @interface IDeviceListMetadata
         * @property {Uint8Array|null} [senderKeyHash] DeviceListMetadata senderKeyHash
         * @property {number|Long|null} [senderTimestamp] DeviceListMetadata senderTimestamp
         * @property {Array.<number>|null} [senderKeyIndexes] DeviceListMetadata senderKeyIndexes
         * @property {Uint8Array|null} [recipientKeyHash] DeviceListMetadata recipientKeyHash
         * @property {number|Long|null} [recipientTimestamp] DeviceListMetadata recipientTimestamp
         * @property {Array.<number>|null} [recipientKeyIndexes] DeviceListMetadata recipientKeyIndexes
         */

        /**
         * Constructs a new DeviceListMetadata.
         * @memberof proto
         * @classdesc Represents a DeviceListMetadata.
         * @implements IDeviceListMetadata
         * @constructor
         * @param {proto.IDeviceListMetadata=} [properties] Properties to set
         */
        function DeviceListMetadata(properties) {
            this.senderKeyIndexes = [];
            this.recipientKeyIndexes = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DeviceListMetadata senderKeyHash.
         * @member {Uint8Array} senderKeyHash
         * @memberof proto.DeviceListMetadata
         * @instance
         */
        DeviceListMetadata.prototype.senderKeyHash = $util.newBuffer([]);

        /**
         * DeviceListMetadata senderTimestamp.
         * @member {number|Long} senderTimestamp
         * @memberof proto.DeviceListMetadata
         * @instance
         */
        DeviceListMetadata.prototype.senderTimestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * DeviceListMetadata senderKeyIndexes.
         * @member {Array.<number>} senderKeyIndexes
         * @memberof proto.DeviceListMetadata
         * @instance
         */
        DeviceListMetadata.prototype.senderKeyIndexes = $util.emptyArray;

        /**
         * DeviceListMetadata recipientKeyHash.
         * @member {Uint8Array} recipientKeyHash
         * @memberof proto.DeviceListMetadata
         * @instance
         */
        DeviceListMetadata.prototype.recipientKeyHash = $util.newBuffer([]);

        /**
         * DeviceListMetadata recipientTimestamp.
         * @member {number|Long} recipientTimestamp
         * @memberof proto.DeviceListMetadata
         * @instance
         */
        DeviceListMetadata.prototype.recipientTimestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * DeviceListMetadata recipientKeyIndexes.
         * @member {Array.<number>} recipientKeyIndexes
         * @memberof proto.DeviceListMetadata
         * @instance
         */
        DeviceListMetadata.prototype.recipientKeyIndexes = $util.emptyArray;

        /**
         * Creates a new DeviceListMetadata instance using the specified properties.
         * @function create
         * @memberof proto.DeviceListMetadata
         * @static
         * @param {proto.IDeviceListMetadata=} [properties] Properties to set
         * @returns {proto.DeviceListMetadata} DeviceListMetadata instance
         */
        DeviceListMetadata.create = function create(properties) {
            return new DeviceListMetadata(properties);
        };

        /**
         * Encodes the specified DeviceListMetadata message. Does not implicitly {@link proto.DeviceListMetadata.verify|verify} messages.
         * @function encode
         * @memberof proto.DeviceListMetadata
         * @static
         * @param {proto.IDeviceListMetadata} message DeviceListMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DeviceListMetadata.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.senderKeyHash != null && Object.hasOwnProperty.call(message, "senderKeyHash"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.senderKeyHash);
            if (message.senderTimestamp != null && Object.hasOwnProperty.call(message, "senderTimestamp"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint64(message.senderTimestamp);
            if (message.senderKeyIndexes != null && message.senderKeyIndexes.length) {
                writer.uint32(/* id 3, wireType 2 =*/26).fork();
                for (var i = 0; i < message.senderKeyIndexes.length; ++i)
                    writer.uint32(message.senderKeyIndexes[i]);
                writer.ldelim();
            }
            if (message.recipientKeyHash != null && Object.hasOwnProperty.call(message, "recipientKeyHash"))
                writer.uint32(/* id 8, wireType 2 =*/66).bytes(message.recipientKeyHash);
            if (message.recipientTimestamp != null && Object.hasOwnProperty.call(message, "recipientTimestamp"))
                writer.uint32(/* id 9, wireType 0 =*/72).uint64(message.recipientTimestamp);
            if (message.recipientKeyIndexes != null && message.recipientKeyIndexes.length) {
                writer.uint32(/* id 10, wireType 2 =*/82).fork();
                for (var i = 0; i < message.recipientKeyIndexes.length; ++i)
                    writer.uint32(message.recipientKeyIndexes[i]);
                writer.ldelim();
            }
            return writer;
        };

        /**
         * Encodes the specified DeviceListMetadata message, length delimited. Does not implicitly {@link proto.DeviceListMetadata.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.DeviceListMetadata
         * @static
         * @param {proto.IDeviceListMetadata} message DeviceListMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DeviceListMetadata.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DeviceListMetadata message from the specified reader or buffer.
         * @function decode
         * @memberof proto.DeviceListMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.DeviceListMetadata} DeviceListMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DeviceListMetadata.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.DeviceListMetadata();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.senderKeyHash = reader.bytes();
                    break;
                case 2:
                    message.senderTimestamp = reader.uint64();
                    break;
                case 3:
                    if (!(message.senderKeyIndexes && message.senderKeyIndexes.length))
                        message.senderKeyIndexes = [];
                    if ((tag & 7) === 2) {
                        var end2 = reader.uint32() + reader.pos;
                        while (reader.pos < end2)
                            message.senderKeyIndexes.push(reader.uint32());
                    } else
                        message.senderKeyIndexes.push(reader.uint32());
                    break;
                case 8:
                    message.recipientKeyHash = reader.bytes();
                    break;
                case 9:
                    message.recipientTimestamp = reader.uint64();
                    break;
                case 10:
                    if (!(message.recipientKeyIndexes && message.recipientKeyIndexes.length))
                        message.recipientKeyIndexes = [];
                    if ((tag & 7) === 2) {
                        var end2 = reader.uint32() + reader.pos;
                        while (reader.pos < end2)
                            message.recipientKeyIndexes.push(reader.uint32());
                    } else
                        message.recipientKeyIndexes.push(reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DeviceListMetadata message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.DeviceListMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.DeviceListMetadata} DeviceListMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DeviceListMetadata.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DeviceListMetadata message.
         * @function verify
         * @memberof proto.DeviceListMetadata
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DeviceListMetadata.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.senderKeyHash != null && message.hasOwnProperty("senderKeyHash"))
                if (!(message.senderKeyHash && typeof message.senderKeyHash.length === "number" || $util.isString(message.senderKeyHash)))
                    return "senderKeyHash: buffer expected";
            if (message.senderTimestamp != null && message.hasOwnProperty("senderTimestamp"))
                if (!$util.isInteger(message.senderTimestamp) && !(message.senderTimestamp && $util.isInteger(message.senderTimestamp.low) && $util.isInteger(message.senderTimestamp.high)))
                    return "senderTimestamp: integer|Long expected";
            if (message.senderKeyIndexes != null && message.hasOwnProperty("senderKeyIndexes")) {
                if (!Array.isArray(message.senderKeyIndexes))
                    return "senderKeyIndexes: array expected";
                for (var i = 0; i < message.senderKeyIndexes.length; ++i)
                    if (!$util.isInteger(message.senderKeyIndexes[i]))
                        return "senderKeyIndexes: integer[] expected";
            }
            if (message.recipientKeyHash != null && message.hasOwnProperty("recipientKeyHash"))
                if (!(message.recipientKeyHash && typeof message.recipientKeyHash.length === "number" || $util.isString(message.recipientKeyHash)))
                    return "recipientKeyHash: buffer expected";
            if (message.recipientTimestamp != null && message.hasOwnProperty("recipientTimestamp"))
                if (!$util.isInteger(message.recipientTimestamp) && !(message.recipientTimestamp && $util.isInteger(message.recipientTimestamp.low) && $util.isInteger(message.recipientTimestamp.high)))
                    return "recipientTimestamp: integer|Long expected";
            if (message.recipientKeyIndexes != null && message.hasOwnProperty("recipientKeyIndexes")) {
                if (!Array.isArray(message.recipientKeyIndexes))
                    return "recipientKeyIndexes: array expected";
                for (var i = 0; i < message.recipientKeyIndexes.length; ++i)
                    if (!$util.isInteger(message.recipientKeyIndexes[i]))
                        return "recipientKeyIndexes: integer[] expected";
            }
            return null;
        };

        /**
         * Creates a DeviceListMetadata message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.DeviceListMetadata
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.DeviceListMetadata} DeviceListMetadata
         */
        DeviceListMetadata.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.DeviceListMetadata)
                return object;
            var message = new $root.proto.DeviceListMetadata();
            if (object.senderKeyHash != null)
                if (typeof object.senderKeyHash === "string")
                    $util.base64.decode(object.senderKeyHash, message.senderKeyHash = $util.newBuffer($util.base64.length(object.senderKeyHash)), 0);
                else if (object.senderKeyHash.length)
                    message.senderKeyHash = object.senderKeyHash;
            if (object.senderTimestamp != null)
                if ($util.Long)
                    (message.senderTimestamp = $util.Long.fromValue(object.senderTimestamp)).unsigned = true;
                else if (typeof object.senderTimestamp === "string")
                    message.senderTimestamp = parseInt(object.senderTimestamp, 10);
                else if (typeof object.senderTimestamp === "number")
                    message.senderTimestamp = object.senderTimestamp;
                else if (typeof object.senderTimestamp === "object")
                    message.senderTimestamp = new $util.LongBits(object.senderTimestamp.low >>> 0, object.senderTimestamp.high >>> 0).toNumber(true);
            if (object.senderKeyIndexes) {
                if (!Array.isArray(object.senderKeyIndexes))
                    throw TypeError(".proto.DeviceListMetadata.senderKeyIndexes: array expected");
                message.senderKeyIndexes = [];
                for (var i = 0; i < object.senderKeyIndexes.length; ++i)
                    message.senderKeyIndexes[i] = object.senderKeyIndexes[i] >>> 0;
            }
            if (object.recipientKeyHash != null)
                if (typeof object.recipientKeyHash === "string")
                    $util.base64.decode(object.recipientKeyHash, message.recipientKeyHash = $util.newBuffer($util.base64.length(object.recipientKeyHash)), 0);
                else if (object.recipientKeyHash.length)
                    message.recipientKeyHash = object.recipientKeyHash;
            if (object.recipientTimestamp != null)
                if ($util.Long)
                    (message.recipientTimestamp = $util.Long.fromValue(object.recipientTimestamp)).unsigned = true;
                else if (typeof object.recipientTimestamp === "string")
                    message.recipientTimestamp = parseInt(object.recipientTimestamp, 10);
                else if (typeof object.recipientTimestamp === "number")
                    message.recipientTimestamp = object.recipientTimestamp;
                else if (typeof object.recipientTimestamp === "object")
                    message.recipientTimestamp = new $util.LongBits(object.recipientTimestamp.low >>> 0, object.recipientTimestamp.high >>> 0).toNumber(true);
            if (object.recipientKeyIndexes) {
                if (!Array.isArray(object.recipientKeyIndexes))
                    throw TypeError(".proto.DeviceListMetadata.recipientKeyIndexes: array expected");
                message.recipientKeyIndexes = [];
                for (var i = 0; i < object.recipientKeyIndexes.length; ++i)
                    message.recipientKeyIndexes[i] = object.recipientKeyIndexes[i] >>> 0;
            }
            return message;
        };

        /**
         * Creates a plain object from a DeviceListMetadata message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.DeviceListMetadata
         * @static
         * @param {proto.DeviceListMetadata} message DeviceListMetadata
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DeviceListMetadata.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults) {
                object.senderKeyIndexes = [];
                object.recipientKeyIndexes = [];
            }
            if (options.defaults) {
                if (options.bytes === String)
                    object.senderKeyHash = "";
                else {
                    object.senderKeyHash = [];
                    if (options.bytes !== Array)
                        object.senderKeyHash = $util.newBuffer(object.senderKeyHash);
                }
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.senderTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.senderTimestamp = options.longs === String ? "0" : 0;
                if (options.bytes === String)
                    object.recipientKeyHash = "";
                else {
                    object.recipientKeyHash = [];
                    if (options.bytes !== Array)
                        object.recipientKeyHash = $util.newBuffer(object.recipientKeyHash);
                }
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.recipientTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.recipientTimestamp = options.longs === String ? "0" : 0;
            }
            if (message.senderKeyHash != null && message.hasOwnProperty("senderKeyHash"))
                object.senderKeyHash = options.bytes === String ? $util.base64.encode(message.senderKeyHash, 0, message.senderKeyHash.length) : options.bytes === Array ? Array.prototype.slice.call(message.senderKeyHash) : message.senderKeyHash;
            if (message.senderTimestamp != null && message.hasOwnProperty("senderTimestamp"))
                if (typeof message.senderTimestamp === "number")
                    object.senderTimestamp = options.longs === String ? String(message.senderTimestamp) : message.senderTimestamp;
                else
                    object.senderTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.senderTimestamp) : options.longs === Number ? new $util.LongBits(message.senderTimestamp.low >>> 0, message.senderTimestamp.high >>> 0).toNumber(true) : message.senderTimestamp;
            if (message.senderKeyIndexes && message.senderKeyIndexes.length) {
                object.senderKeyIndexes = [];
                for (var j = 0; j < message.senderKeyIndexes.length; ++j)
                    object.senderKeyIndexes[j] = message.senderKeyIndexes[j];
            }
            if (message.recipientKeyHash != null && message.hasOwnProperty("recipientKeyHash"))
                object.recipientKeyHash = options.bytes === String ? $util.base64.encode(message.recipientKeyHash, 0, message.recipientKeyHash.length) : options.bytes === Array ? Array.prototype.slice.call(message.recipientKeyHash) : message.recipientKeyHash;
            if (message.recipientTimestamp != null && message.hasOwnProperty("recipientTimestamp"))
                if (typeof message.recipientTimestamp === "number")
                    object.recipientTimestamp = options.longs === String ? String(message.recipientTimestamp) : message.recipientTimestamp;
                else
                    object.recipientTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.recipientTimestamp) : options.longs === Number ? new $util.LongBits(message.recipientTimestamp.low >>> 0, message.recipientTimestamp.high >>> 0).toNumber(true) : message.recipientTimestamp;
            if (message.recipientKeyIndexes && message.recipientKeyIndexes.length) {
                object.recipientKeyIndexes = [];
                for (var j = 0; j < message.recipientKeyIndexes.length; ++j)
                    object.recipientKeyIndexes[j] = message.recipientKeyIndexes[j];
            }
            return object;
        };

        /**
         * Converts this DeviceListMetadata to JSON.
         * @function toJSON
         * @memberof proto.DeviceListMetadata
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DeviceListMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DeviceListMetadata;
    })();

    proto.DeviceSentMessage = (function() {

        /**
         * Properties of a DeviceSentMessage.
         * @memberof proto
         * @interface IDeviceSentMessage
         * @property {string|null} [destinationJid] DeviceSentMessage destinationJid
         * @property {proto.IMessage|null} [message] DeviceSentMessage message
         * @property {string|null} [phash] DeviceSentMessage phash
         */

        /**
         * Constructs a new DeviceSentMessage.
         * @memberof proto
         * @classdesc Represents a DeviceSentMessage.
         * @implements IDeviceSentMessage
         * @constructor
         * @param {proto.IDeviceSentMessage=} [properties] Properties to set
         */
        function DeviceSentMessage(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DeviceSentMessage destinationJid.
         * @member {string} destinationJid
         * @memberof proto.DeviceSentMessage
         * @instance
         */
        DeviceSentMessage.prototype.destinationJid = "";

        /**
         * DeviceSentMessage message.
         * @member {proto.IMessage|null|undefined} message
         * @memberof proto.DeviceSentMessage
         * @instance
         */
        DeviceSentMessage.prototype.message = null;

        /**
         * DeviceSentMessage phash.
         * @member {string} phash
         * @memberof proto.DeviceSentMessage
         * @instance
         */
        DeviceSentMessage.prototype.phash = "";

        /**
         * Creates a new DeviceSentMessage instance using the specified properties.
         * @function create
         * @memberof proto.DeviceSentMessage
         * @static
         * @param {proto.IDeviceSentMessage=} [properties] Properties to set
         * @returns {proto.DeviceSentMessage} DeviceSentMessage instance
         */
        DeviceSentMessage.create = function create(properties) {
            return new DeviceSentMessage(properties);
        };

        /**
         * Encodes the specified DeviceSentMessage message. Does not implicitly {@link proto.DeviceSentMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.DeviceSentMessage
         * @static
         * @param {proto.IDeviceSentMessage} message DeviceSentMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DeviceSentMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.destinationJid != null && Object.hasOwnProperty.call(message, "destinationJid"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.destinationJid);
            if (message.message != null && Object.hasOwnProperty.call(message, "message"))
                $root.proto.Message.encode(message.message, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.phash != null && Object.hasOwnProperty.call(message, "phash"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.phash);
            return writer;
        };

        /**
         * Encodes the specified DeviceSentMessage message, length delimited. Does not implicitly {@link proto.DeviceSentMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.DeviceSentMessage
         * @static
         * @param {proto.IDeviceSentMessage} message DeviceSentMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DeviceSentMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DeviceSentMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.DeviceSentMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.DeviceSentMessage} DeviceSentMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DeviceSentMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.DeviceSentMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.destinationJid = reader.string();
                    break;
                case 2:
                    message.message = $root.proto.Message.decode(reader, reader.uint32());
                    break;
                case 3:
                    message.phash = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DeviceSentMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.DeviceSentMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.DeviceSentMessage} DeviceSentMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DeviceSentMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DeviceSentMessage message.
         * @function verify
         * @memberof proto.DeviceSentMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DeviceSentMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.destinationJid != null && message.hasOwnProperty("destinationJid"))
                if (!$util.isString(message.destinationJid))
                    return "destinationJid: string expected";
            if (message.message != null && message.hasOwnProperty("message")) {
                var error = $root.proto.Message.verify(message.message);
                if (error)
                    return "message." + error;
            }
            if (message.phash != null && message.hasOwnProperty("phash"))
                if (!$util.isString(message.phash))
                    return "phash: string expected";
            return null;
        };

        /**
         * Creates a DeviceSentMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.DeviceSentMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.DeviceSentMessage} DeviceSentMessage
         */
        DeviceSentMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.DeviceSentMessage)
                return object;
            var message = new $root.proto.DeviceSentMessage();
            if (object.destinationJid != null)
                message.destinationJid = String(object.destinationJid);
            if (object.message != null) {
                if (typeof object.message !== "object")
                    throw TypeError(".proto.DeviceSentMessage.message: object expected");
                message.message = $root.proto.Message.fromObject(object.message);
            }
            if (object.phash != null)
                message.phash = String(object.phash);
            return message;
        };

        /**
         * Creates a plain object from a DeviceSentMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.DeviceSentMessage
         * @static
         * @param {proto.DeviceSentMessage} message DeviceSentMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DeviceSentMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.destinationJid = "";
                object.message = null;
                object.phash = "";
            }
            if (message.destinationJid != null && message.hasOwnProperty("destinationJid"))
                object.destinationJid = message.destinationJid;
            if (message.message != null && message.hasOwnProperty("message"))
                object.message = $root.proto.Message.toObject(message.message, options);
            if (message.phash != null && message.hasOwnProperty("phash"))
                object.phash = message.phash;
            return object;
        };

        /**
         * Converts this DeviceSentMessage to JSON.
         * @function toJSON
         * @memberof proto.DeviceSentMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DeviceSentMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DeviceSentMessage;
    })();

    proto.DisappearingMode = (function() {

        /**
         * Properties of a DisappearingMode.
         * @memberof proto
         * @interface IDisappearingMode
         * @property {proto.DisappearingMode.DisappearingModeInitiator|null} [initiator] DisappearingMode initiator
         */

        /**
         * Constructs a new DisappearingMode.
         * @memberof proto
         * @classdesc Represents a DisappearingMode.
         * @implements IDisappearingMode
         * @constructor
         * @param {proto.IDisappearingMode=} [properties] Properties to set
         */
        function DisappearingMode(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DisappearingMode initiator.
         * @member {proto.DisappearingMode.DisappearingModeInitiator} initiator
         * @memberof proto.DisappearingMode
         * @instance
         */
        DisappearingMode.prototype.initiator = 0;

        /**
         * Creates a new DisappearingMode instance using the specified properties.
         * @function create
         * @memberof proto.DisappearingMode
         * @static
         * @param {proto.IDisappearingMode=} [properties] Properties to set
         * @returns {proto.DisappearingMode} DisappearingMode instance
         */
        DisappearingMode.create = function create(properties) {
            return new DisappearingMode(properties);
        };

        /**
         * Encodes the specified DisappearingMode message. Does not implicitly {@link proto.DisappearingMode.verify|verify} messages.
         * @function encode
         * @memberof proto.DisappearingMode
         * @static
         * @param {proto.IDisappearingMode} message DisappearingMode message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DisappearingMode.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.initiator != null && Object.hasOwnProperty.call(message, "initiator"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.initiator);
            return writer;
        };

        /**
         * Encodes the specified DisappearingMode message, length delimited. Does not implicitly {@link proto.DisappearingMode.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.DisappearingMode
         * @static
         * @param {proto.IDisappearingMode} message DisappearingMode message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DisappearingMode.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DisappearingMode message from the specified reader or buffer.
         * @function decode
         * @memberof proto.DisappearingMode
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.DisappearingMode} DisappearingMode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DisappearingMode.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.DisappearingMode();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.initiator = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DisappearingMode message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.DisappearingMode
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.DisappearingMode} DisappearingMode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DisappearingMode.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DisappearingMode message.
         * @function verify
         * @memberof proto.DisappearingMode
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DisappearingMode.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.initiator != null && message.hasOwnProperty("initiator"))
                switch (message.initiator) {
                default:
                    return "initiator: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            return null;
        };

        /**
         * Creates a DisappearingMode message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.DisappearingMode
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.DisappearingMode} DisappearingMode
         */
        DisappearingMode.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.DisappearingMode)
                return object;
            var message = new $root.proto.DisappearingMode();
            switch (object.initiator) {
            case "CHANGED_IN_CHAT":
            case 0:
                message.initiator = 0;
                break;
            case "INITIATED_BY_ME":
            case 1:
                message.initiator = 1;
                break;
            case "INITIATED_BY_OTHER":
            case 2:
                message.initiator = 2;
                break;
            }
            return message;
        };

        /**
         * Creates a plain object from a DisappearingMode message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.DisappearingMode
         * @static
         * @param {proto.DisappearingMode} message DisappearingMode
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DisappearingMode.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.initiator = options.enums === String ? "CHANGED_IN_CHAT" : 0;
            if (message.initiator != null && message.hasOwnProperty("initiator"))
                object.initiator = options.enums === String ? $root.proto.DisappearingMode.DisappearingModeInitiator[message.initiator] : message.initiator;
            return object;
        };

        /**
         * Converts this DisappearingMode to JSON.
         * @function toJSON
         * @memberof proto.DisappearingMode
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DisappearingMode.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * DisappearingModeInitiator enum.
         * @name proto.DisappearingMode.DisappearingModeInitiator
         * @enum {number}
         * @property {number} CHANGED_IN_CHAT=0 CHANGED_IN_CHAT value
         * @property {number} INITIATED_BY_ME=1 INITIATED_BY_ME value
         * @property {number} INITIATED_BY_OTHER=2 INITIATED_BY_OTHER value
         */
        DisappearingMode.DisappearingModeInitiator = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "CHANGED_IN_CHAT"] = 0;
            values[valuesById[1] = "INITIATED_BY_ME"] = 1;
            values[valuesById[2] = "INITIATED_BY_OTHER"] = 2;
            return values;
        })();

        return DisappearingMode;
    })();

    proto.DocumentMessage = (function() {

        /**
         * Properties of a DocumentMessage.
         * @memberof proto
         * @interface IDocumentMessage
         * @property {string|null} [url] DocumentMessage url
         * @property {string|null} [mimetype] DocumentMessage mimetype
         * @property {string|null} [title] DocumentMessage title
         * @property {Uint8Array|null} [fileSha256] DocumentMessage fileSha256
         * @property {number|Long|null} [fileLength] DocumentMessage fileLength
         * @property {number|null} [pageCount] DocumentMessage pageCount
         * @property {Uint8Array|null} [mediaKey] DocumentMessage mediaKey
         * @property {string|null} [fileName] DocumentMessage fileName
         * @property {Uint8Array|null} [fileEncSha256] DocumentMessage fileEncSha256
         * @property {string|null} [directPath] DocumentMessage directPath
         * @property {number|Long|null} [mediaKeyTimestamp] DocumentMessage mediaKeyTimestamp
         * @property {boolean|null} [contactVcard] DocumentMessage contactVcard
         * @property {string|null} [thumbnailDirectPath] DocumentMessage thumbnailDirectPath
         * @property {Uint8Array|null} [thumbnailSha256] DocumentMessage thumbnailSha256
         * @property {Uint8Array|null} [thumbnailEncSha256] DocumentMessage thumbnailEncSha256
         * @property {Uint8Array|null} [jpegThumbnail] DocumentMessage jpegThumbnail
         * @property {proto.IContextInfo|null} [contextInfo] DocumentMessage contextInfo
         * @property {number|null} [thumbnailHeight] DocumentMessage thumbnailHeight
         * @property {number|null} [thumbnailWidth] DocumentMessage thumbnailWidth
         */

        /**
         * Constructs a new DocumentMessage.
         * @memberof proto
         * @classdesc Represents a DocumentMessage.
         * @implements IDocumentMessage
         * @constructor
         * @param {proto.IDocumentMessage=} [properties] Properties to set
         */
        function DocumentMessage(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DocumentMessage url.
         * @member {string} url
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.url = "";

        /**
         * DocumentMessage mimetype.
         * @member {string} mimetype
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.mimetype = "";

        /**
         * DocumentMessage title.
         * @member {string} title
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.title = "";

        /**
         * DocumentMessage fileSha256.
         * @member {Uint8Array} fileSha256
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.fileSha256 = $util.newBuffer([]);

        /**
         * DocumentMessage fileLength.
         * @member {number|Long} fileLength
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.fileLength = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * DocumentMessage pageCount.
         * @member {number} pageCount
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.pageCount = 0;

        /**
         * DocumentMessage mediaKey.
         * @member {Uint8Array} mediaKey
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.mediaKey = $util.newBuffer([]);

        /**
         * DocumentMessage fileName.
         * @member {string} fileName
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.fileName = "";

        /**
         * DocumentMessage fileEncSha256.
         * @member {Uint8Array} fileEncSha256
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.fileEncSha256 = $util.newBuffer([]);

        /**
         * DocumentMessage directPath.
         * @member {string} directPath
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.directPath = "";

        /**
         * DocumentMessage mediaKeyTimestamp.
         * @member {number|Long} mediaKeyTimestamp
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.mediaKeyTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * DocumentMessage contactVcard.
         * @member {boolean} contactVcard
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.contactVcard = false;

        /**
         * DocumentMessage thumbnailDirectPath.
         * @member {string} thumbnailDirectPath
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.thumbnailDirectPath = "";

        /**
         * DocumentMessage thumbnailSha256.
         * @member {Uint8Array} thumbnailSha256
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.thumbnailSha256 = $util.newBuffer([]);

        /**
         * DocumentMessage thumbnailEncSha256.
         * @member {Uint8Array} thumbnailEncSha256
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.thumbnailEncSha256 = $util.newBuffer([]);

        /**
         * DocumentMessage jpegThumbnail.
         * @member {Uint8Array} jpegThumbnail
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.jpegThumbnail = $util.newBuffer([]);

        /**
         * DocumentMessage contextInfo.
         * @member {proto.IContextInfo|null|undefined} contextInfo
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.contextInfo = null;

        /**
         * DocumentMessage thumbnailHeight.
         * @member {number} thumbnailHeight
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.thumbnailHeight = 0;

        /**
         * DocumentMessage thumbnailWidth.
         * @member {number} thumbnailWidth
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.thumbnailWidth = 0;

        /**
         * Creates a new DocumentMessage instance using the specified properties.
         * @function create
         * @memberof proto.DocumentMessage
         * @static
         * @param {proto.IDocumentMessage=} [properties] Properties to set
         * @returns {proto.DocumentMessage} DocumentMessage instance
         */
        DocumentMessage.create = function create(properties) {
            return new DocumentMessage(properties);
        };

        /**
         * Encodes the specified DocumentMessage message. Does not implicitly {@link proto.DocumentMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.DocumentMessage
         * @static
         * @param {proto.IDocumentMessage} message DocumentMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DocumentMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.url != null && Object.hasOwnProperty.call(message, "url"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.url);
            if (message.mimetype != null && Object.hasOwnProperty.call(message, "mimetype"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.mimetype);
            if (message.title != null && Object.hasOwnProperty.call(message, "title"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.title);
            if (message.fileSha256 != null && Object.hasOwnProperty.call(message, "fileSha256"))
                writer.uint32(/* id 4, wireType 2 =*/34).bytes(message.fileSha256);
            if (message.fileLength != null && Object.hasOwnProperty.call(message, "fileLength"))
                writer.uint32(/* id 5, wireType 0 =*/40).uint64(message.fileLength);
            if (message.pageCount != null && Object.hasOwnProperty.call(message, "pageCount"))
                writer.uint32(/* id 6, wireType 0 =*/48).uint32(message.pageCount);
            if (message.mediaKey != null && Object.hasOwnProperty.call(message, "mediaKey"))
                writer.uint32(/* id 7, wireType 2 =*/58).bytes(message.mediaKey);
            if (message.fileName != null && Object.hasOwnProperty.call(message, "fileName"))
                writer.uint32(/* id 8, wireType 2 =*/66).string(message.fileName);
            if (message.fileEncSha256 != null && Object.hasOwnProperty.call(message, "fileEncSha256"))
                writer.uint32(/* id 9, wireType 2 =*/74).bytes(message.fileEncSha256);
            if (message.directPath != null && Object.hasOwnProperty.call(message, "directPath"))
                writer.uint32(/* id 10, wireType 2 =*/82).string(message.directPath);
            if (message.mediaKeyTimestamp != null && Object.hasOwnProperty.call(message, "mediaKeyTimestamp"))
                writer.uint32(/* id 11, wireType 0 =*/88).int64(message.mediaKeyTimestamp);
            if (message.contactVcard != null && Object.hasOwnProperty.call(message, "contactVcard"))
                writer.uint32(/* id 12, wireType 0 =*/96).bool(message.contactVcard);
            if (message.thumbnailDirectPath != null && Object.hasOwnProperty.call(message, "thumbnailDirectPath"))
                writer.uint32(/* id 13, wireType 2 =*/106).string(message.thumbnailDirectPath);
            if (message.thumbnailSha256 != null && Object.hasOwnProperty.call(message, "thumbnailSha256"))
                writer.uint32(/* id 14, wireType 2 =*/114).bytes(message.thumbnailSha256);
            if (message.thumbnailEncSha256 != null && Object.hasOwnProperty.call(message, "thumbnailEncSha256"))
                writer.uint32(/* id 15, wireType 2 =*/122).bytes(message.thumbnailEncSha256);
            if (message.jpegThumbnail != null && Object.hasOwnProperty.call(message, "jpegThumbnail"))
                writer.uint32(/* id 16, wireType 2 =*/130).bytes(message.jpegThumbnail);
            if (message.contextInfo != null && Object.hasOwnProperty.call(message, "contextInfo"))
                $root.proto.ContextInfo.encode(message.contextInfo, writer.uint32(/* id 17, wireType 2 =*/138).fork()).ldelim();
            if (message.thumbnailHeight != null && Object.hasOwnProperty.call(message, "thumbnailHeight"))
                writer.uint32(/* id 18, wireType 0 =*/144).uint32(message.thumbnailHeight);
            if (message.thumbnailWidth != null && Object.hasOwnProperty.call(message, "thumbnailWidth"))
                writer.uint32(/* id 19, wireType 0 =*/152).uint32(message.thumbnailWidth);
            return writer;
        };

        /**
         * Encodes the specified DocumentMessage message, length delimited. Does not implicitly {@link proto.DocumentMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.DocumentMessage
         * @static
         * @param {proto.IDocumentMessage} message DocumentMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DocumentMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DocumentMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.DocumentMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.DocumentMessage} DocumentMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DocumentMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.DocumentMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.url = reader.string();
                    break;
                case 2:
                    message.mimetype = reader.string();
                    break;
                case 3:
                    message.title = reader.string();
                    break;
                case 4:
                    message.fileSha256 = reader.bytes();
                    break;
                case 5:
                    message.fileLength = reader.uint64();
                    break;
                case 6:
                    message.pageCount = reader.uint32();
                    break;
                case 7:
                    message.mediaKey = reader.bytes();
                    break;
                case 8:
                    message.fileName = reader.string();
                    break;
                case 9:
                    message.fileEncSha256 = reader.bytes();
                    break;
                case 10:
                    message.directPath = reader.string();
                    break;
                case 11:
                    message.mediaKeyTimestamp = reader.int64();
                    break;
                case 12:
                    message.contactVcard = reader.bool();
                    break;
                case 13:
                    message.thumbnailDirectPath = reader.string();
                    break;
                case 14:
                    message.thumbnailSha256 = reader.bytes();
                    break;
                case 15:
                    message.thumbnailEncSha256 = reader.bytes();
                    break;
                case 16:
                    message.jpegThumbnail = reader.bytes();
                    break;
                case 17:
                    message.contextInfo = $root.proto.ContextInfo.decode(reader, reader.uint32());
                    break;
                case 18:
                    message.thumbnailHeight = reader.uint32();
                    break;
                case 19:
                    message.thumbnailWidth = reader.uint32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DocumentMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.DocumentMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.DocumentMessage} DocumentMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DocumentMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DocumentMessage message.
         * @function verify
         * @memberof proto.DocumentMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DocumentMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.url != null && message.hasOwnProperty("url"))
                if (!$util.isString(message.url))
                    return "url: string expected";
            if (message.mimetype != null && message.hasOwnProperty("mimetype"))
                if (!$util.isString(message.mimetype))
                    return "mimetype: string expected";
            if (message.title != null && message.hasOwnProperty("title"))
                if (!$util.isString(message.title))
                    return "title: string expected";
            if (message.fileSha256 != null && message.hasOwnProperty("fileSha256"))
                if (!(message.fileSha256 && typeof message.fileSha256.length === "number" || $util.isString(message.fileSha256)))
                    return "fileSha256: buffer expected";
            if (message.fileLength != null && message.hasOwnProperty("fileLength"))
                if (!$util.isInteger(message.fileLength) && !(message.fileLength && $util.isInteger(message.fileLength.low) && $util.isInteger(message.fileLength.high)))
                    return "fileLength: integer|Long expected";
            if (message.pageCount != null && message.hasOwnProperty("pageCount"))
                if (!$util.isInteger(message.pageCount))
                    return "pageCount: integer expected";
            if (message.mediaKey != null && message.hasOwnProperty("mediaKey"))
                if (!(message.mediaKey && typeof message.mediaKey.length === "number" || $util.isString(message.mediaKey)))
                    return "mediaKey: buffer expected";
            if (message.fileName != null && message.hasOwnProperty("fileName"))
                if (!$util.isString(message.fileName))
                    return "fileName: string expected";
            if (message.fileEncSha256 != null && message.hasOwnProperty("fileEncSha256"))
                if (!(message.fileEncSha256 && typeof message.fileEncSha256.length === "number" || $util.isString(message.fileEncSha256)))
                    return "fileEncSha256: buffer expected";
            if (message.directPath != null && message.hasOwnProperty("directPath"))
                if (!$util.isString(message.directPath))
                    return "directPath: string expected";
            if (message.mediaKeyTimestamp != null && message.hasOwnProperty("mediaKeyTimestamp"))
                if (!$util.isInteger(message.mediaKeyTimestamp) && !(message.mediaKeyTimestamp && $util.isInteger(message.mediaKeyTimestamp.low) && $util.isInteger(message.mediaKeyTimestamp.high)))
                    return "mediaKeyTimestamp: integer|Long expected";
            if (message.contactVcard != null && message.hasOwnProperty("contactVcard"))
                if (typeof message.contactVcard !== "boolean")
                    return "contactVcard: boolean expected";
            if (message.thumbnailDirectPath != null && message.hasOwnProperty("thumbnailDirectPath"))
                if (!$util.isString(message.thumbnailDirectPath))
                    return "thumbnailDirectPath: string expected";
            if (message.thumbnailSha256 != null && message.hasOwnProperty("thumbnailSha256"))
                if (!(message.thumbnailSha256 && typeof message.thumbnailSha256.length === "number" || $util.isString(message.thumbnailSha256)))
                    return "thumbnailSha256: buffer expected";
            if (message.thumbnailEncSha256 != null && message.hasOwnProperty("thumbnailEncSha256"))
                if (!(message.thumbnailEncSha256 && typeof message.thumbnailEncSha256.length === "number" || $util.isString(message.thumbnailEncSha256)))
                    return "thumbnailEncSha256: buffer expected";
            if (message.jpegThumbnail != null && message.hasOwnProperty("jpegThumbnail"))
                if (!(message.jpegThumbnail && typeof message.jpegThumbnail.length === "number" || $util.isString(message.jpegThumbnail)))
                    return "jpegThumbnail: buffer expected";
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo")) {
                var error = $root.proto.ContextInfo.verify(message.contextInfo);
                if (error)
                    return "contextInfo." + error;
            }
            if (message.thumbnailHeight != null && message.hasOwnProperty("thumbnailHeight"))
                if (!$util.isInteger(message.thumbnailHeight))
                    return "thumbnailHeight: integer expected";
            if (message.thumbnailWidth != null && message.hasOwnProperty("thumbnailWidth"))
                if (!$util.isInteger(message.thumbnailWidth))
                    return "thumbnailWidth: integer expected";
            return null;
        };

        /**
         * Creates a DocumentMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.DocumentMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.DocumentMessage} DocumentMessage
         */
        DocumentMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.DocumentMessage)
                return object;
            var message = new $root.proto.DocumentMessage();
            if (object.url != null)
                message.url = String(object.url);
            if (object.mimetype != null)
                message.mimetype = String(object.mimetype);
            if (object.title != null)
                message.title = String(object.title);
            if (object.fileSha256 != null)
                if (typeof object.fileSha256 === "string")
                    $util.base64.decode(object.fileSha256, message.fileSha256 = $util.newBuffer($util.base64.length(object.fileSha256)), 0);
                else if (object.fileSha256.length)
                    message.fileSha256 = object.fileSha256;
            if (object.fileLength != null)
                if ($util.Long)
                    (message.fileLength = $util.Long.fromValue(object.fileLength)).unsigned = true;
                else if (typeof object.fileLength === "string")
                    message.fileLength = parseInt(object.fileLength, 10);
                else if (typeof object.fileLength === "number")
                    message.fileLength = object.fileLength;
                else if (typeof object.fileLength === "object")
                    message.fileLength = new $util.LongBits(object.fileLength.low >>> 0, object.fileLength.high >>> 0).toNumber(true);
            if (object.pageCount != null)
                message.pageCount = object.pageCount >>> 0;
            if (object.mediaKey != null)
                if (typeof object.mediaKey === "string")
                    $util.base64.decode(object.mediaKey, message.mediaKey = $util.newBuffer($util.base64.length(object.mediaKey)), 0);
                else if (object.mediaKey.length)
                    message.mediaKey = object.mediaKey;
            if (object.fileName != null)
                message.fileName = String(object.fileName);
            if (object.fileEncSha256 != null)
                if (typeof object.fileEncSha256 === "string")
                    $util.base64.decode(object.fileEncSha256, message.fileEncSha256 = $util.newBuffer($util.base64.length(object.fileEncSha256)), 0);
                else if (object.fileEncSha256.length)
                    message.fileEncSha256 = object.fileEncSha256;
            if (object.directPath != null)
                message.directPath = String(object.directPath);
            if (object.mediaKeyTimestamp != null)
                if ($util.Long)
                    (message.mediaKeyTimestamp = $util.Long.fromValue(object.mediaKeyTimestamp)).unsigned = false;
                else if (typeof object.mediaKeyTimestamp === "string")
                    message.mediaKeyTimestamp = parseInt(object.mediaKeyTimestamp, 10);
                else if (typeof object.mediaKeyTimestamp === "number")
                    message.mediaKeyTimestamp = object.mediaKeyTimestamp;
                else if (typeof object.mediaKeyTimestamp === "object")
                    message.mediaKeyTimestamp = new $util.LongBits(object.mediaKeyTimestamp.low >>> 0, object.mediaKeyTimestamp.high >>> 0).toNumber();
            if (object.contactVcard != null)
                message.contactVcard = Boolean(object.contactVcard);
            if (object.thumbnailDirectPath != null)
                message.thumbnailDirectPath = String(object.thumbnailDirectPath);
            if (object.thumbnailSha256 != null)
                if (typeof object.thumbnailSha256 === "string")
                    $util.base64.decode(object.thumbnailSha256, message.thumbnailSha256 = $util.newBuffer($util.base64.length(object.thumbnailSha256)), 0);
                else if (object.thumbnailSha256.length)
                    message.thumbnailSha256 = object.thumbnailSha256;
            if (object.thumbnailEncSha256 != null)
                if (typeof object.thumbnailEncSha256 === "string")
                    $util.base64.decode(object.thumbnailEncSha256, message.thumbnailEncSha256 = $util.newBuffer($util.base64.length(object.thumbnailEncSha256)), 0);
                else if (object.thumbnailEncSha256.length)
                    message.thumbnailEncSha256 = object.thumbnailEncSha256;
            if (object.jpegThumbnail != null)
                if (typeof object.jpegThumbnail === "string")
                    $util.base64.decode(object.jpegThumbnail, message.jpegThumbnail = $util.newBuffer($util.base64.length(object.jpegThumbnail)), 0);
                else if (object.jpegThumbnail.length)
                    message.jpegThumbnail = object.jpegThumbnail;
            if (object.contextInfo != null) {
                if (typeof object.contextInfo !== "object")
                    throw TypeError(".proto.DocumentMessage.contextInfo: object expected");
                message.contextInfo = $root.proto.ContextInfo.fromObject(object.contextInfo);
            }
            if (object.thumbnailHeight != null)
                message.thumbnailHeight = object.thumbnailHeight >>> 0;
            if (object.thumbnailWidth != null)
                message.thumbnailWidth = object.thumbnailWidth >>> 0;
            return message;
        };

        /**
         * Creates a plain object from a DocumentMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.DocumentMessage
         * @static
         * @param {proto.DocumentMessage} message DocumentMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DocumentMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.url = "";
                object.mimetype = "";
                object.title = "";
                if (options.bytes === String)
                    object.fileSha256 = "";
                else {
                    object.fileSha256 = [];
                    if (options.bytes !== Array)
                        object.fileSha256 = $util.newBuffer(object.fileSha256);
                }
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.fileLength = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.fileLength = options.longs === String ? "0" : 0;
                object.pageCount = 0;
                if (options.bytes === String)
                    object.mediaKey = "";
                else {
                    object.mediaKey = [];
                    if (options.bytes !== Array)
                        object.mediaKey = $util.newBuffer(object.mediaKey);
                }
                object.fileName = "";
                if (options.bytes === String)
                    object.fileEncSha256 = "";
                else {
                    object.fileEncSha256 = [];
                    if (options.bytes !== Array)
                        object.fileEncSha256 = $util.newBuffer(object.fileEncSha256);
                }
                object.directPath = "";
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.mediaKeyTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.mediaKeyTimestamp = options.longs === String ? "0" : 0;
                object.contactVcard = false;
                object.thumbnailDirectPath = "";
                if (options.bytes === String)
                    object.thumbnailSha256 = "";
                else {
                    object.thumbnailSha256 = [];
                    if (options.bytes !== Array)
                        object.thumbnailSha256 = $util.newBuffer(object.thumbnailSha256);
                }
                if (options.bytes === String)
                    object.thumbnailEncSha256 = "";
                else {
                    object.thumbnailEncSha256 = [];
                    if (options.bytes !== Array)
                        object.thumbnailEncSha256 = $util.newBuffer(object.thumbnailEncSha256);
                }
                if (options.bytes === String)
                    object.jpegThumbnail = "";
                else {
                    object.jpegThumbnail = [];
                    if (options.bytes !== Array)
                        object.jpegThumbnail = $util.newBuffer(object.jpegThumbnail);
                }
                object.contextInfo = null;
                object.thumbnailHeight = 0;
                object.thumbnailWidth = 0;
            }
            if (message.url != null && message.hasOwnProperty("url"))
                object.url = message.url;
            if (message.mimetype != null && message.hasOwnProperty("mimetype"))
                object.mimetype = message.mimetype;
            if (message.title != null && message.hasOwnProperty("title"))
                object.title = message.title;
            if (message.fileSha256 != null && message.hasOwnProperty("fileSha256"))
                object.fileSha256 = options.bytes === String ? $util.base64.encode(message.fileSha256, 0, message.fileSha256.length) : options.bytes === Array ? Array.prototype.slice.call(message.fileSha256) : message.fileSha256;
            if (message.fileLength != null && message.hasOwnProperty("fileLength"))
                if (typeof message.fileLength === "number")
                    object.fileLength = options.longs === String ? String(message.fileLength) : message.fileLength;
                else
                    object.fileLength = options.longs === String ? $util.Long.prototype.toString.call(message.fileLength) : options.longs === Number ? new $util.LongBits(message.fileLength.low >>> 0, message.fileLength.high >>> 0).toNumber(true) : message.fileLength;
            if (message.pageCount != null && message.hasOwnProperty("pageCount"))
                object.pageCount = message.pageCount;
            if (message.mediaKey != null && message.hasOwnProperty("mediaKey"))
                object.mediaKey = options.bytes === String ? $util.base64.encode(message.mediaKey, 0, message.mediaKey.length) : options.bytes === Array ? Array.prototype.slice.call(message.mediaKey) : message.mediaKey;
            if (message.fileName != null && message.hasOwnProperty("fileName"))
                object.fileName = message.fileName;
            if (message.fileEncSha256 != null && message.hasOwnProperty("fileEncSha256"))
                object.fileEncSha256 = options.bytes === String ? $util.base64.encode(message.fileEncSha256, 0, message.fileEncSha256.length) : options.bytes === Array ? Array.prototype.slice.call(message.fileEncSha256) : message.fileEncSha256;
            if (message.directPath != null && message.hasOwnProperty("directPath"))
                object.directPath = message.directPath;
            if (message.mediaKeyTimestamp != null && message.hasOwnProperty("mediaKeyTimestamp"))
                if (typeof message.mediaKeyTimestamp === "number")
                    object.mediaKeyTimestamp = options.longs === String ? String(message.mediaKeyTimestamp) : message.mediaKeyTimestamp;
                else
                    object.mediaKeyTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.mediaKeyTimestamp) : options.longs === Number ? new $util.LongBits(message.mediaKeyTimestamp.low >>> 0, message.mediaKeyTimestamp.high >>> 0).toNumber() : message.mediaKeyTimestamp;
            if (message.contactVcard != null && message.hasOwnProperty("contactVcard"))
                object.contactVcard = message.contactVcard;
            if (message.thumbnailDirectPath != null && message.hasOwnProperty("thumbnailDirectPath"))
                object.thumbnailDirectPath = message.thumbnailDirectPath;
            if (message.thumbnailSha256 != null && message.hasOwnProperty("thumbnailSha256"))
                object.thumbnailSha256 = options.bytes === String ? $util.base64.encode(message.thumbnailSha256, 0, message.thumbnailSha256.length) : options.bytes === Array ? Array.prototype.slice.call(message.thumbnailSha256) : message.thumbnailSha256;
            if (message.thumbnailEncSha256 != null && message.hasOwnProperty("thumbnailEncSha256"))
                object.thumbnailEncSha256 = options.bytes === String ? $util.base64.encode(message.thumbnailEncSha256, 0, message.thumbnailEncSha256.length) : options.bytes === Array ? Array.prototype.slice.call(message.thumbnailEncSha256) : message.thumbnailEncSha256;
            if (message.jpegThumbnail != null && message.hasOwnProperty("jpegThumbnail"))
                object.jpegThumbnail = options.bytes === String ? $util.base64.encode(message.jpegThumbnail, 0, message.jpegThumbnail.length) : options.bytes === Array ? Array.prototype.slice.call(message.jpegThumbnail) : message.jpegThumbnail;
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo"))
                object.contextInfo = $root.proto.ContextInfo.toObject(message.contextInfo, options);
            if (message.thumbnailHeight != null && message.hasOwnProperty("thumbnailHeight"))
                object.thumbnailHeight = message.thumbnailHeight;
            if (message.thumbnailWidth != null && message.hasOwnProperty("thumbnailWidth"))
                object.thumbnailWidth = message.thumbnailWidth;
            return object;
        };

        /**
         * Converts this DocumentMessage to JSON.
         * @function toJSON
         * @memberof proto.DocumentMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DocumentMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DocumentMessage;
    })();

    proto.ExtendedTextMessage = (function() {

        /**
         * Properties of an ExtendedTextMessage.
         * @memberof proto
         * @interface IExtendedTextMessage
         * @property {string|null} [text] ExtendedTextMessage text
         * @property {string|null} [matchedText] ExtendedTextMessage matchedText
         * @property {string|null} [canonicalUrl] ExtendedTextMessage canonicalUrl
         * @property {string|null} [description] ExtendedTextMessage description
         * @property {string|null} [title] ExtendedTextMessage title
         * @property {number|null} [textArgb] ExtendedTextMessage textArgb
         * @property {number|null} [backgroundArgb] ExtendedTextMessage backgroundArgb
         * @property {proto.ExtendedTextMessage.ExtendedTextMessageFontType|null} [font] ExtendedTextMessage font
         * @property {proto.ExtendedTextMessage.ExtendedTextMessagePreviewType|null} [previewType] ExtendedTextMessage previewType
         * @property {Uint8Array|null} [jpegThumbnail] ExtendedTextMessage jpegThumbnail
         * @property {proto.IContextInfo|null} [contextInfo] ExtendedTextMessage contextInfo
         * @property {boolean|null} [doNotPlayInline] ExtendedTextMessage doNotPlayInline
         * @property {string|null} [thumbnailDirectPath] ExtendedTextMessage thumbnailDirectPath
         * @property {Uint8Array|null} [thumbnailSha256] ExtendedTextMessage thumbnailSha256
         * @property {Uint8Array|null} [thumbnailEncSha256] ExtendedTextMessage thumbnailEncSha256
         * @property {Uint8Array|null} [mediaKey] ExtendedTextMessage mediaKey
         * @property {number|Long|null} [mediaKeyTimestamp] ExtendedTextMessage mediaKeyTimestamp
         * @property {number|null} [thumbnailHeight] ExtendedTextMessage thumbnailHeight
         * @property {number|null} [thumbnailWidth] ExtendedTextMessage thumbnailWidth
         * @property {proto.ExtendedTextMessage.ExtendedTextMessageInviteLinkGroupType|null} [inviteLinkGroupType] ExtendedTextMessage inviteLinkGroupType
         * @property {string|null} [inviteLinkParentGroupSubjectV2] ExtendedTextMessage inviteLinkParentGroupSubjectV2
         * @property {Uint8Array|null} [inviteLinkParentGroupThumbnailV2] ExtendedTextMessage inviteLinkParentGroupThumbnailV2
         * @property {proto.ExtendedTextMessage.ExtendedTextMessageInviteLinkGroupType|null} [inviteLinkGroupTypeV2] ExtendedTextMessage inviteLinkGroupTypeV2
         */

        /**
         * Constructs a new ExtendedTextMessage.
         * @memberof proto
         * @classdesc Represents an ExtendedTextMessage.
         * @implements IExtendedTextMessage
         * @constructor
         * @param {proto.IExtendedTextMessage=} [properties] Properties to set
         */
        function ExtendedTextMessage(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ExtendedTextMessage text.
         * @member {string} text
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.text = "";

        /**
         * ExtendedTextMessage matchedText.
         * @member {string} matchedText
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.matchedText = "";

        /**
         * ExtendedTextMessage canonicalUrl.
         * @member {string} canonicalUrl
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.canonicalUrl = "";

        /**
         * ExtendedTextMessage description.
         * @member {string} description
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.description = "";

        /**
         * ExtendedTextMessage title.
         * @member {string} title
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.title = "";

        /**
         * ExtendedTextMessage textArgb.
         * @member {number} textArgb
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.textArgb = 0;

        /**
         * ExtendedTextMessage backgroundArgb.
         * @member {number} backgroundArgb
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.backgroundArgb = 0;

        /**
         * ExtendedTextMessage font.
         * @member {proto.ExtendedTextMessage.ExtendedTextMessageFontType} font
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.font = 0;

        /**
         * ExtendedTextMessage previewType.
         * @member {proto.ExtendedTextMessage.ExtendedTextMessagePreviewType} previewType
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.previewType = 0;

        /**
         * ExtendedTextMessage jpegThumbnail.
         * @member {Uint8Array} jpegThumbnail
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.jpegThumbnail = $util.newBuffer([]);

        /**
         * ExtendedTextMessage contextInfo.
         * @member {proto.IContextInfo|null|undefined} contextInfo
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.contextInfo = null;

        /**
         * ExtendedTextMessage doNotPlayInline.
         * @member {boolean} doNotPlayInline
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.doNotPlayInline = false;

        /**
         * ExtendedTextMessage thumbnailDirectPath.
         * @member {string} thumbnailDirectPath
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.thumbnailDirectPath = "";

        /**
         * ExtendedTextMessage thumbnailSha256.
         * @member {Uint8Array} thumbnailSha256
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.thumbnailSha256 = $util.newBuffer([]);

        /**
         * ExtendedTextMessage thumbnailEncSha256.
         * @member {Uint8Array} thumbnailEncSha256
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.thumbnailEncSha256 = $util.newBuffer([]);

        /**
         * ExtendedTextMessage mediaKey.
         * @member {Uint8Array} mediaKey
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.mediaKey = $util.newBuffer([]);

        /**
         * ExtendedTextMessage mediaKeyTimestamp.
         * @member {number|Long} mediaKeyTimestamp
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.mediaKeyTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * ExtendedTextMessage thumbnailHeight.
         * @member {number} thumbnailHeight
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.thumbnailHeight = 0;

        /**
         * ExtendedTextMessage thumbnailWidth.
         * @member {number} thumbnailWidth
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.thumbnailWidth = 0;

        /**
         * ExtendedTextMessage inviteLinkGroupType.
         * @member {proto.ExtendedTextMessage.ExtendedTextMessageInviteLinkGroupType} inviteLinkGroupType
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.inviteLinkGroupType = 0;

        /**
         * ExtendedTextMessage inviteLinkParentGroupSubjectV2.
         * @member {string} inviteLinkParentGroupSubjectV2
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.inviteLinkParentGroupSubjectV2 = "";

        /**
         * ExtendedTextMessage inviteLinkParentGroupThumbnailV2.
         * @member {Uint8Array} inviteLinkParentGroupThumbnailV2
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.inviteLinkParentGroupThumbnailV2 = $util.newBuffer([]);

        /**
         * ExtendedTextMessage inviteLinkGroupTypeV2.
         * @member {proto.ExtendedTextMessage.ExtendedTextMessageInviteLinkGroupType} inviteLinkGroupTypeV2
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.inviteLinkGroupTypeV2 = 0;

        /**
         * Creates a new ExtendedTextMessage instance using the specified properties.
         * @function create
         * @memberof proto.ExtendedTextMessage
         * @static
         * @param {proto.IExtendedTextMessage=} [properties] Properties to set
         * @returns {proto.ExtendedTextMessage} ExtendedTextMessage instance
         */
        ExtendedTextMessage.create = function create(properties) {
            return new ExtendedTextMessage(properties);
        };

        /**
         * Encodes the specified ExtendedTextMessage message. Does not implicitly {@link proto.ExtendedTextMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.ExtendedTextMessage
         * @static
         * @param {proto.IExtendedTextMessage} message ExtendedTextMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ExtendedTextMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.text != null && Object.hasOwnProperty.call(message, "text"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.text);
            if (message.matchedText != null && Object.hasOwnProperty.call(message, "matchedText"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.matchedText);
            if (message.canonicalUrl != null && Object.hasOwnProperty.call(message, "canonicalUrl"))
                writer.uint32(/* id 4, wireType 2 =*/34).string(message.canonicalUrl);
            if (message.description != null && Object.hasOwnProperty.call(message, "description"))
                writer.uint32(/* id 5, wireType 2 =*/42).string(message.description);
            if (message.title != null && Object.hasOwnProperty.call(message, "title"))
                writer.uint32(/* id 6, wireType 2 =*/50).string(message.title);
            if (message.textArgb != null && Object.hasOwnProperty.call(message, "textArgb"))
                writer.uint32(/* id 7, wireType 5 =*/61).fixed32(message.textArgb);
            if (message.backgroundArgb != null && Object.hasOwnProperty.call(message, "backgroundArgb"))
                writer.uint32(/* id 8, wireType 5 =*/69).fixed32(message.backgroundArgb);
            if (message.font != null && Object.hasOwnProperty.call(message, "font"))
                writer.uint32(/* id 9, wireType 0 =*/72).int32(message.font);
            if (message.previewType != null && Object.hasOwnProperty.call(message, "previewType"))
                writer.uint32(/* id 10, wireType 0 =*/80).int32(message.previewType);
            if (message.jpegThumbnail != null && Object.hasOwnProperty.call(message, "jpegThumbnail"))
                writer.uint32(/* id 16, wireType 2 =*/130).bytes(message.jpegThumbnail);
            if (message.contextInfo != null && Object.hasOwnProperty.call(message, "contextInfo"))
                $root.proto.ContextInfo.encode(message.contextInfo, writer.uint32(/* id 17, wireType 2 =*/138).fork()).ldelim();
            if (message.doNotPlayInline != null && Object.hasOwnProperty.call(message, "doNotPlayInline"))
                writer.uint32(/* id 18, wireType 0 =*/144).bool(message.doNotPlayInline);
            if (message.thumbnailDirectPath != null && Object.hasOwnProperty.call(message, "thumbnailDirectPath"))
                writer.uint32(/* id 19, wireType 2 =*/154).string(message.thumbnailDirectPath);
            if (message.thumbnailSha256 != null && Object.hasOwnProperty.call(message, "thumbnailSha256"))
                writer.uint32(/* id 20, wireType 2 =*/162).bytes(message.thumbnailSha256);
            if (message.thumbnailEncSha256 != null && Object.hasOwnProperty.call(message, "thumbnailEncSha256"))
                writer.uint32(/* id 21, wireType 2 =*/170).bytes(message.thumbnailEncSha256);
            if (message.mediaKey != null && Object.hasOwnProperty.call(message, "mediaKey"))
                writer.uint32(/* id 22, wireType 2 =*/178).bytes(message.mediaKey);
            if (message.mediaKeyTimestamp != null && Object.hasOwnProperty.call(message, "mediaKeyTimestamp"))
                writer.uint32(/* id 23, wireType 0 =*/184).int64(message.mediaKeyTimestamp);
            if (message.thumbnailHeight != null && Object.hasOwnProperty.call(message, "thumbnailHeight"))
                writer.uint32(/* id 24, wireType 0 =*/192).uint32(message.thumbnailHeight);
            if (message.thumbnailWidth != null && Object.hasOwnProperty.call(message, "thumbnailWidth"))
                writer.uint32(/* id 25, wireType 0 =*/200).uint32(message.thumbnailWidth);
            if (message.inviteLinkGroupType != null && Object.hasOwnProperty.call(message, "inviteLinkGroupType"))
                writer.uint32(/* id 26, wireType 0 =*/208).int32(message.inviteLinkGroupType);
            if (message.inviteLinkParentGroupSubjectV2 != null && Object.hasOwnProperty.call(message, "inviteLinkParentGroupSubjectV2"))
                writer.uint32(/* id 27, wireType 2 =*/218).string(message.inviteLinkParentGroupSubjectV2);
            if (message.inviteLinkParentGroupThumbnailV2 != null && Object.hasOwnProperty.call(message, "inviteLinkParentGroupThumbnailV2"))
                writer.uint32(/* id 28, wireType 2 =*/226).bytes(message.inviteLinkParentGroupThumbnailV2);
            if (message.inviteLinkGroupTypeV2 != null && Object.hasOwnProperty.call(message, "inviteLinkGroupTypeV2"))
                writer.uint32(/* id 29, wireType 0 =*/232).int32(message.inviteLinkGroupTypeV2);
            return writer;
        };

        /**
         * Encodes the specified ExtendedTextMessage message, length delimited. Does not implicitly {@link proto.ExtendedTextMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ExtendedTextMessage
         * @static
         * @param {proto.IExtendedTextMessage} message ExtendedTextMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ExtendedTextMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an ExtendedTextMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ExtendedTextMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ExtendedTextMessage} ExtendedTextMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ExtendedTextMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ExtendedTextMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.text = reader.string();
                    break;
                case 2:
                    message.matchedText = reader.string();
                    break;
                case 4:
                    message.canonicalUrl = reader.string();
                    break;
                case 5:
                    message.description = reader.string();
                    break;
                case 6:
                    message.title = reader.string();
                    break;
                case 7:
                    message.textArgb = reader.fixed32();
                    break;
                case 8:
                    message.backgroundArgb = reader.fixed32();
                    break;
                case 9:
                    message.font = reader.int32();
                    break;
                case 10:
                    message.previewType = reader.int32();
                    break;
                case 16:
                    message.jpegThumbnail = reader.bytes();
                    break;
                case 17:
                    message.contextInfo = $root.proto.ContextInfo.decode(reader, reader.uint32());
                    break;
                case 18:
                    message.doNotPlayInline = reader.bool();
                    break;
                case 19:
                    message.thumbnailDirectPath = reader.string();
                    break;
                case 20:
                    message.thumbnailSha256 = reader.bytes();
                    break;
                case 21:
                    message.thumbnailEncSha256 = reader.bytes();
                    break;
                case 22:
                    message.mediaKey = reader.bytes();
                    break;
                case 23:
                    message.mediaKeyTimestamp = reader.int64();
                    break;
                case 24:
                    message.thumbnailHeight = reader.uint32();
                    break;
                case 25:
                    message.thumbnailWidth = reader.uint32();
                    break;
                case 26:
                    message.inviteLinkGroupType = reader.int32();
                    break;
                case 27:
                    message.inviteLinkParentGroupSubjectV2 = reader.string();
                    break;
                case 28:
                    message.inviteLinkParentGroupThumbnailV2 = reader.bytes();
                    break;
                case 29:
                    message.inviteLinkGroupTypeV2 = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an ExtendedTextMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ExtendedTextMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ExtendedTextMessage} ExtendedTextMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ExtendedTextMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an ExtendedTextMessage message.
         * @function verify
         * @memberof proto.ExtendedTextMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ExtendedTextMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.text != null && message.hasOwnProperty("text"))
                if (!$util.isString(message.text))
                    return "text: string expected";
            if (message.matchedText != null && message.hasOwnProperty("matchedText"))
                if (!$util.isString(message.matchedText))
                    return "matchedText: string expected";
            if (message.canonicalUrl != null && message.hasOwnProperty("canonicalUrl"))
                if (!$util.isString(message.canonicalUrl))
                    return "canonicalUrl: string expected";
            if (message.description != null && message.hasOwnProperty("description"))
                if (!$util.isString(message.description))
                    return "description: string expected";
            if (message.title != null && message.hasOwnProperty("title"))
                if (!$util.isString(message.title))
                    return "title: string expected";
            if (message.textArgb != null && message.hasOwnProperty("textArgb"))
                if (!$util.isInteger(message.textArgb))
                    return "textArgb: integer expected";
            if (message.backgroundArgb != null && message.hasOwnProperty("backgroundArgb"))
                if (!$util.isInteger(message.backgroundArgb))
                    return "backgroundArgb: integer expected";
            if (message.font != null && message.hasOwnProperty("font"))
                switch (message.font) {
                default:
                    return "font: enum value expected";
                case 0:
                case 1:
                case 2:
                case 3:
                case 4:
                case 5:
                    break;
                }
            if (message.previewType != null && message.hasOwnProperty("previewType"))
                switch (message.previewType) {
                default:
                    return "previewType: enum value expected";
                case 0:
                case 1:
                    break;
                }
            if (message.jpegThumbnail != null && message.hasOwnProperty("jpegThumbnail"))
                if (!(message.jpegThumbnail && typeof message.jpegThumbnail.length === "number" || $util.isString(message.jpegThumbnail)))
                    return "jpegThumbnail: buffer expected";
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo")) {
                var error = $root.proto.ContextInfo.verify(message.contextInfo);
                if (error)
                    return "contextInfo." + error;
            }
            if (message.doNotPlayInline != null && message.hasOwnProperty("doNotPlayInline"))
                if (typeof message.doNotPlayInline !== "boolean")
                    return "doNotPlayInline: boolean expected";
            if (message.thumbnailDirectPath != null && message.hasOwnProperty("thumbnailDirectPath"))
                if (!$util.isString(message.thumbnailDirectPath))
                    return "thumbnailDirectPath: string expected";
            if (message.thumbnailSha256 != null && message.hasOwnProperty("thumbnailSha256"))
                if (!(message.thumbnailSha256 && typeof message.thumbnailSha256.length === "number" || $util.isString(message.thumbnailSha256)))
                    return "thumbnailSha256: buffer expected";
            if (message.thumbnailEncSha256 != null && message.hasOwnProperty("thumbnailEncSha256"))
                if (!(message.thumbnailEncSha256 && typeof message.thumbnailEncSha256.length === "number" || $util.isString(message.thumbnailEncSha256)))
                    return "thumbnailEncSha256: buffer expected";
            if (message.mediaKey != null && message.hasOwnProperty("mediaKey"))
                if (!(message.mediaKey && typeof message.mediaKey.length === "number" || $util.isString(message.mediaKey)))
                    return "mediaKey: buffer expected";
            if (message.mediaKeyTimestamp != null && message.hasOwnProperty("mediaKeyTimestamp"))
                if (!$util.isInteger(message.mediaKeyTimestamp) && !(message.mediaKeyTimestamp && $util.isInteger(message.mediaKeyTimestamp.low) && $util.isInteger(message.mediaKeyTimestamp.high)))
                    return "mediaKeyTimestamp: integer|Long expected";
            if (message.thumbnailHeight != null && message.hasOwnProperty("thumbnailHeight"))
                if (!$util.isInteger(message.thumbnailHeight))
                    return "thumbnailHeight: integer expected";
            if (message.thumbnailWidth != null && message.hasOwnProperty("thumbnailWidth"))
                if (!$util.isInteger(message.thumbnailWidth))
                    return "thumbnailWidth: integer expected";
            if (message.inviteLinkGroupType != null && message.hasOwnProperty("inviteLinkGroupType"))
                switch (message.inviteLinkGroupType) {
                default:
                    return "inviteLinkGroupType: enum value expected";
                case 0:
                case 1:
                    break;
                }
            if (message.inviteLinkParentGroupSubjectV2 != null && message.hasOwnProperty("inviteLinkParentGroupSubjectV2"))
                if (!$util.isString(message.inviteLinkParentGroupSubjectV2))
                    return "inviteLinkParentGroupSubjectV2: string expected";
            if (message.inviteLinkParentGroupThumbnailV2 != null && message.hasOwnProperty("inviteLinkParentGroupThumbnailV2"))
                if (!(message.inviteLinkParentGroupThumbnailV2 && typeof message.inviteLinkParentGroupThumbnailV2.length === "number" || $util.isString(message.inviteLinkParentGroupThumbnailV2)))
                    return "inviteLinkParentGroupThumbnailV2: buffer expected";
            if (message.inviteLinkGroupTypeV2 != null && message.hasOwnProperty("inviteLinkGroupTypeV2"))
                switch (message.inviteLinkGroupTypeV2) {
                default:
                    return "inviteLinkGroupTypeV2: enum value expected";
                case 0:
                case 1:
                    break;
                }
            return null;
        };

        /**
         * Creates an ExtendedTextMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ExtendedTextMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ExtendedTextMessage} ExtendedTextMessage
         */
        ExtendedTextMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ExtendedTextMessage)
                return object;
            var message = new $root.proto.ExtendedTextMessage();
            if (object.text != null)
                message.text = String(object.text);
            if (object.matchedText != null)
                message.matchedText = String(object.matchedText);
            if (object.canonicalUrl != null)
                message.canonicalUrl = String(object.canonicalUrl);
            if (object.description != null)
                message.description = String(object.description);
            if (object.title != null)
                message.title = String(object.title);
            if (object.textArgb != null)
                message.textArgb = object.textArgb >>> 0;
            if (object.backgroundArgb != null)
                message.backgroundArgb = object.backgroundArgb >>> 0;
            switch (object.font) {
            case "SANS_SERIF":
            case 0:
                message.font = 0;
                break;
            case "SERIF":
            case 1:
                message.font = 1;
                break;
            case "NORICAN_REGULAR":
            case 2:
                message.font = 2;
                break;
            case "BRYNDAN_WRITE":
            case 3:
                message.font = 3;
                break;
            case "BEBASNEUE_REGULAR":
            case 4:
                message.font = 4;
                break;
            case "OSWALD_HEAVY":
            case 5:
                message.font = 5;
                break;
            }
            switch (object.previewType) {
            case "NONE":
            case 0:
                message.previewType = 0;
                break;
            case "VIDEO":
            case 1:
                message.previewType = 1;
                break;
            }
            if (object.jpegThumbnail != null)
                if (typeof object.jpegThumbnail === "string")
                    $util.base64.decode(object.jpegThumbnail, message.jpegThumbnail = $util.newBuffer($util.base64.length(object.jpegThumbnail)), 0);
                else if (object.jpegThumbnail.length)
                    message.jpegThumbnail = object.jpegThumbnail;
            if (object.contextInfo != null) {
                if (typeof object.contextInfo !== "object")
                    throw TypeError(".proto.ExtendedTextMessage.contextInfo: object expected");
                message.contextInfo = $root.proto.ContextInfo.fromObject(object.contextInfo);
            }
            if (object.doNotPlayInline != null)
                message.doNotPlayInline = Boolean(object.doNotPlayInline);
            if (object.thumbnailDirectPath != null)
                message.thumbnailDirectPath = String(object.thumbnailDirectPath);
            if (object.thumbnailSha256 != null)
                if (typeof object.thumbnailSha256 === "string")
                    $util.base64.decode(object.thumbnailSha256, message.thumbnailSha256 = $util.newBuffer($util.base64.length(object.thumbnailSha256)), 0);
                else if (object.thumbnailSha256.length)
                    message.thumbnailSha256 = object.thumbnailSha256;
            if (object.thumbnailEncSha256 != null)
                if (typeof object.thumbnailEncSha256 === "string")
                    $util.base64.decode(object.thumbnailEncSha256, message.thumbnailEncSha256 = $util.newBuffer($util.base64.length(object.thumbnailEncSha256)), 0);
                else if (object.thumbnailEncSha256.length)
                    message.thumbnailEncSha256 = object.thumbnailEncSha256;
            if (object.mediaKey != null)
                if (typeof object.mediaKey === "string")
                    $util.base64.decode(object.mediaKey, message.mediaKey = $util.newBuffer($util.base64.length(object.mediaKey)), 0);
                else if (object.mediaKey.length)
                    message.mediaKey = object.mediaKey;
            if (object.mediaKeyTimestamp != null)
                if ($util.Long)
                    (message.mediaKeyTimestamp = $util.Long.fromValue(object.mediaKeyTimestamp)).unsigned = false;
                else if (typeof object.mediaKeyTimestamp === "string")
                    message.mediaKeyTimestamp = parseInt(object.mediaKeyTimestamp, 10);
                else if (typeof object.mediaKeyTimestamp === "number")
                    message.mediaKeyTimestamp = object.mediaKeyTimestamp;
                else if (typeof object.mediaKeyTimestamp === "object")
                    message.mediaKeyTimestamp = new $util.LongBits(object.mediaKeyTimestamp.low >>> 0, object.mediaKeyTimestamp.high >>> 0).toNumber();
            if (object.thumbnailHeight != null)
                message.thumbnailHeight = object.thumbnailHeight >>> 0;
            if (object.thumbnailWidth != null)
                message.thumbnailWidth = object.thumbnailWidth >>> 0;
            switch (object.inviteLinkGroupType) {
            case "DEFAULT":
            case 0:
                message.inviteLinkGroupType = 0;
                break;
            case "PARENT":
            case 1:
                message.inviteLinkGroupType = 1;
                break;
            }
            if (object.inviteLinkParentGroupSubjectV2 != null)
                message.inviteLinkParentGroupSubjectV2 = String(object.inviteLinkParentGroupSubjectV2);
            if (object.inviteLinkParentGroupThumbnailV2 != null)
                if (typeof object.inviteLinkParentGroupThumbnailV2 === "string")
                    $util.base64.decode(object.inviteLinkParentGroupThumbnailV2, message.inviteLinkParentGroupThumbnailV2 = $util.newBuffer($util.base64.length(object.inviteLinkParentGroupThumbnailV2)), 0);
                else if (object.inviteLinkParentGroupThumbnailV2.length)
                    message.inviteLinkParentGroupThumbnailV2 = object.inviteLinkParentGroupThumbnailV2;
            switch (object.inviteLinkGroupTypeV2) {
            case "DEFAULT":
            case 0:
                message.inviteLinkGroupTypeV2 = 0;
                break;
            case "PARENT":
            case 1:
                message.inviteLinkGroupTypeV2 = 1;
                break;
            }
            return message;
        };

        /**
         * Creates a plain object from an ExtendedTextMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ExtendedTextMessage
         * @static
         * @param {proto.ExtendedTextMessage} message ExtendedTextMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ExtendedTextMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.text = "";
                object.matchedText = "";
                object.canonicalUrl = "";
                object.description = "";
                object.title = "";
                object.textArgb = 0;
                object.backgroundArgb = 0;
                object.font = options.enums === String ? "SANS_SERIF" : 0;
                object.previewType = options.enums === String ? "NONE" : 0;
                if (options.bytes === String)
                    object.jpegThumbnail = "";
                else {
                    object.jpegThumbnail = [];
                    if (options.bytes !== Array)
                        object.jpegThumbnail = $util.newBuffer(object.jpegThumbnail);
                }
                object.contextInfo = null;
                object.doNotPlayInline = false;
                object.thumbnailDirectPath = "";
                if (options.bytes === String)
                    object.thumbnailSha256 = "";
                else {
                    object.thumbnailSha256 = [];
                    if (options.bytes !== Array)
                        object.thumbnailSha256 = $util.newBuffer(object.thumbnailSha256);
                }
                if (options.bytes === String)
                    object.thumbnailEncSha256 = "";
                else {
                    object.thumbnailEncSha256 = [];
                    if (options.bytes !== Array)
                        object.thumbnailEncSha256 = $util.newBuffer(object.thumbnailEncSha256);
                }
                if (options.bytes === String)
                    object.mediaKey = "";
                else {
                    object.mediaKey = [];
                    if (options.bytes !== Array)
                        object.mediaKey = $util.newBuffer(object.mediaKey);
                }
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.mediaKeyTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.mediaKeyTimestamp = options.longs === String ? "0" : 0;
                object.thumbnailHeight = 0;
                object.thumbnailWidth = 0;
                object.inviteLinkGroupType = options.enums === String ? "DEFAULT" : 0;
                object.inviteLinkParentGroupSubjectV2 = "";
                if (options.bytes === String)
                    object.inviteLinkParentGroupThumbnailV2 = "";
                else {
                    object.inviteLinkParentGroupThumbnailV2 = [];
                    if (options.bytes !== Array)
                        object.inviteLinkParentGroupThumbnailV2 = $util.newBuffer(object.inviteLinkParentGroupThumbnailV2);
                }
                object.inviteLinkGroupTypeV2 = options.enums === String ? "DEFAULT" : 0;
            }
            if (message.text != null && message.hasOwnProperty("text"))
                object.text = message.text;
            if (message.matchedText != null && message.hasOwnProperty("matchedText"))
                object.matchedText = message.matchedText;
            if (message.canonicalUrl != null && message.hasOwnProperty("canonicalUrl"))
                object.canonicalUrl = message.canonicalUrl;
            if (message.description != null && message.hasOwnProperty("description"))
                object.description = message.description;
            if (message.title != null && message.hasOwnProperty("title"))
                object.title = message.title;
            if (message.textArgb != null && message.hasOwnProperty("textArgb"))
                object.textArgb = message.textArgb;
            if (message.backgroundArgb != null && message.hasOwnProperty("backgroundArgb"))
                object.backgroundArgb = message.backgroundArgb;
            if (message.font != null && message.hasOwnProperty("font"))
                object.font = options.enums === String ? $root.proto.ExtendedTextMessage.ExtendedTextMessageFontType[message.font] : message.font;
            if (message.previewType != null && message.hasOwnProperty("previewType"))
                object.previewType = options.enums === String ? $root.proto.ExtendedTextMessage.ExtendedTextMessagePreviewType[message.previewType] : message.previewType;
            if (message.jpegThumbnail != null && message.hasOwnProperty("jpegThumbnail"))
                object.jpegThumbnail = options.bytes === String ? $util.base64.encode(message.jpegThumbnail, 0, message.jpegThumbnail.length) : options.bytes === Array ? Array.prototype.slice.call(message.jpegThumbnail) : message.jpegThumbnail;
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo"))
                object.contextInfo = $root.proto.ContextInfo.toObject(message.contextInfo, options);
            if (message.doNotPlayInline != null && message.hasOwnProperty("doNotPlayInline"))
                object.doNotPlayInline = message.doNotPlayInline;
            if (message.thumbnailDirectPath != null && message.hasOwnProperty("thumbnailDirectPath"))
                object.thumbnailDirectPath = message.thumbnailDirectPath;
            if (message.thumbnailSha256 != null && message.hasOwnProperty("thumbnailSha256"))
                object.thumbnailSha256 = options.bytes === String ? $util.base64.encode(message.thumbnailSha256, 0, message.thumbnailSha256.length) : options.bytes === Array ? Array.prototype.slice.call(message.thumbnailSha256) : message.thumbnailSha256;
            if (message.thumbnailEncSha256 != null && message.hasOwnProperty("thumbnailEncSha256"))
                object.thumbnailEncSha256 = options.bytes === String ? $util.base64.encode(message.thumbnailEncSha256, 0, message.thumbnailEncSha256.length) : options.bytes === Array ? Array.prototype.slice.call(message.thumbnailEncSha256) : message.thumbnailEncSha256;
            if (message.mediaKey != null && message.hasOwnProperty("mediaKey"))
                object.mediaKey = options.bytes === String ? $util.base64.encode(message.mediaKey, 0, message.mediaKey.length) : options.bytes === Array ? Array.prototype.slice.call(message.mediaKey) : message.mediaKey;
            if (message.mediaKeyTimestamp != null && message.hasOwnProperty("mediaKeyTimestamp"))
                if (typeof message.mediaKeyTimestamp === "number")
                    object.mediaKeyTimestamp = options.longs === String ? String(message.mediaKeyTimestamp) : message.mediaKeyTimestamp;
                else
                    object.mediaKeyTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.mediaKeyTimestamp) : options.longs === Number ? new $util.LongBits(message.mediaKeyTimestamp.low >>> 0, message.mediaKeyTimestamp.high >>> 0).toNumber() : message.mediaKeyTimestamp;
            if (message.thumbnailHeight != null && message.hasOwnProperty("thumbnailHeight"))
                object.thumbnailHeight = message.thumbnailHeight;
            if (message.thumbnailWidth != null && message.hasOwnProperty("thumbnailWidth"))
                object.thumbnailWidth = message.thumbnailWidth;
            if (message.inviteLinkGroupType != null && message.hasOwnProperty("inviteLinkGroupType"))
                object.inviteLinkGroupType = options.enums === String ? $root.proto.ExtendedTextMessage.ExtendedTextMessageInviteLinkGroupType[message.inviteLinkGroupType] : message.inviteLinkGroupType;
            if (message.inviteLinkParentGroupSubjectV2 != null && message.hasOwnProperty("inviteLinkParentGroupSubjectV2"))
                object.inviteLinkParentGroupSubjectV2 = message.inviteLinkParentGroupSubjectV2;
            if (message.inviteLinkParentGroupThumbnailV2 != null && message.hasOwnProperty("inviteLinkParentGroupThumbnailV2"))
                object.inviteLinkParentGroupThumbnailV2 = options.bytes === String ? $util.base64.encode(message.inviteLinkParentGroupThumbnailV2, 0, message.inviteLinkParentGroupThumbnailV2.length) : options.bytes === Array ? Array.prototype.slice.call(message.inviteLinkParentGroupThumbnailV2) : message.inviteLinkParentGroupThumbnailV2;
            if (message.inviteLinkGroupTypeV2 != null && message.hasOwnProperty("inviteLinkGroupTypeV2"))
                object.inviteLinkGroupTypeV2 = options.enums === String ? $root.proto.ExtendedTextMessage.ExtendedTextMessageInviteLinkGroupType[message.inviteLinkGroupTypeV2] : message.inviteLinkGroupTypeV2;
            return object;
        };

        /**
         * Converts this ExtendedTextMessage to JSON.
         * @function toJSON
         * @memberof proto.ExtendedTextMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ExtendedTextMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * ExtendedTextMessageFontType enum.
         * @name proto.ExtendedTextMessage.ExtendedTextMessageFontType
         * @enum {number}
         * @property {number} SANS_SERIF=0 SANS_SERIF value
         * @property {number} SERIF=1 SERIF value
         * @property {number} NORICAN_REGULAR=2 NORICAN_REGULAR value
         * @property {number} BRYNDAN_WRITE=3 BRYNDAN_WRITE value
         * @property {number} BEBASNEUE_REGULAR=4 BEBASNEUE_REGULAR value
         * @property {number} OSWALD_HEAVY=5 OSWALD_HEAVY value
         */
        ExtendedTextMessage.ExtendedTextMessageFontType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "SANS_SERIF"] = 0;
            values[valuesById[1] = "SERIF"] = 1;
            values[valuesById[2] = "NORICAN_REGULAR"] = 2;
            values[valuesById[3] = "BRYNDAN_WRITE"] = 3;
            values[valuesById[4] = "BEBASNEUE_REGULAR"] = 4;
            values[valuesById[5] = "OSWALD_HEAVY"] = 5;
            return values;
        })();

        /**
         * ExtendedTextMessagePreviewType enum.
         * @name proto.ExtendedTextMessage.ExtendedTextMessagePreviewType
         * @enum {number}
         * @property {number} NONE=0 NONE value
         * @property {number} VIDEO=1 VIDEO value
         */
        ExtendedTextMessage.ExtendedTextMessagePreviewType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "NONE"] = 0;
            values[valuesById[1] = "VIDEO"] = 1;
            return values;
        })();

        /**
         * ExtendedTextMessageInviteLinkGroupType enum.
         * @name proto.ExtendedTextMessage.ExtendedTextMessageInviteLinkGroupType
         * @enum {number}
         * @property {number} DEFAULT=0 DEFAULT value
         * @property {number} PARENT=1 PARENT value
         */
        ExtendedTextMessage.ExtendedTextMessageInviteLinkGroupType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "DEFAULT"] = 0;
            values[valuesById[1] = "PARENT"] = 1;
            return values;
        })();

        return ExtendedTextMessage;
    })();

    proto.ExternalAdReplyInfo = (function() {

        /**
         * Properties of an ExternalAdReplyInfo.
         * @memberof proto
         * @interface IExternalAdReplyInfo
         * @property {string|null} [title] ExternalAdReplyInfo title
         * @property {string|null} [body] ExternalAdReplyInfo body
         * @property {proto.ExternalAdReplyInfo.ExternalAdReplyInfoMediaType|null} [mediaType] ExternalAdReplyInfo mediaType
         * @property {string|null} [thumbnailUrl] ExternalAdReplyInfo thumbnailUrl
         * @property {string|null} [mediaUrl] ExternalAdReplyInfo mediaUrl
         * @property {Uint8Array|null} [thumbnail] ExternalAdReplyInfo thumbnail
         * @property {string|null} [sourceType] ExternalAdReplyInfo sourceType
         * @property {string|null} [sourceId] ExternalAdReplyInfo sourceId
         * @property {string|null} [sourceUrl] ExternalAdReplyInfo sourceUrl
         * @property {boolean|null} [containsAutoReply] ExternalAdReplyInfo containsAutoReply
         * @property {boolean|null} [renderLargerThumbnail] ExternalAdReplyInfo renderLargerThumbnail
         * @property {boolean|null} [showAdAttribution] ExternalAdReplyInfo showAdAttribution
         */

        /**
         * Constructs a new ExternalAdReplyInfo.
         * @memberof proto
         * @classdesc Represents an ExternalAdReplyInfo.
         * @implements IExternalAdReplyInfo
         * @constructor
         * @param {proto.IExternalAdReplyInfo=} [properties] Properties to set
         */
        function ExternalAdReplyInfo(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ExternalAdReplyInfo title.
         * @member {string} title
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         */
        ExternalAdReplyInfo.prototype.title = "";

        /**
         * ExternalAdReplyInfo body.
         * @member {string} body
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         */
        ExternalAdReplyInfo.prototype.body = "";

        /**
         * ExternalAdReplyInfo mediaType.
         * @member {proto.ExternalAdReplyInfo.ExternalAdReplyInfoMediaType} mediaType
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         */
        ExternalAdReplyInfo.prototype.mediaType = 0;

        /**
         * ExternalAdReplyInfo thumbnailUrl.
         * @member {string} thumbnailUrl
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         */
        ExternalAdReplyInfo.prototype.thumbnailUrl = "";

        /**
         * ExternalAdReplyInfo mediaUrl.
         * @member {string} mediaUrl
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         */
        ExternalAdReplyInfo.prototype.mediaUrl = "";

        /**
         * ExternalAdReplyInfo thumbnail.
         * @member {Uint8Array} thumbnail
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         */
        ExternalAdReplyInfo.prototype.thumbnail = $util.newBuffer([]);

        /**
         * ExternalAdReplyInfo sourceType.
         * @member {string} sourceType
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         */
        ExternalAdReplyInfo.prototype.sourceType = "";

        /**
         * ExternalAdReplyInfo sourceId.
         * @member {string} sourceId
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         */
        ExternalAdReplyInfo.prototype.sourceId = "";

        /**
         * ExternalAdReplyInfo sourceUrl.
         * @member {string} sourceUrl
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         */
        ExternalAdReplyInfo.prototype.sourceUrl = "";

        /**
         * ExternalAdReplyInfo containsAutoReply.
         * @member {boolean} containsAutoReply
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         */
        ExternalAdReplyInfo.prototype.containsAutoReply = false;

        /**
         * ExternalAdReplyInfo renderLargerThumbnail.
         * @member {boolean} renderLargerThumbnail
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         */
        ExternalAdReplyInfo.prototype.renderLargerThumbnail = false;

        /**
         * ExternalAdReplyInfo showAdAttribution.
         * @member {boolean} showAdAttribution
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         */
        ExternalAdReplyInfo.prototype.showAdAttribution = false;

        /**
         * Creates a new ExternalAdReplyInfo instance using the specified properties.
         * @function create
         * @memberof proto.ExternalAdReplyInfo
         * @static
         * @param {proto.IExternalAdReplyInfo=} [properties] Properties to set
         * @returns {proto.ExternalAdReplyInfo} ExternalAdReplyInfo instance
         */
        ExternalAdReplyInfo.create = function create(properties) {
            return new ExternalAdReplyInfo(properties);
        };

        /**
         * Encodes the specified ExternalAdReplyInfo message. Does not implicitly {@link proto.ExternalAdReplyInfo.verify|verify} messages.
         * @function encode
         * @memberof proto.ExternalAdReplyInfo
         * @static
         * @param {proto.IExternalAdReplyInfo} message ExternalAdReplyInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ExternalAdReplyInfo.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.title != null && Object.hasOwnProperty.call(message, "title"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.title);
            if (message.body != null && Object.hasOwnProperty.call(message, "body"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.body);
            if (message.mediaType != null && Object.hasOwnProperty.call(message, "mediaType"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.mediaType);
            if (message.thumbnailUrl != null && Object.hasOwnProperty.call(message, "thumbnailUrl"))
                writer.uint32(/* id 4, wireType 2 =*/34).string(message.thumbnailUrl);
            if (message.mediaUrl != null && Object.hasOwnProperty.call(message, "mediaUrl"))
                writer.uint32(/* id 5, wireType 2 =*/42).string(message.mediaUrl);
            if (message.thumbnail != null && Object.hasOwnProperty.call(message, "thumbnail"))
                writer.uint32(/* id 6, wireType 2 =*/50).bytes(message.thumbnail);
            if (message.sourceType != null && Object.hasOwnProperty.call(message, "sourceType"))
                writer.uint32(/* id 7, wireType 2 =*/58).string(message.sourceType);
            if (message.sourceId != null && Object.hasOwnProperty.call(message, "sourceId"))
                writer.uint32(/* id 8, wireType 2 =*/66).string(message.sourceId);
            if (message.sourceUrl != null && Object.hasOwnProperty.call(message, "sourceUrl"))
                writer.uint32(/* id 9, wireType 2 =*/74).string(message.sourceUrl);
            if (message.containsAutoReply != null && Object.hasOwnProperty.call(message, "containsAutoReply"))
                writer.uint32(/* id 10, wireType 0 =*/80).bool(message.containsAutoReply);
            if (message.renderLargerThumbnail != null && Object.hasOwnProperty.call(message, "renderLargerThumbnail"))
                writer.uint32(/* id 11, wireType 0 =*/88).bool(message.renderLargerThumbnail);
            if (message.showAdAttribution != null && Object.hasOwnProperty.call(message, "showAdAttribution"))
                writer.uint32(/* id 12, wireType 0 =*/96).bool(message.showAdAttribution);
            return writer;
        };

        /**
         * Encodes the specified ExternalAdReplyInfo message, length delimited. Does not implicitly {@link proto.ExternalAdReplyInfo.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ExternalAdReplyInfo
         * @static
         * @param {proto.IExternalAdReplyInfo} message ExternalAdReplyInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ExternalAdReplyInfo.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an ExternalAdReplyInfo message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ExternalAdReplyInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ExternalAdReplyInfo} ExternalAdReplyInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ExternalAdReplyInfo.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ExternalAdReplyInfo();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.title = reader.string();
                    break;
                case 2:
                    message.body = reader.string();
                    break;
                case 3:
                    message.mediaType = reader.int32();
                    break;
                case 4:
                    message.thumbnailUrl = reader.string();
                    break;
                case 5:
                    message.mediaUrl = reader.string();
                    break;
                case 6:
                    message.thumbnail = reader.bytes();
                    break;
                case 7:
                    message.sourceType = reader.string();
                    break;
                case 8:
                    message.sourceId = reader.string();
                    break;
                case 9:
                    message.sourceUrl = reader.string();
                    break;
                case 10:
                    message.containsAutoReply = reader.bool();
                    break;
                case 11:
                    message.renderLargerThumbnail = reader.bool();
                    break;
                case 12:
                    message.showAdAttribution = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an ExternalAdReplyInfo message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ExternalAdReplyInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ExternalAdReplyInfo} ExternalAdReplyInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ExternalAdReplyInfo.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an ExternalAdReplyInfo message.
         * @function verify
         * @memberof proto.ExternalAdReplyInfo
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ExternalAdReplyInfo.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.title != null && message.hasOwnProperty("title"))
                if (!$util.isString(message.title))
                    return "title: string expected";
            if (message.body != null && message.hasOwnProperty("body"))
                if (!$util.isString(message.body))
                    return "body: string expected";
            if (message.mediaType != null && message.hasOwnProperty("mediaType"))
                switch (message.mediaType) {
                default:
                    return "mediaType: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            if (message.thumbnailUrl != null && message.hasOwnProperty("thumbnailUrl"))
                if (!$util.isString(message.thumbnailUrl))
                    return "thumbnailUrl: string expected";
            if (message.mediaUrl != null && message.hasOwnProperty("mediaUrl"))
                if (!$util.isString(message.mediaUrl))
                    return "mediaUrl: string expected";
            if (message.thumbnail != null && message.hasOwnProperty("thumbnail"))
                if (!(message.thumbnail && typeof message.thumbnail.length === "number" || $util.isString(message.thumbnail)))
                    return "thumbnail: buffer expected";
            if (message.sourceType != null && message.hasOwnProperty("sourceType"))
                if (!$util.isString(message.sourceType))
                    return "sourceType: string expected";
            if (message.sourceId != null && message.hasOwnProperty("sourceId"))
                if (!$util.isString(message.sourceId))
                    return "sourceId: string expected";
            if (message.sourceUrl != null && message.hasOwnProperty("sourceUrl"))
                if (!$util.isString(message.sourceUrl))
                    return "sourceUrl: string expected";
            if (message.containsAutoReply != null && message.hasOwnProperty("containsAutoReply"))
                if (typeof message.containsAutoReply !== "boolean")
                    return "containsAutoReply: boolean expected";
            if (message.renderLargerThumbnail != null && message.hasOwnProperty("renderLargerThumbnail"))
                if (typeof message.renderLargerThumbnail !== "boolean")
                    return "renderLargerThumbnail: boolean expected";
            if (message.showAdAttribution != null && message.hasOwnProperty("showAdAttribution"))
                if (typeof message.showAdAttribution !== "boolean")
                    return "showAdAttribution: boolean expected";
            return null;
        };

        /**
         * Creates an ExternalAdReplyInfo message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ExternalAdReplyInfo
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ExternalAdReplyInfo} ExternalAdReplyInfo
         */
        ExternalAdReplyInfo.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ExternalAdReplyInfo)
                return object;
            var message = new $root.proto.ExternalAdReplyInfo();
            if (object.title != null)
                message.title = String(object.title);
            if (object.body != null)
                message.body = String(object.body);
            switch (object.mediaType) {
            case "NONE":
            case 0:
                message.mediaType = 0;
                break;
            case "IMAGE":
            case 1:
                message.mediaType = 1;
                break;
            case "VIDEO":
            case 2:
                message.mediaType = 2;
                break;
            }
            if (object.thumbnailUrl != null)
                message.thumbnailUrl = String(object.thumbnailUrl);
            if (object.mediaUrl != null)
                message.mediaUrl = String(object.mediaUrl);
            if (object.thumbnail != null)
                if (typeof object.thumbnail === "string")
                    $util.base64.decode(object.thumbnail, message.thumbnail = $util.newBuffer($util.base64.length(object.thumbnail)), 0);
                else if (object.thumbnail.length)
                    message.thumbnail = object.thumbnail;
            if (object.sourceType != null)
                message.sourceType = String(object.sourceType);
            if (object.sourceId != null)
                message.sourceId = String(object.sourceId);
            if (object.sourceUrl != null)
                message.sourceUrl = String(object.sourceUrl);
            if (object.containsAutoReply != null)
                message.containsAutoReply = Boolean(object.containsAutoReply);
            if (object.renderLargerThumbnail != null)
                message.renderLargerThumbnail = Boolean(object.renderLargerThumbnail);
            if (object.showAdAttribution != null)
                message.showAdAttribution = Boolean(object.showAdAttribution);
            return message;
        };

        /**
         * Creates a plain object from an ExternalAdReplyInfo message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ExternalAdReplyInfo
         * @static
         * @param {proto.ExternalAdReplyInfo} message ExternalAdReplyInfo
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ExternalAdReplyInfo.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.title = "";
                object.body = "";
                object.mediaType = options.enums === String ? "NONE" : 0;
                object.thumbnailUrl = "";
                object.mediaUrl = "";
                if (options.bytes === String)
                    object.thumbnail = "";
                else {
                    object.thumbnail = [];
                    if (options.bytes !== Array)
                        object.thumbnail = $util.newBuffer(object.thumbnail);
                }
                object.sourceType = "";
                object.sourceId = "";
                object.sourceUrl = "";
                object.containsAutoReply = false;
                object.renderLargerThumbnail = false;
                object.showAdAttribution = false;
            }
            if (message.title != null && message.hasOwnProperty("title"))
                object.title = message.title;
            if (message.body != null && message.hasOwnProperty("body"))
                object.body = message.body;
            if (message.mediaType != null && message.hasOwnProperty("mediaType"))
                object.mediaType = options.enums === String ? $root.proto.ExternalAdReplyInfo.ExternalAdReplyInfoMediaType[message.mediaType] : message.mediaType;
            if (message.thumbnailUrl != null && message.hasOwnProperty("thumbnailUrl"))
                object.thumbnailUrl = message.thumbnailUrl;
            if (message.mediaUrl != null && message.hasOwnProperty("mediaUrl"))
                object.mediaUrl = message.mediaUrl;
            if (message.thumbnail != null && message.hasOwnProperty("thumbnail"))
                object.thumbnail = options.bytes === String ? $util.base64.encode(message.thumbnail, 0, message.thumbnail.length) : options.bytes === Array ? Array.prototype.slice.call(message.thumbnail) : message.thumbnail;
            if (message.sourceType != null && message.hasOwnProperty("sourceType"))
                object.sourceType = message.sourceType;
            if (message.sourceId != null && message.hasOwnProperty("sourceId"))
                object.sourceId = message.sourceId;
            if (message.sourceUrl != null && message.hasOwnProperty("sourceUrl"))
                object.sourceUrl = message.sourceUrl;
            if (message.containsAutoReply != null && message.hasOwnProperty("containsAutoReply"))
                object.containsAutoReply = message.containsAutoReply;
            if (message.renderLargerThumbnail != null && message.hasOwnProperty("renderLargerThumbnail"))
                object.renderLargerThumbnail = message.renderLargerThumbnail;
            if (message.showAdAttribution != null && message.hasOwnProperty("showAdAttribution"))
                object.showAdAttribution = message.showAdAttribution;
            return object;
        };

        /**
         * Converts this ExternalAdReplyInfo to JSON.
         * @function toJSON
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ExternalAdReplyInfo.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * ExternalAdReplyInfoMediaType enum.
         * @name proto.ExternalAdReplyInfo.ExternalAdReplyInfoMediaType
         * @enum {number}
         * @property {number} NONE=0 NONE value
         * @property {number} IMAGE=1 IMAGE value
         * @property {number} VIDEO=2 VIDEO value
         */
        ExternalAdReplyInfo.ExternalAdReplyInfoMediaType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "NONE"] = 0;
            values[valuesById[1] = "IMAGE"] = 1;
            values[valuesById[2] = "VIDEO"] = 2;
            return values;
        })();

        return ExternalAdReplyInfo;
    })();

    proto.Footer = (function() {

        /**
         * Properties of a Footer.
         * @memberof proto
         * @interface IFooter
         * @property {string|null} [text] Footer text
         */

        /**
         * Constructs a new Footer.
         * @memberof proto
         * @classdesc Represents a Footer.
         * @implements IFooter
         * @constructor
         * @param {proto.IFooter=} [properties] Properties to set
         */
        function Footer(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Footer text.
         * @member {string} text
         * @memberof proto.Footer
         * @instance
         */
        Footer.prototype.text = "";

        /**
         * Creates a new Footer instance using the specified properties.
         * @function create
         * @memberof proto.Footer
         * @static
         * @param {proto.IFooter=} [properties] Properties to set
         * @returns {proto.Footer} Footer instance
         */
        Footer.create = function create(properties) {
            return new Footer(properties);
        };

        /**
         * Encodes the specified Footer message. Does not implicitly {@link proto.Footer.verify|verify} messages.
         * @function encode
         * @memberof proto.Footer
         * @static
         * @param {proto.IFooter} message Footer message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Footer.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.text != null && Object.hasOwnProperty.call(message, "text"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.text);
            return writer;
        };

        /**
         * Encodes the specified Footer message, length delimited. Does not implicitly {@link proto.Footer.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.Footer
         * @static
         * @param {proto.IFooter} message Footer message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Footer.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a Footer message from the specified reader or buffer.
         * @function decode
         * @memberof proto.Footer
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.Footer} Footer
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Footer.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.Footer();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.text = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a Footer message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.Footer
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.Footer} Footer
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Footer.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a Footer message.
         * @function verify
         * @memberof proto.Footer
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Footer.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.text != null && message.hasOwnProperty("text"))
                if (!$util.isString(message.text))
                    return "text: string expected";
            return null;
        };

        /**
         * Creates a Footer message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.Footer
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.Footer} Footer
         */
        Footer.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.Footer)
                return object;
            var message = new $root.proto.Footer();
            if (object.text != null)
                message.text = String(object.text);
            return message;
        };

        /**
         * Creates a plain object from a Footer message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.Footer
         * @static
         * @param {proto.Footer} message Footer
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Footer.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.text = "";
            if (message.text != null && message.hasOwnProperty("text"))
                object.text = message.text;
            return object;
        };

        /**
         * Converts this Footer to JSON.
         * @function toJSON
         * @memberof proto.Footer
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Footer.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return Footer;
    })();

    proto.FourRowTemplate = (function() {

        /**
         * Properties of a FourRowTemplate.
         * @memberof proto
         * @interface IFourRowTemplate
         * @property {proto.IHighlyStructuredMessage|null} [content] FourRowTemplate content
         * @property {proto.IHighlyStructuredMessage|null} [footer] FourRowTemplate footer
         * @property {Array.<proto.ITemplateButton>|null} [buttons] FourRowTemplate buttons
         * @property {proto.IDocumentMessage|null} [documentMessage] FourRowTemplate documentMessage
         * @property {proto.IHighlyStructuredMessage|null} [highlyStructuredMessage] FourRowTemplate highlyStructuredMessage
         * @property {proto.IImageMessage|null} [imageMessage] FourRowTemplate imageMessage
         * @property {proto.IVideoMessage|null} [videoMessage] FourRowTemplate videoMessage
         * @property {proto.ILocationMessage|null} [locationMessage] FourRowTemplate locationMessage
         */

        /**
         * Constructs a new FourRowTemplate.
         * @memberof proto
         * @classdesc Represents a FourRowTemplate.
         * @implements IFourRowTemplate
         * @constructor
         * @param {proto.IFourRowTemplate=} [properties] Properties to set
         */
        function FourRowTemplate(properties) {
            this.buttons = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * FourRowTemplate content.
         * @member {proto.IHighlyStructuredMessage|null|undefined} content
         * @memberof proto.FourRowTemplate
         * @instance
         */
        FourRowTemplate.prototype.content = null;

        /**
         * FourRowTemplate footer.
         * @member {proto.IHighlyStructuredMessage|null|undefined} footer
         * @memberof proto.FourRowTemplate
         * @instance
         */
        FourRowTemplate.prototype.footer = null;

        /**
         * FourRowTemplate buttons.
         * @member {Array.<proto.ITemplateButton>} buttons
         * @memberof proto.FourRowTemplate
         * @instance
         */
        FourRowTemplate.prototype.buttons = $util.emptyArray;

        /**
         * FourRowTemplate documentMessage.
         * @member {proto.IDocumentMessage|null|undefined} documentMessage
         * @memberof proto.FourRowTemplate
         * @instance
         */
        FourRowTemplate.prototype.documentMessage = null;

        /**
         * FourRowTemplate highlyStructuredMessage.
         * @member {proto.IHighlyStructuredMessage|null|undefined} highlyStructuredMessage
         * @memberof proto.FourRowTemplate
         * @instance
         */
        FourRowTemplate.prototype.highlyStructuredMessage = null;

        /**
         * FourRowTemplate imageMessage.
         * @member {proto.IImageMessage|null|undefined} imageMessage
         * @memberof proto.FourRowTemplate
         * @instance
         */
        FourRowTemplate.prototype.imageMessage = null;

        /**
         * FourRowTemplate videoMessage.
         * @member {proto.IVideoMessage|null|undefined} videoMessage
         * @memberof proto.FourRowTemplate
         * @instance
         */
        FourRowTemplate.prototype.videoMessage = null;

        /**
         * FourRowTemplate locationMessage.
         * @member {proto.ILocationMessage|null|undefined} locationMessage
         * @memberof proto.FourRowTemplate
         * @instance
         */
        FourRowTemplate.prototype.locationMessage = null;

        // OneOf field names bound to virtual getters and setters
        var $oneOfFields;

        /**
         * FourRowTemplate title.
         * @member {"documentMessage"|"highlyStructuredMessage"|"imageMessage"|"videoMessage"|"locationMessage"|undefined} title
         * @memberof proto.FourRowTemplate
         * @instance
         */
        Object.defineProperty(FourRowTemplate.prototype, "title", {
            get: $util.oneOfGetter($oneOfFields = ["documentMessage", "highlyStructuredMessage", "imageMessage", "videoMessage", "locationMessage"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new FourRowTemplate instance using the specified properties.
         * @function create
         * @memberof proto.FourRowTemplate
         * @static
         * @param {proto.IFourRowTemplate=} [properties] Properties to set
         * @returns {proto.FourRowTemplate} FourRowTemplate instance
         */
        FourRowTemplate.create = function create(properties) {
            return new FourRowTemplate(properties);
        };

        /**
         * Encodes the specified FourRowTemplate message. Does not implicitly {@link proto.FourRowTemplate.verify|verify} messages.
         * @function encode
         * @memberof proto.FourRowTemplate
         * @static
         * @param {proto.IFourRowTemplate} message FourRowTemplate message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FourRowTemplate.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.documentMessage != null && Object.hasOwnProperty.call(message, "documentMessage"))
                $root.proto.DocumentMessage.encode(message.documentMessage, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.highlyStructuredMessage != null && Object.hasOwnProperty.call(message, "highlyStructuredMessage"))
                $root.proto.HighlyStructuredMessage.encode(message.highlyStructuredMessage, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.imageMessage != null && Object.hasOwnProperty.call(message, "imageMessage"))
                $root.proto.ImageMessage.encode(message.imageMessage, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            if (message.videoMessage != null && Object.hasOwnProperty.call(message, "videoMessage"))
                $root.proto.VideoMessage.encode(message.videoMessage, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
            if (message.locationMessage != null && Object.hasOwnProperty.call(message, "locationMessage"))
                $root.proto.LocationMessage.encode(message.locationMessage, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
            if (message.content != null && Object.hasOwnProperty.call(message, "content"))
                $root.proto.HighlyStructuredMessage.encode(message.content, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
            if (message.footer != null && Object.hasOwnProperty.call(message, "footer"))
                $root.proto.HighlyStructuredMessage.encode(message.footer, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
            if (message.buttons != null && message.buttons.length)
                for (var i = 0; i < message.buttons.length; ++i)
                    $root.proto.TemplateButton.encode(message.buttons[i], writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified FourRowTemplate message, length delimited. Does not implicitly {@link proto.FourRowTemplate.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.FourRowTemplate
         * @static
         * @param {proto.IFourRowTemplate} message FourRowTemplate message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FourRowTemplate.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a FourRowTemplate message from the specified reader or buffer.
         * @function decode
         * @memberof proto.FourRowTemplate
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.FourRowTemplate} FourRowTemplate
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FourRowTemplate.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.FourRowTemplate();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 6:
                    message.content = $root.proto.HighlyStructuredMessage.decode(reader, reader.uint32());
                    break;
                case 7:
                    message.footer = $root.proto.HighlyStructuredMessage.decode(reader, reader.uint32());
                    break;
                case 8:
                    if (!(message.buttons && message.buttons.length))
                        message.buttons = [];
                    message.buttons.push($root.proto.TemplateButton.decode(reader, reader.uint32()));
                    break;
                case 1:
                    message.documentMessage = $root.proto.DocumentMessage.decode(reader, reader.uint32());
                    break;
                case 2:
                    message.highlyStructuredMessage = $root.proto.HighlyStructuredMessage.decode(reader, reader.uint32());
                    break;
                case 3:
                    message.imageMessage = $root.proto.ImageMessage.decode(reader, reader.uint32());
                    break;
                case 4:
                    message.videoMessage = $root.proto.VideoMessage.decode(reader, reader.uint32());
                    break;
                case 5:
                    message.locationMessage = $root.proto.LocationMessage.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a FourRowTemplate message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.FourRowTemplate
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.FourRowTemplate} FourRowTemplate
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FourRowTemplate.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a FourRowTemplate message.
         * @function verify
         * @memberof proto.FourRowTemplate
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        FourRowTemplate.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            var properties = {};
            if (message.content != null && message.hasOwnProperty("content")) {
                var error = $root.proto.HighlyStructuredMessage.verify(message.content);
                if (error)
                    return "content." + error;
            }
            if (message.footer != null && message.hasOwnProperty("footer")) {
                var error = $root.proto.HighlyStructuredMessage.verify(message.footer);
                if (error)
                    return "footer." + error;
            }
            if (message.buttons != null && message.hasOwnProperty("buttons")) {
                if (!Array.isArray(message.buttons))
                    return "buttons: array expected";
                for (var i = 0; i < message.buttons.length; ++i) {
                    var error = $root.proto.TemplateButton.verify(message.buttons[i]);
                    if (error)
                        return "buttons." + error;
                }
            }
            if (message.documentMessage != null && message.hasOwnProperty("documentMessage")) {
                properties.title = 1;
                {
                    var error = $root.proto.DocumentMessage.verify(message.documentMessage);
                    if (error)
                        return "documentMessage." + error;
                }
            }
            if (message.highlyStructuredMessage != null && message.hasOwnProperty("highlyStructuredMessage")) {
                if (properties.title === 1)
                    return "title: multiple values";
                properties.title = 1;
                {
                    var error = $root.proto.HighlyStructuredMessage.verify(message.highlyStructuredMessage);
                    if (error)
                        return "highlyStructuredMessage." + error;
                }
            }
            if (message.imageMessage != null && message.hasOwnProperty("imageMessage")) {
                if (properties.title === 1)
                    return "title: multiple values";
                properties.title = 1;
                {
                    var error = $root.proto.ImageMessage.verify(message.imageMessage);
                    if (error)
                        return "imageMessage." + error;
                }
            }
            if (message.videoMessage != null && message.hasOwnProperty("videoMessage")) {
                if (properties.title === 1)
                    return "title: multiple values";
                properties.title = 1;
                {
                    var error = $root.proto.VideoMessage.verify(message.videoMessage);
                    if (error)
                        return "videoMessage." + error;
                }
            }
            if (message.locationMessage != null && message.hasOwnProperty("locationMessage")) {
                if (properties.title === 1)
                    return "title: multiple values";
                properties.title = 1;
                {
                    var error = $root.proto.LocationMessage.verify(message.locationMessage);
                    if (error)
                        return "locationMessage." + error;
                }
            }
            return null;
        };

        /**
         * Creates a FourRowTemplate message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.FourRowTemplate
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.FourRowTemplate} FourRowTemplate
         */
        FourRowTemplate.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.FourRowTemplate)
                return object;
            var message = new $root.proto.FourRowTemplate();
            if (object.content != null) {
                if (typeof object.content !== "object")
                    throw TypeError(".proto.FourRowTemplate.content: object expected");
                message.content = $root.proto.HighlyStructuredMessage.fromObject(object.content);
            }
            if (object.footer != null) {
                if (typeof object.footer !== "object")
                    throw TypeError(".proto.FourRowTemplate.footer: object expected");
                message.footer = $root.proto.HighlyStructuredMessage.fromObject(object.footer);
            }
            if (object.buttons) {
                if (!Array.isArray(object.buttons))
                    throw TypeError(".proto.FourRowTemplate.buttons: array expected");
                message.buttons = [];
                for (var i = 0; i < object.buttons.length; ++i) {
                    if (typeof object.buttons[i] !== "object")
                        throw TypeError(".proto.FourRowTemplate.buttons: object expected");
                    message.buttons[i] = $root.proto.TemplateButton.fromObject(object.buttons[i]);
                }
            }
            if (object.documentMessage != null) {
                if (typeof object.documentMessage !== "object")
                    throw TypeError(".proto.FourRowTemplate.documentMessage: object expected");
                message.documentMessage = $root.proto.DocumentMessage.fromObject(object.documentMessage);
            }
            if (object.highlyStructuredMessage != null) {
                if (typeof object.highlyStructuredMessage !== "object")
                    throw TypeError(".proto.FourRowTemplate.highlyStructuredMessage: object expected");
                message.highlyStructuredMessage = $root.proto.HighlyStructuredMessage.fromObject(object.highlyStructuredMessage);
            }
            if (object.imageMessage != null) {
                if (typeof object.imageMessage !== "object")
                    throw TypeError(".proto.FourRowTemplate.imageMessage: object expected");
                message.imageMessage = $root.proto.ImageMessage.fromObject(object.imageMessage);
            }
            if (object.videoMessage != null) {
                if (typeof object.videoMessage !== "object")
                    throw TypeError(".proto.FourRowTemplate.videoMessage: object expected");
                message.videoMessage = $root.proto.VideoMessage.fromObject(object.videoMessage);
            }
            if (object.locationMessage != null) {
                if (typeof object.locationMessage !== "object")
                    throw TypeError(".proto.FourRowTemplate.locationMessage: object expected");
                message.locationMessage = $root.proto.LocationMessage.fromObject(object.locationMessage);
            }
            return message;
        };

        /**
         * Creates a plain object from a FourRowTemplate message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.FourRowTemplate
         * @static
         * @param {proto.FourRowTemplate} message FourRowTemplate
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        FourRowTemplate.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.buttons = [];
            if (options.defaults) {
                object.content = null;
                object.footer = null;
            }
            if (message.documentMessage != null && message.hasOwnProperty("documentMessage")) {
                object.documentMessage = $root.proto.DocumentMessage.toObject(message.documentMessage, options);
                if (options.oneofs)
                    object.title = "documentMessage";
            }
            if (message.highlyStructuredMessage != null && message.hasOwnProperty("highlyStructuredMessage")) {
                object.highlyStructuredMessage = $root.proto.HighlyStructuredMessage.toObject(message.highlyStructuredMessage, options);
                if (options.oneofs)
                    object.title = "highlyStructuredMessage";
            }
            if (message.imageMessage != null && message.hasOwnProperty("imageMessage")) {
                object.imageMessage = $root.proto.ImageMessage.toObject(message.imageMessage, options);
                if (options.oneofs)
                    object.title = "imageMessage";
            }
            if (message.videoMessage != null && message.hasOwnProperty("videoMessage")) {
                object.videoMessage = $root.proto.VideoMessage.toObject(message.videoMessage, options);
                if (options.oneofs)
                    object.title = "videoMessage";
            }
            if (message.locationMessage != null && message.hasOwnProperty("locationMessage")) {
                object.locationMessage = $root.proto.LocationMessage.toObject(message.locationMessage, options);
                if (options.oneofs)
                    object.title = "locationMessage";
            }
            if (message.content != null && message.hasOwnProperty("content"))
                object.content = $root.proto.HighlyStructuredMessage.toObject(message.content, options);
            if (message.footer != null && message.hasOwnProperty("footer"))
                object.footer = $root.proto.HighlyStructuredMessage.toObject(message.footer, options);
            if (message.buttons && message.buttons.length) {
                object.buttons = [];
                for (var j = 0; j < message.buttons.length; ++j)
                    object.buttons[j] = $root.proto.TemplateButton.toObject(message.buttons[j], options);
            }
            return object;
        };

        /**
         * Converts this FourRowTemplate to JSON.
         * @function toJSON
         * @memberof proto.FourRowTemplate
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        FourRowTemplate.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return FourRowTemplate;
    })();

    proto.FutureProofMessage = (function() {

        /**
         * Properties of a FutureProofMessage.
         * @memberof proto
         * @interface IFutureProofMessage
         * @property {proto.IMessage|null} [message] FutureProofMessage message
         */

        /**
         * Constructs a new FutureProofMessage.
         * @memberof proto
         * @classdesc Represents a FutureProofMessage.
         * @implements IFutureProofMessage
         * @constructor
         * @param {proto.IFutureProofMessage=} [properties] Properties to set
         */
        function FutureProofMessage(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * FutureProofMessage message.
         * @member {proto.IMessage|null|undefined} message
         * @memberof proto.FutureProofMessage
         * @instance
         */
        FutureProofMessage.prototype.message = null;

        /**
         * Creates a new FutureProofMessage instance using the specified properties.
         * @function create
         * @memberof proto.FutureProofMessage
         * @static
         * @param {proto.IFutureProofMessage=} [properties] Properties to set
         * @returns {proto.FutureProofMessage} FutureProofMessage instance
         */
        FutureProofMessage.create = function create(properties) {
            return new FutureProofMessage(properties);
        };

        /**
         * Encodes the specified FutureProofMessage message. Does not implicitly {@link proto.FutureProofMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.FutureProofMessage
         * @static
         * @param {proto.IFutureProofMessage} message FutureProofMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FutureProofMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.message != null && Object.hasOwnProperty.call(message, "message"))
                $root.proto.Message.encode(message.message, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified FutureProofMessage message, length delimited. Does not implicitly {@link proto.FutureProofMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.FutureProofMessage
         * @static
         * @param {proto.IFutureProofMessage} message FutureProofMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FutureProofMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a FutureProofMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.FutureProofMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.FutureProofMessage} FutureProofMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FutureProofMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.FutureProofMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.message = $root.proto.Message.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a FutureProofMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.FutureProofMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.FutureProofMessage} FutureProofMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FutureProofMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a FutureProofMessage message.
         * @function verify
         * @memberof proto.FutureProofMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        FutureProofMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.message != null && message.hasOwnProperty("message")) {
                var error = $root.proto.Message.verify(message.message);
                if (error)
                    return "message." + error;
            }
            return null;
        };

        /**
         * Creates a FutureProofMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.FutureProofMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.FutureProofMessage} FutureProofMessage
         */
        FutureProofMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.FutureProofMessage)
                return object;
            var message = new $root.proto.FutureProofMessage();
            if (object.message != null) {
                if (typeof object.message !== "object")
                    throw TypeError(".proto.FutureProofMessage.message: object expected");
                message.message = $root.proto.Message.fromObject(object.message);
            }
            return message;
        };

        /**
         * Creates a plain object from a FutureProofMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.FutureProofMessage
         * @static
         * @param {proto.FutureProofMessage} message FutureProofMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        FutureProofMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.message = null;
            if (message.message != null && message.hasOwnProperty("message"))
                object.message = $root.proto.Message.toObject(message.message, options);
            return object;
        };

        /**
         * Converts this FutureProofMessage to JSON.
         * @function toJSON
         * @memberof proto.FutureProofMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        FutureProofMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return FutureProofMessage;
    })();

    proto.GroupInviteMessage = (function() {

        /**
         * Properties of a GroupInviteMessage.
         * @memberof proto
         * @interface IGroupInviteMessage
         * @property {string|null} [groupJid] GroupInviteMessage groupJid
         * @property {string|null} [inviteCode] GroupInviteMessage inviteCode
         * @property {number|Long|null} [inviteExpiration] GroupInviteMessage inviteExpiration
         * @property {string|null} [groupName] GroupInviteMessage groupName
         * @property {Uint8Array|null} [jpegThumbnail] GroupInviteMessage jpegThumbnail
         * @property {string|null} [caption] GroupInviteMessage caption
         * @property {proto.IContextInfo|null} [contextInfo] GroupInviteMessage contextInfo
         * @property {proto.GroupInviteMessage.GroupInviteMessageGroupType|null} [groupType] GroupInviteMessage groupType
         */

        /**
         * Constructs a new GroupInviteMessage.
         * @memberof proto
         * @classdesc Represents a GroupInviteMessage.
         * @implements IGroupInviteMessage
         * @constructor
         * @param {proto.IGroupInviteMessage=} [properties] Properties to set
         */
        function GroupInviteMessage(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * GroupInviteMessage groupJid.
         * @member {string} groupJid
         * @memberof proto.GroupInviteMessage
         * @instance
         */
        GroupInviteMessage.prototype.groupJid = "";

        /**
         * GroupInviteMessage inviteCode.
         * @member {string} inviteCode
         * @memberof proto.GroupInviteMessage
         * @instance
         */
        GroupInviteMessage.prototype.inviteCode = "";

        /**
         * GroupInviteMessage inviteExpiration.
         * @member {number|Long} inviteExpiration
         * @memberof proto.GroupInviteMessage
         * @instance
         */
        GroupInviteMessage.prototype.inviteExpiration = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * GroupInviteMessage groupName.
         * @member {string} groupName
         * @memberof proto.GroupInviteMessage
         * @instance
         */
        GroupInviteMessage.prototype.groupName = "";

        /**
         * GroupInviteMessage jpegThumbnail.
         * @member {Uint8Array} jpegThumbnail
         * @memberof proto.GroupInviteMessage
         * @instance
         */
        GroupInviteMessage.prototype.jpegThumbnail = $util.newBuffer([]);

        /**
         * GroupInviteMessage caption.
         * @member {string} caption
         * @memberof proto.GroupInviteMessage
         * @instance
         */
        GroupInviteMessage.prototype.caption = "";

        /**
         * GroupInviteMessage contextInfo.
         * @member {proto.IContextInfo|null|undefined} contextInfo
         * @memberof proto.GroupInviteMessage
         * @instance
         */
        GroupInviteMessage.prototype.contextInfo = null;

        /**
         * GroupInviteMessage groupType.
         * @member {proto.GroupInviteMessage.GroupInviteMessageGroupType} groupType
         * @memberof proto.GroupInviteMessage
         * @instance
         */
        GroupInviteMessage.prototype.groupType = 0;

        /**
         * Creates a new GroupInviteMessage instance using the specified properties.
         * @function create
         * @memberof proto.GroupInviteMessage
         * @static
         * @param {proto.IGroupInviteMessage=} [properties] Properties to set
         * @returns {proto.GroupInviteMessage} GroupInviteMessage instance
         */
        GroupInviteMessage.create = function create(properties) {
            return new GroupInviteMessage(properties);
        };

        /**
         * Encodes the specified GroupInviteMessage message. Does not implicitly {@link proto.GroupInviteMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.GroupInviteMessage
         * @static
         * @param {proto.IGroupInviteMessage} message GroupInviteMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        GroupInviteMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.groupJid != null && Object.hasOwnProperty.call(message, "groupJid"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.groupJid);
            if (message.inviteCode != null && Object.hasOwnProperty.call(message, "inviteCode"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.inviteCode);
            if (message.inviteExpiration != null && Object.hasOwnProperty.call(message, "inviteExpiration"))
                writer.uint32(/* id 3, wireType 0 =*/24).int64(message.inviteExpiration);
            if (message.groupName != null && Object.hasOwnProperty.call(message, "groupName"))
                writer.uint32(/* id 4, wireType 2 =*/34).string(message.groupName);
            if (message.jpegThumbnail != null && Object.hasOwnProperty.call(message, "jpegThumbnail"))
                writer.uint32(/* id 5, wireType 2 =*/42).bytes(message.jpegThumbnail);
            if (message.caption != null && Object.hasOwnProperty.call(message, "caption"))
                writer.uint32(/* id 6, wireType 2 =*/50).string(message.caption);
            if (message.contextInfo != null && Object.hasOwnProperty.call(message, "contextInfo"))
                $root.proto.ContextInfo.encode(message.contextInfo, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
            if (message.groupType != null && Object.hasOwnProperty.call(message, "groupType"))
                writer.uint32(/* id 8, wireType 0 =*/64).int32(message.groupType);
            return writer;
        };

        /**
         * Encodes the specified GroupInviteMessage message, length delimited. Does not implicitly {@link proto.GroupInviteMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.GroupInviteMessage
         * @static
         * @param {proto.IGroupInviteMessage} message GroupInviteMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        GroupInviteMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a GroupInviteMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.GroupInviteMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.GroupInviteMessage} GroupInviteMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        GroupInviteMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.GroupInviteMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.groupJid = reader.string();
                    break;
                case 2:
                    message.inviteCode = reader.string();
                    break;
                case 3:
                    message.inviteExpiration = reader.int64();
                    break;
                case 4:
                    message.groupName = reader.string();
                    break;
                case 5:
                    message.jpegThumbnail = reader.bytes();
                    break;
                case 6:
                    message.caption = reader.string();
                    break;
                case 7:
                    message.contextInfo = $root.proto.ContextInfo.decode(reader, reader.uint32());
                    break;
                case 8:
                    message.groupType = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a GroupInviteMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.GroupInviteMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.GroupInviteMessage} GroupInviteMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        GroupInviteMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a GroupInviteMessage message.
         * @function verify
         * @memberof proto.GroupInviteMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        GroupInviteMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.groupJid != null && message.hasOwnProperty("groupJid"))
                if (!$util.isString(message.groupJid))
                    return "groupJid: string expected";
            if (message.inviteCode != null && message.hasOwnProperty("inviteCode"))
                if (!$util.isString(message.inviteCode))
                    return "inviteCode: string expected";
            if (message.inviteExpiration != null && message.hasOwnProperty("inviteExpiration"))
                if (!$util.isInteger(message.inviteExpiration) && !(message.inviteExpiration && $util.isInteger(message.inviteExpiration.low) && $util.isInteger(message.inviteExpiration.high)))
                    return "inviteExpiration: integer|Long expected";
            if (message.groupName != null && message.hasOwnProperty("groupName"))
                if (!$util.isString(message.groupName))
                    return "groupName: string expected";
            if (message.jpegThumbnail != null && message.hasOwnProperty("jpegThumbnail"))
                if (!(message.jpegThumbnail && typeof message.jpegThumbnail.length === "number" || $util.isString(message.jpegThumbnail)))
                    return "jpegThumbnail: buffer expected";
            if (message.caption != null && message.hasOwnProperty("caption"))
                if (!$util.isString(message.caption))
                    return "caption: string expected";
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo")) {
                var error = $root.proto.ContextInfo.verify(message.contextInfo);
                if (error)
                    return "contextInfo." + error;
            }
            if (message.groupType != null && message.hasOwnProperty("groupType"))
                switch (message.groupType) {
                default:
                    return "groupType: enum value expected";
                case 0:
                case 1:
                    break;
                }
            return null;
        };

        /**
         * Creates a GroupInviteMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.GroupInviteMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.GroupInviteMessage} GroupInviteMessage
         */
        GroupInviteMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.GroupInviteMessage)
                return object;
            var message = new $root.proto.GroupInviteMessage();
            if (object.groupJid != null)
                message.groupJid = String(object.groupJid);
            if (object.inviteCode != null)
                message.inviteCode = String(object.inviteCode);
            if (object.inviteExpiration != null)
                if ($util.Long)
                    (message.inviteExpiration = $util.Long.fromValue(object.inviteExpiration)).unsigned = false;
                else if (typeof object.inviteExpiration === "string")
                    message.inviteExpiration = parseInt(object.inviteExpiration, 10);
                else if (typeof object.inviteExpiration === "number")
                    message.inviteExpiration = object.inviteExpiration;
                else if (typeof object.inviteExpiration === "object")
                    message.inviteExpiration = new $util.LongBits(object.inviteExpiration.low >>> 0, object.inviteExpiration.high >>> 0).toNumber();
            if (object.groupName != null)
                message.groupName = String(object.groupName);
            if (object.jpegThumbnail != null)
                if (typeof object.jpegThumbnail === "string")
                    $util.base64.decode(object.jpegThumbnail, message.jpegThumbnail = $util.newBuffer($util.base64.length(object.jpegThumbnail)), 0);
                else if (object.jpegThumbnail.length)
                    message.jpegThumbnail = object.jpegThumbnail;
            if (object.caption != null)
                message.caption = String(object.caption);
            if (object.contextInfo != null) {
                if (typeof object.contextInfo !== "object")
                    throw TypeError(".proto.GroupInviteMessage.contextInfo: object expected");
                message.contextInfo = $root.proto.ContextInfo.fromObject(object.contextInfo);
            }
            switch (object.groupType) {
            case "DEFAULT":
            case 0:
                message.groupType = 0;
                break;
            case "PARENT":
            case 1:
                message.groupType = 1;
                break;
            }
            return message;
        };

        /**
         * Creates a plain object from a GroupInviteMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.GroupInviteMessage
         * @static
         * @param {proto.GroupInviteMessage} message GroupInviteMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        GroupInviteMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.groupJid = "";
                object.inviteCode = "";
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.inviteExpiration = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.inviteExpiration = options.longs === String ? "0" : 0;
                object.groupName = "";
                if (options.bytes === String)
                    object.jpegThumbnail = "";
                else {
                    object.jpegThumbnail = [];
                    if (options.bytes !== Array)
                        object.jpegThumbnail = $util.newBuffer(object.jpegThumbnail);
                }
                object.caption = "";
                object.contextInfo = null;
                object.groupType = options.enums === String ? "DEFAULT" : 0;
            }
            if (message.groupJid != null && message.hasOwnProperty("groupJid"))
                object.groupJid = message.groupJid;
            if (message.inviteCode != null && message.hasOwnProperty("inviteCode"))
                object.inviteCode = message.inviteCode;
            if (message.inviteExpiration != null && message.hasOwnProperty("inviteExpiration"))
                if (typeof message.inviteExpiration === "number")
                    object.inviteExpiration = options.longs === String ? String(message.inviteExpiration) : message.inviteExpiration;
                else
                    object.inviteExpiration = options.longs === String ? $util.Long.prototype.toString.call(message.inviteExpiration) : options.longs === Number ? new $util.LongBits(message.inviteExpiration.low >>> 0, message.inviteExpiration.high >>> 0).toNumber() : message.inviteExpiration;
            if (message.groupName != null && message.hasOwnProperty("groupName"))
                object.groupName = message.groupName;
            if (message.jpegThumbnail != null && message.hasOwnProperty("jpegThumbnail"))
                object.jpegThumbnail = options.bytes === String ? $util.base64.encode(message.jpegThumbnail, 0, message.jpegThumbnail.length) : options.bytes === Array ? Array.prototype.slice.call(message.jpegThumbnail) : message.jpegThumbnail;
            if (message.caption != null && message.hasOwnProperty("caption"))
                object.caption = message.caption;
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo"))
                object.contextInfo = $root.proto.ContextInfo.toObject(message.contextInfo, options);
            if (message.groupType != null && message.hasOwnProperty("groupType"))
                object.groupType = options.enums === String ? $root.proto.GroupInviteMessage.GroupInviteMessageGroupType[message.groupType] : message.groupType;
            return object;
        };

        /**
         * Converts this GroupInviteMessage to JSON.
         * @function toJSON
         * @memberof proto.GroupInviteMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        GroupInviteMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * GroupInviteMessageGroupType enum.
         * @name proto.GroupInviteMessage.GroupInviteMessageGroupType
         * @enum {number}
         * @property {number} DEFAULT=0 DEFAULT value
         * @property {number} PARENT=1 PARENT value
         */
        GroupInviteMessage.GroupInviteMessageGroupType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "DEFAULT"] = 0;
            values[valuesById[1] = "PARENT"] = 1;
            return values;
        })();

        return GroupInviteMessage;
    })();

    proto.Header = (function() {

        /**
         * Properties of a Header.
         * @memberof proto
         * @interface IHeader
         * @property {string|null} [title] Header title
         * @property {string|null} [subtitle] Header subtitle
         * @property {boolean|null} [hasMediaAttachment] Header hasMediaAttachment
         * @property {proto.IDocumentMessage|null} [documentMessage] Header documentMessage
         * @property {proto.IImageMessage|null} [imageMessage] Header imageMessage
         * @property {Uint8Array|null} [jpegThumbnail] Header jpegThumbnail
         * @property {proto.IVideoMessage|null} [videoMessage] Header videoMessage
         */

        /**
         * Constructs a new Header.
         * @memberof proto
         * @classdesc Represents a Header.
         * @implements IHeader
         * @constructor
         * @param {proto.IHeader=} [properties] Properties to set
         */
        function Header(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Header title.
         * @member {string} title
         * @memberof proto.Header
         * @instance
         */
        Header.prototype.title = "";

        /**
         * Header subtitle.
         * @member {string} subtitle
         * @memberof proto.Header
         * @instance
         */
        Header.prototype.subtitle = "";

        /**
         * Header hasMediaAttachment.
         * @member {boolean} hasMediaAttachment
         * @memberof proto.Header
         * @instance
         */
        Header.prototype.hasMediaAttachment = false;

        /**
         * Header documentMessage.
         * @member {proto.IDocumentMessage|null|undefined} documentMessage
         * @memberof proto.Header
         * @instance
         */
        Header.prototype.documentMessage = null;

        /**
         * Header imageMessage.
         * @member {proto.IImageMessage|null|undefined} imageMessage
         * @memberof proto.Header
         * @instance
         */
        Header.prototype.imageMessage = null;

        /**
         * Header jpegThumbnail.
         * @member {Uint8Array|null|undefined} jpegThumbnail
         * @memberof proto.Header
         * @instance
         */
        Header.prototype.jpegThumbnail = null;

        /**
         * Header videoMessage.
         * @member {proto.IVideoMessage|null|undefined} videoMessage
         * @memberof proto.Header
         * @instance
         */
        Header.prototype.videoMessage = null;

        // OneOf field names bound to virtual getters and setters
        var $oneOfFields;

        /**
         * Header media.
         * @member {"documentMessage"|"imageMessage"|"jpegThumbnail"|"videoMessage"|undefined} media
         * @memberof proto.Header
         * @instance
         */
        Object.defineProperty(Header.prototype, "media", {
            get: $util.oneOfGetter($oneOfFields = ["documentMessage", "imageMessage", "jpegThumbnail", "videoMessage"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new Header instance using the specified properties.
         * @function create
         * @memberof proto.Header
         * @static
         * @param {proto.IHeader=} [properties] Properties to set
         * @returns {proto.Header} Header instance
         */
        Header.create = function create(properties) {
            return new Header(properties);
        };

        /**
         * Encodes the specified Header message. Does not implicitly {@link proto.Header.verify|verify} messages.
         * @function encode
         * @memberof proto.Header
         * @static
         * @param {proto.IHeader} message Header message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Header.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.title != null && Object.hasOwnProperty.call(message, "title"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.title);
            if (message.subtitle != null && Object.hasOwnProperty.call(message, "subtitle"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.subtitle);
            if (message.documentMessage != null && Object.hasOwnProperty.call(message, "documentMessage"))
                $root.proto.DocumentMessage.encode(message.documentMessage, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            if (message.imageMessage != null && Object.hasOwnProperty.call(message, "imageMessage"))
                $root.proto.ImageMessage.encode(message.imageMessage, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
            if (message.hasMediaAttachment != null && Object.hasOwnProperty.call(message, "hasMediaAttachment"))
                writer.uint32(/* id 5, wireType 0 =*/40).bool(message.hasMediaAttachment);
            if (message.jpegThumbnail != null && Object.hasOwnProperty.call(message, "jpegThumbnail"))
                writer.uint32(/* id 6, wireType 2 =*/50).bytes(message.jpegThumbnail);
            if (message.videoMessage != null && Object.hasOwnProperty.call(message, "videoMessage"))
                $root.proto.VideoMessage.encode(message.videoMessage, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified Header message, length delimited. Does not implicitly {@link proto.Header.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.Header
         * @static
         * @param {proto.IHeader} message Header message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Header.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a Header message from the specified reader or buffer.
         * @function decode
         * @memberof proto.Header
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.Header} Header
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Header.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.Header();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.title = reader.string();
                    break;
                case 2:
                    message.subtitle = reader.string();
                    break;
                case 5:
                    message.hasMediaAttachment = reader.bool();
                    break;
                case 3:
                    message.documentMessage = $root.proto.DocumentMessage.decode(reader, reader.uint32());
                    break;
                case 4:
                    message.imageMessage = $root.proto.ImageMessage.decode(reader, reader.uint32());
                    break;
                case 6:
                    message.jpegThumbnail = reader.bytes();
                    break;
                case 7:
                    message.videoMessage = $root.proto.VideoMessage.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a Header message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.Header
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.Header} Header
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Header.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a Header message.
         * @function verify
         * @memberof proto.Header
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Header.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            var properties = {};
            if (message.title != null && message.hasOwnProperty("title"))
                if (!$util.isString(message.title))
                    return "title: string expected";
            if (message.subtitle != null && message.hasOwnProperty("subtitle"))
                if (!$util.isString(message.subtitle))
                    return "subtitle: string expected";
            if (message.hasMediaAttachment != null && message.hasOwnProperty("hasMediaAttachment"))
                if (typeof message.hasMediaAttachment !== "boolean")
                    return "hasMediaAttachment: boolean expected";
            if (message.documentMessage != null && message.hasOwnProperty("documentMessage")) {
                properties.media = 1;
                {
                    var error = $root.proto.DocumentMessage.verify(message.documentMessage);
                    if (error)
                        return "documentMessage." + error;
                }
            }
            if (message.imageMessage != null && message.hasOwnProperty("imageMessage")) {
                if (properties.media === 1)
                    return "media: multiple values";
                properties.media = 1;
                {
                    var error = $root.proto.ImageMessage.verify(message.imageMessage);
                    if (error)
                        return "imageMessage." + error;
                }
            }
            if (message.jpegThumbnail != null && message.hasOwnProperty("jpegThumbnail")) {
                if (properties.media === 1)
                    return "media: multiple values";
                properties.media = 1;
                if (!(message.jpegThumbnail && typeof message.jpegThumbnail.length === "number" || $util.isString(message.jpegThumbnail)))
                    return "jpegThumbnail: buffer expected";
            }
            if (message.videoMessage != null && message.hasOwnProperty("videoMessage")) {
                if (properties.media === 1)
                    return "media: multiple values";
                properties.media = 1;
                {
                    var error = $root.proto.VideoMessage.verify(message.videoMessage);
                    if (error)
                        return "videoMessage." + error;
                }
            }
            return null;
        };

        /**
         * Creates a Header message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.Header
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.Header} Header
         */
        Header.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.Header)
                return object;
            var message = new $root.proto.Header();
            if (object.title != null)
                message.title = String(object.title);
            if (object.subtitle != null)
                message.subtitle = String(object.subtitle);
            if (object.hasMediaAttachment != null)
                message.hasMediaAttachment = Boolean(object.hasMediaAttachment);
            if (object.documentMessage != null) {
                if (typeof object.documentMessage !== "object")
                    throw TypeError(".proto.Header.documentMessage: object expected");
                message.documentMessage = $root.proto.DocumentMessage.fromObject(object.documentMessage);
            }
            if (object.imageMessage != null) {
                if (typeof object.imageMessage !== "object")
                    throw TypeError(".proto.Header.imageMessage: object expected");
                message.imageMessage = $root.proto.ImageMessage.fromObject(object.imageMessage);
            }
            if (object.jpegThumbnail != null)
                if (typeof object.jpegThumbnail === "string")
                    $util.base64.decode(object.jpegThumbnail, message.jpegThumbnail = $util.newBuffer($util.base64.length(object.jpegThumbnail)), 0);
                else if (object.jpegThumbnail.length)
                    message.jpegThumbnail = object.jpegThumbnail;
            if (object.videoMessage != null) {
                if (typeof object.videoMessage !== "object")
                    throw TypeError(".proto.Header.videoMessage: object expected");
                message.videoMessage = $root.proto.VideoMessage.fromObject(object.videoMessage);
            }
            return message;
        };

        /**
         * Creates a plain object from a Header message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.Header
         * @static
         * @param {proto.Header} message Header
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Header.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.title = "";
                object.subtitle = "";
                object.hasMediaAttachment = false;
            }
            if (message.title != null && message.hasOwnProperty("title"))
                object.title = message.title;
            if (message.subtitle != null && message.hasOwnProperty("subtitle"))
                object.subtitle = message.subtitle;
            if (message.documentMessage != null && message.hasOwnProperty("documentMessage")) {
                object.documentMessage = $root.proto.DocumentMessage.toObject(message.documentMessage, options);
                if (options.oneofs)
                    object.media = "documentMessage";
            }
            if (message.imageMessage != null && message.hasOwnProperty("imageMessage")) {
                object.imageMessage = $root.proto.ImageMessage.toObject(message.imageMessage, options);
                if (options.oneofs)
                    object.media = "imageMessage";
            }
            if (message.hasMediaAttachment != null && message.hasOwnProperty("hasMediaAttachment"))
                object.hasMediaAttachment = message.hasMediaAttachment;
            if (message.jpegThumbnail != null && message.hasOwnProperty("jpegThumbnail")) {
                object.jpegThumbnail = options.bytes === String ? $util.base64.encode(message.jpegThumbnail, 0, message.jpegThumbnail.length) : options.bytes === Array ? Array.prototype.slice.call(message.jpegThumbnail) : message.jpegThumbnail;
                if (options.oneofs)
                    object.media = "jpegThumbnail";
            }
            if (message.videoMessage != null && message.hasOwnProperty("videoMessage")) {
                object.videoMessage = $root.proto.VideoMessage.toObject(message.videoMessage, options);
                if (options.oneofs)
                    object.media = "videoMessage";
            }
            return object;
        };

        /**
         * Converts this Header to JSON.
         * @function toJSON
         * @memberof proto.Header
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Header.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return Header;
    })();

    proto.HighlyStructuredMessage = (function() {

        /**
         * Properties of a HighlyStructuredMessage.
         * @memberof proto
         * @interface IHighlyStructuredMessage
         * @property {string|null} [namespace] HighlyStructuredMessage namespace
         * @property {string|null} [elementName] HighlyStructuredMessage elementName
         * @property {Array.<string>|null} [params] HighlyStructuredMessage params
         * @property {string|null} [fallbackLg] HighlyStructuredMessage fallbackLg
         * @property {string|null} [fallbackLc] HighlyStructuredMessage fallbackLc
         * @property {Array.<proto.IHSMLocalizableParameter>|null} [localizableParams] HighlyStructuredMessage localizableParams
         * @property {string|null} [deterministicLg] HighlyStructuredMessage deterministicLg
         * @property {string|null} [deterministicLc] HighlyStructuredMessage deterministicLc
         * @property {proto.ITemplateMessage|null} [hydratedHsm] HighlyStructuredMessage hydratedHsm
         */

        /**
         * Constructs a new HighlyStructuredMessage.
         * @memberof proto
         * @classdesc Represents a HighlyStructuredMessage.
         * @implements IHighlyStructuredMessage
         * @constructor
         * @param {proto.IHighlyStructuredMessage=} [properties] Properties to set
         */
        function HighlyStructuredMessage(properties) {
            this.params = [];
            this.localizableParams = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * HighlyStructuredMessage namespace.
         * @member {string} namespace
         * @memberof proto.HighlyStructuredMessage
         * @instance
         */
        HighlyStructuredMessage.prototype.namespace = "";

        /**
         * HighlyStructuredMessage elementName.
         * @member {string} elementName
         * @memberof proto.HighlyStructuredMessage
         * @instance
         */
        HighlyStructuredMessage.prototype.elementName = "";

        /**
         * HighlyStructuredMessage params.
         * @member {Array.<string>} params
         * @memberof proto.HighlyStructuredMessage
         * @instance
         */
        HighlyStructuredMessage.prototype.params = $util.emptyArray;

        /**
         * HighlyStructuredMessage fallbackLg.
         * @member {string} fallbackLg
         * @memberof proto.HighlyStructuredMessage
         * @instance
         */
        HighlyStructuredMessage.prototype.fallbackLg = "";

        /**
         * HighlyStructuredMessage fallbackLc.
         * @member {string} fallbackLc
         * @memberof proto.HighlyStructuredMessage
         * @instance
         */
        HighlyStructuredMessage.prototype.fallbackLc = "";

        /**
         * HighlyStructuredMessage localizableParams.
         * @member {Array.<proto.IHSMLocalizableParameter>} localizableParams
         * @memberof proto.HighlyStructuredMessage
         * @instance
         */
        HighlyStructuredMessage.prototype.localizableParams = $util.emptyArray;

        /**
         * HighlyStructuredMessage deterministicLg.
         * @member {string} deterministicLg
         * @memberof proto.HighlyStructuredMessage
         * @instance
         */
        HighlyStructuredMessage.prototype.deterministicLg = "";

        /**
         * HighlyStructuredMessage deterministicLc.
         * @member {string} deterministicLc
         * @memberof proto.HighlyStructuredMessage
         * @instance
         */
        HighlyStructuredMessage.prototype.deterministicLc = "";

        /**
         * HighlyStructuredMessage hydratedHsm.
         * @member {proto.ITemplateMessage|null|undefined} hydratedHsm
         * @memberof proto.HighlyStructuredMessage
         * @instance
         */
        HighlyStructuredMessage.prototype.hydratedHsm = null;

        /**
         * Creates a new HighlyStructuredMessage instance using the specified properties.
         * @function create
         * @memberof proto.HighlyStructuredMessage
         * @static
         * @param {proto.IHighlyStructuredMessage=} [properties] Properties to set
         * @returns {proto.HighlyStructuredMessage} HighlyStructuredMessage instance
         */
        HighlyStructuredMessage.create = function create(properties) {
            return new HighlyStructuredMessage(properties);
        };

        /**
         * Encodes the specified HighlyStructuredMessage message. Does not implicitly {@link proto.HighlyStructuredMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.HighlyStructuredMessage
         * @static
         * @param {proto.IHighlyStructuredMessage} message HighlyStructuredMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HighlyStructuredMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.namespace != null && Object.hasOwnProperty.call(message, "namespace"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.namespace);
            if (message.elementName != null && Object.hasOwnProperty.call(message, "elementName"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.elementName);
            if (message.params != null && message.params.length)
                for (var i = 0; i < message.params.length; ++i)
                    writer.uint32(/* id 3, wireType 2 =*/26).string(message.params[i]);
            if (message.fallbackLg != null && Object.hasOwnProperty.call(message, "fallbackLg"))
                writer.uint32(/* id 4, wireType 2 =*/34).string(message.fallbackLg);
            if (message.fallbackLc != null && Object.hasOwnProperty.call(message, "fallbackLc"))
                writer.uint32(/* id 5, wireType 2 =*/42).string(message.fallbackLc);
            if (message.localizableParams != null && message.localizableParams.length)
                for (var i = 0; i < message.localizableParams.length; ++i)
                    $root.proto.HSMLocalizableParameter.encode(message.localizableParams[i], writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
            if (message.deterministicLg != null && Object.hasOwnProperty.call(message, "deterministicLg"))
                writer.uint32(/* id 7, wireType 2 =*/58).string(message.deterministicLg);
            if (message.deterministicLc != null && Object.hasOwnProperty.call(message, "deterministicLc"))
                writer.uint32(/* id 8, wireType 2 =*/66).string(message.deterministicLc);
            if (message.hydratedHsm != null && Object.hasOwnProperty.call(message, "hydratedHsm"))
                $root.proto.TemplateMessage.encode(message.hydratedHsm, writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified HighlyStructuredMessage message, length delimited. Does not implicitly {@link proto.HighlyStructuredMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.HighlyStructuredMessage
         * @static
         * @param {proto.IHighlyStructuredMessage} message HighlyStructuredMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HighlyStructuredMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a HighlyStructuredMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.HighlyStructuredMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.HighlyStructuredMessage} HighlyStructuredMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HighlyStructuredMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.HighlyStructuredMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.namespace = reader.string();
                    break;
                case 2:
                    message.elementName = reader.string();
                    break;
                case 3:
                    if (!(message.params && message.params.length))
                        message.params = [];
                    message.params.push(reader.string());
                    break;
                case 4:
                    message.fallbackLg = reader.string();
                    break;
                case 5:
                    message.fallbackLc = reader.string();
                    break;
                case 6:
                    if (!(message.localizableParams && message.localizableParams.length))
                        message.localizableParams = [];
                    message.localizableParams.push($root.proto.HSMLocalizableParameter.decode(reader, reader.uint32()));
                    break;
                case 7:
                    message.deterministicLg = reader.string();
                    break;
                case 8:
                    message.deterministicLc = reader.string();
                    break;
                case 9:
                    message.hydratedHsm = $root.proto.TemplateMessage.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a HighlyStructuredMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.HighlyStructuredMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.HighlyStructuredMessage} HighlyStructuredMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HighlyStructuredMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a HighlyStructuredMessage message.
         * @function verify
         * @memberof proto.HighlyStructuredMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        HighlyStructuredMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.namespace != null && message.hasOwnProperty("namespace"))
                if (!$util.isString(message.namespace))
                    return "namespace: string expected";
            if (message.elementName != null && message.hasOwnProperty("elementName"))
                if (!$util.isString(message.elementName))
                    return "elementName: string expected";
            if (message.params != null && message.hasOwnProperty("params")) {
                if (!Array.isArray(message.params))
                    return "params: array expected";
                for (var i = 0; i < message.params.length; ++i)
                    if (!$util.isString(message.params[i]))
                        return "params: string[] expected";
            }
            if (message.fallbackLg != null && message.hasOwnProperty("fallbackLg"))
                if (!$util.isString(message.fallbackLg))
                    return "fallbackLg: string expected";
            if (message.fallbackLc != null && message.hasOwnProperty("fallbackLc"))
                if (!$util.isString(message.fallbackLc))
                    return "fallbackLc: string expected";
            if (message.localizableParams != null && message.hasOwnProperty("localizableParams")) {
                if (!Array.isArray(message.localizableParams))
                    return "localizableParams: array expected";
                for (var i = 0; i < message.localizableParams.length; ++i) {
                    var error = $root.proto.HSMLocalizableParameter.verify(message.localizableParams[i]);
                    if (error)
                        return "localizableParams." + error;
                }
            }
            if (message.deterministicLg != null && message.hasOwnProperty("deterministicLg"))
                if (!$util.isString(message.deterministicLg))
                    return "deterministicLg: string expected";
            if (message.deterministicLc != null && message.hasOwnProperty("deterministicLc"))
                if (!$util.isString(message.deterministicLc))
                    return "deterministicLc: string expected";
            if (message.hydratedHsm != null && message.hasOwnProperty("hydratedHsm")) {
                var error = $root.proto.TemplateMessage.verify(message.hydratedHsm);
                if (error)
                    return "hydratedHsm." + error;
            }
            return null;
        };

        /**
         * Creates a HighlyStructuredMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.HighlyStructuredMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.HighlyStructuredMessage} HighlyStructuredMessage
         */
        HighlyStructuredMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.HighlyStructuredMessage)
                return object;
            var message = new $root.proto.HighlyStructuredMessage();
            if (object.namespace != null)
                message.namespace = String(object.namespace);
            if (object.elementName != null)
                message.elementName = String(object.elementName);
            if (object.params) {
                if (!Array.isArray(object.params))
                    throw TypeError(".proto.HighlyStructuredMessage.params: array expected");
                message.params = [];
                for (var i = 0; i < object.params.length; ++i)
                    message.params[i] = String(object.params[i]);
            }
            if (object.fallbackLg != null)
                message.fallbackLg = String(object.fallbackLg);
            if (object.fallbackLc != null)
                message.fallbackLc = String(object.fallbackLc);
            if (object.localizableParams) {
                if (!Array.isArray(object.localizableParams))
                    throw TypeError(".proto.HighlyStructuredMessage.localizableParams: array expected");
                message.localizableParams = [];
                for (var i = 0; i < object.localizableParams.length; ++i) {
                    if (typeof object.localizableParams[i] !== "object")
                        throw TypeError(".proto.HighlyStructuredMessage.localizableParams: object expected");
                    message.localizableParams[i] = $root.proto.HSMLocalizableParameter.fromObject(object.localizableParams[i]);
                }
            }
            if (object.deterministicLg != null)
                message.deterministicLg = String(object.deterministicLg);
            if (object.deterministicLc != null)
                message.deterministicLc = String(object.deterministicLc);
            if (object.hydratedHsm != null) {
                if (typeof object.hydratedHsm !== "object")
                    throw TypeError(".proto.HighlyStructuredMessage.hydratedHsm: object expected");
                message.hydratedHsm = $root.proto.TemplateMessage.fromObject(object.hydratedHsm);
            }
            return message;
        };

        /**
         * Creates a plain object from a HighlyStructuredMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.HighlyStructuredMessage
         * @static
         * @param {proto.HighlyStructuredMessage} message HighlyStructuredMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        HighlyStructuredMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults) {
                object.params = [];
                object.localizableParams = [];
            }
            if (options.defaults) {
                object.namespace = "";
                object.elementName = "";
                object.fallbackLg = "";
                object.fallbackLc = "";
                object.deterministicLg = "";
                object.deterministicLc = "";
                object.hydratedHsm = null;
            }
            if (message.namespace != null && message.hasOwnProperty("namespace"))
                object.namespace = message.namespace;
            if (message.elementName != null && message.hasOwnProperty("elementName"))
                object.elementName = message.elementName;
            if (message.params && message.params.length) {
                object.params = [];
                for (var j = 0; j < message.params.length; ++j)
                    object.params[j] = message.params[j];
            }
            if (message.fallbackLg != null && message.hasOwnProperty("fallbackLg"))
                object.fallbackLg = message.fallbackLg;
            if (message.fallbackLc != null && message.hasOwnProperty("fallbackLc"))
                object.fallbackLc = message.fallbackLc;
            if (message.localizableParams && message.localizableParams.length) {
                object.localizableParams = [];
                for (var j = 0; j < message.localizableParams.length; ++j)
                    object.localizableParams[j] = $root.proto.HSMLocalizableParameter.toObject(message.localizableParams[j], options);
            }
            if (message.deterministicLg != null && message.hasOwnProperty("deterministicLg"))
                object.deterministicLg = message.deterministicLg;
            if (message.deterministicLc != null && message.hasOwnProperty("deterministicLc"))
                object.deterministicLc = message.deterministicLc;
            if (message.hydratedHsm != null && message.hasOwnProperty("hydratedHsm"))
                object.hydratedHsm = $root.proto.TemplateMessage.toObject(message.hydratedHsm, options);
            return object;
        };

        /**
         * Converts this HighlyStructuredMessage to JSON.
         * @function toJSON
         * @memberof proto.HighlyStructuredMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        HighlyStructuredMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return HighlyStructuredMessage;
    })();

    proto.HistorySyncNotification = (function() {

        /**
         * Properties of a HistorySyncNotification.
         * @memberof proto
         * @interface IHistorySyncNotification
         * @property {Uint8Array|null} [fileSha256] HistorySyncNotification fileSha256
         * @property {number|Long|null} [fileLength] HistorySyncNotification fileLength
         * @property {Uint8Array|null} [mediaKey] HistorySyncNotification mediaKey
         * @property {Uint8Array|null} [fileEncSha256] HistorySyncNotification fileEncSha256
         * @property {string|null} [directPath] HistorySyncNotification directPath
         * @property {proto.HistorySyncNotification.HistorySyncNotificationHistorySyncType|null} [syncType] HistorySyncNotification syncType
         * @property {number|null} [chunkOrder] HistorySyncNotification chunkOrder
         * @property {string|null} [originalMessageId] HistorySyncNotification originalMessageId
         */

        /**
         * Constructs a new HistorySyncNotification.
         * @memberof proto
         * @classdesc Represents a HistorySyncNotification.
         * @implements IHistorySyncNotification
         * @constructor
         * @param {proto.IHistorySyncNotification=} [properties] Properties to set
         */
        function HistorySyncNotification(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * HistorySyncNotification fileSha256.
         * @member {Uint8Array} fileSha256
         * @memberof proto.HistorySyncNotification
         * @instance
         */
        HistorySyncNotification.prototype.fileSha256 = $util.newBuffer([]);

        /**
         * HistorySyncNotification fileLength.
         * @member {number|Long} fileLength
         * @memberof proto.HistorySyncNotification
         * @instance
         */
        HistorySyncNotification.prototype.fileLength = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * HistorySyncNotification mediaKey.
         * @member {Uint8Array} mediaKey
         * @memberof proto.HistorySyncNotification
         * @instance
         */
        HistorySyncNotification.prototype.mediaKey = $util.newBuffer([]);

        /**
         * HistorySyncNotification fileEncSha256.
         * @member {Uint8Array} fileEncSha256
         * @memberof proto.HistorySyncNotification
         * @instance
         */
        HistorySyncNotification.prototype.fileEncSha256 = $util.newBuffer([]);

        /**
         * HistorySyncNotification directPath.
         * @member {string} directPath
         * @memberof proto.HistorySyncNotification
         * @instance
         */
        HistorySyncNotification.prototype.directPath = "";

        /**
         * HistorySyncNotification syncType.
         * @member {proto.HistorySyncNotification.HistorySyncNotificationHistorySyncType} syncType
         * @memberof proto.HistorySyncNotification
         * @instance
         */
        HistorySyncNotification.prototype.syncType = 0;

        /**
         * HistorySyncNotification chunkOrder.
         * @member {number} chunkOrder
         * @memberof proto.HistorySyncNotification
         * @instance
         */
        HistorySyncNotification.prototype.chunkOrder = 0;

        /**
         * HistorySyncNotification originalMessageId.
         * @member {string} originalMessageId
         * @memberof proto.HistorySyncNotification
         * @instance
         */
        HistorySyncNotification.prototype.originalMessageId = "";

        /**
         * Creates a new HistorySyncNotification instance using the specified properties.
         * @function create
         * @memberof proto.HistorySyncNotification
         * @static
         * @param {proto.IHistorySyncNotification=} [properties] Properties to set
         * @returns {proto.HistorySyncNotification} HistorySyncNotification instance
         */
        HistorySyncNotification.create = function create(properties) {
            return new HistorySyncNotification(properties);
        };

        /**
         * Encodes the specified HistorySyncNotification message. Does not implicitly {@link proto.HistorySyncNotification.verify|verify} messages.
         * @function encode
         * @memberof proto.HistorySyncNotification
         * @static
         * @param {proto.IHistorySyncNotification} message HistorySyncNotification message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HistorySyncNotification.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.fileSha256 != null && Object.hasOwnProperty.call(message, "fileSha256"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.fileSha256);
            if (message.fileLength != null && Object.hasOwnProperty.call(message, "fileLength"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint64(message.fileLength);
            if (message.mediaKey != null && Object.hasOwnProperty.call(message, "mediaKey"))
                writer.uint32(/* id 3, wireType 2 =*/26).bytes(message.mediaKey);
            if (message.fileEncSha256 != null && Object.hasOwnProperty.call(message, "fileEncSha256"))
                writer.uint32(/* id 4, wireType 2 =*/34).bytes(message.fileEncSha256);
            if (message.directPath != null && Object.hasOwnProperty.call(message, "directPath"))
                writer.uint32(/* id 5, wireType 2 =*/42).string(message.directPath);
            if (message.syncType != null && Object.hasOwnProperty.call(message, "syncType"))
                writer.uint32(/* id 6, wireType 0 =*/48).int32(message.syncType);
            if (message.chunkOrder != null && Object.hasOwnProperty.call(message, "chunkOrder"))
                writer.uint32(/* id 7, wireType 0 =*/56).uint32(message.chunkOrder);
            if (message.originalMessageId != null && Object.hasOwnProperty.call(message, "originalMessageId"))
                writer.uint32(/* id 8, wireType 2 =*/66).string(message.originalMessageId);
            return writer;
        };

        /**
         * Encodes the specified HistorySyncNotification message, length delimited. Does not implicitly {@link proto.HistorySyncNotification.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.HistorySyncNotification
         * @static
         * @param {proto.IHistorySyncNotification} message HistorySyncNotification message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HistorySyncNotification.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a HistorySyncNotification message from the specified reader or buffer.
         * @function decode
         * @memberof proto.HistorySyncNotification
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.HistorySyncNotification} HistorySyncNotification
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HistorySyncNotification.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.HistorySyncNotification();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.fileSha256 = reader.bytes();
                    break;
                case 2:
                    message.fileLength = reader.uint64();
                    break;
                case 3:
                    message.mediaKey = reader.bytes();
                    break;
                case 4:
                    message.fileEncSha256 = reader.bytes();
                    break;
                case 5:
                    message.directPath = reader.string();
                    break;
                case 6:
                    message.syncType = reader.int32();
                    break;
                case 7:
                    message.chunkOrder = reader.uint32();
                    break;
                case 8:
                    message.originalMessageId = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a HistorySyncNotification message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.HistorySyncNotification
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.HistorySyncNotification} HistorySyncNotification
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HistorySyncNotification.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a HistorySyncNotification message.
         * @function verify
         * @memberof proto.HistorySyncNotification
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        HistorySyncNotification.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.fileSha256 != null && message.hasOwnProperty("fileSha256"))
                if (!(message.fileSha256 && typeof message.fileSha256.length === "number" || $util.isString(message.fileSha256)))
                    return "fileSha256: buffer expected";
            if (message.fileLength != null && message.hasOwnProperty("fileLength"))
                if (!$util.isInteger(message.fileLength) && !(message.fileLength && $util.isInteger(message.fileLength.low) && $util.isInteger(message.fileLength.high)))
                    return "fileLength: integer|Long expected";
            if (message.mediaKey != null && message.hasOwnProperty("mediaKey"))
                if (!(message.mediaKey && typeof message.mediaKey.length === "number" || $util.isString(message.mediaKey)))
                    return "mediaKey: buffer expected";
            if (message.fileEncSha256 != null && message.hasOwnProperty("fileEncSha256"))
                if (!(message.fileEncSha256 && typeof message.fileEncSha256.length === "number" || $util.isString(message.fileEncSha256)))
                    return "fileEncSha256: buffer expected";
            if (message.directPath != null && message.hasOwnProperty("directPath"))
                if (!$util.isString(message.directPath))
                    return "directPath: string expected";
            if (message.syncType != null && message.hasOwnProperty("syncType"))
                switch (message.syncType) {
                default:
                    return "syncType: enum value expected";
                case 0:
                case 1:
                case 2:
                case 3:
                case 4:
                    break;
                }
            if (message.chunkOrder != null && message.hasOwnProperty("chunkOrder"))
                if (!$util.isInteger(message.chunkOrder))
                    return "chunkOrder: integer expected";
            if (message.originalMessageId != null && message.hasOwnProperty("originalMessageId"))
                if (!$util.isString(message.originalMessageId))
                    return "originalMessageId: string expected";
            return null;
        };

        /**
         * Creates a HistorySyncNotification message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.HistorySyncNotification
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.HistorySyncNotification} HistorySyncNotification
         */
        HistorySyncNotification.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.HistorySyncNotification)
                return object;
            var message = new $root.proto.HistorySyncNotification();
            if (object.fileSha256 != null)
                if (typeof object.fileSha256 === "string")
                    $util.base64.decode(object.fileSha256, message.fileSha256 = $util.newBuffer($util.base64.length(object.fileSha256)), 0);
                else if (object.fileSha256.length)
                    message.fileSha256 = object.fileSha256;
            if (object.fileLength != null)
                if ($util.Long)
                    (message.fileLength = $util.Long.fromValue(object.fileLength)).unsigned = true;
                else if (typeof object.fileLength === "string")
                    message.fileLength = parseInt(object.fileLength, 10);
                else if (typeof object.fileLength === "number")
                    message.fileLength = object.fileLength;
                else if (typeof object.fileLength === "object")
                    message.fileLength = new $util.LongBits(object.fileLength.low >>> 0, object.fileLength.high >>> 0).toNumber(true);
            if (object.mediaKey != null)
                if (typeof object.mediaKey === "string")
                    $util.base64.decode(object.mediaKey, message.mediaKey = $util.newBuffer($util.base64.length(object.mediaKey)), 0);
                else if (object.mediaKey.length)
                    message.mediaKey = object.mediaKey;
            if (object.fileEncSha256 != null)
                if (typeof object.fileEncSha256 === "string")
                    $util.base64.decode(object.fileEncSha256, message.fileEncSha256 = $util.newBuffer($util.base64.length(object.fileEncSha256)), 0);
                else if (object.fileEncSha256.length)
                    message.fileEncSha256 = object.fileEncSha256;
            if (object.directPath != null)
                message.directPath = String(object.directPath);
            switch (object.syncType) {
            case "INITIAL_BOOTSTRAP":
            case 0:
                message.syncType = 0;
                break;
            case "INITIAL_STATUS_V3":
            case 1:
                message.syncType = 1;
                break;
            case "FULL":
            case 2:
                message.syncType = 2;
                break;
            case "RECENT":
            case 3:
                message.syncType = 3;
                break;
            case "PUSH_NAME":
            case 4:
                message.syncType = 4;
                break;
            }
            if (object.chunkOrder != null)
                message.chunkOrder = object.chunkOrder >>> 0;
            if (object.originalMessageId != null)
                message.originalMessageId = String(object.originalMessageId);
            return message;
        };

        /**
         * Creates a plain object from a HistorySyncNotification message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.HistorySyncNotification
         * @static
         * @param {proto.HistorySyncNotification} message HistorySyncNotification
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        HistorySyncNotification.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if (options.bytes === String)
                    object.fileSha256 = "";
                else {
                    object.fileSha256 = [];
                    if (options.bytes !== Array)
                        object.fileSha256 = $util.newBuffer(object.fileSha256);
                }
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.fileLength = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.fileLength = options.longs === String ? "0" : 0;
                if (options.bytes === String)
                    object.mediaKey = "";
                else {
                    object.mediaKey = [];
                    if (options.bytes !== Array)
                        object.mediaKey = $util.newBuffer(object.mediaKey);
                }
                if (options.bytes === String)
                    object.fileEncSha256 = "";
                else {
                    object.fileEncSha256 = [];
                    if (options.bytes !== Array)
                        object.fileEncSha256 = $util.newBuffer(object.fileEncSha256);
                }
                object.directPath = "";
                object.syncType = options.enums === String ? "INITIAL_BOOTSTRAP" : 0;
                object.chunkOrder = 0;
                object.originalMessageId = "";
            }
            if (message.fileSha256 != null && message.hasOwnProperty("fileSha256"))
                object.fileSha256 = options.bytes === String ? $util.base64.encode(message.fileSha256, 0, message.fileSha256.length) : options.bytes === Array ? Array.prototype.slice.call(message.fileSha256) : message.fileSha256;
            if (message.fileLength != null && message.hasOwnProperty("fileLength"))
                if (typeof message.fileLength === "number")
                    object.fileLength = options.longs === String ? String(message.fileLength) : message.fileLength;
                else
                    object.fileLength = options.longs === String ? $util.Long.prototype.toString.call(message.fileLength) : options.longs === Number ? new $util.LongBits(message.fileLength.low >>> 0, message.fileLength.high >>> 0).toNumber(true) : message.fileLength;
            if (message.mediaKey != null && message.hasOwnProperty("mediaKey"))
                object.mediaKey = options.bytes === String ? $util.base64.encode(message.mediaKey, 0, message.mediaKey.length) : options.bytes === Array ? Array.prototype.slice.call(message.mediaKey) : message.mediaKey;
            if (message.fileEncSha256 != null && message.hasOwnProperty("fileEncSha256"))
                object.fileEncSha256 = options.bytes === String ? $util.base64.encode(message.fileEncSha256, 0, message.fileEncSha256.length) : options.bytes === Array ? Array.prototype.slice.call(message.fileEncSha256) : message.fileEncSha256;
            if (message.directPath != null && message.hasOwnProperty("directPath"))
                object.directPath = message.directPath;
            if (message.syncType != null && message.hasOwnProperty("syncType"))
                object.syncType = options.enums === String ? $root.proto.HistorySyncNotification.HistorySyncNotificationHistorySyncType[message.syncType] : message.syncType;
            if (message.chunkOrder != null && message.hasOwnProperty("chunkOrder"))
                object.chunkOrder = message.chunkOrder;
            if (message.originalMessageId != null && message.hasOwnProperty("originalMessageId"))
                object.originalMessageId = message.originalMessageId;
            return object;
        };

        /**
         * Converts this HistorySyncNotification to JSON.
         * @function toJSON
         * @memberof proto.HistorySyncNotification
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        HistorySyncNotification.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * HistorySyncNotificationHistorySyncType enum.
         * @name proto.HistorySyncNotification.HistorySyncNotificationHistorySyncType
         * @enum {number}
         * @property {number} INITIAL_BOOTSTRAP=0 INITIAL_BOOTSTRAP value
         * @property {number} INITIAL_STATUS_V3=1 INITIAL_STATUS_V3 value
         * @property {number} FULL=2 FULL value
         * @property {number} RECENT=3 RECENT value
         * @property {number} PUSH_NAME=4 PUSH_NAME value
         */
        HistorySyncNotification.HistorySyncNotificationHistorySyncType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "INITIAL_BOOTSTRAP"] = 0;
            values[valuesById[1] = "INITIAL_STATUS_V3"] = 1;
            values[valuesById[2] = "FULL"] = 2;
            values[valuesById[3] = "RECENT"] = 3;
            values[valuesById[4] = "PUSH_NAME"] = 4;
            return values;
        })();

        return HistorySyncNotification;
    })();

    proto.HSMCurrency = (function() {

        /**
         * Properties of a HSMCurrency.
         * @memberof proto
         * @interface IHSMCurrency
         * @property {string|null} [currencyCode] HSMCurrency currencyCode
         * @property {number|Long|null} [amount1000] HSMCurrency amount1000
         */

        /**
         * Constructs a new HSMCurrency.
         * @memberof proto
         * @classdesc Represents a HSMCurrency.
         * @implements IHSMCurrency
         * @constructor
         * @param {proto.IHSMCurrency=} [properties] Properties to set
         */
        function HSMCurrency(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * HSMCurrency currencyCode.
         * @member {string} currencyCode
         * @memberof proto.HSMCurrency
         * @instance
         */
        HSMCurrency.prototype.currencyCode = "";

        /**
         * HSMCurrency amount1000.
         * @member {number|Long} amount1000
         * @memberof proto.HSMCurrency
         * @instance
         */
        HSMCurrency.prototype.amount1000 = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * Creates a new HSMCurrency instance using the specified properties.
         * @function create
         * @memberof proto.HSMCurrency
         * @static
         * @param {proto.IHSMCurrency=} [properties] Properties to set
         * @returns {proto.HSMCurrency} HSMCurrency instance
         */
        HSMCurrency.create = function create(properties) {
            return new HSMCurrency(properties);
        };

        /**
         * Encodes the specified HSMCurrency message. Does not implicitly {@link proto.HSMCurrency.verify|verify} messages.
         * @function encode
         * @memberof proto.HSMCurrency
         * @static
         * @param {proto.IHSMCurrency} message HSMCurrency message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HSMCurrency.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.currencyCode != null && Object.hasOwnProperty.call(message, "currencyCode"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.currencyCode);
            if (message.amount1000 != null && Object.hasOwnProperty.call(message, "amount1000"))
                writer.uint32(/* id 2, wireType 0 =*/16).int64(message.amount1000);
            return writer;
        };

        /**
         * Encodes the specified HSMCurrency message, length delimited. Does not implicitly {@link proto.HSMCurrency.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.HSMCurrency
         * @static
         * @param {proto.IHSMCurrency} message HSMCurrency message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HSMCurrency.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a HSMCurrency message from the specified reader or buffer.
         * @function decode
         * @memberof proto.HSMCurrency
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.HSMCurrency} HSMCurrency
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HSMCurrency.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.HSMCurrency();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.currencyCode = reader.string();
                    break;
                case 2:
                    message.amount1000 = reader.int64();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a HSMCurrency message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.HSMCurrency
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.HSMCurrency} HSMCurrency
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HSMCurrency.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a HSMCurrency message.
         * @function verify
         * @memberof proto.HSMCurrency
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        HSMCurrency.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.currencyCode != null && message.hasOwnProperty("currencyCode"))
                if (!$util.isString(message.currencyCode))
                    return "currencyCode: string expected";
            if (message.amount1000 != null && message.hasOwnProperty("amount1000"))
                if (!$util.isInteger(message.amount1000) && !(message.amount1000 && $util.isInteger(message.amount1000.low) && $util.isInteger(message.amount1000.high)))
                    return "amount1000: integer|Long expected";
            return null;
        };

        /**
         * Creates a HSMCurrency message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.HSMCurrency
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.HSMCurrency} HSMCurrency
         */
        HSMCurrency.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.HSMCurrency)
                return object;
            var message = new $root.proto.HSMCurrency();
            if (object.currencyCode != null)
                message.currencyCode = String(object.currencyCode);
            if (object.amount1000 != null)
                if ($util.Long)
                    (message.amount1000 = $util.Long.fromValue(object.amount1000)).unsigned = false;
                else if (typeof object.amount1000 === "string")
                    message.amount1000 = parseInt(object.amount1000, 10);
                else if (typeof object.amount1000 === "number")
                    message.amount1000 = object.amount1000;
                else if (typeof object.amount1000 === "object")
                    message.amount1000 = new $util.LongBits(object.amount1000.low >>> 0, object.amount1000.high >>> 0).toNumber();
            return message;
        };

        /**
         * Creates a plain object from a HSMCurrency message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.HSMCurrency
         * @static
         * @param {proto.HSMCurrency} message HSMCurrency
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        HSMCurrency.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.currencyCode = "";
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.amount1000 = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.amount1000 = options.longs === String ? "0" : 0;
            }
            if (message.currencyCode != null && message.hasOwnProperty("currencyCode"))
                object.currencyCode = message.currencyCode;
            if (message.amount1000 != null && message.hasOwnProperty("amount1000"))
                if (typeof message.amount1000 === "number")
                    object.amount1000 = options.longs === String ? String(message.amount1000) : message.amount1000;
                else
                    object.amount1000 = options.longs === String ? $util.Long.prototype.toString.call(message.amount1000) : options.longs === Number ? new $util.LongBits(message.amount1000.low >>> 0, message.amount1000.high >>> 0).toNumber() : message.amount1000;
            return object;
        };

        /**
         * Converts this HSMCurrency to JSON.
         * @function toJSON
         * @memberof proto.HSMCurrency
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        HSMCurrency.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return HSMCurrency;
    })();

    proto.HSMDateTime = (function() {

        /**
         * Properties of a HSMDateTime.
         * @memberof proto
         * @interface IHSMDateTime
         * @property {proto.IHSMDateTimeComponent|null} [component] HSMDateTime component
         * @property {proto.IHSMDateTimeUnixEpoch|null} [unixEpoch] HSMDateTime unixEpoch
         */

        /**
         * Constructs a new HSMDateTime.
         * @memberof proto
         * @classdesc Represents a HSMDateTime.
         * @implements IHSMDateTime
         * @constructor
         * @param {proto.IHSMDateTime=} [properties] Properties to set
         */
        function HSMDateTime(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * HSMDateTime component.
         * @member {proto.IHSMDateTimeComponent|null|undefined} component
         * @memberof proto.HSMDateTime
         * @instance
         */
        HSMDateTime.prototype.component = null;

        /**
         * HSMDateTime unixEpoch.
         * @member {proto.IHSMDateTimeUnixEpoch|null|undefined} unixEpoch
         * @memberof proto.HSMDateTime
         * @instance
         */
        HSMDateTime.prototype.unixEpoch = null;

        // OneOf field names bound to virtual getters and setters
        var $oneOfFields;

        /**
         * HSMDateTime datetimeOneof.
         * @member {"component"|"unixEpoch"|undefined} datetimeOneof
         * @memberof proto.HSMDateTime
         * @instance
         */
        Object.defineProperty(HSMDateTime.prototype, "datetimeOneof", {
            get: $util.oneOfGetter($oneOfFields = ["component", "unixEpoch"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new HSMDateTime instance using the specified properties.
         * @function create
         * @memberof proto.HSMDateTime
         * @static
         * @param {proto.IHSMDateTime=} [properties] Properties to set
         * @returns {proto.HSMDateTime} HSMDateTime instance
         */
        HSMDateTime.create = function create(properties) {
            return new HSMDateTime(properties);
        };

        /**
         * Encodes the specified HSMDateTime message. Does not implicitly {@link proto.HSMDateTime.verify|verify} messages.
         * @function encode
         * @memberof proto.HSMDateTime
         * @static
         * @param {proto.IHSMDateTime} message HSMDateTime message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HSMDateTime.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.component != null && Object.hasOwnProperty.call(message, "component"))
                $root.proto.HSMDateTimeComponent.encode(message.component, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.unixEpoch != null && Object.hasOwnProperty.call(message, "unixEpoch"))
                $root.proto.HSMDateTimeUnixEpoch.encode(message.unixEpoch, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified HSMDateTime message, length delimited. Does not implicitly {@link proto.HSMDateTime.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.HSMDateTime
         * @static
         * @param {proto.IHSMDateTime} message HSMDateTime message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HSMDateTime.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a HSMDateTime message from the specified reader or buffer.
         * @function decode
         * @memberof proto.HSMDateTime
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.HSMDateTime} HSMDateTime
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HSMDateTime.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.HSMDateTime();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.component = $root.proto.HSMDateTimeComponent.decode(reader, reader.uint32());
                    break;
                case 2:
                    message.unixEpoch = $root.proto.HSMDateTimeUnixEpoch.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a HSMDateTime message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.HSMDateTime
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.HSMDateTime} HSMDateTime
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HSMDateTime.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a HSMDateTime message.
         * @function verify
         * @memberof proto.HSMDateTime
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        HSMDateTime.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            var properties = {};
            if (message.component != null && message.hasOwnProperty("component")) {
                properties.datetimeOneof = 1;
                {
                    var error = $root.proto.HSMDateTimeComponent.verify(message.component);
                    if (error)
                        return "component." + error;
                }
            }
            if (message.unixEpoch != null && message.hasOwnProperty("unixEpoch")) {
                if (properties.datetimeOneof === 1)
                    return "datetimeOneof: multiple values";
                properties.datetimeOneof = 1;
                {
                    var error = $root.proto.HSMDateTimeUnixEpoch.verify(message.unixEpoch);
                    if (error)
                        return "unixEpoch." + error;
                }
            }
            return null;
        };

        /**
         * Creates a HSMDateTime message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.HSMDateTime
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.HSMDateTime} HSMDateTime
         */
        HSMDateTime.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.HSMDateTime)
                return object;
            var message = new $root.proto.HSMDateTime();
            if (object.component != null) {
                if (typeof object.component !== "object")
                    throw TypeError(".proto.HSMDateTime.component: object expected");
                message.component = $root.proto.HSMDateTimeComponent.fromObject(object.component);
            }
            if (object.unixEpoch != null) {
                if (typeof object.unixEpoch !== "object")
                    throw TypeError(".proto.HSMDateTime.unixEpoch: object expected");
                message.unixEpoch = $root.proto.HSMDateTimeUnixEpoch.fromObject(object.unixEpoch);
            }
            return message;
        };

        /**
         * Creates a plain object from a HSMDateTime message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.HSMDateTime
         * @static
         * @param {proto.HSMDateTime} message HSMDateTime
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        HSMDateTime.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (message.component != null && message.hasOwnProperty("component")) {
                object.component = $root.proto.HSMDateTimeComponent.toObject(message.component, options);
                if (options.oneofs)
                    object.datetimeOneof = "component";
            }
            if (message.unixEpoch != null && message.hasOwnProperty("unixEpoch")) {
                object.unixEpoch = $root.proto.HSMDateTimeUnixEpoch.toObject(message.unixEpoch, options);
                if (options.oneofs)
                    object.datetimeOneof = "unixEpoch";
            }
            return object;
        };

        /**
         * Converts this HSMDateTime to JSON.
         * @function toJSON
         * @memberof proto.HSMDateTime
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        HSMDateTime.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return HSMDateTime;
    })();

    proto.HSMDateTimeComponent = (function() {

        /**
         * Properties of a HSMDateTimeComponent.
         * @memberof proto
         * @interface IHSMDateTimeComponent
         * @property {proto.HSMDateTimeComponent.HSMDateTimeComponentDayOfWeekType|null} [dayOfWeek] HSMDateTimeComponent dayOfWeek
         * @property {number|null} [year] HSMDateTimeComponent year
         * @property {number|null} [month] HSMDateTimeComponent month
         * @property {number|null} [dayOfMonth] HSMDateTimeComponent dayOfMonth
         * @property {number|null} [hour] HSMDateTimeComponent hour
         * @property {number|null} [minute] HSMDateTimeComponent minute
         * @property {proto.HSMDateTimeComponent.HSMDateTimeComponentCalendarType|null} [calendar] HSMDateTimeComponent calendar
         */

        /**
         * Constructs a new HSMDateTimeComponent.
         * @memberof proto
         * @classdesc Represents a HSMDateTimeComponent.
         * @implements IHSMDateTimeComponent
         * @constructor
         * @param {proto.IHSMDateTimeComponent=} [properties] Properties to set
         */
        function HSMDateTimeComponent(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * HSMDateTimeComponent dayOfWeek.
         * @member {proto.HSMDateTimeComponent.HSMDateTimeComponentDayOfWeekType} dayOfWeek
         * @memberof proto.HSMDateTimeComponent
         * @instance
         */
        HSMDateTimeComponent.prototype.dayOfWeek = 1;

        /**
         * HSMDateTimeComponent year.
         * @member {number} year
         * @memberof proto.HSMDateTimeComponent
         * @instance
         */
        HSMDateTimeComponent.prototype.year = 0;

        /**
         * HSMDateTimeComponent month.
         * @member {number} month
         * @memberof proto.HSMDateTimeComponent
         * @instance
         */
        HSMDateTimeComponent.prototype.month = 0;

        /**
         * HSMDateTimeComponent dayOfMonth.
         * @member {number} dayOfMonth
         * @memberof proto.HSMDateTimeComponent
         * @instance
         */
        HSMDateTimeComponent.prototype.dayOfMonth = 0;

        /**
         * HSMDateTimeComponent hour.
         * @member {number} hour
         * @memberof proto.HSMDateTimeComponent
         * @instance
         */
        HSMDateTimeComponent.prototype.hour = 0;

        /**
         * HSMDateTimeComponent minute.
         * @member {number} minute
         * @memberof proto.HSMDateTimeComponent
         * @instance
         */
        HSMDateTimeComponent.prototype.minute = 0;

        /**
         * HSMDateTimeComponent calendar.
         * @member {proto.HSMDateTimeComponent.HSMDateTimeComponentCalendarType} calendar
         * @memberof proto.HSMDateTimeComponent
         * @instance
         */
        HSMDateTimeComponent.prototype.calendar = 1;

        /**
         * Creates a new HSMDateTimeComponent instance using the specified properties.
         * @function create
         * @memberof proto.HSMDateTimeComponent
         * @static
         * @param {proto.IHSMDateTimeComponent=} [properties] Properties to set
         * @returns {proto.HSMDateTimeComponent} HSMDateTimeComponent instance
         */
        HSMDateTimeComponent.create = function create(properties) {
            return new HSMDateTimeComponent(properties);
        };

        /**
         * Encodes the specified HSMDateTimeComponent message. Does not implicitly {@link proto.HSMDateTimeComponent.verify|verify} messages.
         * @function encode
         * @memberof proto.HSMDateTimeComponent
         * @static
         * @param {proto.IHSMDateTimeComponent} message HSMDateTimeComponent message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HSMDateTimeComponent.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.dayOfWeek != null && Object.hasOwnProperty.call(message, "dayOfWeek"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.dayOfWeek);
            if (message.year != null && Object.hasOwnProperty.call(message, "year"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint32(message.year);
            if (message.month != null && Object.hasOwnProperty.call(message, "month"))
                writer.uint32(/* id 3, wireType 0 =*/24).uint32(message.month);
            if (message.dayOfMonth != null && Object.hasOwnProperty.call(message, "dayOfMonth"))
                writer.uint32(/* id 4, wireType 0 =*/32).uint32(message.dayOfMonth);
            if (message.hour != null && Object.hasOwnProperty.call(message, "hour"))
                writer.uint32(/* id 5, wireType 0 =*/40).uint32(message.hour);
            if (message.minute != null && Object.hasOwnProperty.call(message, "minute"))
                writer.uint32(/* id 6, wireType 0 =*/48).uint32(message.minute);
            if (message.calendar != null && Object.hasOwnProperty.call(message, "calendar"))
                writer.uint32(/* id 7, wireType 0 =*/56).int32(message.calendar);
            return writer;
        };

        /**
         * Encodes the specified HSMDateTimeComponent message, length delimited. Does not implicitly {@link proto.HSMDateTimeComponent.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.HSMDateTimeComponent
         * @static
         * @param {proto.IHSMDateTimeComponent} message HSMDateTimeComponent message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HSMDateTimeComponent.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a HSMDateTimeComponent message from the specified reader or buffer.
         * @function decode
         * @memberof proto.HSMDateTimeComponent
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.HSMDateTimeComponent} HSMDateTimeComponent
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HSMDateTimeComponent.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.HSMDateTimeComponent();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.dayOfWeek = reader.int32();
                    break;
                case 2:
                    message.year = reader.uint32();
                    break;
                case 3:
                    message.month = reader.uint32();
                    break;
                case 4:
                    message.dayOfMonth = reader.uint32();
                    break;
                case 5:
                    message.hour = reader.uint32();
                    break;
                case 6:
                    message.minute = reader.uint32();
                    break;
                case 7:
                    message.calendar = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a HSMDateTimeComponent message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.HSMDateTimeComponent
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.HSMDateTimeComponent} HSMDateTimeComponent
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HSMDateTimeComponent.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a HSMDateTimeComponent message.
         * @function verify
         * @memberof proto.HSMDateTimeComponent
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        HSMDateTimeComponent.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.dayOfWeek != null && message.hasOwnProperty("dayOfWeek"))
                switch (message.dayOfWeek) {
                default:
                    return "dayOfWeek: enum value expected";
                case 1:
                case 2:
                case 3:
                case 4:
                case 5:
                case 6:
                case 7:
                    break;
                }
            if (message.year != null && message.hasOwnProperty("year"))
                if (!$util.isInteger(message.year))
                    return "year: integer expected";
            if (message.month != null && message.hasOwnProperty("month"))
                if (!$util.isInteger(message.month))
                    return "month: integer expected";
            if (message.dayOfMonth != null && message.hasOwnProperty("dayOfMonth"))
                if (!$util.isInteger(message.dayOfMonth))
                    return "dayOfMonth: integer expected";
            if (message.hour != null && message.hasOwnProperty("hour"))
                if (!$util.isInteger(message.hour))
                    return "hour: integer expected";
            if (message.minute != null && message.hasOwnProperty("minute"))
                if (!$util.isInteger(message.minute))
                    return "minute: integer expected";
            if (message.calendar != null && message.hasOwnProperty("calendar"))
                switch (message.calendar) {
                default:
                    return "calendar: enum value expected";
                case 1:
                case 2:
                    break;
                }
            return null;
        };

        /**
         * Creates a HSMDateTimeComponent message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.HSMDateTimeComponent
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.HSMDateTimeComponent} HSMDateTimeComponent
         */
        HSMDateTimeComponent.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.HSMDateTimeComponent)
                return object;
            var message = new $root.proto.HSMDateTimeComponent();
            switch (object.dayOfWeek) {
            case "MONDAY":
            case 1:
                message.dayOfWeek = 1;
                break;
            case "TUESDAY":
            case 2:
                message.dayOfWeek = 2;
                break;
            case "WEDNESDAY":
            case 3:
                message.dayOfWeek = 3;
                break;
            case "THURSDAY":
            case 4:
                message.dayOfWeek = 4;
                break;
            case "FRIDAY":
            case 5:
                message.dayOfWeek = 5;
                break;
            case "SATURDAY":
            case 6:
                message.dayOfWeek = 6;
                break;
            case "SUNDAY":
            case 7:
                message.dayOfWeek = 7;
                break;
            }
            if (object.year != null)
                message.year = object.year >>> 0;
            if (object.month != null)
                message.month = object.month >>> 0;
            if (object.dayOfMonth != null)
                message.dayOfMonth = object.dayOfMonth >>> 0;
            if (object.hour != null)
                message.hour = object.hour >>> 0;
            if (object.minute != null)
                message.minute = object.minute >>> 0;
            switch (object.calendar) {
            case "GREGORIAN":
            case 1:
                message.calendar = 1;
                break;
            case "SOLAR_HIJRI":
            case 2:
                message.calendar = 2;
                break;
            }
            return message;
        };

        /**
         * Creates a plain object from a HSMDateTimeComponent message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.HSMDateTimeComponent
         * @static
         * @param {proto.HSMDateTimeComponent} message HSMDateTimeComponent
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        HSMDateTimeComponent.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.dayOfWeek = options.enums === String ? "MONDAY" : 1;
                object.year = 0;
                object.month = 0;
                object.dayOfMonth = 0;
                object.hour = 0;
                object.minute = 0;
                object.calendar = options.enums === String ? "GREGORIAN" : 1;
            }
            if (message.dayOfWeek != null && message.hasOwnProperty("dayOfWeek"))
                object.dayOfWeek = options.enums === String ? $root.proto.HSMDateTimeComponent.HSMDateTimeComponentDayOfWeekType[message.dayOfWeek] : message.dayOfWeek;
            if (message.year != null && message.hasOwnProperty("year"))
                object.year = message.year;
            if (message.month != null && message.hasOwnProperty("month"))
                object.month = message.month;
            if (message.dayOfMonth != null && message.hasOwnProperty("dayOfMonth"))
                object.dayOfMonth = message.dayOfMonth;
            if (message.hour != null && message.hasOwnProperty("hour"))
                object.hour = message.hour;
            if (message.minute != null && message.hasOwnProperty("minute"))
                object.minute = message.minute;
            if (message.calendar != null && message.hasOwnProperty("calendar"))
                object.calendar = options.enums === String ? $root.proto.HSMDateTimeComponent.HSMDateTimeComponentCalendarType[message.calendar] : message.calendar;
            return object;
        };

        /**
         * Converts this HSMDateTimeComponent to JSON.
         * @function toJSON
         * @memberof proto.HSMDateTimeComponent
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        HSMDateTimeComponent.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * HSMDateTimeComponentDayOfWeekType enum.
         * @name proto.HSMDateTimeComponent.HSMDateTimeComponentDayOfWeekType
         * @enum {number}
         * @property {number} MONDAY=1 MONDAY value
         * @property {number} TUESDAY=2 TUESDAY value
         * @property {number} WEDNESDAY=3 WEDNESDAY value
         * @property {number} THURSDAY=4 THURSDAY value
         * @property {number} FRIDAY=5 FRIDAY value
         * @property {number} SATURDAY=6 SATURDAY value
         * @property {number} SUNDAY=7 SUNDAY value
         */
        HSMDateTimeComponent.HSMDateTimeComponentDayOfWeekType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[1] = "MONDAY"] = 1;
            values[valuesById[2] = "TUESDAY"] = 2;
            values[valuesById[3] = "WEDNESDAY"] = 3;
            values[valuesById[4] = "THURSDAY"] = 4;
            values[valuesById[5] = "FRIDAY"] = 5;
            values[valuesById[6] = "SATURDAY"] = 6;
            values[valuesById[7] = "SUNDAY"] = 7;
            return values;
        })();

        /**
         * HSMDateTimeComponentCalendarType enum.
         * @name proto.HSMDateTimeComponent.HSMDateTimeComponentCalendarType
         * @enum {number}
         * @property {number} GREGORIAN=1 GREGORIAN value
         * @property {number} SOLAR_HIJRI=2 SOLAR_HIJRI value
         */
        HSMDateTimeComponent.HSMDateTimeComponentCalendarType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[1] = "GREGORIAN"] = 1;
            values[valuesById[2] = "SOLAR_HIJRI"] = 2;
            return values;
        })();

        return HSMDateTimeComponent;
    })();

    proto.HSMDateTimeUnixEpoch = (function() {

        /**
         * Properties of a HSMDateTimeUnixEpoch.
         * @memberof proto
         * @interface IHSMDateTimeUnixEpoch
         * @property {number|Long|null} [timestamp] HSMDateTimeUnixEpoch timestamp
         */

        /**
         * Constructs a new HSMDateTimeUnixEpoch.
         * @memberof proto
         * @classdesc Represents a HSMDateTimeUnixEpoch.
         * @implements IHSMDateTimeUnixEpoch
         * @constructor
         * @param {proto.IHSMDateTimeUnixEpoch=} [properties] Properties to set
         */
        function HSMDateTimeUnixEpoch(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * HSMDateTimeUnixEpoch timestamp.
         * @member {number|Long} timestamp
         * @memberof proto.HSMDateTimeUnixEpoch
         * @instance
         */
        HSMDateTimeUnixEpoch.prototype.timestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * Creates a new HSMDateTimeUnixEpoch instance using the specified properties.
         * @function create
         * @memberof proto.HSMDateTimeUnixEpoch
         * @static
         * @param {proto.IHSMDateTimeUnixEpoch=} [properties] Properties to set
         * @returns {proto.HSMDateTimeUnixEpoch} HSMDateTimeUnixEpoch instance
         */
        HSMDateTimeUnixEpoch.create = function create(properties) {
            return new HSMDateTimeUnixEpoch(properties);
        };

        /**
         * Encodes the specified HSMDateTimeUnixEpoch message. Does not implicitly {@link proto.HSMDateTimeUnixEpoch.verify|verify} messages.
         * @function encode
         * @memberof proto.HSMDateTimeUnixEpoch
         * @static
         * @param {proto.IHSMDateTimeUnixEpoch} message HSMDateTimeUnixEpoch message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HSMDateTimeUnixEpoch.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.timestamp != null && Object.hasOwnProperty.call(message, "timestamp"))
                writer.uint32(/* id 1, wireType 0 =*/8).int64(message.timestamp);
            return writer;
        };

        /**
         * Encodes the specified HSMDateTimeUnixEpoch message, length delimited. Does not implicitly {@link proto.HSMDateTimeUnixEpoch.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.HSMDateTimeUnixEpoch
         * @static
         * @param {proto.IHSMDateTimeUnixEpoch} message HSMDateTimeUnixEpoch message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HSMDateTimeUnixEpoch.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a HSMDateTimeUnixEpoch message from the specified reader or buffer.
         * @function decode
         * @memberof proto.HSMDateTimeUnixEpoch
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.HSMDateTimeUnixEpoch} HSMDateTimeUnixEpoch
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HSMDateTimeUnixEpoch.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.HSMDateTimeUnixEpoch();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.timestamp = reader.int64();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a HSMDateTimeUnixEpoch message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.HSMDateTimeUnixEpoch
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.HSMDateTimeUnixEpoch} HSMDateTimeUnixEpoch
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HSMDateTimeUnixEpoch.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a HSMDateTimeUnixEpoch message.
         * @function verify
         * @memberof proto.HSMDateTimeUnixEpoch
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        HSMDateTimeUnixEpoch.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                if (!$util.isInteger(message.timestamp) && !(message.timestamp && $util.isInteger(message.timestamp.low) && $util.isInteger(message.timestamp.high)))
                    return "timestamp: integer|Long expected";
            return null;
        };

        /**
         * Creates a HSMDateTimeUnixEpoch message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.HSMDateTimeUnixEpoch
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.HSMDateTimeUnixEpoch} HSMDateTimeUnixEpoch
         */
        HSMDateTimeUnixEpoch.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.HSMDateTimeUnixEpoch)
                return object;
            var message = new $root.proto.HSMDateTimeUnixEpoch();
            if (object.timestamp != null)
                if ($util.Long)
                    (message.timestamp = $util.Long.fromValue(object.timestamp)).unsigned = false;
                else if (typeof object.timestamp === "string")
                    message.timestamp = parseInt(object.timestamp, 10);
                else if (typeof object.timestamp === "number")
                    message.timestamp = object.timestamp;
                else if (typeof object.timestamp === "object")
                    message.timestamp = new $util.LongBits(object.timestamp.low >>> 0, object.timestamp.high >>> 0).toNumber();
            return message;
        };

        /**
         * Creates a plain object from a HSMDateTimeUnixEpoch message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.HSMDateTimeUnixEpoch
         * @static
         * @param {proto.HSMDateTimeUnixEpoch} message HSMDateTimeUnixEpoch
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        HSMDateTimeUnixEpoch.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.timestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.timestamp = options.longs === String ? "0" : 0;
            if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                if (typeof message.timestamp === "number")
                    object.timestamp = options.longs === String ? String(message.timestamp) : message.timestamp;
                else
                    object.timestamp = options.longs === String ? $util.Long.prototype.toString.call(message.timestamp) : options.longs === Number ? new $util.LongBits(message.timestamp.low >>> 0, message.timestamp.high >>> 0).toNumber() : message.timestamp;
            return object;
        };

        /**
         * Converts this HSMDateTimeUnixEpoch to JSON.
         * @function toJSON
         * @memberof proto.HSMDateTimeUnixEpoch
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        HSMDateTimeUnixEpoch.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return HSMDateTimeUnixEpoch;
    })();

    proto.HSMLocalizableParameter = (function() {

        /**
         * Properties of a HSMLocalizableParameter.
         * @memberof proto
         * @interface IHSMLocalizableParameter
         * @property {string|null} ["default"] HSMLocalizableParameter default
         * @property {proto.IHSMCurrency|null} [currency] HSMLocalizableParameter currency
         * @property {proto.IHSMDateTime|null} [dateTime] HSMLocalizableParameter dateTime
         */

        /**
         * Constructs a new HSMLocalizableParameter.
         * @memberof proto
         * @classdesc Represents a HSMLocalizableParameter.
         * @implements IHSMLocalizableParameter
         * @constructor
         * @param {proto.IHSMLocalizableParameter=} [properties] Properties to set
         */
        function HSMLocalizableParameter(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * HSMLocalizableParameter default.
         * @member {string} default
         * @memberof proto.HSMLocalizableParameter
         * @instance
         */
        HSMLocalizableParameter.prototype["default"] = "";

        /**
         * HSMLocalizableParameter currency.
         * @member {proto.IHSMCurrency|null|undefined} currency
         * @memberof proto.HSMLocalizableParameter
         * @instance
         */
        HSMLocalizableParameter.prototype.currency = null;

        /**
         * HSMLocalizableParameter dateTime.
         * @member {proto.IHSMDateTime|null|undefined} dateTime
         * @memberof proto.HSMLocalizableParameter
         * @instance
         */
        HSMLocalizableParameter.prototype.dateTime = null;

        // OneOf field names bound to virtual getters and setters
        var $oneOfFields;

        /**
         * HSMLocalizableParameter paramOneof.
         * @member {"currency"|"dateTime"|undefined} paramOneof
         * @memberof proto.HSMLocalizableParameter
         * @instance
         */
        Object.defineProperty(HSMLocalizableParameter.prototype, "paramOneof", {
            get: $util.oneOfGetter($oneOfFields = ["currency", "dateTime"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new HSMLocalizableParameter instance using the specified properties.
         * @function create
         * @memberof proto.HSMLocalizableParameter
         * @static
         * @param {proto.IHSMLocalizableParameter=} [properties] Properties to set
         * @returns {proto.HSMLocalizableParameter} HSMLocalizableParameter instance
         */
        HSMLocalizableParameter.create = function create(properties) {
            return new HSMLocalizableParameter(properties);
        };

        /**
         * Encodes the specified HSMLocalizableParameter message. Does not implicitly {@link proto.HSMLocalizableParameter.verify|verify} messages.
         * @function encode
         * @memberof proto.HSMLocalizableParameter
         * @static
         * @param {proto.IHSMLocalizableParameter} message HSMLocalizableParameter message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HSMLocalizableParameter.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message["default"] != null && Object.hasOwnProperty.call(message, "default"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message["default"]);
            if (message.currency != null && Object.hasOwnProperty.call(message, "currency"))
                $root.proto.HSMCurrency.encode(message.currency, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.dateTime != null && Object.hasOwnProperty.call(message, "dateTime"))
                $root.proto.HSMDateTime.encode(message.dateTime, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified HSMLocalizableParameter message, length delimited. Does not implicitly {@link proto.HSMLocalizableParameter.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.HSMLocalizableParameter
         * @static
         * @param {proto.IHSMLocalizableParameter} message HSMLocalizableParameter message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HSMLocalizableParameter.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a HSMLocalizableParameter message from the specified reader or buffer.
         * @function decode
         * @memberof proto.HSMLocalizableParameter
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.HSMLocalizableParameter} HSMLocalizableParameter
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HSMLocalizableParameter.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.HSMLocalizableParameter();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message["default"] = reader.string();
                    break;
                case 2:
                    message.currency = $root.proto.HSMCurrency.decode(reader, reader.uint32());
                    break;
                case 3:
                    message.dateTime = $root.proto.HSMDateTime.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a HSMLocalizableParameter message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.HSMLocalizableParameter
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.HSMLocalizableParameter} HSMLocalizableParameter
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HSMLocalizableParameter.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a HSMLocalizableParameter message.
         * @function verify
         * @memberof proto.HSMLocalizableParameter
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        HSMLocalizableParameter.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            var properties = {};
            if (message["default"] != null && message.hasOwnProperty("default"))
                if (!$util.isString(message["default"]))
                    return "default: string expected";
            if (message.currency != null && message.hasOwnProperty("currency")) {
                properties.paramOneof = 1;
                {
                    var error = $root.proto.HSMCurrency.verify(message.currency);
                    if (error)
                        return "currency." + error;
                }
            }
            if (message.dateTime != null && message.hasOwnProperty("dateTime")) {
                if (properties.paramOneof === 1)
                    return "paramOneof: multiple values";
                properties.paramOneof = 1;
                {
                    var error = $root.proto.HSMDateTime.verify(message.dateTime);
                    if (error)
                        return "dateTime." + error;
                }
            }
            return null;
        };

        /**
         * Creates a HSMLocalizableParameter message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.HSMLocalizableParameter
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.HSMLocalizableParameter} HSMLocalizableParameter
         */
        HSMLocalizableParameter.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.HSMLocalizableParameter)
                return object;
            var message = new $root.proto.HSMLocalizableParameter();
            if (object["default"] != null)
                message["default"] = String(object["default"]);
            if (object.currency != null) {
                if (typeof object.currency !== "object")
                    throw TypeError(".proto.HSMLocalizableParameter.currency: object expected");
                message.currency = $root.proto.HSMCurrency.fromObject(object.currency);
            }
            if (object.dateTime != null) {
                if (typeof object.dateTime !== "object")
                    throw TypeError(".proto.HSMLocalizableParameter.dateTime: object expected");
                message.dateTime = $root.proto.HSMDateTime.fromObject(object.dateTime);
            }
            return message;
        };

        /**
         * Creates a plain object from a HSMLocalizableParameter message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.HSMLocalizableParameter
         * @static
         * @param {proto.HSMLocalizableParameter} message HSMLocalizableParameter
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        HSMLocalizableParameter.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object["default"] = "";
            if (message["default"] != null && message.hasOwnProperty("default"))
                object["default"] = message["default"];
            if (message.currency != null && message.hasOwnProperty("currency")) {
                object.currency = $root.proto.HSMCurrency.toObject(message.currency, options);
                if (options.oneofs)
                    object.paramOneof = "currency";
            }
            if (message.dateTime != null && message.hasOwnProperty("dateTime")) {
                object.dateTime = $root.proto.HSMDateTime.toObject(message.dateTime, options);
                if (options.oneofs)
                    object.paramOneof = "dateTime";
            }
            return object;
        };

        /**
         * Converts this HSMLocalizableParameter to JSON.
         * @function toJSON
         * @memberof proto.HSMLocalizableParameter
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        HSMLocalizableParameter.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return HSMLocalizableParameter;
    })();

    proto.HydratedCallButton = (function() {

        /**
         * Properties of a HydratedCallButton.
         * @memberof proto
         * @interface IHydratedCallButton
         * @property {string|null} [displayText] HydratedCallButton displayText
         * @property {string|null} [phoneNumber] HydratedCallButton phoneNumber
         */

        /**
         * Constructs a new HydratedCallButton.
         * @memberof proto
         * @classdesc Represents a HydratedCallButton.
         * @implements IHydratedCallButton
         * @constructor
         * @param {proto.IHydratedCallButton=} [properties] Properties to set
         */
        function HydratedCallButton(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * HydratedCallButton displayText.
         * @member {string} displayText
         * @memberof proto.HydratedCallButton
         * @instance
         */
        HydratedCallButton.prototype.displayText = "";

        /**
         * HydratedCallButton phoneNumber.
         * @member {string} phoneNumber
         * @memberof proto.HydratedCallButton
         * @instance
         */
        HydratedCallButton.prototype.phoneNumber = "";

        /**
         * Creates a new HydratedCallButton instance using the specified properties.
         * @function create
         * @memberof proto.HydratedCallButton
         * @static
         * @param {proto.IHydratedCallButton=} [properties] Properties to set
         * @returns {proto.HydratedCallButton} HydratedCallButton instance
         */
        HydratedCallButton.create = function create(properties) {
            return new HydratedCallButton(properties);
        };

        /**
         * Encodes the specified HydratedCallButton message. Does not implicitly {@link proto.HydratedCallButton.verify|verify} messages.
         * @function encode
         * @memberof proto.HydratedCallButton
         * @static
         * @param {proto.IHydratedCallButton} message HydratedCallButton message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HydratedCallButton.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.displayText != null && Object.hasOwnProperty.call(message, "displayText"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.displayText);
            if (message.phoneNumber != null && Object.hasOwnProperty.call(message, "phoneNumber"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.phoneNumber);
            return writer;
        };

        /**
         * Encodes the specified HydratedCallButton message, length delimited. Does not implicitly {@link proto.HydratedCallButton.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.HydratedCallButton
         * @static
         * @param {proto.IHydratedCallButton} message HydratedCallButton message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HydratedCallButton.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a HydratedCallButton message from the specified reader or buffer.
         * @function decode
         * @memberof proto.HydratedCallButton
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.HydratedCallButton} HydratedCallButton
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HydratedCallButton.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.HydratedCallButton();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.displayText = reader.string();
                    break;
                case 2:
                    message.phoneNumber = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a HydratedCallButton message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.HydratedCallButton
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.HydratedCallButton} HydratedCallButton
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HydratedCallButton.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a HydratedCallButton message.
         * @function verify
         * @memberof proto.HydratedCallButton
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        HydratedCallButton.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.displayText != null && message.hasOwnProperty("displayText"))
                if (!$util.isString(message.displayText))
                    return "displayText: string expected";
            if (message.phoneNumber != null && message.hasOwnProperty("phoneNumber"))
                if (!$util.isString(message.phoneNumber))
                    return "phoneNumber: string expected";
            return null;
        };

        /**
         * Creates a HydratedCallButton message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.HydratedCallButton
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.HydratedCallButton} HydratedCallButton
         */
        HydratedCallButton.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.HydratedCallButton)
                return object;
            var message = new $root.proto.HydratedCallButton();
            if (object.displayText != null)
                message.displayText = String(object.displayText);
            if (object.phoneNumber != null)
                message.phoneNumber = String(object.phoneNumber);
            return message;
        };

        /**
         * Creates a plain object from a HydratedCallButton message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.HydratedCallButton
         * @static
         * @param {proto.HydratedCallButton} message HydratedCallButton
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        HydratedCallButton.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.displayText = "";
                object.phoneNumber = "";
            }
            if (message.displayText != null && message.hasOwnProperty("displayText"))
                object.displayText = message.displayText;
            if (message.phoneNumber != null && message.hasOwnProperty("phoneNumber"))
                object.phoneNumber = message.phoneNumber;
            return object;
        };

        /**
         * Converts this HydratedCallButton to JSON.
         * @function toJSON
         * @memberof proto.HydratedCallButton
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        HydratedCallButton.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return HydratedCallButton;
    })();

    proto.HydratedFourRowTemplate = (function() {

        /**
         * Properties of a HydratedFourRowTemplate.
         * @memberof proto
         * @interface IHydratedFourRowTemplate
         * @property {string|null} [hydratedContentText] HydratedFourRowTemplate hydratedContentText
         * @property {string|null} [hydratedFooterText] HydratedFourRowTemplate hydratedFooterText
         * @property {Array.<proto.IHydratedTemplateButton>|null} [hydratedButtons] HydratedFourRowTemplate hydratedButtons
         * @property {string|null} [templateId] HydratedFourRowTemplate templateId
         * @property {proto.IDocumentMessage|null} [documentMessage] HydratedFourRowTemplate documentMessage
         * @property {string|null} [hydratedTitleText] HydratedFourRowTemplate hydratedTitleText
         * @property {proto.IImageMessage|null} [imageMessage] HydratedFourRowTemplate imageMessage
         * @property {proto.IVideoMessage|null} [videoMessage] HydratedFourRowTemplate videoMessage
         * @property {proto.ILocationMessage|null} [locationMessage] HydratedFourRowTemplate locationMessage
         */

        /**
         * Constructs a new HydratedFourRowTemplate.
         * @memberof proto
         * @classdesc Represents a HydratedFourRowTemplate.
         * @implements IHydratedFourRowTemplate
         * @constructor
         * @param {proto.IHydratedFourRowTemplate=} [properties] Properties to set
         */
        function HydratedFourRowTemplate(properties) {
            this.hydratedButtons = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * HydratedFourRowTemplate hydratedContentText.
         * @member {string} hydratedContentText
         * @memberof proto.HydratedFourRowTemplate
         * @instance
         */
        HydratedFourRowTemplate.prototype.hydratedContentText = "";

        /**
         * HydratedFourRowTemplate hydratedFooterText.
         * @member {string} hydratedFooterText
         * @memberof proto.HydratedFourRowTemplate
         * @instance
         */
        HydratedFourRowTemplate.prototype.hydratedFooterText = "";

        /**
         * HydratedFourRowTemplate hydratedButtons.
         * @member {Array.<proto.IHydratedTemplateButton>} hydratedButtons
         * @memberof proto.HydratedFourRowTemplate
         * @instance
         */
        HydratedFourRowTemplate.prototype.hydratedButtons = $util.emptyArray;

        /**
         * HydratedFourRowTemplate templateId.
         * @member {string} templateId
         * @memberof proto.HydratedFourRowTemplate
         * @instance
         */
        HydratedFourRowTemplate.prototype.templateId = "";

        /**
         * HydratedFourRowTemplate documentMessage.
         * @member {proto.IDocumentMessage|null|undefined} documentMessage
         * @memberof proto.HydratedFourRowTemplate
         * @instance
         */
        HydratedFourRowTemplate.prototype.documentMessage = null;

        /**
         * HydratedFourRowTemplate hydratedTitleText.
         * @member {string|null|undefined} hydratedTitleText
         * @memberof proto.HydratedFourRowTemplate
         * @instance
         */
        HydratedFourRowTemplate.prototype.hydratedTitleText = null;

        /**
         * HydratedFourRowTemplate imageMessage.
         * @member {proto.IImageMessage|null|undefined} imageMessage
         * @memberof proto.HydratedFourRowTemplate
         * @instance
         */
        HydratedFourRowTemplate.prototype.imageMessage = null;

        /**
         * HydratedFourRowTemplate videoMessage.
         * @member {proto.IVideoMessage|null|undefined} videoMessage
         * @memberof proto.HydratedFourRowTemplate
         * @instance
         */
        HydratedFourRowTemplate.prototype.videoMessage = null;

        /**
         * HydratedFourRowTemplate locationMessage.
         * @member {proto.ILocationMessage|null|undefined} locationMessage
         * @memberof proto.HydratedFourRowTemplate
         * @instance
         */
        HydratedFourRowTemplate.prototype.locationMessage = null;

        // OneOf field names bound to virtual getters and setters
        var $oneOfFields;

        /**
         * HydratedFourRowTemplate title.
         * @member {"documentMessage"|"hydratedTitleText"|"imageMessage"|"videoMessage"|"locationMessage"|undefined} title
         * @memberof proto.HydratedFourRowTemplate
         * @instance
         */
        Object.defineProperty(HydratedFourRowTemplate.prototype, "title", {
            get: $util.oneOfGetter($oneOfFields = ["documentMessage", "hydratedTitleText", "imageMessage", "videoMessage", "locationMessage"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new HydratedFourRowTemplate instance using the specified properties.
         * @function create
         * @memberof proto.HydratedFourRowTemplate
         * @static
         * @param {proto.IHydratedFourRowTemplate=} [properties] Properties to set
         * @returns {proto.HydratedFourRowTemplate} HydratedFourRowTemplate instance
         */
        HydratedFourRowTemplate.create = function create(properties) {
            return new HydratedFourRowTemplate(properties);
        };

        /**
         * Encodes the specified HydratedFourRowTemplate message. Does not implicitly {@link proto.HydratedFourRowTemplate.verify|verify} messages.
         * @function encode
         * @memberof proto.HydratedFourRowTemplate
         * @static
         * @param {proto.IHydratedFourRowTemplate} message HydratedFourRowTemplate message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HydratedFourRowTemplate.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.documentMessage != null && Object.hasOwnProperty.call(message, "documentMessage"))
                $root.proto.DocumentMessage.encode(message.documentMessage, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.hydratedTitleText != null && Object.hasOwnProperty.call(message, "hydratedTitleText"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.hydratedTitleText);
            if (message.imageMessage != null && Object.hasOwnProperty.call(message, "imageMessage"))
                $root.proto.ImageMessage.encode(message.imageMessage, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            if (message.videoMessage != null && Object.hasOwnProperty.call(message, "videoMessage"))
                $root.proto.VideoMessage.encode(message.videoMessage, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
            if (message.locationMessage != null && Object.hasOwnProperty.call(message, "locationMessage"))
                $root.proto.LocationMessage.encode(message.locationMessage, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
            if (message.hydratedContentText != null && Object.hasOwnProperty.call(message, "hydratedContentText"))
                writer.uint32(/* id 6, wireType 2 =*/50).string(message.hydratedContentText);
            if (message.hydratedFooterText != null && Object.hasOwnProperty.call(message, "hydratedFooterText"))
                writer.uint32(/* id 7, wireType 2 =*/58).string(message.hydratedFooterText);
            if (message.hydratedButtons != null && message.hydratedButtons.length)
                for (var i = 0; i < message.hydratedButtons.length; ++i)
                    $root.proto.HydratedTemplateButton.encode(message.hydratedButtons[i], writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
            if (message.templateId != null && Object.hasOwnProperty.call(message, "templateId"))
                writer.uint32(/* id 9, wireType 2 =*/74).string(message.templateId);
            return writer;
        };

        /**
         * Encodes the specified HydratedFourRowTemplate message, length delimited. Does not implicitly {@link proto.HydratedFourRowTemplate.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.HydratedFourRowTemplate
         * @static
         * @param {proto.IHydratedFourRowTemplate} message HydratedFourRowTemplate message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HydratedFourRowTemplate.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a HydratedFourRowTemplate message from the specified reader or buffer.
         * @function decode
         * @memberof proto.HydratedFourRowTemplate
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.HydratedFourRowTemplate} HydratedFourRowTemplate
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HydratedFourRowTemplate.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.HydratedFourRowTemplate();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 6:
                    message.hydratedContentText = reader.string();
                    break;
                case 7:
                    message.hydratedFooterText = reader.string();
                    break;
                case 8:
                    if (!(message.hydratedButtons && message.hydratedButtons.length))
                        message.hydratedButtons = [];
                    message.hydratedButtons.push($root.proto.HydratedTemplateButton.decode(reader, reader.uint32()));
                    break;
                case 9:
                    message.templateId = reader.string();
                    break;
                case 1:
                    message.documentMessage = $root.proto.DocumentMessage.decode(reader, reader.uint32());
                    break;
                case 2:
                    message.hydratedTitleText = reader.string();
                    break;
                case 3:
                    message.imageMessage = $root.proto.ImageMessage.decode(reader, reader.uint32());
                    break;
                case 4:
                    message.videoMessage = $root.proto.VideoMessage.decode(reader, reader.uint32());
                    break;
                case 5:
                    message.locationMessage = $root.proto.LocationMessage.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a HydratedFourRowTemplate message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.HydratedFourRowTemplate
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.HydratedFourRowTemplate} HydratedFourRowTemplate
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HydratedFourRowTemplate.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a HydratedFourRowTemplate message.
         * @function verify
         * @memberof proto.HydratedFourRowTemplate
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        HydratedFourRowTemplate.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            var properties = {};
            if (message.hydratedContentText != null && message.hasOwnProperty("hydratedContentText"))
                if (!$util.isString(message.hydratedContentText))
                    return "hydratedContentText: string expected";
            if (message.hydratedFooterText != null && message.hasOwnProperty("hydratedFooterText"))
                if (!$util.isString(message.hydratedFooterText))
                    return "hydratedFooterText: string expected";
            if (message.hydratedButtons != null && message.hasOwnProperty("hydratedButtons")) {
                if (!Array.isArray(message.hydratedButtons))
                    return "hydratedButtons: array expected";
                for (var i = 0; i < message.hydratedButtons.length; ++i) {
                    var error = $root.proto.HydratedTemplateButton.verify(message.hydratedButtons[i]);
                    if (error)
                        return "hydratedButtons." + error;
                }
            }
            if (message.templateId != null && message.hasOwnProperty("templateId"))
                if (!$util.isString(message.templateId))
                    return "templateId: string expected";
            if (message.documentMessage != null && message.hasOwnProperty("documentMessage")) {
                properties.title = 1;
                {
                    var error = $root.proto.DocumentMessage.verify(message.documentMessage);
                    if (error)
                        return "documentMessage." + error;
                }
            }
            if (message.hydratedTitleText != null && message.hasOwnProperty("hydratedTitleText")) {
                if (properties.title === 1)
                    return "title: multiple values";
                properties.title = 1;
                if (!$util.isString(message.hydratedTitleText))
                    return "hydratedTitleText: string expected";
            }
            if (message.imageMessage != null && message.hasOwnProperty("imageMessage")) {
                if (properties.title === 1)
                    return "title: multiple values";
                properties.title = 1;
                {
                    var error = $root.proto.ImageMessage.verify(message.imageMessage);
                    if (error)
                        return "imageMessage." + error;
                }
            }
            if (message.videoMessage != null && message.hasOwnProperty("videoMessage")) {
                if (properties.title === 1)
                    return "title: multiple values";
                properties.title = 1;
                {
                    var error = $root.proto.VideoMessage.verify(message.videoMessage);
                    if (error)
                        return "videoMessage." + error;
                }
            }
            if (message.locationMessage != null && message.hasOwnProperty("locationMessage")) {
                if (properties.title === 1)
                    return "title: multiple values";
                properties.title = 1;
                {
                    var error = $root.proto.LocationMessage.verify(message.locationMessage);
                    if (error)
                        return "locationMessage." + error;
                }
            }
            return null;
        };

        /**
         * Creates a HydratedFourRowTemplate message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.HydratedFourRowTemplate
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.HydratedFourRowTemplate} HydratedFourRowTemplate
         */
        HydratedFourRowTemplate.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.HydratedFourRowTemplate)
                return object;
            var message = new $root.proto.HydratedFourRowTemplate();
            if (object.hydratedContentText != null)
                message.hydratedContentText = String(object.hydratedContentText);
            if (object.hydratedFooterText != null)
                message.hydratedFooterText = String(object.hydratedFooterText);
            if (object.hydratedButtons) {
                if (!Array.isArray(object.hydratedButtons))
                    throw TypeError(".proto.HydratedFourRowTemplate.hydratedButtons: array expected");
                message.hydratedButtons = [];
                for (var i = 0; i < object.hydratedButtons.length; ++i) {
                    if (typeof object.hydratedButtons[i] !== "object")
                        throw TypeError(".proto.HydratedFourRowTemplate.hydratedButtons: object expected");
                    message.hydratedButtons[i] = $root.proto.HydratedTemplateButton.fromObject(object.hydratedButtons[i]);
                }
            }
            if (object.templateId != null)
                message.templateId = String(object.templateId);
            if (object.documentMessage != null) {
                if (typeof object.documentMessage !== "object")
                    throw TypeError(".proto.HydratedFourRowTemplate.documentMessage: object expected");
                message.documentMessage = $root.proto.DocumentMessage.fromObject(object.documentMessage);
            }
            if (object.hydratedTitleText != null)
                message.hydratedTitleText = String(object.hydratedTitleText);
            if (object.imageMessage != null) {
                if (typeof object.imageMessage !== "object")
                    throw TypeError(".proto.HydratedFourRowTemplate.imageMessage: object expected");
                message.imageMessage = $root.proto.ImageMessage.fromObject(object.imageMessage);
            }
            if (object.videoMessage != null) {
                if (typeof object.videoMessage !== "object")
                    throw TypeError(".proto.HydratedFourRowTemplate.videoMessage: object expected");
                message.videoMessage = $root.proto.VideoMessage.fromObject(object.videoMessage);
            }
            if (object.locationMessage != null) {
                if (typeof object.locationMessage !== "object")
                    throw TypeError(".proto.HydratedFourRowTemplate.locationMessage: object expected");
                message.locationMessage = $root.proto.LocationMessage.fromObject(object.locationMessage);
            }
            return message;
        };

        /**
         * Creates a plain object from a HydratedFourRowTemplate message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.HydratedFourRowTemplate
         * @static
         * @param {proto.HydratedFourRowTemplate} message HydratedFourRowTemplate
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        HydratedFourRowTemplate.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.hydratedButtons = [];
            if (options.defaults) {
                object.hydratedContentText = "";
                object.hydratedFooterText = "";
                object.templateId = "";
            }
            if (message.documentMessage != null && message.hasOwnProperty("documentMessage")) {
                object.documentMessage = $root.proto.DocumentMessage.toObject(message.documentMessage, options);
                if (options.oneofs)
                    object.title = "documentMessage";
            }
            if (message.hydratedTitleText != null && message.hasOwnProperty("hydratedTitleText")) {
                object.hydratedTitleText = message.hydratedTitleText;
                if (options.oneofs)
                    object.title = "hydratedTitleText";
            }
            if (message.imageMessage != null && message.hasOwnProperty("imageMessage")) {
                object.imageMessage = $root.proto.ImageMessage.toObject(message.imageMessage, options);
                if (options.oneofs)
                    object.title = "imageMessage";
            }
            if (message.videoMessage != null && message.hasOwnProperty("videoMessage")) {
                object.videoMessage = $root.proto.VideoMessage.toObject(message.videoMessage, options);
                if (options.oneofs)
                    object.title = "videoMessage";
            }
            if (message.locationMessage != null && message.hasOwnProperty("locationMessage")) {
                object.locationMessage = $root.proto.LocationMessage.toObject(message.locationMessage, options);
                if (options.oneofs)
                    object.title = "locationMessage";
            }
            if (message.hydratedContentText != null && message.hasOwnProperty("hydratedContentText"))
                object.hydratedContentText = message.hydratedContentText;
            if (message.hydratedFooterText != null && message.hasOwnProperty("hydratedFooterText"))
                object.hydratedFooterText = message.hydratedFooterText;
            if (message.hydratedButtons && message.hydratedButtons.length) {
                object.hydratedButtons = [];
                for (var j = 0; j < message.hydratedButtons.length; ++j)
                    object.hydratedButtons[j] = $root.proto.HydratedTemplateButton.toObject(message.hydratedButtons[j], options);
            }
            if (message.templateId != null && message.hasOwnProperty("templateId"))
                object.templateId = message.templateId;
            return object;
        };

        /**
         * Converts this HydratedFourRowTemplate to JSON.
         * @function toJSON
         * @memberof proto.HydratedFourRowTemplate
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        HydratedFourRowTemplate.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return HydratedFourRowTemplate;
    })();

    proto.HydratedQuickReplyButton = (function() {

        /**
         * Properties of a HydratedQuickReplyButton.
         * @memberof proto
         * @interface IHydratedQuickReplyButton
         * @property {string|null} [displayText] HydratedQuickReplyButton displayText
         * @property {string|null} [id] HydratedQuickReplyButton id
         */

        /**
         * Constructs a new HydratedQuickReplyButton.
         * @memberof proto
         * @classdesc Represents a HydratedQuickReplyButton.
         * @implements IHydratedQuickReplyButton
         * @constructor
         * @param {proto.IHydratedQuickReplyButton=} [properties] Properties to set
         */
        function HydratedQuickReplyButton(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * HydratedQuickReplyButton displayText.
         * @member {string} displayText
         * @memberof proto.HydratedQuickReplyButton
         * @instance
         */
        HydratedQuickReplyButton.prototype.displayText = "";

        /**
         * HydratedQuickReplyButton id.
         * @member {string} id
         * @memberof proto.HydratedQuickReplyButton
         * @instance
         */
        HydratedQuickReplyButton.prototype.id = "";

        /**
         * Creates a new HydratedQuickReplyButton instance using the specified properties.
         * @function create
         * @memberof proto.HydratedQuickReplyButton
         * @static
         * @param {proto.IHydratedQuickReplyButton=} [properties] Properties to set
         * @returns {proto.HydratedQuickReplyButton} HydratedQuickReplyButton instance
         */
        HydratedQuickReplyButton.create = function create(properties) {
            return new HydratedQuickReplyButton(properties);
        };

        /**
         * Encodes the specified HydratedQuickReplyButton message. Does not implicitly {@link proto.HydratedQuickReplyButton.verify|verify} messages.
         * @function encode
         * @memberof proto.HydratedQuickReplyButton
         * @static
         * @param {proto.IHydratedQuickReplyButton} message HydratedQuickReplyButton message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HydratedQuickReplyButton.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.displayText != null && Object.hasOwnProperty.call(message, "displayText"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.displayText);
            if (message.id != null && Object.hasOwnProperty.call(message, "id"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.id);
            return writer;
        };

        /**
         * Encodes the specified HydratedQuickReplyButton message, length delimited. Does not implicitly {@link proto.HydratedQuickReplyButton.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.HydratedQuickReplyButton
         * @static
         * @param {proto.IHydratedQuickReplyButton} message HydratedQuickReplyButton message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HydratedQuickReplyButton.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a HydratedQuickReplyButton message from the specified reader or buffer.
         * @function decode
         * @memberof proto.HydratedQuickReplyButton
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.HydratedQuickReplyButton} HydratedQuickReplyButton
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HydratedQuickReplyButton.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.HydratedQuickReplyButton();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.displayText = reader.string();
                    break;
                case 2:
                    message.id = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a HydratedQuickReplyButton message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.HydratedQuickReplyButton
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.HydratedQuickReplyButton} HydratedQuickReplyButton
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HydratedQuickReplyButton.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a HydratedQuickReplyButton message.
         * @function verify
         * @memberof proto.HydratedQuickReplyButton
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        HydratedQuickReplyButton.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.displayText != null && message.hasOwnProperty("displayText"))
                if (!$util.isString(message.displayText))
                    return "displayText: string expected";
            if (message.id != null && message.hasOwnProperty("id"))
                if (!$util.isString(message.id))
                    return "id: string expected";
            return null;
        };

        /**
         * Creates a HydratedQuickReplyButton message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.HydratedQuickReplyButton
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.HydratedQuickReplyButton} HydratedQuickReplyButton
         */
        HydratedQuickReplyButton.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.HydratedQuickReplyButton)
                return object;
            var message = new $root.proto.HydratedQuickReplyButton();
            if (object.displayText != null)
                message.displayText = String(object.displayText);
            if (object.id != null)
                message.id = String(object.id);
            return message;
        };

        /**
         * Creates a plain object from a HydratedQuickReplyButton message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.HydratedQuickReplyButton
         * @static
         * @param {proto.HydratedQuickReplyButton} message HydratedQuickReplyButton
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        HydratedQuickReplyButton.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.displayText = "";
                object.id = "";
            }
            if (message.displayText != null && message.hasOwnProperty("displayText"))
                object.displayText = message.displayText;
            if (message.id != null && message.hasOwnProperty("id"))
                object.id = message.id;
            return object;
        };

        /**
         * Converts this HydratedQuickReplyButton to JSON.
         * @function toJSON
         * @memberof proto.HydratedQuickReplyButton
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        HydratedQuickReplyButton.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return HydratedQuickReplyButton;
    })();

    proto.HydratedTemplateButton = (function() {

        /**
         * Properties of a HydratedTemplateButton.
         * @memberof proto
         * @interface IHydratedTemplateButton
         * @property {number|null} [index] HydratedTemplateButton index
         * @property {proto.IHydratedQuickReplyButton|null} [quickReplyButton] HydratedTemplateButton quickReplyButton
         * @property {proto.IHydratedURLButton|null} [urlButton] HydratedTemplateButton urlButton
         * @property {proto.IHydratedCallButton|null} [callButton] HydratedTemplateButton callButton
         */

        /**
         * Constructs a new HydratedTemplateButton.
         * @memberof proto
         * @classdesc Represents a HydratedTemplateButton.
         * @implements IHydratedTemplateButton
         * @constructor
         * @param {proto.IHydratedTemplateButton=} [properties] Properties to set
         */
        function HydratedTemplateButton(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * HydratedTemplateButton index.
         * @member {number} index
         * @memberof proto.HydratedTemplateButton
         * @instance
         */
        HydratedTemplateButton.prototype.index = 0;

        /**
         * HydratedTemplateButton quickReplyButton.
         * @member {proto.IHydratedQuickReplyButton|null|undefined} quickReplyButton
         * @memberof proto.HydratedTemplateButton
         * @instance
         */
        HydratedTemplateButton.prototype.quickReplyButton = null;

        /**
         * HydratedTemplateButton urlButton.
         * @member {proto.IHydratedURLButton|null|undefined} urlButton
         * @memberof proto.HydratedTemplateButton
         * @instance
         */
        HydratedTemplateButton.prototype.urlButton = null;

        /**
         * HydratedTemplateButton callButton.
         * @member {proto.IHydratedCallButton|null|undefined} callButton
         * @memberof proto.HydratedTemplateButton
         * @instance
         */
        HydratedTemplateButton.prototype.callButton = null;

        // OneOf field names bound to virtual getters and setters
        var $oneOfFields;

        /**
         * HydratedTemplateButton hydratedButton.
         * @member {"quickReplyButton"|"urlButton"|"callButton"|undefined} hydratedButton
         * @memberof proto.HydratedTemplateButton
         * @instance
         */
        Object.defineProperty(HydratedTemplateButton.prototype, "hydratedButton", {
            get: $util.oneOfGetter($oneOfFields = ["quickReplyButton", "urlButton", "callButton"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new HydratedTemplateButton instance using the specified properties.
         * @function create
         * @memberof proto.HydratedTemplateButton
         * @static
         * @param {proto.IHydratedTemplateButton=} [properties] Properties to set
         * @returns {proto.HydratedTemplateButton} HydratedTemplateButton instance
         */
        HydratedTemplateButton.create = function create(properties) {
            return new HydratedTemplateButton(properties);
        };

        /**
         * Encodes the specified HydratedTemplateButton message. Does not implicitly {@link proto.HydratedTemplateButton.verify|verify} messages.
         * @function encode
         * @memberof proto.HydratedTemplateButton
         * @static
         * @param {proto.IHydratedTemplateButton} message HydratedTemplateButton message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HydratedTemplateButton.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.quickReplyButton != null && Object.hasOwnProperty.call(message, "quickReplyButton"))
                $root.proto.HydratedQuickReplyButton.encode(message.quickReplyButton, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.urlButton != null && Object.hasOwnProperty.call(message, "urlButton"))
                $root.proto.HydratedURLButton.encode(message.urlButton, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.callButton != null && Object.hasOwnProperty.call(message, "callButton"))
                $root.proto.HydratedCallButton.encode(message.callButton, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            if (message.index != null && Object.hasOwnProperty.call(message, "index"))
                writer.uint32(/* id 4, wireType 0 =*/32).uint32(message.index);
            return writer;
        };

        /**
         * Encodes the specified HydratedTemplateButton message, length delimited. Does not implicitly {@link proto.HydratedTemplateButton.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.HydratedTemplateButton
         * @static
         * @param {proto.IHydratedTemplateButton} message HydratedTemplateButton message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HydratedTemplateButton.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a HydratedTemplateButton message from the specified reader or buffer.
         * @function decode
         * @memberof proto.HydratedTemplateButton
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.HydratedTemplateButton} HydratedTemplateButton
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HydratedTemplateButton.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.HydratedTemplateButton();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 4:
                    message.index = reader.uint32();
                    break;
                case 1:
                    message.quickReplyButton = $root.proto.HydratedQuickReplyButton.decode(reader, reader.uint32());
                    break;
                case 2:
                    message.urlButton = $root.proto.HydratedURLButton.decode(reader, reader.uint32());
                    break;
                case 3:
                    message.callButton = $root.proto.HydratedCallButton.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a HydratedTemplateButton message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.HydratedTemplateButton
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.HydratedTemplateButton} HydratedTemplateButton
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HydratedTemplateButton.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a HydratedTemplateButton message.
         * @function verify
         * @memberof proto.HydratedTemplateButton
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        HydratedTemplateButton.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            var properties = {};
            if (message.index != null && message.hasOwnProperty("index"))
                if (!$util.isInteger(message.index))
                    return "index: integer expected";
            if (message.quickReplyButton != null && message.hasOwnProperty("quickReplyButton")) {
                properties.hydratedButton = 1;
                {
                    var error = $root.proto.HydratedQuickReplyButton.verify(message.quickReplyButton);
                    if (error)
                        return "quickReplyButton." + error;
                }
            }
            if (message.urlButton != null && message.hasOwnProperty("urlButton")) {
                if (properties.hydratedButton === 1)
                    return "hydratedButton: multiple values";
                properties.hydratedButton = 1;
                {
                    var error = $root.proto.HydratedURLButton.verify(message.urlButton);
                    if (error)
                        return "urlButton." + error;
                }
            }
            if (message.callButton != null && message.hasOwnProperty("callButton")) {
                if (properties.hydratedButton === 1)
                    return "hydratedButton: multiple values";
                properties.hydratedButton = 1;
                {
                    var error = $root.proto.HydratedCallButton.verify(message.callButton);
                    if (error)
                        return "callButton." + error;
                }
            }
            return null;
        };

        /**
         * Creates a HydratedTemplateButton message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.HydratedTemplateButton
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.HydratedTemplateButton} HydratedTemplateButton
         */
        HydratedTemplateButton.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.HydratedTemplateButton)
                return object;
            var message = new $root.proto.HydratedTemplateButton();
            if (object.index != null)
                message.index = object.index >>> 0;
            if (object.quickReplyButton != null) {
                if (typeof object.quickReplyButton !== "object")
                    throw TypeError(".proto.HydratedTemplateButton.quickReplyButton: object expected");
                message.quickReplyButton = $root.proto.HydratedQuickReplyButton.fromObject(object.quickReplyButton);
            }
            if (object.urlButton != null) {
                if (typeof object.urlButton !== "object")
                    throw TypeError(".proto.HydratedTemplateButton.urlButton: object expected");
                message.urlButton = $root.proto.HydratedURLButton.fromObject(object.urlButton);
            }
            if (object.callButton != null) {
                if (typeof object.callButton !== "object")
                    throw TypeError(".proto.HydratedTemplateButton.callButton: object expected");
                message.callButton = $root.proto.HydratedCallButton.fromObject(object.callButton);
            }
            return message;
        };

        /**
         * Creates a plain object from a HydratedTemplateButton message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.HydratedTemplateButton
         * @static
         * @param {proto.HydratedTemplateButton} message HydratedTemplateButton
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        HydratedTemplateButton.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.index = 0;
            if (message.quickReplyButton != null && message.hasOwnProperty("quickReplyButton")) {
                object.quickReplyButton = $root.proto.HydratedQuickReplyButton.toObject(message.quickReplyButton, options);
                if (options.oneofs)
                    object.hydratedButton = "quickReplyButton";
            }
            if (message.urlButton != null && message.hasOwnProperty("urlButton")) {
                object.urlButton = $root.proto.HydratedURLButton.toObject(message.urlButton, options);
                if (options.oneofs)
                    object.hydratedButton = "urlButton";
            }
            if (message.callButton != null && message.hasOwnProperty("callButton")) {
                object.callButton = $root.proto.HydratedCallButton.toObject(message.callButton, options);
                if (options.oneofs)
                    object.hydratedButton = "callButton";
            }
            if (message.index != null && message.hasOwnProperty("index"))
                object.index = message.index;
            return object;
        };

        /**
         * Converts this HydratedTemplateButton to JSON.
         * @function toJSON
         * @memberof proto.HydratedTemplateButton
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        HydratedTemplateButton.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return HydratedTemplateButton;
    })();

    proto.HydratedURLButton = (function() {

        /**
         * Properties of a HydratedURLButton.
         * @memberof proto
         * @interface IHydratedURLButton
         * @property {string|null} [displayText] HydratedURLButton displayText
         * @property {string|null} [url] HydratedURLButton url
         */

        /**
         * Constructs a new HydratedURLButton.
         * @memberof proto
         * @classdesc Represents a HydratedURLButton.
         * @implements IHydratedURLButton
         * @constructor
         * @param {proto.IHydratedURLButton=} [properties] Properties to set
         */
        function HydratedURLButton(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * HydratedURLButton displayText.
         * @member {string} displayText
         * @memberof proto.HydratedURLButton
         * @instance
         */
        HydratedURLButton.prototype.displayText = "";

        /**
         * HydratedURLButton url.
         * @member {string} url
         * @memberof proto.HydratedURLButton
         * @instance
         */
        HydratedURLButton.prototype.url = "";

        /**
         * Creates a new HydratedURLButton instance using the specified properties.
         * @function create
         * @memberof proto.HydratedURLButton
         * @static
         * @param {proto.IHydratedURLButton=} [properties] Properties to set
         * @returns {proto.HydratedURLButton} HydratedURLButton instance
         */
        HydratedURLButton.create = function create(properties) {
            return new HydratedURLButton(properties);
        };

        /**
         * Encodes the specified HydratedURLButton message. Does not implicitly {@link proto.HydratedURLButton.verify|verify} messages.
         * @function encode
         * @memberof proto.HydratedURLButton
         * @static
         * @param {proto.IHydratedURLButton} message HydratedURLButton message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HydratedURLButton.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.displayText != null && Object.hasOwnProperty.call(message, "displayText"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.displayText);
            if (message.url != null && Object.hasOwnProperty.call(message, "url"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.url);
            return writer;
        };

        /**
         * Encodes the specified HydratedURLButton message, length delimited. Does not implicitly {@link proto.HydratedURLButton.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.HydratedURLButton
         * @static
         * @param {proto.IHydratedURLButton} message HydratedURLButton message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HydratedURLButton.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a HydratedURLButton message from the specified reader or buffer.
         * @function decode
         * @memberof proto.HydratedURLButton
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.HydratedURLButton} HydratedURLButton
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HydratedURLButton.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.HydratedURLButton();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.displayText = reader.string();
                    break;
                case 2:
                    message.url = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a HydratedURLButton message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.HydratedURLButton
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.HydratedURLButton} HydratedURLButton
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HydratedURLButton.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a HydratedURLButton message.
         * @function verify
         * @memberof proto.HydratedURLButton
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        HydratedURLButton.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.displayText != null && message.hasOwnProperty("displayText"))
                if (!$util.isString(message.displayText))
                    return "displayText: string expected";
            if (message.url != null && message.hasOwnProperty("url"))
                if (!$util.isString(message.url))
                    return "url: string expected";
            return null;
        };

        /**
         * Creates a HydratedURLButton message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.HydratedURLButton
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.HydratedURLButton} HydratedURLButton
         */
        HydratedURLButton.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.HydratedURLButton)
                return object;
            var message = new $root.proto.HydratedURLButton();
            if (object.displayText != null)
                message.displayText = String(object.displayText);
            if (object.url != null)
                message.url = String(object.url);
            return message;
        };

        /**
         * Creates a plain object from a HydratedURLButton message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.HydratedURLButton
         * @static
         * @param {proto.HydratedURLButton} message HydratedURLButton
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        HydratedURLButton.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.displayText = "";
                object.url = "";
            }
            if (message.displayText != null && message.hasOwnProperty("displayText"))
                object.displayText = message.displayText;
            if (message.url != null && message.hasOwnProperty("url"))
                object.url = message.url;
            return object;
        };

        /**
         * Converts this HydratedURLButton to JSON.
         * @function toJSON
         * @memberof proto.HydratedURLButton
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        HydratedURLButton.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return HydratedURLButton;
    })();

    proto.ImageMessage = (function() {

        /**
         * Properties of an ImageMessage.
         * @memberof proto
         * @interface IImageMessage
         * @property {string|null} [url] ImageMessage url
         * @property {string|null} [mimetype] ImageMessage mimetype
         * @property {string|null} [caption] ImageMessage caption
         * @property {Uint8Array|null} [fileSha256] ImageMessage fileSha256
         * @property {number|Long|null} [fileLength] ImageMessage fileLength
         * @property {number|null} [height] ImageMessage height
         * @property {number|null} [width] ImageMessage width
         * @property {Uint8Array|null} [mediaKey] ImageMessage mediaKey
         * @property {Uint8Array|null} [fileEncSha256] ImageMessage fileEncSha256
         * @property {Array.<proto.IInteractiveAnnotation>|null} [interactiveAnnotations] ImageMessage interactiveAnnotations
         * @property {string|null} [directPath] ImageMessage directPath
         * @property {number|Long|null} [mediaKeyTimestamp] ImageMessage mediaKeyTimestamp
         * @property {Uint8Array|null} [jpegThumbnail] ImageMessage jpegThumbnail
         * @property {proto.IContextInfo|null} [contextInfo] ImageMessage contextInfo
         * @property {Uint8Array|null} [firstScanSidecar] ImageMessage firstScanSidecar
         * @property {number|null} [firstScanLength] ImageMessage firstScanLength
         * @property {number|null} [experimentGroupId] ImageMessage experimentGroupId
         * @property {Uint8Array|null} [scansSidecar] ImageMessage scansSidecar
         * @property {Array.<number>|null} [scanLengths] ImageMessage scanLengths
         * @property {Uint8Array|null} [midQualityFileSha256] ImageMessage midQualityFileSha256
         * @property {Uint8Array|null} [midQualityFileEncSha256] ImageMessage midQualityFileEncSha256
         * @property {boolean|null} [viewOnce] ImageMessage viewOnce
         * @property {string|null} [thumbnailDirectPath] ImageMessage thumbnailDirectPath
         * @property {Uint8Array|null} [thumbnailSha256] ImageMessage thumbnailSha256
         * @property {Uint8Array|null} [thumbnailEncSha256] ImageMessage thumbnailEncSha256
         * @property {string|null} [staticUrl] ImageMessage staticUrl
         */

        /**
         * Constructs a new ImageMessage.
         * @memberof proto
         * @classdesc Represents an ImageMessage.
         * @implements IImageMessage
         * @constructor
         * @param {proto.IImageMessage=} [properties] Properties to set
         */
        function ImageMessage(properties) {
            this.interactiveAnnotations = [];
            this.scanLengths = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ImageMessage url.
         * @member {string} url
         * @memberof proto.ImageMessage
         * @instance
         */
        ImageMessage.prototype.url = "";

        /**
         * ImageMessage mimetype.
         * @member {string} mimetype
         * @memberof proto.ImageMessage
         * @instance
         */
        ImageMessage.prototype.mimetype = "";

        /**
         * ImageMessage caption.
         * @member {string} caption
         * @memberof proto.ImageMessage
         * @instance
         */
        ImageMessage.prototype.caption = "";

        /**
         * ImageMessage fileSha256.
         * @member {Uint8Array} fileSha256
         * @memberof proto.ImageMessage
         * @instance
         */
        ImageMessage.prototype.fileSha256 = $util.newBuffer([]);

        /**
         * ImageMessage fileLength.
         * @member {number|Long} fileLength
         * @memberof proto.ImageMessage
         * @instance
         */
        ImageMessage.prototype.fileLength = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * ImageMessage height.
         * @member {number} height
         * @memberof proto.ImageMessage
         * @instance
         */
        ImageMessage.prototype.height = 0;

        /**
         * ImageMessage width.
         * @member {number} width
         * @memberof proto.ImageMessage
         * @instance
         */
        ImageMessage.prototype.width = 0;

        /**
         * ImageMessage mediaKey.
         * @member {Uint8Array} mediaKey
         * @memberof proto.ImageMessage
         * @instance
         */
        ImageMessage.prototype.mediaKey = $util.newBuffer([]);

        /**
         * ImageMessage fileEncSha256.
         * @member {Uint8Array} fileEncSha256
         * @memberof proto.ImageMessage
         * @instance
         */
        ImageMessage.prototype.fileEncSha256 = $util.newBuffer([]);

        /**
         * ImageMessage interactiveAnnotations.
         * @member {Array.<proto.IInteractiveAnnotation>} interactiveAnnotations
         * @memberof proto.ImageMessage
         * @instance
         */
        ImageMessage.prototype.interactiveAnnotations = $util.emptyArray;

        /**
         * ImageMessage directPath.
         * @member {string} directPath
         * @memberof proto.ImageMessage
         * @instance
         */
        ImageMessage.prototype.directPath = "";

        /**
         * ImageMessage mediaKeyTimestamp.
         * @member {number|Long} mediaKeyTimestamp
         * @memberof proto.ImageMessage
         * @instance
         */
        ImageMessage.prototype.mediaKeyTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * ImageMessage jpegThumbnail.
         * @member {Uint8Array} jpegThumbnail
         * @memberof proto.ImageMessage
         * @instance
         */
        ImageMessage.prototype.jpegThumbnail = $util.newBuffer([]);

        /**
         * ImageMessage contextInfo.
         * @member {proto.IContextInfo|null|undefined} contextInfo
         * @memberof proto.ImageMessage
         * @instance
         */
        ImageMessage.prototype.contextInfo = null;

        /**
         * ImageMessage firstScanSidecar.
         * @member {Uint8Array} firstScanSidecar
         * @memberof proto.ImageMessage
         * @instance
         */
        ImageMessage.prototype.firstScanSidecar = $util.newBuffer([]);

        /**
         * ImageMessage firstScanLength.
         * @member {number} firstScanLength
         * @memberof proto.ImageMessage
         * @instance
         */
        ImageMessage.prototype.firstScanLength = 0;

        /**
         * ImageMessage experimentGroupId.
         * @member {number} experimentGroupId
         * @memberof proto.ImageMessage
         * @instance
         */
        ImageMessage.prototype.experimentGroupId = 0;

        /**
         * ImageMessage scansSidecar.
         * @member {Uint8Array} scansSidecar
         * @memberof proto.ImageMessage
         * @instance
         */
        ImageMessage.prototype.scansSidecar = $util.newBuffer([]);

        /**
         * ImageMessage scanLengths.
         * @member {Array.<number>} scanLengths
         * @memberof proto.ImageMessage
         * @instance
         */
        ImageMessage.prototype.scanLengths = $util.emptyArray;

        /**
         * ImageMessage midQualityFileSha256.
         * @member {Uint8Array} midQualityFileSha256
         * @memberof proto.ImageMessage
         * @instance
         */
        ImageMessage.prototype.midQualityFileSha256 = $util.newBuffer([]);

        /**
         * ImageMessage midQualityFileEncSha256.
         * @member {Uint8Array} midQualityFileEncSha256
         * @memberof proto.ImageMessage
         * @instance
         */
        ImageMessage.prototype.midQualityFileEncSha256 = $util.newBuffer([]);

        /**
         * ImageMessage viewOnce.
         * @member {boolean} viewOnce
         * @memberof proto.ImageMessage
         * @instance
         */
        ImageMessage.prototype.viewOnce = false;

        /**
         * ImageMessage thumbnailDirectPath.
         * @member {string} thumbnailDirectPath
         * @memberof proto.ImageMessage
         * @instance
         */
        ImageMessage.prototype.thumbnailDirectPath = "";

        /**
         * ImageMessage thumbnailSha256.
         * @member {Uint8Array} thumbnailSha256
         * @memberof proto.ImageMessage
         * @instance
         */
        ImageMessage.prototype.thumbnailSha256 = $util.newBuffer([]);

        /**
         * ImageMessage thumbnailEncSha256.
         * @member {Uint8Array} thumbnailEncSha256
         * @memberof proto.ImageMessage
         * @instance
         */
        ImageMessage.prototype.thumbnailEncSha256 = $util.newBuffer([]);

        /**
         * ImageMessage staticUrl.
         * @member {string} staticUrl
         * @memberof proto.ImageMessage
         * @instance
         */
        ImageMessage.prototype.staticUrl = "";

        /**
         * Creates a new ImageMessage instance using the specified properties.
         * @function create
         * @memberof proto.ImageMessage
         * @static
         * @param {proto.IImageMessage=} [properties] Properties to set
         * @returns {proto.ImageMessage} ImageMessage instance
         */
        ImageMessage.create = function create(properties) {
            return new ImageMessage(properties);
        };

        /**
         * Encodes the specified ImageMessage message. Does not implicitly {@link proto.ImageMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.ImageMessage
         * @static
         * @param {proto.IImageMessage} message ImageMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ImageMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.url != null && Object.hasOwnProperty.call(message, "url"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.url);
            if (message.mimetype != null && Object.hasOwnProperty.call(message, "mimetype"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.mimetype);
            if (message.caption != null && Object.hasOwnProperty.call(message, "caption"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.caption);
            if (message.fileSha256 != null && Object.hasOwnProperty.call(message, "fileSha256"))
                writer.uint32(/* id 4, wireType 2 =*/34).bytes(message.fileSha256);
            if (message.fileLength != null && Object.hasOwnProperty.call(message, "fileLength"))
                writer.uint32(/* id 5, wireType 0 =*/40).uint64(message.fileLength);
            if (message.height != null && Object.hasOwnProperty.call(message, "height"))
                writer.uint32(/* id 6, wireType 0 =*/48).uint32(message.height);
            if (message.width != null && Object.hasOwnProperty.call(message, "width"))
                writer.uint32(/* id 7, wireType 0 =*/56).uint32(message.width);
            if (message.mediaKey != null && Object.hasOwnProperty.call(message, "mediaKey"))
                writer.uint32(/* id 8, wireType 2 =*/66).bytes(message.mediaKey);
            if (message.fileEncSha256 != null && Object.hasOwnProperty.call(message, "fileEncSha256"))
                writer.uint32(/* id 9, wireType 2 =*/74).bytes(message.fileEncSha256);
            if (message.interactiveAnnotations != null && message.interactiveAnnotations.length)
                for (var i = 0; i < message.interactiveAnnotations.length; ++i)
                    $root.proto.InteractiveAnnotation.encode(message.interactiveAnnotations[i], writer.uint32(/* id 10, wireType 2 =*/82).fork()).ldelim();
            if (message.directPath != null && Object.hasOwnProperty.call(message, "directPath"))
                writer.uint32(/* id 11, wireType 2 =*/90).string(message.directPath);
            if (message.mediaKeyTimestamp != null && Object.hasOwnProperty.call(message, "mediaKeyTimestamp"))
                writer.uint32(/* id 12, wireType 0 =*/96).int64(message.mediaKeyTimestamp);
            if (message.jpegThumbnail != null && Object.hasOwnProperty.call(message, "jpegThumbnail"))
                writer.uint32(/* id 16, wireType 2 =*/130).bytes(message.jpegThumbnail);
            if (message.contextInfo != null && Object.hasOwnProperty.call(message, "contextInfo"))
                $root.proto.ContextInfo.encode(message.contextInfo, writer.uint32(/* id 17, wireType 2 =*/138).fork()).ldelim();
            if (message.firstScanSidecar != null && Object.hasOwnProperty.call(message, "firstScanSidecar"))
                writer.uint32(/* id 18, wireType 2 =*/146).bytes(message.firstScanSidecar);
            if (message.firstScanLength != null && Object.hasOwnProperty.call(message, "firstScanLength"))
                writer.uint32(/* id 19, wireType 0 =*/152).uint32(message.firstScanLength);
            if (message.experimentGroupId != null && Object.hasOwnProperty.call(message, "experimentGroupId"))
                writer.uint32(/* id 20, wireType 0 =*/160).uint32(message.experimentGroupId);
            if (message.scansSidecar != null && Object.hasOwnProperty.call(message, "scansSidecar"))
                writer.uint32(/* id 21, wireType 2 =*/170).bytes(message.scansSidecar);
            if (message.scanLengths != null && message.scanLengths.length)
                for (var i = 0; i < message.scanLengths.length; ++i)
                    writer.uint32(/* id 22, wireType 0 =*/176).uint32(message.scanLengths[i]);
            if (message.midQualityFileSha256 != null && Object.hasOwnProperty.call(message, "midQualityFileSha256"))
                writer.uint32(/* id 23, wireType 2 =*/186).bytes(message.midQualityFileSha256);
            if (message.midQualityFileEncSha256 != null && Object.hasOwnProperty.call(message, "midQualityFileEncSha256"))
                writer.uint32(/* id 24, wireType 2 =*/194).bytes(message.midQualityFileEncSha256);
            if (message.viewOnce != null && Object.hasOwnProperty.call(message, "viewOnce"))
                writer.uint32(/* id 25, wireType 0 =*/200).bool(message.viewOnce);
            if (message.thumbnailDirectPath != null && Object.hasOwnProperty.call(message, "thumbnailDirectPath"))
                writer.uint32(/* id 26, wireType 2 =*/210).string(message.thumbnailDirectPath);
            if (message.thumbnailSha256 != null && Object.hasOwnProperty.call(message, "thumbnailSha256"))
                writer.uint32(/* id 27, wireType 2 =*/218).bytes(message.thumbnailSha256);
            if (message.thumbnailEncSha256 != null && Object.hasOwnProperty.call(message, "thumbnailEncSha256"))
                writer.uint32(/* id 28, wireType 2 =*/226).bytes(message.thumbnailEncSha256);
            if (message.staticUrl != null && Object.hasOwnProperty.call(message, "staticUrl"))
                writer.uint32(/* id 29, wireType 2 =*/234).string(message.staticUrl);
            return writer;
        };

        /**
         * Encodes the specified ImageMessage message, length delimited. Does not implicitly {@link proto.ImageMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ImageMessage
         * @static
         * @param {proto.IImageMessage} message ImageMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ImageMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an ImageMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ImageMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ImageMessage} ImageMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ImageMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ImageMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.url = reader.string();
                    break;
                case 2:
                    message.mimetype = reader.string();
                    break;
                case 3:
                    message.caption = reader.string();
                    break;
                case 4:
                    message.fileSha256 = reader.bytes();
                    break;
                case 5:
                    message.fileLength = reader.uint64();
                    break;
                case 6:
                    message.height = reader.uint32();
                    break;
                case 7:
                    message.width = reader.uint32();
                    break;
                case 8:
                    message.mediaKey = reader.bytes();
                    break;
                case 9:
                    message.fileEncSha256 = reader.bytes();
                    break;
                case 10:
                    if (!(message.interactiveAnnotations && message.interactiveAnnotations.length))
                        message.interactiveAnnotations = [];
                    message.interactiveAnnotations.push($root.proto.InteractiveAnnotation.decode(reader, reader.uint32()));
                    break;
                case 11:
                    message.directPath = reader.string();
                    break;
                case 12:
                    message.mediaKeyTimestamp = reader.int64();
                    break;
                case 16:
                    message.jpegThumbnail = reader.bytes();
                    break;
                case 17:
                    message.contextInfo = $root.proto.ContextInfo.decode(reader, reader.uint32());
                    break;
                case 18:
                    message.firstScanSidecar = reader.bytes();
                    break;
                case 19:
                    message.firstScanLength = reader.uint32();
                    break;
                case 20:
                    message.experimentGroupId = reader.uint32();
                    break;
                case 21:
                    message.scansSidecar = reader.bytes();
                    break;
                case 22:
                    if (!(message.scanLengths && message.scanLengths.length))
                        message.scanLengths = [];
                    if ((tag & 7) === 2) {
                        var end2 = reader.uint32() + reader.pos;
                        while (reader.pos < end2)
                            message.scanLengths.push(reader.uint32());
                    } else
                        message.scanLengths.push(reader.uint32());
                    break;
                case 23:
                    message.midQualityFileSha256 = reader.bytes();
                    break;
                case 24:
                    message.midQualityFileEncSha256 = reader.bytes();
                    break;
                case 25:
                    message.viewOnce = reader.bool();
                    break;
                case 26:
                    message.thumbnailDirectPath = reader.string();
                    break;
                case 27:
                    message.thumbnailSha256 = reader.bytes();
                    break;
                case 28:
                    message.thumbnailEncSha256 = reader.bytes();
                    break;
                case 29:
                    message.staticUrl = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an ImageMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ImageMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ImageMessage} ImageMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ImageMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an ImageMessage message.
         * @function verify
         * @memberof proto.ImageMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ImageMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.url != null && message.hasOwnProperty("url"))
                if (!$util.isString(message.url))
                    return "url: string expected";
            if (message.mimetype != null && message.hasOwnProperty("mimetype"))
                if (!$util.isString(message.mimetype))
                    return "mimetype: string expected";
            if (message.caption != null && message.hasOwnProperty("caption"))
                if (!$util.isString(message.caption))
                    return "caption: string expected";
            if (message.fileSha256 != null && message.hasOwnProperty("fileSha256"))
                if (!(message.fileSha256 && typeof message.fileSha256.length === "number" || $util.isString(message.fileSha256)))
                    return "fileSha256: buffer expected";
            if (message.fileLength != null && message.hasOwnProperty("fileLength"))
                if (!$util.isInteger(message.fileLength) && !(message.fileLength && $util.isInteger(message.fileLength.low) && $util.isInteger(message.fileLength.high)))
                    return "fileLength: integer|Long expected";
            if (message.height != null && message.hasOwnProperty("height"))
                if (!$util.isInteger(message.height))
                    return "height: integer expected";
            if (message.width != null && message.hasOwnProperty("width"))
                if (!$util.isInteger(message.width))
                    return "width: integer expected";
            if (message.mediaKey != null && message.hasOwnProperty("mediaKey"))
                if (!(message.mediaKey && typeof message.mediaKey.length === "number" || $util.isString(message.mediaKey)))
                    return "mediaKey: buffer expected";
            if (message.fileEncSha256 != null && message.hasOwnProperty("fileEncSha256"))
                if (!(message.fileEncSha256 && typeof message.fileEncSha256.length === "number" || $util.isString(message.fileEncSha256)))
                    return "fileEncSha256: buffer expected";
            if (message.interactiveAnnotations != null && message.hasOwnProperty("interactiveAnnotations")) {
                if (!Array.isArray(message.interactiveAnnotations))
                    return "interactiveAnnotations: array expected";
                for (var i = 0; i < message.interactiveAnnotations.length; ++i) {
                    var error = $root.proto.InteractiveAnnotation.verify(message.interactiveAnnotations[i]);
                    if (error)
                        return "interactiveAnnotations." + error;
                }
            }
            if (message.directPath != null && message.hasOwnProperty("directPath"))
                if (!$util.isString(message.directPath))
                    return "directPath: string expected";
            if (message.mediaKeyTimestamp != null && message.hasOwnProperty("mediaKeyTimestamp"))
                if (!$util.isInteger(message.mediaKeyTimestamp) && !(message.mediaKeyTimestamp && $util.isInteger(message.mediaKeyTimestamp.low) && $util.isInteger(message.mediaKeyTimestamp.high)))
                    return "mediaKeyTimestamp: integer|Long expected";
            if (message.jpegThumbnail != null && message.hasOwnProperty("jpegThumbnail"))
                if (!(message.jpegThumbnail && typeof message.jpegThumbnail.length === "number" || $util.isString(message.jpegThumbnail)))
                    return "jpegThumbnail: buffer expected";
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo")) {
                var error = $root.proto.ContextInfo.verify(message.contextInfo);
                if (error)
                    return "contextInfo." + error;
            }
            if (message.firstScanSidecar != null && message.hasOwnProperty("firstScanSidecar"))
                if (!(message.firstScanSidecar && typeof message.firstScanSidecar.length === "number" || $util.isString(message.firstScanSidecar)))
                    return "firstScanSidecar: buffer expected";
            if (message.firstScanLength != null && message.hasOwnProperty("firstScanLength"))
                if (!$util.isInteger(message.firstScanLength))
                    return "firstScanLength: integer expected";
            if (message.experimentGroupId != null && message.hasOwnProperty("experimentGroupId"))
                if (!$util.isInteger(message.experimentGroupId))
                    return "experimentGroupId: integer expected";
            if (message.scansSidecar != null && message.hasOwnProperty("scansSidecar"))
                if (!(message.scansSidecar && typeof message.scansSidecar.length === "number" || $util.isString(message.scansSidecar)))
                    return "scansSidecar: buffer expected";
            if (message.scanLengths != null && message.hasOwnProperty("scanLengths")) {
                if (!Array.isArray(message.scanLengths))
                    return "scanLengths: array expected";
                for (var i = 0; i < message.scanLengths.length; ++i)
                    if (!$util.isInteger(message.scanLengths[i]))
                        return "scanLengths: integer[] expected";
            }
            if (message.midQualityFileSha256 != null && message.hasOwnProperty("midQualityFileSha256"))
                if (!(message.midQualityFileSha256 && typeof message.midQualityFileSha256.length === "number" || $util.isString(message.midQualityFileSha256)))
                    return "midQualityFileSha256: buffer expected";
            if (message.midQualityFileEncSha256 != null && message.hasOwnProperty("midQualityFileEncSha256"))
                if (!(message.midQualityFileEncSha256 && typeof message.midQualityFileEncSha256.length === "number" || $util.isString(message.midQualityFileEncSha256)))
                    return "midQualityFileEncSha256: buffer expected";
            if (message.viewOnce != null && message.hasOwnProperty("viewOnce"))
                if (typeof message.viewOnce !== "boolean")
                    return "viewOnce: boolean expected";
            if (message.thumbnailDirectPath != null && message.hasOwnProperty("thumbnailDirectPath"))
                if (!$util.isString(message.thumbnailDirectPath))
                    return "thumbnailDirectPath: string expected";
            if (message.thumbnailSha256 != null && message.hasOwnProperty("thumbnailSha256"))
                if (!(message.thumbnailSha256 && typeof message.thumbnailSha256.length === "number" || $util.isString(message.thumbnailSha256)))
                    return "thumbnailSha256: buffer expected";
            if (message.thumbnailEncSha256 != null && message.hasOwnProperty("thumbnailEncSha256"))
                if (!(message.thumbnailEncSha256 && typeof message.thumbnailEncSha256.length === "number" || $util.isString(message.thumbnailEncSha256)))
                    return "thumbnailEncSha256: buffer expected";
            if (message.staticUrl != null && message.hasOwnProperty("staticUrl"))
                if (!$util.isString(message.staticUrl))
                    return "staticUrl: string expected";
            return null;
        };

        /**
         * Creates an ImageMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ImageMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ImageMessage} ImageMessage
         */
        ImageMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ImageMessage)
                return object;
            var message = new $root.proto.ImageMessage();
            if (object.url != null)
                message.url = String(object.url);
            if (object.mimetype != null)
                message.mimetype = String(object.mimetype);
            if (object.caption != null)
                message.caption = String(object.caption);
            if (object.fileSha256 != null)
                if (typeof object.fileSha256 === "string")
                    $util.base64.decode(object.fileSha256, message.fileSha256 = $util.newBuffer($util.base64.length(object.fileSha256)), 0);
                else if (object.fileSha256.length)
                    message.fileSha256 = object.fileSha256;
            if (object.fileLength != null)
                if ($util.Long)
                    (message.fileLength = $util.Long.fromValue(object.fileLength)).unsigned = true;
                else if (typeof object.fileLength === "string")
                    message.fileLength = parseInt(object.fileLength, 10);
                else if (typeof object.fileLength === "number")
                    message.fileLength = object.fileLength;
                else if (typeof object.fileLength === "object")
                    message.fileLength = new $util.LongBits(object.fileLength.low >>> 0, object.fileLength.high >>> 0).toNumber(true);
            if (object.height != null)
                message.height = object.height >>> 0;
            if (object.width != null)
                message.width = object.width >>> 0;
            if (object.mediaKey != null)
                if (typeof object.mediaKey === "string")
                    $util.base64.decode(object.mediaKey, message.mediaKey = $util.newBuffer($util.base64.length(object.mediaKey)), 0);
                else if (object.mediaKey.length)
                    message.mediaKey = object.mediaKey;
            if (object.fileEncSha256 != null)
                if (typeof object.fileEncSha256 === "string")
                    $util.base64.decode(object.fileEncSha256, message.fileEncSha256 = $util.newBuffer($util.base64.length(object.fileEncSha256)), 0);
                else if (object.fileEncSha256.length)
                    message.fileEncSha256 = object.fileEncSha256;
            if (object.interactiveAnnotations) {
                if (!Array.isArray(object.interactiveAnnotations))
                    throw TypeError(".proto.ImageMessage.interactiveAnnotations: array expected");
                message.interactiveAnnotations = [];
                for (var i = 0; i < object.interactiveAnnotations.length; ++i) {
                    if (typeof object.interactiveAnnotations[i] !== "object")
                        throw TypeError(".proto.ImageMessage.interactiveAnnotations: object expected");
                    message.interactiveAnnotations[i] = $root.proto.InteractiveAnnotation.fromObject(object.interactiveAnnotations[i]);
                }
            }
            if (object.directPath != null)
                message.directPath = String(object.directPath);
            if (object.mediaKeyTimestamp != null)
                if ($util.Long)
                    (message.mediaKeyTimestamp = $util.Long.fromValue(object.mediaKeyTimestamp)).unsigned = false;
                else if (typeof object.mediaKeyTimestamp === "string")
                    message.mediaKeyTimestamp = parseInt(object.mediaKeyTimestamp, 10);
                else if (typeof object.mediaKeyTimestamp === "number")
                    message.mediaKeyTimestamp = object.mediaKeyTimestamp;
                else if (typeof object.mediaKeyTimestamp === "object")
                    message.mediaKeyTimestamp = new $util.LongBits(object.mediaKeyTimestamp.low >>> 0, object.mediaKeyTimestamp.high >>> 0).toNumber();
            if (object.jpegThumbnail != null)
                if (typeof object.jpegThumbnail === "string")
                    $util.base64.decode(object.jpegThumbnail, message.jpegThumbnail = $util.newBuffer($util.base64.length(object.jpegThumbnail)), 0);
                else if (object.jpegThumbnail.length)
                    message.jpegThumbnail = object.jpegThumbnail;
            if (object.contextInfo != null) {
                if (typeof object.contextInfo !== "object")
                    throw TypeError(".proto.ImageMessage.contextInfo: object expected");
                message.contextInfo = $root.proto.ContextInfo.fromObject(object.contextInfo);
            }
            if (object.firstScanSidecar != null)
                if (typeof object.firstScanSidecar === "string")
                    $util.base64.decode(object.firstScanSidecar, message.firstScanSidecar = $util.newBuffer($util.base64.length(object.firstScanSidecar)), 0);
                else if (object.firstScanSidecar.length)
                    message.firstScanSidecar = object.firstScanSidecar;
            if (object.firstScanLength != null)
                message.firstScanLength = object.firstScanLength >>> 0;
            if (object.experimentGroupId != null)
                message.experimentGroupId = object.experimentGroupId >>> 0;
            if (object.scansSidecar != null)
                if (typeof object.scansSidecar === "string")
                    $util.base64.decode(object.scansSidecar, message.scansSidecar = $util.newBuffer($util.base64.length(object.scansSidecar)), 0);
                else if (object.scansSidecar.length)
                    message.scansSidecar = object.scansSidecar;
            if (object.scanLengths) {
                if (!Array.isArray(object.scanLengths))
                    throw TypeError(".proto.ImageMessage.scanLengths: array expected");
                message.scanLengths = [];
                for (var i = 0; i < object.scanLengths.length; ++i)
                    message.scanLengths[i] = object.scanLengths[i] >>> 0;
            }
            if (object.midQualityFileSha256 != null)
                if (typeof object.midQualityFileSha256 === "string")
                    $util.base64.decode(object.midQualityFileSha256, message.midQualityFileSha256 = $util.newBuffer($util.base64.length(object.midQualityFileSha256)), 0);
                else if (object.midQualityFileSha256.length)
                    message.midQualityFileSha256 = object.midQualityFileSha256;
            if (object.midQualityFileEncSha256 != null)
                if (typeof object.midQualityFileEncSha256 === "string")
                    $util.base64.decode(object.midQualityFileEncSha256, message.midQualityFileEncSha256 = $util.newBuffer($util.base64.length(object.midQualityFileEncSha256)), 0);
                else if (object.midQualityFileEncSha256.length)
                    message.midQualityFileEncSha256 = object.midQualityFileEncSha256;
            if (object.viewOnce != null)
                message.viewOnce = Boolean(object.viewOnce);
            if (object.thumbnailDirectPath != null)
                message.thumbnailDirectPath = String(object.thumbnailDirectPath);
            if (object.thumbnailSha256 != null)
                if (typeof object.thumbnailSha256 === "string")
                    $util.base64.decode(object.thumbnailSha256, message.thumbnailSha256 = $util.newBuffer($util.base64.length(object.thumbnailSha256)), 0);
                else if (object.thumbnailSha256.length)
                    message.thumbnailSha256 = object.thumbnailSha256;
            if (object.thumbnailEncSha256 != null)
                if (typeof object.thumbnailEncSha256 === "string")
                    $util.base64.decode(object.thumbnailEncSha256, message.thumbnailEncSha256 = $util.newBuffer($util.base64.length(object.thumbnailEncSha256)), 0);
                else if (object.thumbnailEncSha256.length)
                    message.thumbnailEncSha256 = object.thumbnailEncSha256;
            if (object.staticUrl != null)
                message.staticUrl = String(object.staticUrl);
            return message;
        };

        /**
         * Creates a plain object from an ImageMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ImageMessage
         * @static
         * @param {proto.ImageMessage} message ImageMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ImageMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults) {
                object.interactiveAnnotations = [];
                object.scanLengths = [];
            }
            if (options.defaults) {
                object.url = "";
                object.mimetype = "";
                object.caption = "";
                if (options.bytes === String)
                    object.fileSha256 = "";
                else {
                    object.fileSha256 = [];
                    if (options.bytes !== Array)
                        object.fileSha256 = $util.newBuffer(object.fileSha256);
                }
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.fileLength = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.fileLength = options.longs === String ? "0" : 0;
                object.height = 0;
                object.width = 0;
                if (options.bytes === String)
                    object.mediaKey = "";
                else {
                    object.mediaKey = [];
                    if (options.bytes !== Array)
                        object.mediaKey = $util.newBuffer(object.mediaKey);
                }
                if (options.bytes === String)
                    object.fileEncSha256 = "";
                else {
                    object.fileEncSha256 = [];
                    if (options.bytes !== Array)
                        object.fileEncSha256 = $util.newBuffer(object.fileEncSha256);
                }
                object.directPath = "";
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.mediaKeyTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.mediaKeyTimestamp = options.longs === String ? "0" : 0;
                if (options.bytes === String)
                    object.jpegThumbnail = "";
                else {
                    object.jpegThumbnail = [];
                    if (options.bytes !== Array)
                        object.jpegThumbnail = $util.newBuffer(object.jpegThumbnail);
                }
                object.contextInfo = null;
                if (options.bytes === String)
                    object.firstScanSidecar = "";
                else {
                    object.firstScanSidecar = [];
                    if (options.bytes !== Array)
                        object.firstScanSidecar = $util.newBuffer(object.firstScanSidecar);
                }
                object.firstScanLength = 0;
                object.experimentGroupId = 0;
                if (options.bytes === String)
                    object.scansSidecar = "";
                else {
                    object.scansSidecar = [];
                    if (options.bytes !== Array)
                        object.scansSidecar = $util.newBuffer(object.scansSidecar);
                }
                if (options.bytes === String)
                    object.midQualityFileSha256 = "";
                else {
                    object.midQualityFileSha256 = [];
                    if (options.bytes !== Array)
                        object.midQualityFileSha256 = $util.newBuffer(object.midQualityFileSha256);
                }
                if (options.bytes === String)
                    object.midQualityFileEncSha256 = "";
                else {
                    object.midQualityFileEncSha256 = [];
                    if (options.bytes !== Array)
                        object.midQualityFileEncSha256 = $util.newBuffer(object.midQualityFileEncSha256);
                }
                object.viewOnce = false;
                object.thumbnailDirectPath = "";
                if (options.bytes === String)
                    object.thumbnailSha256 = "";
                else {
                    object.thumbnailSha256 = [];
                    if (options.bytes !== Array)
                        object.thumbnailSha256 = $util.newBuffer(object.thumbnailSha256);
                }
                if (options.bytes === String)
                    object.thumbnailEncSha256 = "";
                else {
                    object.thumbnailEncSha256 = [];
                    if (options.bytes !== Array)
                        object.thumbnailEncSha256 = $util.newBuffer(object.thumbnailEncSha256);
                }
                object.staticUrl = "";
            }
            if (message.url != null && message.hasOwnProperty("url"))
                object.url = message.url;
            if (message.mimetype != null && message.hasOwnProperty("mimetype"))
                object.mimetype = message.mimetype;
            if (message.caption != null && message.hasOwnProperty("caption"))
                object.caption = message.caption;
            if (message.fileSha256 != null && message.hasOwnProperty("fileSha256"))
                object.fileSha256 = options.bytes === String ? $util.base64.encode(message.fileSha256, 0, message.fileSha256.length) : options.bytes === Array ? Array.prototype.slice.call(message.fileSha256) : message.fileSha256;
            if (message.fileLength != null && message.hasOwnProperty("fileLength"))
                if (typeof message.fileLength === "number")
                    object.fileLength = options.longs === String ? String(message.fileLength) : message.fileLength;
                else
                    object.fileLength = options.longs === String ? $util.Long.prototype.toString.call(message.fileLength) : options.longs === Number ? new $util.LongBits(message.fileLength.low >>> 0, message.fileLength.high >>> 0).toNumber(true) : message.fileLength;
            if (message.height != null && message.hasOwnProperty("height"))
                object.height = message.height;
            if (message.width != null && message.hasOwnProperty("width"))
                object.width = message.width;
            if (message.mediaKey != null && message.hasOwnProperty("mediaKey"))
                object.mediaKey = options.bytes === String ? $util.base64.encode(message.mediaKey, 0, message.mediaKey.length) : options.bytes === Array ? Array.prototype.slice.call(message.mediaKey) : message.mediaKey;
            if (message.fileEncSha256 != null && message.hasOwnProperty("fileEncSha256"))
                object.fileEncSha256 = options.bytes === String ? $util.base64.encode(message.fileEncSha256, 0, message.fileEncSha256.length) : options.bytes === Array ? Array.prototype.slice.call(message.fileEncSha256) : message.fileEncSha256;
            if (message.interactiveAnnotations && message.interactiveAnnotations.length) {
                object.interactiveAnnotations = [];
                for (var j = 0; j < message.interactiveAnnotations.length; ++j)
                    object.interactiveAnnotations[j] = $root.proto.InteractiveAnnotation.toObject(message.interactiveAnnotations[j], options);
            }
            if (message.directPath != null && message.hasOwnProperty("directPath"))
                object.directPath = message.directPath;
            if (message.mediaKeyTimestamp != null && message.hasOwnProperty("mediaKeyTimestamp"))
                if (typeof message.mediaKeyTimestamp === "number")
                    object.mediaKeyTimestamp = options.longs === String ? String(message.mediaKeyTimestamp) : message.mediaKeyTimestamp;
                else
                    object.mediaKeyTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.mediaKeyTimestamp) : options.longs === Number ? new $util.LongBits(message.mediaKeyTimestamp.low >>> 0, message.mediaKeyTimestamp.high >>> 0).toNumber() : message.mediaKeyTimestamp;
            if (message.jpegThumbnail != null && message.hasOwnProperty("jpegThumbnail"))
                object.jpegThumbnail = options.bytes === String ? $util.base64.encode(message.jpegThumbnail, 0, message.jpegThumbnail.length) : options.bytes === Array ? Array.prototype.slice.call(message.jpegThumbnail) : message.jpegThumbnail;
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo"))
                object.contextInfo = $root.proto.ContextInfo.toObject(message.contextInfo, options);
            if (message.firstScanSidecar != null && message.hasOwnProperty("firstScanSidecar"))
                object.firstScanSidecar = options.bytes === String ? $util.base64.encode(message.firstScanSidecar, 0, message.firstScanSidecar.length) : options.bytes === Array ? Array.prototype.slice.call(message.firstScanSidecar) : message.firstScanSidecar;
            if (message.firstScanLength != null && message.hasOwnProperty("firstScanLength"))
                object.firstScanLength = message.firstScanLength;
            if (message.experimentGroupId != null && message.hasOwnProperty("experimentGroupId"))
                object.experimentGroupId = message.experimentGroupId;
            if (message.scansSidecar != null && message.hasOwnProperty("scansSidecar"))
                object.scansSidecar = options.bytes === String ? $util.base64.encode(message.scansSidecar, 0, message.scansSidecar.length) : options.bytes === Array ? Array.prototype.slice.call(message.scansSidecar) : message.scansSidecar;
            if (message.scanLengths && message.scanLengths.length) {
                object.scanLengths = [];
                for (var j = 0; j < message.scanLengths.length; ++j)
                    object.scanLengths[j] = message.scanLengths[j];
            }
            if (message.midQualityFileSha256 != null && message.hasOwnProperty("midQualityFileSha256"))
                object.midQualityFileSha256 = options.bytes === String ? $util.base64.encode(message.midQualityFileSha256, 0, message.midQualityFileSha256.length) : options.bytes === Array ? Array.prototype.slice.call(message.midQualityFileSha256) : message.midQualityFileSha256;
            if (message.midQualityFileEncSha256 != null && message.hasOwnProperty("midQualityFileEncSha256"))
                object.midQualityFileEncSha256 = options.bytes === String ? $util.base64.encode(message.midQualityFileEncSha256, 0, message.midQualityFileEncSha256.length) : options.bytes === Array ? Array.prototype.slice.call(message.midQualityFileEncSha256) : message.midQualityFileEncSha256;
            if (message.viewOnce != null && message.hasOwnProperty("viewOnce"))
                object.viewOnce = message.viewOnce;
            if (message.thumbnailDirectPath != null && message.hasOwnProperty("thumbnailDirectPath"))
                object.thumbnailDirectPath = message.thumbnailDirectPath;
            if (message.thumbnailSha256 != null && message.hasOwnProperty("thumbnailSha256"))
                object.thumbnailSha256 = options.bytes === String ? $util.base64.encode(message.thumbnailSha256, 0, message.thumbnailSha256.length) : options.bytes === Array ? Array.prototype.slice.call(message.thumbnailSha256) : message.thumbnailSha256;
            if (message.thumbnailEncSha256 != null && message.hasOwnProperty("thumbnailEncSha256"))
                object.thumbnailEncSha256 = options.bytes === String ? $util.base64.encode(message.thumbnailEncSha256, 0, message.thumbnailEncSha256.length) : options.bytes === Array ? Array.prototype.slice.call(message.thumbnailEncSha256) : message.thumbnailEncSha256;
            if (message.staticUrl != null && message.hasOwnProperty("staticUrl"))
                object.staticUrl = message.staticUrl;
            return object;
        };

        /**
         * Converts this ImageMessage to JSON.
         * @function toJSON
         * @memberof proto.ImageMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ImageMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ImageMessage;
    })();

    proto.InitialSecurityNotificationSettingSync = (function() {

        /**
         * Properties of an InitialSecurityNotificationSettingSync.
         * @memberof proto
         * @interface IInitialSecurityNotificationSettingSync
         * @property {boolean|null} [securityNotificationEnabled] InitialSecurityNotificationSettingSync securityNotificationEnabled
         */

        /**
         * Constructs a new InitialSecurityNotificationSettingSync.
         * @memberof proto
         * @classdesc Represents an InitialSecurityNotificationSettingSync.
         * @implements IInitialSecurityNotificationSettingSync
         * @constructor
         * @param {proto.IInitialSecurityNotificationSettingSync=} [properties] Properties to set
         */
        function InitialSecurityNotificationSettingSync(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * InitialSecurityNotificationSettingSync securityNotificationEnabled.
         * @member {boolean} securityNotificationEnabled
         * @memberof proto.InitialSecurityNotificationSettingSync
         * @instance
         */
        InitialSecurityNotificationSettingSync.prototype.securityNotificationEnabled = false;

        /**
         * Creates a new InitialSecurityNotificationSettingSync instance using the specified properties.
         * @function create
         * @memberof proto.InitialSecurityNotificationSettingSync
         * @static
         * @param {proto.IInitialSecurityNotificationSettingSync=} [properties] Properties to set
         * @returns {proto.InitialSecurityNotificationSettingSync} InitialSecurityNotificationSettingSync instance
         */
        InitialSecurityNotificationSettingSync.create = function create(properties) {
            return new InitialSecurityNotificationSettingSync(properties);
        };

        /**
         * Encodes the specified InitialSecurityNotificationSettingSync message. Does not implicitly {@link proto.InitialSecurityNotificationSettingSync.verify|verify} messages.
         * @function encode
         * @memberof proto.InitialSecurityNotificationSettingSync
         * @static
         * @param {proto.IInitialSecurityNotificationSettingSync} message InitialSecurityNotificationSettingSync message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        InitialSecurityNotificationSettingSync.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.securityNotificationEnabled != null && Object.hasOwnProperty.call(message, "securityNotificationEnabled"))
                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.securityNotificationEnabled);
            return writer;
        };

        /**
         * Encodes the specified InitialSecurityNotificationSettingSync message, length delimited. Does not implicitly {@link proto.InitialSecurityNotificationSettingSync.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.InitialSecurityNotificationSettingSync
         * @static
         * @param {proto.IInitialSecurityNotificationSettingSync} message InitialSecurityNotificationSettingSync message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        InitialSecurityNotificationSettingSync.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an InitialSecurityNotificationSettingSync message from the specified reader or buffer.
         * @function decode
         * @memberof proto.InitialSecurityNotificationSettingSync
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.InitialSecurityNotificationSettingSync} InitialSecurityNotificationSettingSync
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        InitialSecurityNotificationSettingSync.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.InitialSecurityNotificationSettingSync();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.securityNotificationEnabled = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an InitialSecurityNotificationSettingSync message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.InitialSecurityNotificationSettingSync
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.InitialSecurityNotificationSettingSync} InitialSecurityNotificationSettingSync
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        InitialSecurityNotificationSettingSync.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an InitialSecurityNotificationSettingSync message.
         * @function verify
         * @memberof proto.InitialSecurityNotificationSettingSync
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        InitialSecurityNotificationSettingSync.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.securityNotificationEnabled != null && message.hasOwnProperty("securityNotificationEnabled"))
                if (typeof message.securityNotificationEnabled !== "boolean")
                    return "securityNotificationEnabled: boolean expected";
            return null;
        };

        /**
         * Creates an InitialSecurityNotificationSettingSync message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.InitialSecurityNotificationSettingSync
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.InitialSecurityNotificationSettingSync} InitialSecurityNotificationSettingSync
         */
        InitialSecurityNotificationSettingSync.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.InitialSecurityNotificationSettingSync)
                return object;
            var message = new $root.proto.InitialSecurityNotificationSettingSync();
            if (object.securityNotificationEnabled != null)
                message.securityNotificationEnabled = Boolean(object.securityNotificationEnabled);
            return message;
        };

        /**
         * Creates a plain object from an InitialSecurityNotificationSettingSync message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.InitialSecurityNotificationSettingSync
         * @static
         * @param {proto.InitialSecurityNotificationSettingSync} message InitialSecurityNotificationSettingSync
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        InitialSecurityNotificationSettingSync.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.securityNotificationEnabled = false;
            if (message.securityNotificationEnabled != null && message.hasOwnProperty("securityNotificationEnabled"))
                object.securityNotificationEnabled = message.securityNotificationEnabled;
            return object;
        };

        /**
         * Converts this InitialSecurityNotificationSettingSync to JSON.
         * @function toJSON
         * @memberof proto.InitialSecurityNotificationSettingSync
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        InitialSecurityNotificationSettingSync.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return InitialSecurityNotificationSettingSync;
    })();

    proto.InteractiveAnnotation = (function() {

        /**
         * Properties of an InteractiveAnnotation.
         * @memberof proto
         * @interface IInteractiveAnnotation
         * @property {Array.<proto.IPoint>|null} [polygonVertices] InteractiveAnnotation polygonVertices
         * @property {proto.ILocation|null} [location] InteractiveAnnotation location
         */

        /**
         * Constructs a new InteractiveAnnotation.
         * @memberof proto
         * @classdesc Represents an InteractiveAnnotation.
         * @implements IInteractiveAnnotation
         * @constructor
         * @param {proto.IInteractiveAnnotation=} [properties] Properties to set
         */
        function InteractiveAnnotation(properties) {
            this.polygonVertices = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * InteractiveAnnotation polygonVertices.
         * @member {Array.<proto.IPoint>} polygonVertices
         * @memberof proto.InteractiveAnnotation
         * @instance
         */
        InteractiveAnnotation.prototype.polygonVertices = $util.emptyArray;

        /**
         * InteractiveAnnotation location.
         * @member {proto.ILocation|null|undefined} location
         * @memberof proto.InteractiveAnnotation
         * @instance
         */
        InteractiveAnnotation.prototype.location = null;

        // OneOf field names bound to virtual getters and setters
        var $oneOfFields;

        /**
         * InteractiveAnnotation action.
         * @member {"location"|undefined} action
         * @memberof proto.InteractiveAnnotation
         * @instance
         */
        Object.defineProperty(InteractiveAnnotation.prototype, "action", {
            get: $util.oneOfGetter($oneOfFields = ["location"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new InteractiveAnnotation instance using the specified properties.
         * @function create
         * @memberof proto.InteractiveAnnotation
         * @static
         * @param {proto.IInteractiveAnnotation=} [properties] Properties to set
         * @returns {proto.InteractiveAnnotation} InteractiveAnnotation instance
         */
        InteractiveAnnotation.create = function create(properties) {
            return new InteractiveAnnotation(properties);
        };

        /**
         * Encodes the specified InteractiveAnnotation message. Does not implicitly {@link proto.InteractiveAnnotation.verify|verify} messages.
         * @function encode
         * @memberof proto.InteractiveAnnotation
         * @static
         * @param {proto.IInteractiveAnnotation} message InteractiveAnnotation message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        InteractiveAnnotation.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.polygonVertices != null && message.polygonVertices.length)
                for (var i = 0; i < message.polygonVertices.length; ++i)
                    $root.proto.Point.encode(message.polygonVertices[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.location != null && Object.hasOwnProperty.call(message, "location"))
                $root.proto.Location.encode(message.location, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified InteractiveAnnotation message, length delimited. Does not implicitly {@link proto.InteractiveAnnotation.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.InteractiveAnnotation
         * @static
         * @param {proto.IInteractiveAnnotation} message InteractiveAnnotation message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        InteractiveAnnotation.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an InteractiveAnnotation message from the specified reader or buffer.
         * @function decode
         * @memberof proto.InteractiveAnnotation
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.InteractiveAnnotation} InteractiveAnnotation
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        InteractiveAnnotation.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.InteractiveAnnotation();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    if (!(message.polygonVertices && message.polygonVertices.length))
                        message.polygonVertices = [];
                    message.polygonVertices.push($root.proto.Point.decode(reader, reader.uint32()));
                    break;
                case 2:
                    message.location = $root.proto.Location.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an InteractiveAnnotation message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.InteractiveAnnotation
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.InteractiveAnnotation} InteractiveAnnotation
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        InteractiveAnnotation.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an InteractiveAnnotation message.
         * @function verify
         * @memberof proto.InteractiveAnnotation
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        InteractiveAnnotation.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            var properties = {};
            if (message.polygonVertices != null && message.hasOwnProperty("polygonVertices")) {
                if (!Array.isArray(message.polygonVertices))
                    return "polygonVertices: array expected";
                for (var i = 0; i < message.polygonVertices.length; ++i) {
                    var error = $root.proto.Point.verify(message.polygonVertices[i]);
                    if (error)
                        return "polygonVertices." + error;
                }
            }
            if (message.location != null && message.hasOwnProperty("location")) {
                properties.action = 1;
                {
                    var error = $root.proto.Location.verify(message.location);
                    if (error)
                        return "location." + error;
                }
            }
            return null;
        };

        /**
         * Creates an InteractiveAnnotation message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.InteractiveAnnotation
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.InteractiveAnnotation} InteractiveAnnotation
         */
        InteractiveAnnotation.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.InteractiveAnnotation)
                return object;
            var message = new $root.proto.InteractiveAnnotation();
            if (object.polygonVertices) {
                if (!Array.isArray(object.polygonVertices))
                    throw TypeError(".proto.InteractiveAnnotation.polygonVertices: array expected");
                message.polygonVertices = [];
                for (var i = 0; i < object.polygonVertices.length; ++i) {
                    if (typeof object.polygonVertices[i] !== "object")
                        throw TypeError(".proto.InteractiveAnnotation.polygonVertices: object expected");
                    message.polygonVertices[i] = $root.proto.Point.fromObject(object.polygonVertices[i]);
                }
            }
            if (object.location != null) {
                if (typeof object.location !== "object")
                    throw TypeError(".proto.InteractiveAnnotation.location: object expected");
                message.location = $root.proto.Location.fromObject(object.location);
            }
            return message;
        };

        /**
         * Creates a plain object from an InteractiveAnnotation message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.InteractiveAnnotation
         * @static
         * @param {proto.InteractiveAnnotation} message InteractiveAnnotation
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        InteractiveAnnotation.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.polygonVertices = [];
            if (message.polygonVertices && message.polygonVertices.length) {
                object.polygonVertices = [];
                for (var j = 0; j < message.polygonVertices.length; ++j)
                    object.polygonVertices[j] = $root.proto.Point.toObject(message.polygonVertices[j], options);
            }
            if (message.location != null && message.hasOwnProperty("location")) {
                object.location = $root.proto.Location.toObject(message.location, options);
                if (options.oneofs)
                    object.action = "location";
            }
            return object;
        };

        /**
         * Converts this InteractiveAnnotation to JSON.
         * @function toJSON
         * @memberof proto.InteractiveAnnotation
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        InteractiveAnnotation.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return InteractiveAnnotation;
    })();

    proto.InteractiveMessage = (function() {

        /**
         * Properties of an InteractiveMessage.
         * @memberof proto
         * @interface IInteractiveMessage
         * @property {proto.IHeader|null} [header] InteractiveMessage header
         * @property {proto.IInteractiveMessageBody|null} [body] InteractiveMessage body
         * @property {proto.IFooter|null} [footer] InteractiveMessage footer
         * @property {proto.IContextInfo|null} [contextInfo] InteractiveMessage contextInfo
         * @property {proto.IShopMessage|null} [shopStorefrontMessage] InteractiveMessage shopStorefrontMessage
         * @property {proto.ICollectionMessage|null} [collectionMessage] InteractiveMessage collectionMessage
         * @property {proto.INativeFlowMessage|null} [nativeFlowMessage] InteractiveMessage nativeFlowMessage
         */

        /**
         * Constructs a new InteractiveMessage.
         * @memberof proto
         * @classdesc Represents an InteractiveMessage.
         * @implements IInteractiveMessage
         * @constructor
         * @param {proto.IInteractiveMessage=} [properties] Properties to set
         */
        function InteractiveMessage(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * InteractiveMessage header.
         * @member {proto.IHeader|null|undefined} header
         * @memberof proto.InteractiveMessage
         * @instance
         */
        InteractiveMessage.prototype.header = null;

        /**
         * InteractiveMessage body.
         * @member {proto.IInteractiveMessageBody|null|undefined} body
         * @memberof proto.InteractiveMessage
         * @instance
         */
        InteractiveMessage.prototype.body = null;

        /**
         * InteractiveMessage footer.
         * @member {proto.IFooter|null|undefined} footer
         * @memberof proto.InteractiveMessage
         * @instance
         */
        InteractiveMessage.prototype.footer = null;

        /**
         * InteractiveMessage contextInfo.
         * @member {proto.IContextInfo|null|undefined} contextInfo
         * @memberof proto.InteractiveMessage
         * @instance
         */
        InteractiveMessage.prototype.contextInfo = null;

        /**
         * InteractiveMessage shopStorefrontMessage.
         * @member {proto.IShopMessage|null|undefined} shopStorefrontMessage
         * @memberof proto.InteractiveMessage
         * @instance
         */
        InteractiveMessage.prototype.shopStorefrontMessage = null;

        /**
         * InteractiveMessage collectionMessage.
         * @member {proto.ICollectionMessage|null|undefined} collectionMessage
         * @memberof proto.InteractiveMessage
         * @instance
         */
        InteractiveMessage.prototype.collectionMessage = null;

        /**
         * InteractiveMessage nativeFlowMessage.
         * @member {proto.INativeFlowMessage|null|undefined} nativeFlowMessage
         * @memberof proto.InteractiveMessage
         * @instance
         */
        InteractiveMessage.prototype.nativeFlowMessage = null;

        // OneOf field names bound to virtual getters and setters
        var $oneOfFields;

        /**
         * InteractiveMessage interactiveMessage.
         * @member {"shopStorefrontMessage"|"collectionMessage"|"nativeFlowMessage"|undefined} interactiveMessage
         * @memberof proto.InteractiveMessage
         * @instance
         */
        Object.defineProperty(InteractiveMessage.prototype, "interactiveMessage", {
            get: $util.oneOfGetter($oneOfFields = ["shopStorefrontMessage", "collectionMessage", "nativeFlowMessage"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new InteractiveMessage instance using the specified properties.
         * @function create
         * @memberof proto.InteractiveMessage
         * @static
         * @param {proto.IInteractiveMessage=} [properties] Properties to set
         * @returns {proto.InteractiveMessage} InteractiveMessage instance
         */
        InteractiveMessage.create = function create(properties) {
            return new InteractiveMessage(properties);
        };

        /**
         * Encodes the specified InteractiveMessage message. Does not implicitly {@link proto.InteractiveMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.InteractiveMessage
         * @static
         * @param {proto.IInteractiveMessage} message InteractiveMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        InteractiveMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.header != null && Object.hasOwnProperty.call(message, "header"))
                $root.proto.Header.encode(message.header, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.body != null && Object.hasOwnProperty.call(message, "body"))
                $root.proto.InteractiveMessageBody.encode(message.body, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.footer != null && Object.hasOwnProperty.call(message, "footer"))
                $root.proto.Footer.encode(message.footer, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            if (message.shopStorefrontMessage != null && Object.hasOwnProperty.call(message, "shopStorefrontMessage"))
                $root.proto.ShopMessage.encode(message.shopStorefrontMessage, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
            if (message.collectionMessage != null && Object.hasOwnProperty.call(message, "collectionMessage"))
                $root.proto.CollectionMessage.encode(message.collectionMessage, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
            if (message.nativeFlowMessage != null && Object.hasOwnProperty.call(message, "nativeFlowMessage"))
                $root.proto.NativeFlowMessage.encode(message.nativeFlowMessage, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
            if (message.contextInfo != null && Object.hasOwnProperty.call(message, "contextInfo"))
                $root.proto.ContextInfo.encode(message.contextInfo, writer.uint32(/* id 15, wireType 2 =*/122).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified InteractiveMessage message, length delimited. Does not implicitly {@link proto.InteractiveMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.InteractiveMessage
         * @static
         * @param {proto.IInteractiveMessage} message InteractiveMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        InteractiveMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an InteractiveMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.InteractiveMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.InteractiveMessage} InteractiveMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        InteractiveMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.InteractiveMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.header = $root.proto.Header.decode(reader, reader.uint32());
                    break;
                case 2:
                    message.body = $root.proto.InteractiveMessageBody.decode(reader, reader.uint32());
                    break;
                case 3:
                    message.footer = $root.proto.Footer.decode(reader, reader.uint32());
                    break;
                case 15:
                    message.contextInfo = $root.proto.ContextInfo.decode(reader, reader.uint32());
                    break;
                case 4:
                    message.shopStorefrontMessage = $root.proto.ShopMessage.decode(reader, reader.uint32());
                    break;
                case 5:
                    message.collectionMessage = $root.proto.CollectionMessage.decode(reader, reader.uint32());
                    break;
                case 6:
                    message.nativeFlowMessage = $root.proto.NativeFlowMessage.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an InteractiveMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.InteractiveMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.InteractiveMessage} InteractiveMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        InteractiveMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an InteractiveMessage message.
         * @function verify
         * @memberof proto.InteractiveMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        InteractiveMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            var properties = {};
            if (message.header != null && message.hasOwnProperty("header")) {
                var error = $root.proto.Header.verify(message.header);
                if (error)
                    return "header." + error;
            }
            if (message.body != null && message.hasOwnProperty("body")) {
                var error = $root.proto.InteractiveMessageBody.verify(message.body);
                if (error)
                    return "body." + error;
            }
            if (message.footer != null && message.hasOwnProperty("footer")) {
                var error = $root.proto.Footer.verify(message.footer);
                if (error)
                    return "footer." + error;
            }
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo")) {
                var error = $root.proto.ContextInfo.verify(message.contextInfo);
                if (error)
                    return "contextInfo." + error;
            }
            if (message.shopStorefrontMessage != null && message.hasOwnProperty("shopStorefrontMessage")) {
                properties.interactiveMessage = 1;
                {
                    var error = $root.proto.ShopMessage.verify(message.shopStorefrontMessage);
                    if (error)
                        return "shopStorefrontMessage." + error;
                }
            }
            if (message.collectionMessage != null && message.hasOwnProperty("collectionMessage")) {
                if (properties.interactiveMessage === 1)
                    return "interactiveMessage: multiple values";
                properties.interactiveMessage = 1;
                {
                    var error = $root.proto.CollectionMessage.verify(message.collectionMessage);
                    if (error)
                        return "collectionMessage." + error;
                }
            }
            if (message.nativeFlowMessage != null && message.hasOwnProperty("nativeFlowMessage")) {
                if (properties.interactiveMessage === 1)
                    return "interactiveMessage: multiple values";
                properties.interactiveMessage = 1;
                {
                    var error = $root.proto.NativeFlowMessage.verify(message.nativeFlowMessage);
                    if (error)
                        return "nativeFlowMessage." + error;
                }
            }
            return null;
        };

        /**
         * Creates an InteractiveMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.InteractiveMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.InteractiveMessage} InteractiveMessage
         */
        InteractiveMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.InteractiveMessage)
                return object;
            var message = new $root.proto.InteractiveMessage();
            if (object.header != null) {
                if (typeof object.header !== "object")
                    throw TypeError(".proto.InteractiveMessage.header: object expected");
                message.header = $root.proto.Header.fromObject(object.header);
            }
            if (object.body != null) {
                if (typeof object.body !== "object")
                    throw TypeError(".proto.InteractiveMessage.body: object expected");
                message.body = $root.proto.InteractiveMessageBody.fromObject(object.body);
            }
            if (object.footer != null) {
                if (typeof object.footer !== "object")
                    throw TypeError(".proto.InteractiveMessage.footer: object expected");
                message.footer = $root.proto.Footer.fromObject(object.footer);
            }
            if (object.contextInfo != null) {
                if (typeof object.contextInfo !== "object")
                    throw TypeError(".proto.InteractiveMessage.contextInfo: object expected");
                message.contextInfo = $root.proto.ContextInfo.fromObject(object.contextInfo);
            }
            if (object.shopStorefrontMessage != null) {
                if (typeof object.shopStorefrontMessage !== "object")
                    throw TypeError(".proto.InteractiveMessage.shopStorefrontMessage: object expected");
                message.shopStorefrontMessage = $root.proto.ShopMessage.fromObject(object.shopStorefrontMessage);
            }
            if (object.collectionMessage != null) {
                if (typeof object.collectionMessage !== "object")
                    throw TypeError(".proto.InteractiveMessage.collectionMessage: object expected");
                message.collectionMessage = $root.proto.CollectionMessage.fromObject(object.collectionMessage);
            }
            if (object.nativeFlowMessage != null) {
                if (typeof object.nativeFlowMessage !== "object")
                    throw TypeError(".proto.InteractiveMessage.nativeFlowMessage: object expected");
                message.nativeFlowMessage = $root.proto.NativeFlowMessage.fromObject(object.nativeFlowMessage);
            }
            return message;
        };

        /**
         * Creates a plain object from an InteractiveMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.InteractiveMessage
         * @static
         * @param {proto.InteractiveMessage} message InteractiveMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        InteractiveMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.header = null;
                object.body = null;
                object.footer = null;
                object.contextInfo = null;
            }
            if (message.header != null && message.hasOwnProperty("header"))
                object.header = $root.proto.Header.toObject(message.header, options);
            if (message.body != null && message.hasOwnProperty("body"))
                object.body = $root.proto.InteractiveMessageBody.toObject(message.body, options);
            if (message.footer != null && message.hasOwnProperty("footer"))
                object.footer = $root.proto.Footer.toObject(message.footer, options);
            if (message.shopStorefrontMessage != null && message.hasOwnProperty("shopStorefrontMessage")) {
                object.shopStorefrontMessage = $root.proto.ShopMessage.toObject(message.shopStorefrontMessage, options);
                if (options.oneofs)
                    object.interactiveMessage = "shopStorefrontMessage";
            }
            if (message.collectionMessage != null && message.hasOwnProperty("collectionMessage")) {
                object.collectionMessage = $root.proto.CollectionMessage.toObject(message.collectionMessage, options);
                if (options.oneofs)
                    object.interactiveMessage = "collectionMessage";
            }
            if (message.nativeFlowMessage != null && message.hasOwnProperty("nativeFlowMessage")) {
                object.nativeFlowMessage = $root.proto.NativeFlowMessage.toObject(message.nativeFlowMessage, options);
                if (options.oneofs)
                    object.interactiveMessage = "nativeFlowMessage";
            }
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo"))
                object.contextInfo = $root.proto.ContextInfo.toObject(message.contextInfo, options);
            return object;
        };

        /**
         * Converts this InteractiveMessage to JSON.
         * @function toJSON
         * @memberof proto.InteractiveMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        InteractiveMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return InteractiveMessage;
    })();

    proto.InteractiveMessageBody = (function() {

        /**
         * Properties of an InteractiveMessageBody.
         * @memberof proto
         * @interface IInteractiveMessageBody
         * @property {string|null} [text] InteractiveMessageBody text
         */

        /**
         * Constructs a new InteractiveMessageBody.
         * @memberof proto
         * @classdesc Represents an InteractiveMessageBody.
         * @implements IInteractiveMessageBody
         * @constructor
         * @param {proto.IInteractiveMessageBody=} [properties] Properties to set
         */
        function InteractiveMessageBody(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * InteractiveMessageBody text.
         * @member {string} text
         * @memberof proto.InteractiveMessageBody
         * @instance
         */
        InteractiveMessageBody.prototype.text = "";

        /**
         * Creates a new InteractiveMessageBody instance using the specified properties.
         * @function create
         * @memberof proto.InteractiveMessageBody
         * @static
         * @param {proto.IInteractiveMessageBody=} [properties] Properties to set
         * @returns {proto.InteractiveMessageBody} InteractiveMessageBody instance
         */
        InteractiveMessageBody.create = function create(properties) {
            return new InteractiveMessageBody(properties);
        };

        /**
         * Encodes the specified InteractiveMessageBody message. Does not implicitly {@link proto.InteractiveMessageBody.verify|verify} messages.
         * @function encode
         * @memberof proto.InteractiveMessageBody
         * @static
         * @param {proto.IInteractiveMessageBody} message InteractiveMessageBody message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        InteractiveMessageBody.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.text != null && Object.hasOwnProperty.call(message, "text"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.text);
            return writer;
        };

        /**
         * Encodes the specified InteractiveMessageBody message, length delimited. Does not implicitly {@link proto.InteractiveMessageBody.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.InteractiveMessageBody
         * @static
         * @param {proto.IInteractiveMessageBody} message InteractiveMessageBody message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        InteractiveMessageBody.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an InteractiveMessageBody message from the specified reader or buffer.
         * @function decode
         * @memberof proto.InteractiveMessageBody
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.InteractiveMessageBody} InteractiveMessageBody
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        InteractiveMessageBody.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.InteractiveMessageBody();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.text = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an InteractiveMessageBody message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.InteractiveMessageBody
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.InteractiveMessageBody} InteractiveMessageBody
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        InteractiveMessageBody.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an InteractiveMessageBody message.
         * @function verify
         * @memberof proto.InteractiveMessageBody
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        InteractiveMessageBody.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.text != null && message.hasOwnProperty("text"))
                if (!$util.isString(message.text))
                    return "text: string expected";
            return null;
        };

        /**
         * Creates an InteractiveMessageBody message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.InteractiveMessageBody
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.InteractiveMessageBody} InteractiveMessageBody
         */
        InteractiveMessageBody.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.InteractiveMessageBody)
                return object;
            var message = new $root.proto.InteractiveMessageBody();
            if (object.text != null)
                message.text = String(object.text);
            return message;
        };

        /**
         * Creates a plain object from an InteractiveMessageBody message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.InteractiveMessageBody
         * @static
         * @param {proto.InteractiveMessageBody} message InteractiveMessageBody
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        InteractiveMessageBody.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.text = "";
            if (message.text != null && message.hasOwnProperty("text"))
                object.text = message.text;
            return object;
        };

        /**
         * Converts this InteractiveMessageBody to JSON.
         * @function toJSON
         * @memberof proto.InteractiveMessageBody
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        InteractiveMessageBody.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return InteractiveMessageBody;
    })();

    proto.InteractiveResponseMessage = (function() {

        /**
         * Properties of an InteractiveResponseMessage.
         * @memberof proto
         * @interface IInteractiveResponseMessage
         * @property {proto.IInteractiveResponseMessageBody|null} [body] InteractiveResponseMessage body
         * @property {proto.IContextInfo|null} [contextInfo] InteractiveResponseMessage contextInfo
         * @property {proto.INativeFlowResponseMessage|null} [nativeFlowResponseMessage] InteractiveResponseMessage nativeFlowResponseMessage
         */

        /**
         * Constructs a new InteractiveResponseMessage.
         * @memberof proto
         * @classdesc Represents an InteractiveResponseMessage.
         * @implements IInteractiveResponseMessage
         * @constructor
         * @param {proto.IInteractiveResponseMessage=} [properties] Properties to set
         */
        function InteractiveResponseMessage(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * InteractiveResponseMessage body.
         * @member {proto.IInteractiveResponseMessageBody|null|undefined} body
         * @memberof proto.InteractiveResponseMessage
         * @instance
         */
        InteractiveResponseMessage.prototype.body = null;

        /**
         * InteractiveResponseMessage contextInfo.
         * @member {proto.IContextInfo|null|undefined} contextInfo
         * @memberof proto.InteractiveResponseMessage
         * @instance
         */
        InteractiveResponseMessage.prototype.contextInfo = null;

        /**
         * InteractiveResponseMessage nativeFlowResponseMessage.
         * @member {proto.INativeFlowResponseMessage|null|undefined} nativeFlowResponseMessage
         * @memberof proto.InteractiveResponseMessage
         * @instance
         */
        InteractiveResponseMessage.prototype.nativeFlowResponseMessage = null;

        // OneOf field names bound to virtual getters and setters
        var $oneOfFields;

        /**
         * InteractiveResponseMessage interactiveResponseMessage.
         * @member {"nativeFlowResponseMessage"|undefined} interactiveResponseMessage
         * @memberof proto.InteractiveResponseMessage
         * @instance
         */
        Object.defineProperty(InteractiveResponseMessage.prototype, "interactiveResponseMessage", {
            get: $util.oneOfGetter($oneOfFields = ["nativeFlowResponseMessage"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new InteractiveResponseMessage instance using the specified properties.
         * @function create
         * @memberof proto.InteractiveResponseMessage
         * @static
         * @param {proto.IInteractiveResponseMessage=} [properties] Properties to set
         * @returns {proto.InteractiveResponseMessage} InteractiveResponseMessage instance
         */
        InteractiveResponseMessage.create = function create(properties) {
            return new InteractiveResponseMessage(properties);
        };

        /**
         * Encodes the specified InteractiveResponseMessage message. Does not implicitly {@link proto.InteractiveResponseMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.InteractiveResponseMessage
         * @static
         * @param {proto.IInteractiveResponseMessage} message InteractiveResponseMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        InteractiveResponseMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.body != null && Object.hasOwnProperty.call(message, "body"))
                $root.proto.InteractiveResponseMessageBody.encode(message.body, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.nativeFlowResponseMessage != null && Object.hasOwnProperty.call(message, "nativeFlowResponseMessage"))
                $root.proto.NativeFlowResponseMessage.encode(message.nativeFlowResponseMessage, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.contextInfo != null && Object.hasOwnProperty.call(message, "contextInfo"))
                $root.proto.ContextInfo.encode(message.contextInfo, writer.uint32(/* id 15, wireType 2 =*/122).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified InteractiveResponseMessage message, length delimited. Does not implicitly {@link proto.InteractiveResponseMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.InteractiveResponseMessage
         * @static
         * @param {proto.IInteractiveResponseMessage} message InteractiveResponseMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        InteractiveResponseMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an InteractiveResponseMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.InteractiveResponseMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.InteractiveResponseMessage} InteractiveResponseMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        InteractiveResponseMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.InteractiveResponseMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.body = $root.proto.InteractiveResponseMessageBody.decode(reader, reader.uint32());
                    break;
                case 15:
                    message.contextInfo = $root.proto.ContextInfo.decode(reader, reader.uint32());
                    break;
                case 2:
                    message.nativeFlowResponseMessage = $root.proto.NativeFlowResponseMessage.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an InteractiveResponseMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.InteractiveResponseMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.InteractiveResponseMessage} InteractiveResponseMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        InteractiveResponseMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an InteractiveResponseMessage message.
         * @function verify
         * @memberof proto.InteractiveResponseMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        InteractiveResponseMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            var properties = {};
            if (message.body != null && message.hasOwnProperty("body")) {
                var error = $root.proto.InteractiveResponseMessageBody.verify(message.body);
                if (error)
                    return "body." + error;
            }
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo")) {
                var error = $root.proto.ContextInfo.verify(message.contextInfo);
                if (error)
                    return "contextInfo." + error;
            }
            if (message.nativeFlowResponseMessage != null && message.hasOwnProperty("nativeFlowResponseMessage")) {
                properties.interactiveResponseMessage = 1;
                {
                    var error = $root.proto.NativeFlowResponseMessage.verify(message.nativeFlowResponseMessage);
                    if (error)
                        return "nativeFlowResponseMessage." + error;
                }
            }
            return null;
        };

        /**
         * Creates an InteractiveResponseMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.InteractiveResponseMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.InteractiveResponseMessage} InteractiveResponseMessage
         */
        InteractiveResponseMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.InteractiveResponseMessage)
                return object;
            var message = new $root.proto.InteractiveResponseMessage();
            if (object.body != null) {
                if (typeof object.body !== "object")
                    throw TypeError(".proto.InteractiveResponseMessage.body: object expected");
                message.body = $root.proto.InteractiveResponseMessageBody.fromObject(object.body);
            }
            if (object.contextInfo != null) {
                if (typeof object.contextInfo !== "object")
                    throw TypeError(".proto.InteractiveResponseMessage.contextInfo: object expected");
                message.contextInfo = $root.proto.ContextInfo.fromObject(object.contextInfo);
            }
            if (object.nativeFlowResponseMessage != null) {
                if (typeof object.nativeFlowResponseMessage !== "object")
                    throw TypeError(".proto.InteractiveResponseMessage.nativeFlowResponseMessage: object expected");
                message.nativeFlowResponseMessage = $root.proto.NativeFlowResponseMessage.fromObject(object.nativeFlowResponseMessage);
            }
            return message;
        };

        /**
         * Creates a plain object from an InteractiveResponseMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.InteractiveResponseMessage
         * @static
         * @param {proto.InteractiveResponseMessage} message InteractiveResponseMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        InteractiveResponseMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.body = null;
                object.contextInfo = null;
            }
            if (message.body != null && message.hasOwnProperty("body"))
                object.body = $root.proto.InteractiveResponseMessageBody.toObject(message.body, options);
            if (message.nativeFlowResponseMessage != null && message.hasOwnProperty("nativeFlowResponseMessage")) {
                object.nativeFlowResponseMessage = $root.proto.NativeFlowResponseMessage.toObject(message.nativeFlowResponseMessage, options);
                if (options.oneofs)
                    object.interactiveResponseMessage = "nativeFlowResponseMessage";
            }
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo"))
                object.contextInfo = $root.proto.ContextInfo.toObject(message.contextInfo, options);
            return object;
        };

        /**
         * Converts this InteractiveResponseMessage to JSON.
         * @function toJSON
         * @memberof proto.InteractiveResponseMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        InteractiveResponseMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return InteractiveResponseMessage;
    })();

    proto.InteractiveResponseMessageBody = (function() {

        /**
         * Properties of an InteractiveResponseMessageBody.
         * @memberof proto
         * @interface IInteractiveResponseMessageBody
         * @property {string|null} [text] InteractiveResponseMessageBody text
         */

        /**
         * Constructs a new InteractiveResponseMessageBody.
         * @memberof proto
         * @classdesc Represents an InteractiveResponseMessageBody.
         * @implements IInteractiveResponseMessageBody
         * @constructor
         * @param {proto.IInteractiveResponseMessageBody=} [properties] Properties to set
         */
        function InteractiveResponseMessageBody(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * InteractiveResponseMessageBody text.
         * @member {string} text
         * @memberof proto.InteractiveResponseMessageBody
         * @instance
         */
        InteractiveResponseMessageBody.prototype.text = "";

        /**
         * Creates a new InteractiveResponseMessageBody instance using the specified properties.
         * @function create
         * @memberof proto.InteractiveResponseMessageBody
         * @static
         * @param {proto.IInteractiveResponseMessageBody=} [properties] Properties to set
         * @returns {proto.InteractiveResponseMessageBody} InteractiveResponseMessageBody instance
         */
        InteractiveResponseMessageBody.create = function create(properties) {
            return new InteractiveResponseMessageBody(properties);
        };

        /**
         * Encodes the specified InteractiveResponseMessageBody message. Does not implicitly {@link proto.InteractiveResponseMessageBody.verify|verify} messages.
         * @function encode
         * @memberof proto.InteractiveResponseMessageBody
         * @static
         * @param {proto.IInteractiveResponseMessageBody} message InteractiveResponseMessageBody message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        InteractiveResponseMessageBody.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.text != null && Object.hasOwnProperty.call(message, "text"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.text);
            return writer;
        };

        /**
         * Encodes the specified InteractiveResponseMessageBody message, length delimited. Does not implicitly {@link proto.InteractiveResponseMessageBody.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.InteractiveResponseMessageBody
         * @static
         * @param {proto.IInteractiveResponseMessageBody} message InteractiveResponseMessageBody message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        InteractiveResponseMessageBody.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an InteractiveResponseMessageBody message from the specified reader or buffer.
         * @function decode
         * @memberof proto.InteractiveResponseMessageBody
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.InteractiveResponseMessageBody} InteractiveResponseMessageBody
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        InteractiveResponseMessageBody.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.InteractiveResponseMessageBody();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.text = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an InteractiveResponseMessageBody message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.InteractiveResponseMessageBody
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.InteractiveResponseMessageBody} InteractiveResponseMessageBody
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        InteractiveResponseMessageBody.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an InteractiveResponseMessageBody message.
         * @function verify
         * @memberof proto.InteractiveResponseMessageBody
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        InteractiveResponseMessageBody.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.text != null && message.hasOwnProperty("text"))
                if (!$util.isString(message.text))
                    return "text: string expected";
            return null;
        };

        /**
         * Creates an InteractiveResponseMessageBody message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.InteractiveResponseMessageBody
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.InteractiveResponseMessageBody} InteractiveResponseMessageBody
         */
        InteractiveResponseMessageBody.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.InteractiveResponseMessageBody)
                return object;
            var message = new $root.proto.InteractiveResponseMessageBody();
            if (object.text != null)
                message.text = String(object.text);
            return message;
        };

        /**
         * Creates a plain object from an InteractiveResponseMessageBody message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.InteractiveResponseMessageBody
         * @static
         * @param {proto.InteractiveResponseMessageBody} message InteractiveResponseMessageBody
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        InteractiveResponseMessageBody.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.text = "";
            if (message.text != null && message.hasOwnProperty("text"))
                object.text = message.text;
            return object;
        };

        /**
         * Converts this InteractiveResponseMessageBody to JSON.
         * @function toJSON
         * @memberof proto.InteractiveResponseMessageBody
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        InteractiveResponseMessageBody.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return InteractiveResponseMessageBody;
    })();

    proto.InvoiceMessage = (function() {

        /**
         * Properties of an InvoiceMessage.
         * @memberof proto
         * @interface IInvoiceMessage
         * @property {string|null} [note] InvoiceMessage note
         * @property {string|null} [token] InvoiceMessage token
         * @property {proto.InvoiceMessage.InvoiceMessageAttachmentType|null} [attachmentType] InvoiceMessage attachmentType
         * @property {string|null} [attachmentMimetype] InvoiceMessage attachmentMimetype
         * @property {Uint8Array|null} [attachmentMediaKey] InvoiceMessage attachmentMediaKey
         * @property {number|Long|null} [attachmentMediaKeyTimestamp] InvoiceMessage attachmentMediaKeyTimestamp
         * @property {Uint8Array|null} [attachmentFileSha256] InvoiceMessage attachmentFileSha256
         * @property {Uint8Array|null} [attachmentFileEncSha256] InvoiceMessage attachmentFileEncSha256
         * @property {string|null} [attachmentDirectPath] InvoiceMessage attachmentDirectPath
         * @property {Uint8Array|null} [attachmentJpegThumbnail] InvoiceMessage attachmentJpegThumbnail
         */

        /**
         * Constructs a new InvoiceMessage.
         * @memberof proto
         * @classdesc Represents an InvoiceMessage.
         * @implements IInvoiceMessage
         * @constructor
         * @param {proto.IInvoiceMessage=} [properties] Properties to set
         */
        function InvoiceMessage(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * InvoiceMessage note.
         * @member {string} note
         * @memberof proto.InvoiceMessage
         * @instance
         */
        InvoiceMessage.prototype.note = "";

        /**
         * InvoiceMessage token.
         * @member {string} token
         * @memberof proto.InvoiceMessage
         * @instance
         */
        InvoiceMessage.prototype.token = "";

        /**
         * InvoiceMessage attachmentType.
         * @member {proto.InvoiceMessage.InvoiceMessageAttachmentType} attachmentType
         * @memberof proto.InvoiceMessage
         * @instance
         */
        InvoiceMessage.prototype.attachmentType = 0;

        /**
         * InvoiceMessage attachmentMimetype.
         * @member {string} attachmentMimetype
         * @memberof proto.InvoiceMessage
         * @instance
         */
        InvoiceMessage.prototype.attachmentMimetype = "";

        /**
         * InvoiceMessage attachmentMediaKey.
         * @member {Uint8Array} attachmentMediaKey
         * @memberof proto.InvoiceMessage
         * @instance
         */
        InvoiceMessage.prototype.attachmentMediaKey = $util.newBuffer([]);

        /**
         * InvoiceMessage attachmentMediaKeyTimestamp.
         * @member {number|Long} attachmentMediaKeyTimestamp
         * @memberof proto.InvoiceMessage
         * @instance
         */
        InvoiceMessage.prototype.attachmentMediaKeyTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * InvoiceMessage attachmentFileSha256.
         * @member {Uint8Array} attachmentFileSha256
         * @memberof proto.InvoiceMessage
         * @instance
         */
        InvoiceMessage.prototype.attachmentFileSha256 = $util.newBuffer([]);

        /**
         * InvoiceMessage attachmentFileEncSha256.
         * @member {Uint8Array} attachmentFileEncSha256
         * @memberof proto.InvoiceMessage
         * @instance
         */
        InvoiceMessage.prototype.attachmentFileEncSha256 = $util.newBuffer([]);

        /**
         * InvoiceMessage attachmentDirectPath.
         * @member {string} attachmentDirectPath
         * @memberof proto.InvoiceMessage
         * @instance
         */
        InvoiceMessage.prototype.attachmentDirectPath = "";

        /**
         * InvoiceMessage attachmentJpegThumbnail.
         * @member {Uint8Array} attachmentJpegThumbnail
         * @memberof proto.InvoiceMessage
         * @instance
         */
        InvoiceMessage.prototype.attachmentJpegThumbnail = $util.newBuffer([]);

        /**
         * Creates a new InvoiceMessage instance using the specified properties.
         * @function create
         * @memberof proto.InvoiceMessage
         * @static
         * @param {proto.IInvoiceMessage=} [properties] Properties to set
         * @returns {proto.InvoiceMessage} InvoiceMessage instance
         */
        InvoiceMessage.create = function create(properties) {
            return new InvoiceMessage(properties);
        };

        /**
         * Encodes the specified InvoiceMessage message. Does not implicitly {@link proto.InvoiceMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.InvoiceMessage
         * @static
         * @param {proto.IInvoiceMessage} message InvoiceMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        InvoiceMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.note != null && Object.hasOwnProperty.call(message, "note"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.note);
            if (message.token != null && Object.hasOwnProperty.call(message, "token"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.token);
            if (message.attachmentType != null && Object.hasOwnProperty.call(message, "attachmentType"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.attachmentType);
            if (message.attachmentMimetype != null && Object.hasOwnProperty.call(message, "attachmentMimetype"))
                writer.uint32(/* id 4, wireType 2 =*/34).string(message.attachmentMimetype);
            if (message.attachmentMediaKey != null && Object.hasOwnProperty.call(message, "attachmentMediaKey"))
                writer.uint32(/* id 5, wireType 2 =*/42).bytes(message.attachmentMediaKey);
            if (message.attachmentMediaKeyTimestamp != null && Object.hasOwnProperty.call(message, "attachmentMediaKeyTimestamp"))
                writer.uint32(/* id 6, wireType 0 =*/48).int64(message.attachmentMediaKeyTimestamp);
            if (message.attachmentFileSha256 != null && Object.hasOwnProperty.call(message, "attachmentFileSha256"))
                writer.uint32(/* id 7, wireType 2 =*/58).bytes(message.attachmentFileSha256);
            if (message.attachmentFileEncSha256 != null && Object.hasOwnProperty.call(message, "attachmentFileEncSha256"))
                writer.uint32(/* id 8, wireType 2 =*/66).bytes(message.attachmentFileEncSha256);
            if (message.attachmentDirectPath != null && Object.hasOwnProperty.call(message, "attachmentDirectPath"))
                writer.uint32(/* id 9, wireType 2 =*/74).string(message.attachmentDirectPath);
            if (message.attachmentJpegThumbnail != null && Object.hasOwnProperty.call(message, "attachmentJpegThumbnail"))
                writer.uint32(/* id 10, wireType 2 =*/82).bytes(message.attachmentJpegThumbnail);
            return writer;
        };

        /**
         * Encodes the specified InvoiceMessage message, length delimited. Does not implicitly {@link proto.InvoiceMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.InvoiceMessage
         * @static
         * @param {proto.IInvoiceMessage} message InvoiceMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        InvoiceMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an InvoiceMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.InvoiceMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.InvoiceMessage} InvoiceMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        InvoiceMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.InvoiceMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.note = reader.string();
                    break;
                case 2:
                    message.token = reader.string();
                    break;
                case 3:
                    message.attachmentType = reader.int32();
                    break;
                case 4:
                    message.attachmentMimetype = reader.string();
                    break;
                case 5:
                    message.attachmentMediaKey = reader.bytes();
                    break;
                case 6:
                    message.attachmentMediaKeyTimestamp = reader.int64();
                    break;
                case 7:
                    message.attachmentFileSha256 = reader.bytes();
                    break;
                case 8:
                    message.attachmentFileEncSha256 = reader.bytes();
                    break;
                case 9:
                    message.attachmentDirectPath = reader.string();
                    break;
                case 10:
                    message.attachmentJpegThumbnail = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an InvoiceMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.InvoiceMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.InvoiceMessage} InvoiceMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        InvoiceMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an InvoiceMessage message.
         * @function verify
         * @memberof proto.InvoiceMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        InvoiceMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.note != null && message.hasOwnProperty("note"))
                if (!$util.isString(message.note))
                    return "note: string expected";
            if (message.token != null && message.hasOwnProperty("token"))
                if (!$util.isString(message.token))
                    return "token: string expected";
            if (message.attachmentType != null && message.hasOwnProperty("attachmentType"))
                switch (message.attachmentType) {
                default:
                    return "attachmentType: enum value expected";
                case 0:
                case 1:
                    break;
                }
            if (message.attachmentMimetype != null && message.hasOwnProperty("attachmentMimetype"))
                if (!$util.isString(message.attachmentMimetype))
                    return "attachmentMimetype: string expected";
            if (message.attachmentMediaKey != null && message.hasOwnProperty("attachmentMediaKey"))
                if (!(message.attachmentMediaKey && typeof message.attachmentMediaKey.length === "number" || $util.isString(message.attachmentMediaKey)))
                    return "attachmentMediaKey: buffer expected";
            if (message.attachmentMediaKeyTimestamp != null && message.hasOwnProperty("attachmentMediaKeyTimestamp"))
                if (!$util.isInteger(message.attachmentMediaKeyTimestamp) && !(message.attachmentMediaKeyTimestamp && $util.isInteger(message.attachmentMediaKeyTimestamp.low) && $util.isInteger(message.attachmentMediaKeyTimestamp.high)))
                    return "attachmentMediaKeyTimestamp: integer|Long expected";
            if (message.attachmentFileSha256 != null && message.hasOwnProperty("attachmentFileSha256"))
                if (!(message.attachmentFileSha256 && typeof message.attachmentFileSha256.length === "number" || $util.isString(message.attachmentFileSha256)))
                    return "attachmentFileSha256: buffer expected";
            if (message.attachmentFileEncSha256 != null && message.hasOwnProperty("attachmentFileEncSha256"))
                if (!(message.attachmentFileEncSha256 && typeof message.attachmentFileEncSha256.length === "number" || $util.isString(message.attachmentFileEncSha256)))
                    return "attachmentFileEncSha256: buffer expected";
            if (message.attachmentDirectPath != null && message.hasOwnProperty("attachmentDirectPath"))
                if (!$util.isString(message.attachmentDirectPath))
                    return "attachmentDirectPath: string expected";
            if (message.attachmentJpegThumbnail != null && message.hasOwnProperty("attachmentJpegThumbnail"))
                if (!(message.attachmentJpegThumbnail && typeof message.attachmentJpegThumbnail.length === "number" || $util.isString(message.attachmentJpegThumbnail)))
                    return "attachmentJpegThumbnail: buffer expected";
            return null;
        };

        /**
         * Creates an InvoiceMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.InvoiceMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.InvoiceMessage} InvoiceMessage
         */
        InvoiceMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.InvoiceMessage)
                return object;
            var message = new $root.proto.InvoiceMessage();
            if (object.note != null)
                message.note = String(object.note);
            if (object.token != null)
                message.token = String(object.token);
            switch (object.attachmentType) {
            case "IMAGE":
            case 0:
                message.attachmentType = 0;
                break;
            case "PDF":
            case 1:
                message.attachmentType = 1;
                break;
            }
            if (object.attachmentMimetype != null)
                message.attachmentMimetype = String(object.attachmentMimetype);
            if (object.attachmentMediaKey != null)
                if (typeof object.attachmentMediaKey === "string")
                    $util.base64.decode(object.attachmentMediaKey, message.attachmentMediaKey = $util.newBuffer($util.base64.length(object.attachmentMediaKey)), 0);
                else if (object.attachmentMediaKey.length)
                    message.attachmentMediaKey = object.attachmentMediaKey;
            if (object.attachmentMediaKeyTimestamp != null)
                if ($util.Long)
                    (message.attachmentMediaKeyTimestamp = $util.Long.fromValue(object.attachmentMediaKeyTimestamp)).unsigned = false;
                else if (typeof object.attachmentMediaKeyTimestamp === "string")
                    message.attachmentMediaKeyTimestamp = parseInt(object.attachmentMediaKeyTimestamp, 10);
                else if (typeof object.attachmentMediaKeyTimestamp === "number")
                    message.attachmentMediaKeyTimestamp = object.attachmentMediaKeyTimestamp;
                else if (typeof object.attachmentMediaKeyTimestamp === "object")
                    message.attachmentMediaKeyTimestamp = new $util.LongBits(object.attachmentMediaKeyTimestamp.low >>> 0, object.attachmentMediaKeyTimestamp.high >>> 0).toNumber();
            if (object.attachmentFileSha256 != null)
                if (typeof object.attachmentFileSha256 === "string")
                    $util.base64.decode(object.attachmentFileSha256, message.attachmentFileSha256 = $util.newBuffer($util.base64.length(object.attachmentFileSha256)), 0);
                else if (object.attachmentFileSha256.length)
                    message.attachmentFileSha256 = object.attachmentFileSha256;
            if (object.attachmentFileEncSha256 != null)
                if (typeof object.attachmentFileEncSha256 === "string")
                    $util.base64.decode(object.attachmentFileEncSha256, message.attachmentFileEncSha256 = $util.newBuffer($util.base64.length(object.attachmentFileEncSha256)), 0);
                else if (object.attachmentFileEncSha256.length)
                    message.attachmentFileEncSha256 = object.attachmentFileEncSha256;
            if (object.attachmentDirectPath != null)
                message.attachmentDirectPath = String(object.attachmentDirectPath);
            if (object.attachmentJpegThumbnail != null)
                if (typeof object.attachmentJpegThumbnail === "string")
                    $util.base64.decode(object.attachmentJpegThumbnail, message.attachmentJpegThumbnail = $util.newBuffer($util.base64.length(object.attachmentJpegThumbnail)), 0);
                else if (object.attachmentJpegThumbnail.length)
                    message.attachmentJpegThumbnail = object.attachmentJpegThumbnail;
            return message;
        };

        /**
         * Creates a plain object from an InvoiceMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.InvoiceMessage
         * @static
         * @param {proto.InvoiceMessage} message InvoiceMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        InvoiceMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.note = "";
                object.token = "";
                object.attachmentType = options.enums === String ? "IMAGE" : 0;
                object.attachmentMimetype = "";
                if (options.bytes === String)
                    object.attachmentMediaKey = "";
                else {
                    object.attachmentMediaKey = [];
                    if (options.bytes !== Array)
                        object.attachmentMediaKey = $util.newBuffer(object.attachmentMediaKey);
                }
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.attachmentMediaKeyTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.attachmentMediaKeyTimestamp = options.longs === String ? "0" : 0;
                if (options.bytes === String)
                    object.attachmentFileSha256 = "";
                else {
                    object.attachmentFileSha256 = [];
                    if (options.bytes !== Array)
                        object.attachmentFileSha256 = $util.newBuffer(object.attachmentFileSha256);
                }
                if (options.bytes === String)
                    object.attachmentFileEncSha256 = "";
                else {
                    object.attachmentFileEncSha256 = [];
                    if (options.bytes !== Array)
                        object.attachmentFileEncSha256 = $util.newBuffer(object.attachmentFileEncSha256);
                }
                object.attachmentDirectPath = "";
                if (options.bytes === String)
                    object.attachmentJpegThumbnail = "";
                else {
                    object.attachmentJpegThumbnail = [];
                    if (options.bytes !== Array)
                        object.attachmentJpegThumbnail = $util.newBuffer(object.attachmentJpegThumbnail);
                }
            }
            if (message.note != null && message.hasOwnProperty("note"))
                object.note = message.note;
            if (message.token != null && message.hasOwnProperty("token"))
                object.token = message.token;
            if (message.attachmentType != null && message.hasOwnProperty("attachmentType"))
                object.attachmentType = options.enums === String ? $root.proto.InvoiceMessage.InvoiceMessageAttachmentType[message.attachmentType] : message.attachmentType;
            if (message.attachmentMimetype != null && message.hasOwnProperty("attachmentMimetype"))
                object.attachmentMimetype = message.attachmentMimetype;
            if (message.attachmentMediaKey != null && message.hasOwnProperty("attachmentMediaKey"))
                object.attachmentMediaKey = options.bytes === String ? $util.base64.encode(message.attachmentMediaKey, 0, message.attachmentMediaKey.length) : options.bytes === Array ? Array.prototype.slice.call(message.attachmentMediaKey) : message.attachmentMediaKey;
            if (message.attachmentMediaKeyTimestamp != null && message.hasOwnProperty("attachmentMediaKeyTimestamp"))
                if (typeof message.attachmentMediaKeyTimestamp === "number")
                    object.attachmentMediaKeyTimestamp = options.longs === String ? String(message.attachmentMediaKeyTimestamp) : message.attachmentMediaKeyTimestamp;
                else
                    object.attachmentMediaKeyTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.attachmentMediaKeyTimestamp) : options.longs === Number ? new $util.LongBits(message.attachmentMediaKeyTimestamp.low >>> 0, message.attachmentMediaKeyTimestamp.high >>> 0).toNumber() : message.attachmentMediaKeyTimestamp;
            if (message.attachmentFileSha256 != null && message.hasOwnProperty("attachmentFileSha256"))
                object.attachmentFileSha256 = options.bytes === String ? $util.base64.encode(message.attachmentFileSha256, 0, message.attachmentFileSha256.length) : options.bytes === Array ? Array.prototype.slice.call(message.attachmentFileSha256) : message.attachmentFileSha256;
            if (message.attachmentFileEncSha256 != null && message.hasOwnProperty("attachmentFileEncSha256"))
                object.attachmentFileEncSha256 = options.bytes === String ? $util.base64.encode(message.attachmentFileEncSha256, 0, message.attachmentFileEncSha256.length) : options.bytes === Array ? Array.prototype.slice.call(message.attachmentFileEncSha256) : message.attachmentFileEncSha256;
            if (message.attachmentDirectPath != null && message.hasOwnProperty("attachmentDirectPath"))
                object.attachmentDirectPath = message.attachmentDirectPath;
            if (message.attachmentJpegThumbnail != null && message.hasOwnProperty("attachmentJpegThumbnail"))
                object.attachmentJpegThumbnail = options.bytes === String ? $util.base64.encode(message.attachmentJpegThumbnail, 0, message.attachmentJpegThumbnail.length) : options.bytes === Array ? Array.prototype.slice.call(message.attachmentJpegThumbnail) : message.attachmentJpegThumbnail;
            return object;
        };

        /**
         * Converts this InvoiceMessage to JSON.
         * @function toJSON
         * @memberof proto.InvoiceMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        InvoiceMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * InvoiceMessageAttachmentType enum.
         * @name proto.InvoiceMessage.InvoiceMessageAttachmentType
         * @enum {number}
         * @property {number} IMAGE=0 IMAGE value
         * @property {number} PDF=1 PDF value
         */
        InvoiceMessage.InvoiceMessageAttachmentType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "IMAGE"] = 0;
            values[valuesById[1] = "PDF"] = 1;
            return values;
        })();

        return InvoiceMessage;
    })();

    proto.ListMessage = (function() {

        /**
         * Properties of a ListMessage.
         * @memberof proto
         * @interface IListMessage
         * @property {string|null} [title] ListMessage title
         * @property {string|null} [description] ListMessage description
         * @property {string|null} [buttonText] ListMessage buttonText
         * @property {proto.ListMessage.ListMessageListType|null} [listType] ListMessage listType
         * @property {Array.<proto.ISection>|null} [sections] ListMessage sections
         * @property {proto.IProductListInfo|null} [productListInfo] ListMessage productListInfo
         * @property {string|null} [footerText] ListMessage footerText
         * @property {proto.IContextInfo|null} [contextInfo] ListMessage contextInfo
         */

        /**
         * Constructs a new ListMessage.
         * @memberof proto
         * @classdesc Represents a ListMessage.
         * @implements IListMessage
         * @constructor
         * @param {proto.IListMessage=} [properties] Properties to set
         */
        function ListMessage(properties) {
            this.sections = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ListMessage title.
         * @member {string} title
         * @memberof proto.ListMessage
         * @instance
         */
        ListMessage.prototype.title = "";

        /**
         * ListMessage description.
         * @member {string} description
         * @memberof proto.ListMessage
         * @instance
         */
        ListMessage.prototype.description = "";

        /**
         * ListMessage buttonText.
         * @member {string} buttonText
         * @memberof proto.ListMessage
         * @instance
         */
        ListMessage.prototype.buttonText = "";

        /**
         * ListMessage listType.
         * @member {proto.ListMessage.ListMessageListType} listType
         * @memberof proto.ListMessage
         * @instance
         */
        ListMessage.prototype.listType = 0;

        /**
         * ListMessage sections.
         * @member {Array.<proto.ISection>} sections
         * @memberof proto.ListMessage
         * @instance
         */
        ListMessage.prototype.sections = $util.emptyArray;

        /**
         * ListMessage productListInfo.
         * @member {proto.IProductListInfo|null|undefined} productListInfo
         * @memberof proto.ListMessage
         * @instance
         */
        ListMessage.prototype.productListInfo = null;

        /**
         * ListMessage footerText.
         * @member {string} footerText
         * @memberof proto.ListMessage
         * @instance
         */
        ListMessage.prototype.footerText = "";

        /**
         * ListMessage contextInfo.
         * @member {proto.IContextInfo|null|undefined} contextInfo
         * @memberof proto.ListMessage
         * @instance
         */
        ListMessage.prototype.contextInfo = null;

        /**
         * Creates a new ListMessage instance using the specified properties.
         * @function create
         * @memberof proto.ListMessage
         * @static
         * @param {proto.IListMessage=} [properties] Properties to set
         * @returns {proto.ListMessage} ListMessage instance
         */
        ListMessage.create = function create(properties) {
            return new ListMessage(properties);
        };

        /**
         * Encodes the specified ListMessage message. Does not implicitly {@link proto.ListMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.ListMessage
         * @static
         * @param {proto.IListMessage} message ListMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ListMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.title != null && Object.hasOwnProperty.call(message, "title"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.title);
            if (message.description != null && Object.hasOwnProperty.call(message, "description"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.description);
            if (message.buttonText != null && Object.hasOwnProperty.call(message, "buttonText"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.buttonText);
            if (message.listType != null && Object.hasOwnProperty.call(message, "listType"))
                writer.uint32(/* id 4, wireType 0 =*/32).int32(message.listType);
            if (message.sections != null && message.sections.length)
                for (var i = 0; i < message.sections.length; ++i)
                    $root.proto.Section.encode(message.sections[i], writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
            if (message.productListInfo != null && Object.hasOwnProperty.call(message, "productListInfo"))
                $root.proto.ProductListInfo.encode(message.productListInfo, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
            if (message.footerText != null && Object.hasOwnProperty.call(message, "footerText"))
                writer.uint32(/* id 7, wireType 2 =*/58).string(message.footerText);
            if (message.contextInfo != null && Object.hasOwnProperty.call(message, "contextInfo"))
                $root.proto.ContextInfo.encode(message.contextInfo, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified ListMessage message, length delimited. Does not implicitly {@link proto.ListMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ListMessage
         * @static
         * @param {proto.IListMessage} message ListMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ListMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ListMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ListMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ListMessage} ListMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ListMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ListMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.title = reader.string();
                    break;
                case 2:
                    message.description = reader.string();
                    break;
                case 3:
                    message.buttonText = reader.string();
                    break;
                case 4:
                    message.listType = reader.int32();
                    break;
                case 5:
                    if (!(message.sections && message.sections.length))
                        message.sections = [];
                    message.sections.push($root.proto.Section.decode(reader, reader.uint32()));
                    break;
                case 6:
                    message.productListInfo = $root.proto.ProductListInfo.decode(reader, reader.uint32());
                    break;
                case 7:
                    message.footerText = reader.string();
                    break;
                case 8:
                    message.contextInfo = $root.proto.ContextInfo.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ListMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ListMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ListMessage} ListMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ListMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ListMessage message.
         * @function verify
         * @memberof proto.ListMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ListMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.title != null && message.hasOwnProperty("title"))
                if (!$util.isString(message.title))
                    return "title: string expected";
            if (message.description != null && message.hasOwnProperty("description"))
                if (!$util.isString(message.description))
                    return "description: string expected";
            if (message.buttonText != null && message.hasOwnProperty("buttonText"))
                if (!$util.isString(message.buttonText))
                    return "buttonText: string expected";
            if (message.listType != null && message.hasOwnProperty("listType"))
                switch (message.listType) {
                default:
                    return "listType: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            if (message.sections != null && message.hasOwnProperty("sections")) {
                if (!Array.isArray(message.sections))
                    return "sections: array expected";
                for (var i = 0; i < message.sections.length; ++i) {
                    var error = $root.proto.Section.verify(message.sections[i]);
                    if (error)
                        return "sections." + error;
                }
            }
            if (message.productListInfo != null && message.hasOwnProperty("productListInfo")) {
                var error = $root.proto.ProductListInfo.verify(message.productListInfo);
                if (error)
                    return "productListInfo." + error;
            }
            if (message.footerText != null && message.hasOwnProperty("footerText"))
                if (!$util.isString(message.footerText))
                    return "footerText: string expected";
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo")) {
                var error = $root.proto.ContextInfo.verify(message.contextInfo);
                if (error)
                    return "contextInfo." + error;
            }
            return null;
        };

        /**
         * Creates a ListMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ListMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ListMessage} ListMessage
         */
        ListMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ListMessage)
                return object;
            var message = new $root.proto.ListMessage();
            if (object.title != null)
                message.title = String(object.title);
            if (object.description != null)
                message.description = String(object.description);
            if (object.buttonText != null)
                message.buttonText = String(object.buttonText);
            switch (object.listType) {
            case "UNKNOWN":
            case 0:
                message.listType = 0;
                break;
            case "SINGLE_SELECT":
            case 1:
                message.listType = 1;
                break;
            case "PRODUCT_LIST":
            case 2:
                message.listType = 2;
                break;
            }
            if (object.sections) {
                if (!Array.isArray(object.sections))
                    throw TypeError(".proto.ListMessage.sections: array expected");
                message.sections = [];
                for (var i = 0; i < object.sections.length; ++i) {
                    if (typeof object.sections[i] !== "object")
                        throw TypeError(".proto.ListMessage.sections: object expected");
                    message.sections[i] = $root.proto.Section.fromObject(object.sections[i]);
                }
            }
            if (object.productListInfo != null) {
                if (typeof object.productListInfo !== "object")
                    throw TypeError(".proto.ListMessage.productListInfo: object expected");
                message.productListInfo = $root.proto.ProductListInfo.fromObject(object.productListInfo);
            }
            if (object.footerText != null)
                message.footerText = String(object.footerText);
            if (object.contextInfo != null) {
                if (typeof object.contextInfo !== "object")
                    throw TypeError(".proto.ListMessage.contextInfo: object expected");
                message.contextInfo = $root.proto.ContextInfo.fromObject(object.contextInfo);
            }
            return message;
        };

        /**
         * Creates a plain object from a ListMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ListMessage
         * @static
         * @param {proto.ListMessage} message ListMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ListMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.sections = [];
            if (options.defaults) {
                object.title = "";
                object.description = "";
                object.buttonText = "";
                object.listType = options.enums === String ? "UNKNOWN" : 0;
                object.productListInfo = null;
                object.footerText = "";
                object.contextInfo = null;
            }
            if (message.title != null && message.hasOwnProperty("title"))
                object.title = message.title;
            if (message.description != null && message.hasOwnProperty("description"))
                object.description = message.description;
            if (message.buttonText != null && message.hasOwnProperty("buttonText"))
                object.buttonText = message.buttonText;
            if (message.listType != null && message.hasOwnProperty("listType"))
                object.listType = options.enums === String ? $root.proto.ListMessage.ListMessageListType[message.listType] : message.listType;
            if (message.sections && message.sections.length) {
                object.sections = [];
                for (var j = 0; j < message.sections.length; ++j)
                    object.sections[j] = $root.proto.Section.toObject(message.sections[j], options);
            }
            if (message.productListInfo != null && message.hasOwnProperty("productListInfo"))
                object.productListInfo = $root.proto.ProductListInfo.toObject(message.productListInfo, options);
            if (message.footerText != null && message.hasOwnProperty("footerText"))
                object.footerText = message.footerText;
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo"))
                object.contextInfo = $root.proto.ContextInfo.toObject(message.contextInfo, options);
            return object;
        };

        /**
         * Converts this ListMessage to JSON.
         * @function toJSON
         * @memberof proto.ListMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ListMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * ListMessageListType enum.
         * @name proto.ListMessage.ListMessageListType
         * @enum {number}
         * @property {number} UNKNOWN=0 UNKNOWN value
         * @property {number} SINGLE_SELECT=1 SINGLE_SELECT value
         * @property {number} PRODUCT_LIST=2 PRODUCT_LIST value
         */
        ListMessage.ListMessageListType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "SINGLE_SELECT"] = 1;
            values[valuesById[2] = "PRODUCT_LIST"] = 2;
            return values;
        })();

        return ListMessage;
    })();

    proto.ListResponseMessage = (function() {

        /**
         * Properties of a ListResponseMessage.
         * @memberof proto
         * @interface IListResponseMessage
         * @property {string|null} [title] ListResponseMessage title
         * @property {proto.ListResponseMessage.ListResponseMessageListType|null} [listType] ListResponseMessage listType
         * @property {proto.ISingleSelectReply|null} [singleSelectReply] ListResponseMessage singleSelectReply
         * @property {proto.IContextInfo|null} [contextInfo] ListResponseMessage contextInfo
         * @property {string|null} [description] ListResponseMessage description
         */

        /**
         * Constructs a new ListResponseMessage.
         * @memberof proto
         * @classdesc Represents a ListResponseMessage.
         * @implements IListResponseMessage
         * @constructor
         * @param {proto.IListResponseMessage=} [properties] Properties to set
         */
        function ListResponseMessage(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ListResponseMessage title.
         * @member {string} title
         * @memberof proto.ListResponseMessage
         * @instance
         */
        ListResponseMessage.prototype.title = "";

        /**
         * ListResponseMessage listType.
         * @member {proto.ListResponseMessage.ListResponseMessageListType} listType
         * @memberof proto.ListResponseMessage
         * @instance
         */
        ListResponseMessage.prototype.listType = 0;

        /**
         * ListResponseMessage singleSelectReply.
         * @member {proto.ISingleSelectReply|null|undefined} singleSelectReply
         * @memberof proto.ListResponseMessage
         * @instance
         */
        ListResponseMessage.prototype.singleSelectReply = null;

        /**
         * ListResponseMessage contextInfo.
         * @member {proto.IContextInfo|null|undefined} contextInfo
         * @memberof proto.ListResponseMessage
         * @instance
         */
        ListResponseMessage.prototype.contextInfo = null;

        /**
         * ListResponseMessage description.
         * @member {string} description
         * @memberof proto.ListResponseMessage
         * @instance
         */
        ListResponseMessage.prototype.description = "";

        /**
         * Creates a new ListResponseMessage instance using the specified properties.
         * @function create
         * @memberof proto.ListResponseMessage
         * @static
         * @param {proto.IListResponseMessage=} [properties] Properties to set
         * @returns {proto.ListResponseMessage} ListResponseMessage instance
         */
        ListResponseMessage.create = function create(properties) {
            return new ListResponseMessage(properties);
        };

        /**
         * Encodes the specified ListResponseMessage message. Does not implicitly {@link proto.ListResponseMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.ListResponseMessage
         * @static
         * @param {proto.IListResponseMessage} message ListResponseMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ListResponseMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.title != null && Object.hasOwnProperty.call(message, "title"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.title);
            if (message.listType != null && Object.hasOwnProperty.call(message, "listType"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.listType);
            if (message.singleSelectReply != null && Object.hasOwnProperty.call(message, "singleSelectReply"))
                $root.proto.SingleSelectReply.encode(message.singleSelectReply, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            if (message.contextInfo != null && Object.hasOwnProperty.call(message, "contextInfo"))
                $root.proto.ContextInfo.encode(message.contextInfo, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
            if (message.description != null && Object.hasOwnProperty.call(message, "description"))
                writer.uint32(/* id 5, wireType 2 =*/42).string(message.description);
            return writer;
        };

        /**
         * Encodes the specified ListResponseMessage message, length delimited. Does not implicitly {@link proto.ListResponseMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ListResponseMessage
         * @static
         * @param {proto.IListResponseMessage} message ListResponseMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ListResponseMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ListResponseMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ListResponseMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ListResponseMessage} ListResponseMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ListResponseMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ListResponseMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.title = reader.string();
                    break;
                case 2:
                    message.listType = reader.int32();
                    break;
                case 3:
                    message.singleSelectReply = $root.proto.SingleSelectReply.decode(reader, reader.uint32());
                    break;
                case 4:
                    message.contextInfo = $root.proto.ContextInfo.decode(reader, reader.uint32());
                    break;
                case 5:
                    message.description = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ListResponseMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ListResponseMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ListResponseMessage} ListResponseMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ListResponseMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ListResponseMessage message.
         * @function verify
         * @memberof proto.ListResponseMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ListResponseMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.title != null && message.hasOwnProperty("title"))
                if (!$util.isString(message.title))
                    return "title: string expected";
            if (message.listType != null && message.hasOwnProperty("listType"))
                switch (message.listType) {
                default:
                    return "listType: enum value expected";
                case 0:
                case 1:
                    break;
                }
            if (message.singleSelectReply != null && message.hasOwnProperty("singleSelectReply")) {
                var error = $root.proto.SingleSelectReply.verify(message.singleSelectReply);
                if (error)
                    return "singleSelectReply." + error;
            }
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo")) {
                var error = $root.proto.ContextInfo.verify(message.contextInfo);
                if (error)
                    return "contextInfo." + error;
            }
            if (message.description != null && message.hasOwnProperty("description"))
                if (!$util.isString(message.description))
                    return "description: string expected";
            return null;
        };

        /**
         * Creates a ListResponseMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ListResponseMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ListResponseMessage} ListResponseMessage
         */
        ListResponseMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ListResponseMessage)
                return object;
            var message = new $root.proto.ListResponseMessage();
            if (object.title != null)
                message.title = String(object.title);
            switch (object.listType) {
            case "UNKNOWN":
            case 0:
                message.listType = 0;
                break;
            case "SINGLE_SELECT":
            case 1:
                message.listType = 1;
                break;
            }
            if (object.singleSelectReply != null) {
                if (typeof object.singleSelectReply !== "object")
                    throw TypeError(".proto.ListResponseMessage.singleSelectReply: object expected");
                message.singleSelectReply = $root.proto.SingleSelectReply.fromObject(object.singleSelectReply);
            }
            if (object.contextInfo != null) {
                if (typeof object.contextInfo !== "object")
                    throw TypeError(".proto.ListResponseMessage.contextInfo: object expected");
                message.contextInfo = $root.proto.ContextInfo.fromObject(object.contextInfo);
            }
            if (object.description != null)
                message.description = String(object.description);
            return message;
        };

        /**
         * Creates a plain object from a ListResponseMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ListResponseMessage
         * @static
         * @param {proto.ListResponseMessage} message ListResponseMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ListResponseMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.title = "";
                object.listType = options.enums === String ? "UNKNOWN" : 0;
                object.singleSelectReply = null;
                object.contextInfo = null;
                object.description = "";
            }
            if (message.title != null && message.hasOwnProperty("title"))
                object.title = message.title;
            if (message.listType != null && message.hasOwnProperty("listType"))
                object.listType = options.enums === String ? $root.proto.ListResponseMessage.ListResponseMessageListType[message.listType] : message.listType;
            if (message.singleSelectReply != null && message.hasOwnProperty("singleSelectReply"))
                object.singleSelectReply = $root.proto.SingleSelectReply.toObject(message.singleSelectReply, options);
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo"))
                object.contextInfo = $root.proto.ContextInfo.toObject(message.contextInfo, options);
            if (message.description != null && message.hasOwnProperty("description"))
                object.description = message.description;
            return object;
        };

        /**
         * Converts this ListResponseMessage to JSON.
         * @function toJSON
         * @memberof proto.ListResponseMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ListResponseMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * ListResponseMessageListType enum.
         * @name proto.ListResponseMessage.ListResponseMessageListType
         * @enum {number}
         * @property {number} UNKNOWN=0 UNKNOWN value
         * @property {number} SINGLE_SELECT=1 SINGLE_SELECT value
         */
        ListResponseMessage.ListResponseMessageListType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "SINGLE_SELECT"] = 1;
            return values;
        })();

        return ListResponseMessage;
    })();

    proto.LiveLocationMessage = (function() {

        /**
         * Properties of a LiveLocationMessage.
         * @memberof proto
         * @interface ILiveLocationMessage
         * @property {number|null} [degreesLatitude] LiveLocationMessage degreesLatitude
         * @property {number|null} [degreesLongitude] LiveLocationMessage degreesLongitude
         * @property {number|null} [accuracyInMeters] LiveLocationMessage accuracyInMeters
         * @property {number|null} [speedInMps] LiveLocationMessage speedInMps
         * @property {number|null} [degreesClockwiseFromMagneticNorth] LiveLocationMessage degreesClockwiseFromMagneticNorth
         * @property {string|null} [caption] LiveLocationMessage caption
         * @property {number|Long|null} [sequenceNumber] LiveLocationMessage sequenceNumber
         * @property {number|null} [timeOffset] LiveLocationMessage timeOffset
         * @property {Uint8Array|null} [jpegThumbnail] LiveLocationMessage jpegThumbnail
         * @property {proto.IContextInfo|null} [contextInfo] LiveLocationMessage contextInfo
         */

        /**
         * Constructs a new LiveLocationMessage.
         * @memberof proto
         * @classdesc Represents a LiveLocationMessage.
         * @implements ILiveLocationMessage
         * @constructor
         * @param {proto.ILiveLocationMessage=} [properties] Properties to set
         */
        function LiveLocationMessage(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * LiveLocationMessage degreesLatitude.
         * @member {number} degreesLatitude
         * @memberof proto.LiveLocationMessage
         * @instance
         */
        LiveLocationMessage.prototype.degreesLatitude = 0;

        /**
         * LiveLocationMessage degreesLongitude.
         * @member {number} degreesLongitude
         * @memberof proto.LiveLocationMessage
         * @instance
         */
        LiveLocationMessage.prototype.degreesLongitude = 0;

        /**
         * LiveLocationMessage accuracyInMeters.
         * @member {number} accuracyInMeters
         * @memberof proto.LiveLocationMessage
         * @instance
         */
        LiveLocationMessage.prototype.accuracyInMeters = 0;

        /**
         * LiveLocationMessage speedInMps.
         * @member {number} speedInMps
         * @memberof proto.LiveLocationMessage
         * @instance
         */
        LiveLocationMessage.prototype.speedInMps = 0;

        /**
         * LiveLocationMessage degreesClockwiseFromMagneticNorth.
         * @member {number} degreesClockwiseFromMagneticNorth
         * @memberof proto.LiveLocationMessage
         * @instance
         */
        LiveLocationMessage.prototype.degreesClockwiseFromMagneticNorth = 0;

        /**
         * LiveLocationMessage caption.
         * @member {string} caption
         * @memberof proto.LiveLocationMessage
         * @instance
         */
        LiveLocationMessage.prototype.caption = "";

        /**
         * LiveLocationMessage sequenceNumber.
         * @member {number|Long} sequenceNumber
         * @memberof proto.LiveLocationMessage
         * @instance
         */
        LiveLocationMessage.prototype.sequenceNumber = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * LiveLocationMessage timeOffset.
         * @member {number} timeOffset
         * @memberof proto.LiveLocationMessage
         * @instance
         */
        LiveLocationMessage.prototype.timeOffset = 0;

        /**
         * LiveLocationMessage jpegThumbnail.
         * @member {Uint8Array} jpegThumbnail
         * @memberof proto.LiveLocationMessage
         * @instance
         */
        LiveLocationMessage.prototype.jpegThumbnail = $util.newBuffer([]);

        /**
         * LiveLocationMessage contextInfo.
         * @member {proto.IContextInfo|null|undefined} contextInfo
         * @memberof proto.LiveLocationMessage
         * @instance
         */
        LiveLocationMessage.prototype.contextInfo = null;

        /**
         * Creates a new LiveLocationMessage instance using the specified properties.
         * @function create
         * @memberof proto.LiveLocationMessage
         * @static
         * @param {proto.ILiveLocationMessage=} [properties] Properties to set
         * @returns {proto.LiveLocationMessage} LiveLocationMessage instance
         */
        LiveLocationMessage.create = function create(properties) {
            return new LiveLocationMessage(properties);
        };

        /**
         * Encodes the specified LiveLocationMessage message. Does not implicitly {@link proto.LiveLocationMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.LiveLocationMessage
         * @static
         * @param {proto.ILiveLocationMessage} message LiveLocationMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        LiveLocationMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.degreesLatitude != null && Object.hasOwnProperty.call(message, "degreesLatitude"))
                writer.uint32(/* id 1, wireType 1 =*/9).double(message.degreesLatitude);
            if (message.degreesLongitude != null && Object.hasOwnProperty.call(message, "degreesLongitude"))
                writer.uint32(/* id 2, wireType 1 =*/17).double(message.degreesLongitude);
            if (message.accuracyInMeters != null && Object.hasOwnProperty.call(message, "accuracyInMeters"))
                writer.uint32(/* id 3, wireType 0 =*/24).uint32(message.accuracyInMeters);
            if (message.speedInMps != null && Object.hasOwnProperty.call(message, "speedInMps"))
                writer.uint32(/* id 4, wireType 5 =*/37).float(message.speedInMps);
            if (message.degreesClockwiseFromMagneticNorth != null && Object.hasOwnProperty.call(message, "degreesClockwiseFromMagneticNorth"))
                writer.uint32(/* id 5, wireType 0 =*/40).uint32(message.degreesClockwiseFromMagneticNorth);
            if (message.caption != null && Object.hasOwnProperty.call(message, "caption"))
                writer.uint32(/* id 6, wireType 2 =*/50).string(message.caption);
            if (message.sequenceNumber != null && Object.hasOwnProperty.call(message, "sequenceNumber"))
                writer.uint32(/* id 7, wireType 0 =*/56).int64(message.sequenceNumber);
            if (message.timeOffset != null && Object.hasOwnProperty.call(message, "timeOffset"))
                writer.uint32(/* id 8, wireType 0 =*/64).uint32(message.timeOffset);
            if (message.jpegThumbnail != null && Object.hasOwnProperty.call(message, "jpegThumbnail"))
                writer.uint32(/* id 16, wireType 2 =*/130).bytes(message.jpegThumbnail);
            if (message.contextInfo != null && Object.hasOwnProperty.call(message, "contextInfo"))
                $root.proto.ContextInfo.encode(message.contextInfo, writer.uint32(/* id 17, wireType 2 =*/138).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified LiveLocationMessage message, length delimited. Does not implicitly {@link proto.LiveLocationMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.LiveLocationMessage
         * @static
         * @param {proto.ILiveLocationMessage} message LiveLocationMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        LiveLocationMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a LiveLocationMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.LiveLocationMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.LiveLocationMessage} LiveLocationMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        LiveLocationMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.LiveLocationMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.degreesLatitude = reader.double();
                    break;
                case 2:
                    message.degreesLongitude = reader.double();
                    break;
                case 3:
                    message.accuracyInMeters = reader.uint32();
                    break;
                case 4:
                    message.speedInMps = reader.float();
                    break;
                case 5:
                    message.degreesClockwiseFromMagneticNorth = reader.uint32();
                    break;
                case 6:
                    message.caption = reader.string();
                    break;
                case 7:
                    message.sequenceNumber = reader.int64();
                    break;
                case 8:
                    message.timeOffset = reader.uint32();
                    break;
                case 16:
                    message.jpegThumbnail = reader.bytes();
                    break;
                case 17:
                    message.contextInfo = $root.proto.ContextInfo.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a LiveLocationMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.LiveLocationMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.LiveLocationMessage} LiveLocationMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        LiveLocationMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a LiveLocationMessage message.
         * @function verify
         * @memberof proto.LiveLocationMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        LiveLocationMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.degreesLatitude != null && message.hasOwnProperty("degreesLatitude"))
                if (typeof message.degreesLatitude !== "number")
                    return "degreesLatitude: number expected";
            if (message.degreesLongitude != null && message.hasOwnProperty("degreesLongitude"))
                if (typeof message.degreesLongitude !== "number")
                    return "degreesLongitude: number expected";
            if (message.accuracyInMeters != null && message.hasOwnProperty("accuracyInMeters"))
                if (!$util.isInteger(message.accuracyInMeters))
                    return "accuracyInMeters: integer expected";
            if (message.speedInMps != null && message.hasOwnProperty("speedInMps"))
                if (typeof message.speedInMps !== "number")
                    return "speedInMps: number expected";
            if (message.degreesClockwiseFromMagneticNorth != null && message.hasOwnProperty("degreesClockwiseFromMagneticNorth"))
                if (!$util.isInteger(message.degreesClockwiseFromMagneticNorth))
                    return "degreesClockwiseFromMagneticNorth: integer expected";
            if (message.caption != null && message.hasOwnProperty("caption"))
                if (!$util.isString(message.caption))
                    return "caption: string expected";
            if (message.sequenceNumber != null && message.hasOwnProperty("sequenceNumber"))
                if (!$util.isInteger(message.sequenceNumber) && !(message.sequenceNumber && $util.isInteger(message.sequenceNumber.low) && $util.isInteger(message.sequenceNumber.high)))
                    return "sequenceNumber: integer|Long expected";
            if (message.timeOffset != null && message.hasOwnProperty("timeOffset"))
                if (!$util.isInteger(message.timeOffset))
                    return "timeOffset: integer expected";
            if (message.jpegThumbnail != null && message.hasOwnProperty("jpegThumbnail"))
                if (!(message.jpegThumbnail && typeof message.jpegThumbnail.length === "number" || $util.isString(message.jpegThumbnail)))
                    return "jpegThumbnail: buffer expected";
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo")) {
                var error = $root.proto.ContextInfo.verify(message.contextInfo);
                if (error)
                    return "contextInfo." + error;
            }
            return null;
        };

        /**
         * Creates a LiveLocationMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.LiveLocationMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.LiveLocationMessage} LiveLocationMessage
         */
        LiveLocationMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.LiveLocationMessage)
                return object;
            var message = new $root.proto.LiveLocationMessage();
            if (object.degreesLatitude != null)
                message.degreesLatitude = Number(object.degreesLatitude);
            if (object.degreesLongitude != null)
                message.degreesLongitude = Number(object.degreesLongitude);
            if (object.accuracyInMeters != null)
                message.accuracyInMeters = object.accuracyInMeters >>> 0;
            if (object.speedInMps != null)
                message.speedInMps = Number(object.speedInMps);
            if (object.degreesClockwiseFromMagneticNorth != null)
                message.degreesClockwiseFromMagneticNorth = object.degreesClockwiseFromMagneticNorth >>> 0;
            if (object.caption != null)
                message.caption = String(object.caption);
            if (object.sequenceNumber != null)
                if ($util.Long)
                    (message.sequenceNumber = $util.Long.fromValue(object.sequenceNumber)).unsigned = false;
                else if (typeof object.sequenceNumber === "string")
                    message.sequenceNumber = parseInt(object.sequenceNumber, 10);
                else if (typeof object.sequenceNumber === "number")
                    message.sequenceNumber = object.sequenceNumber;
                else if (typeof object.sequenceNumber === "object")
                    message.sequenceNumber = new $util.LongBits(object.sequenceNumber.low >>> 0, object.sequenceNumber.high >>> 0).toNumber();
            if (object.timeOffset != null)
                message.timeOffset = object.timeOffset >>> 0;
            if (object.jpegThumbnail != null)
                if (typeof object.jpegThumbnail === "string")
                    $util.base64.decode(object.jpegThumbnail, message.jpegThumbnail = $util.newBuffer($util.base64.length(object.jpegThumbnail)), 0);
                else if (object.jpegThumbnail.length)
                    message.jpegThumbnail = object.jpegThumbnail;
            if (object.contextInfo != null) {
                if (typeof object.contextInfo !== "object")
                    throw TypeError(".proto.LiveLocationMessage.contextInfo: object expected");
                message.contextInfo = $root.proto.ContextInfo.fromObject(object.contextInfo);
            }
            return message;
        };

        /**
         * Creates a plain object from a LiveLocationMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.LiveLocationMessage
         * @static
         * @param {proto.LiveLocationMessage} message LiveLocationMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        LiveLocationMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.degreesLatitude = 0;
                object.degreesLongitude = 0;
                object.accuracyInMeters = 0;
                object.speedInMps = 0;
                object.degreesClockwiseFromMagneticNorth = 0;
                object.caption = "";
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.sequenceNumber = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.sequenceNumber = options.longs === String ? "0" : 0;
                object.timeOffset = 0;
                if (options.bytes === String)
                    object.jpegThumbnail = "";
                else {
                    object.jpegThumbnail = [];
                    if (options.bytes !== Array)
                        object.jpegThumbnail = $util.newBuffer(object.jpegThumbnail);
                }
                object.contextInfo = null;
            }
            if (message.degreesLatitude != null && message.hasOwnProperty("degreesLatitude"))
                object.degreesLatitude = options.json && !isFinite(message.degreesLatitude) ? String(message.degreesLatitude) : message.degreesLatitude;
            if (message.degreesLongitude != null && message.hasOwnProperty("degreesLongitude"))
                object.degreesLongitude = options.json && !isFinite(message.degreesLongitude) ? String(message.degreesLongitude) : message.degreesLongitude;
            if (message.accuracyInMeters != null && message.hasOwnProperty("accuracyInMeters"))
                object.accuracyInMeters = message.accuracyInMeters;
            if (message.speedInMps != null && message.hasOwnProperty("speedInMps"))
                object.speedInMps = options.json && !isFinite(message.speedInMps) ? String(message.speedInMps) : message.speedInMps;
            if (message.degreesClockwiseFromMagneticNorth != null && message.hasOwnProperty("degreesClockwiseFromMagneticNorth"))
                object.degreesClockwiseFromMagneticNorth = message.degreesClockwiseFromMagneticNorth;
            if (message.caption != null && message.hasOwnProperty("caption"))
                object.caption = message.caption;
            if (message.sequenceNumber != null && message.hasOwnProperty("sequenceNumber"))
                if (typeof message.sequenceNumber === "number")
                    object.sequenceNumber = options.longs === String ? String(message.sequenceNumber) : message.sequenceNumber;
                else
                    object.sequenceNumber = options.longs === String ? $util.Long.prototype.toString.call(message.sequenceNumber) : options.longs === Number ? new $util.LongBits(message.sequenceNumber.low >>> 0, message.sequenceNumber.high >>> 0).toNumber() : message.sequenceNumber;
            if (message.timeOffset != null && message.hasOwnProperty("timeOffset"))
                object.timeOffset = message.timeOffset;
            if (message.jpegThumbnail != null && message.hasOwnProperty("jpegThumbnail"))
                object.jpegThumbnail = options.bytes === String ? $util.base64.encode(message.jpegThumbnail, 0, message.jpegThumbnail.length) : options.bytes === Array ? Array.prototype.slice.call(message.jpegThumbnail) : message.jpegThumbnail;
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo"))
                object.contextInfo = $root.proto.ContextInfo.toObject(message.contextInfo, options);
            return object;
        };

        /**
         * Converts this LiveLocationMessage to JSON.
         * @function toJSON
         * @memberof proto.LiveLocationMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        LiveLocationMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return LiveLocationMessage;
    })();

    proto.Location = (function() {

        /**
         * Properties of a Location.
         * @memberof proto
         * @interface ILocation
         * @property {number|null} [degreesLatitude] Location degreesLatitude
         * @property {number|null} [degreesLongitude] Location degreesLongitude
         * @property {string|null} [name] Location name
         */

        /**
         * Constructs a new Location.
         * @memberof proto
         * @classdesc Represents a Location.
         * @implements ILocation
         * @constructor
         * @param {proto.ILocation=} [properties] Properties to set
         */
        function Location(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Location degreesLatitude.
         * @member {number} degreesLatitude
         * @memberof proto.Location
         * @instance
         */
        Location.prototype.degreesLatitude = 0;

        /**
         * Location degreesLongitude.
         * @member {number} degreesLongitude
         * @memberof proto.Location
         * @instance
         */
        Location.prototype.degreesLongitude = 0;

        /**
         * Location name.
         * @member {string} name
         * @memberof proto.Location
         * @instance
         */
        Location.prototype.name = "";

        /**
         * Creates a new Location instance using the specified properties.
         * @function create
         * @memberof proto.Location
         * @static
         * @param {proto.ILocation=} [properties] Properties to set
         * @returns {proto.Location} Location instance
         */
        Location.create = function create(properties) {
            return new Location(properties);
        };

        /**
         * Encodes the specified Location message. Does not implicitly {@link proto.Location.verify|verify} messages.
         * @function encode
         * @memberof proto.Location
         * @static
         * @param {proto.ILocation} message Location message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Location.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.degreesLatitude != null && Object.hasOwnProperty.call(message, "degreesLatitude"))
                writer.uint32(/* id 1, wireType 1 =*/9).double(message.degreesLatitude);
            if (message.degreesLongitude != null && Object.hasOwnProperty.call(message, "degreesLongitude"))
                writer.uint32(/* id 2, wireType 1 =*/17).double(message.degreesLongitude);
            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.name);
            return writer;
        };

        /**
         * Encodes the specified Location message, length delimited. Does not implicitly {@link proto.Location.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.Location
         * @static
         * @param {proto.ILocation} message Location message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Location.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a Location message from the specified reader or buffer.
         * @function decode
         * @memberof proto.Location
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.Location} Location
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Location.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.Location();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.degreesLatitude = reader.double();
                    break;
                case 2:
                    message.degreesLongitude = reader.double();
                    break;
                case 3:
                    message.name = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a Location message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.Location
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.Location} Location
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Location.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a Location message.
         * @function verify
         * @memberof proto.Location
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Location.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.degreesLatitude != null && message.hasOwnProperty("degreesLatitude"))
                if (typeof message.degreesLatitude !== "number")
                    return "degreesLatitude: number expected";
            if (message.degreesLongitude != null && message.hasOwnProperty("degreesLongitude"))
                if (typeof message.degreesLongitude !== "number")
                    return "degreesLongitude: number expected";
            if (message.name != null && message.hasOwnProperty("name"))
                if (!$util.isString(message.name))
                    return "name: string expected";
            return null;
        };

        /**
         * Creates a Location message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.Location
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.Location} Location
         */
        Location.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.Location)
                return object;
            var message = new $root.proto.Location();
            if (object.degreesLatitude != null)
                message.degreesLatitude = Number(object.degreesLatitude);
            if (object.degreesLongitude != null)
                message.degreesLongitude = Number(object.degreesLongitude);
            if (object.name != null)
                message.name = String(object.name);
            return message;
        };

        /**
         * Creates a plain object from a Location message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.Location
         * @static
         * @param {proto.Location} message Location
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Location.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.degreesLatitude = 0;
                object.degreesLongitude = 0;
                object.name = "";
            }
            if (message.degreesLatitude != null && message.hasOwnProperty("degreesLatitude"))
                object.degreesLatitude = options.json && !isFinite(message.degreesLatitude) ? String(message.degreesLatitude) : message.degreesLatitude;
            if (message.degreesLongitude != null && message.hasOwnProperty("degreesLongitude"))
                object.degreesLongitude = options.json && !isFinite(message.degreesLongitude) ? String(message.degreesLongitude) : message.degreesLongitude;
            if (message.name != null && message.hasOwnProperty("name"))
                object.name = message.name;
            return object;
        };

        /**
         * Converts this Location to JSON.
         * @function toJSON
         * @memberof proto.Location
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Location.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return Location;
    })();

    proto.LocationMessage = (function() {

        /**
         * Properties of a LocationMessage.
         * @memberof proto
         * @interface ILocationMessage
         * @property {number|null} [degreesLatitude] LocationMessage degreesLatitude
         * @property {number|null} [degreesLongitude] LocationMessage degreesLongitude
         * @property {string|null} [name] LocationMessage name
         * @property {string|null} [address] LocationMessage address
         * @property {string|null} [url] LocationMessage url
         * @property {boolean|null} [isLive] LocationMessage isLive
         * @property {number|null} [accuracyInMeters] LocationMessage accuracyInMeters
         * @property {number|null} [speedInMps] LocationMessage speedInMps
         * @property {number|null} [degreesClockwiseFromMagneticNorth] LocationMessage degreesClockwiseFromMagneticNorth
         * @property {string|null} [comment] LocationMessage comment
         * @property {Uint8Array|null} [jpegThumbnail] LocationMessage jpegThumbnail
         * @property {proto.IContextInfo|null} [contextInfo] LocationMessage contextInfo
         */

        /**
         * Constructs a new LocationMessage.
         * @memberof proto
         * @classdesc Represents a LocationMessage.
         * @implements ILocationMessage
         * @constructor
         * @param {proto.ILocationMessage=} [properties] Properties to set
         */
        function LocationMessage(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * LocationMessage degreesLatitude.
         * @member {number} degreesLatitude
         * @memberof proto.LocationMessage
         * @instance
         */
        LocationMessage.prototype.degreesLatitude = 0;

        /**
         * LocationMessage degreesLongitude.
         * @member {number} degreesLongitude
         * @memberof proto.LocationMessage
         * @instance
         */
        LocationMessage.prototype.degreesLongitude = 0;

        /**
         * LocationMessage name.
         * @member {string} name
         * @memberof proto.LocationMessage
         * @instance
         */
        LocationMessage.prototype.name = "";

        /**
         * LocationMessage address.
         * @member {string} address
         * @memberof proto.LocationMessage
         * @instance
         */
        LocationMessage.prototype.address = "";

        /**
         * LocationMessage url.
         * @member {string} url
         * @memberof proto.LocationMessage
         * @instance
         */
        LocationMessage.prototype.url = "";

        /**
         * LocationMessage isLive.
         * @member {boolean} isLive
         * @memberof proto.LocationMessage
         * @instance
         */
        LocationMessage.prototype.isLive = false;

        /**
         * LocationMessage accuracyInMeters.
         * @member {number} accuracyInMeters
         * @memberof proto.LocationMessage
         * @instance
         */
        LocationMessage.prototype.accuracyInMeters = 0;

        /**
         * LocationMessage speedInMps.
         * @member {number} speedInMps
         * @memberof proto.LocationMessage
         * @instance
         */
        LocationMessage.prototype.speedInMps = 0;

        /**
         * LocationMessage degreesClockwiseFromMagneticNorth.
         * @member {number} degreesClockwiseFromMagneticNorth
         * @memberof proto.LocationMessage
         * @instance
         */
        LocationMessage.prototype.degreesClockwiseFromMagneticNorth = 0;

        /**
         * LocationMessage comment.
         * @member {string} comment
         * @memberof proto.LocationMessage
         * @instance
         */
        LocationMessage.prototype.comment = "";

        /**
         * LocationMessage jpegThumbnail.
         * @member {Uint8Array} jpegThumbnail
         * @memberof proto.LocationMessage
         * @instance
         */
        LocationMessage.prototype.jpegThumbnail = $util.newBuffer([]);

        /**
         * LocationMessage contextInfo.
         * @member {proto.IContextInfo|null|undefined} contextInfo
         * @memberof proto.LocationMessage
         * @instance
         */
        LocationMessage.prototype.contextInfo = null;

        /**
         * Creates a new LocationMessage instance using the specified properties.
         * @function create
         * @memberof proto.LocationMessage
         * @static
         * @param {proto.ILocationMessage=} [properties] Properties to set
         * @returns {proto.LocationMessage} LocationMessage instance
         */
        LocationMessage.create = function create(properties) {
            return new LocationMessage(properties);
        };

        /**
         * Encodes the specified LocationMessage message. Does not implicitly {@link proto.LocationMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.LocationMessage
         * @static
         * @param {proto.ILocationMessage} message LocationMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        LocationMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.degreesLatitude != null && Object.hasOwnProperty.call(message, "degreesLatitude"))
                writer.uint32(/* id 1, wireType 1 =*/9).double(message.degreesLatitude);
            if (message.degreesLongitude != null && Object.hasOwnProperty.call(message, "degreesLongitude"))
                writer.uint32(/* id 2, wireType 1 =*/17).double(message.degreesLongitude);
            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.name);
            if (message.address != null && Object.hasOwnProperty.call(message, "address"))
                writer.uint32(/* id 4, wireType 2 =*/34).string(message.address);
            if (message.url != null && Object.hasOwnProperty.call(message, "url"))
                writer.uint32(/* id 5, wireType 2 =*/42).string(message.url);
            if (message.isLive != null && Object.hasOwnProperty.call(message, "isLive"))
                writer.uint32(/* id 6, wireType 0 =*/48).bool(message.isLive);
            if (message.accuracyInMeters != null && Object.hasOwnProperty.call(message, "accuracyInMeters"))
                writer.uint32(/* id 7, wireType 0 =*/56).uint32(message.accuracyInMeters);
            if (message.speedInMps != null && Object.hasOwnProperty.call(message, "speedInMps"))
                writer.uint32(/* id 8, wireType 5 =*/69).float(message.speedInMps);
            if (message.degreesClockwiseFromMagneticNorth != null && Object.hasOwnProperty.call(message, "degreesClockwiseFromMagneticNorth"))
                writer.uint32(/* id 9, wireType 0 =*/72).uint32(message.degreesClockwiseFromMagneticNorth);
            if (message.comment != null && Object.hasOwnProperty.call(message, "comment"))
                writer.uint32(/* id 11, wireType 2 =*/90).string(message.comment);
            if (message.jpegThumbnail != null && Object.hasOwnProperty.call(message, "jpegThumbnail"))
                writer.uint32(/* id 16, wireType 2 =*/130).bytes(message.jpegThumbnail);
            if (message.contextInfo != null && Object.hasOwnProperty.call(message, "contextInfo"))
                $root.proto.ContextInfo.encode(message.contextInfo, writer.uint32(/* id 17, wireType 2 =*/138).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified LocationMessage message, length delimited. Does not implicitly {@link proto.LocationMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.LocationMessage
         * @static
         * @param {proto.ILocationMessage} message LocationMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        LocationMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).lde